/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.OrderPurchaseItemCrtXbjAtomService;
import com.cgd.order.atom.bo.OrderPurchaseItemCrtXbjReqBO;
import com.cgd.order.atom.bo.OrderPurchaseItemXbjBO;
import com.cgd.order.dao.OrderPurchaseItemXbjMapper;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.po.OrderPurchaseItemXbjPO;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.util.DateUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;

public class OrderPurchaseItemCrtXbjAtomServiceImpl
implements OrderPurchaseItemCrtXbjAtomService {
    private static final Log log = LogFactory.getLog(OrderPurchaseItemCrtXbjAtomServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;
    private OrderPurchaseItemXbjMapper orderPurchaseItemXbjMapper;

    public void setOrderPurchaseXbjMapper(OrderPurchaseXbjMapper orderPurchaseXbjMapper) {
        this.orderPurchaseXbjMapper = orderPurchaseXbjMapper;
    }

    public void setOrderPurchaseItemXbjMapper(OrderPurchaseItemXbjMapper orderPurchaseItemXbjMapper) {
        this.orderPurchaseItemXbjMapper = orderPurchaseItemXbjMapper;
    }

    @Override
    public List<OrderPurchaseItemXbjPO> orderPurchaseItemCrt(OrderPurchaseItemCrtXbjReqBO orderPurchaseItemCrtReqBO) {
        if (this.isDebugEnabled) {
            log.debug((Object)("\u91c7\u8d2d\u5355\uff0c\u91c7\u8d2d\u660e\u7ec6\u751f\u6210\u539f\u5b50\u670d\u52a1\u5165\u53c2" + orderPurchaseItemCrtReqBO.toString()));
        }
        if (null == orderPurchaseItemCrtReqBO.getPurchaseOrderId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u5355\uff0c\u91c7\u8d2d\u660e\u7ec6\u751f\u6210\u539f\u5b50\u670d\u52a1\u91c7\u8d2d\u5355\u7f16\u53f7[purchaseOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == orderPurchaseItemCrtReqBO.getSaleOrderId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u5355\uff0c\u91c7\u8d2d\u660e\u7ec6\u751f\u6210\u539f\u5b50\u670d\u52a1\u9500\u552e\u5355\u7f16\u53f7[saleOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == orderPurchaseItemCrtReqBO.getPurchaserId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u5355\uff0c\u91c7\u8d2d\u660e\u7ec6\u751f\u6210\u539f\u5b50\u670d\u52a1\u91c7\u8d2d\u5546\u7f16\u53f7[purchaserId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == orderPurchaseItemCrtReqBO.getPurchaseOrderStatus()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u5355\uff0c\u91c7\u8d2d\u660e\u7ec6\u751f\u6210\u539f\u5b50\u670d\u52a1\u91c7\u8d2d\u8ba2\u5355\u72b6\u6001[purchaseOrderStatus]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == orderPurchaseItemCrtReqBO.getSaleOrderType()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u5355\uff0c\u91c7\u8d2d\u660e\u7ec6\u751f\u6210\u539f\u5b50\u670d\u52a1\u9500\u552e\u8ba2\u5355\u7c7b\u578b[saleOrderType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == orderPurchaseItemCrtReqBO.getGoodsSupplierId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u5355\uff0c\u91c7\u8d2d\u660e\u7ec6\u751f\u6210\u539f\u5b50\u670d\u52a1\u4f9b\u5e94\u5546\u7f16\u53f7[goodsSupplierId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == orderPurchaseItemCrtReqBO.getPurchaserAccountId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u5355\uff0c\u91c7\u8d2d\u660e\u7ec6\u751f\u6210\u539f\u5b50\u670d\u52a1\u91c7\u8d2d\u5546\u4e0b\u5355\u4eba\u7f16\u53f7[purchaserAccountId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == orderPurchaseItemCrtReqBO.getProfessionalOrganizationId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u5355\uff0c\u91c7\u8d2d\u660e\u7ec6\u751f\u6210\u539f\u5b50\u670d\u52a1\u4e13\u4e1a\u673a\u6784\u7f16\u53f7[professionalOrganizationId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (orderPurchaseItemCrtReqBO.getOrderPurchaseItemBOs() == null || orderPurchaseItemCrtReqBO.getOrderPurchaseItemBOs().size() < 0) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u5355\uff0c\u91c7\u8d2d\u660e\u7ec6\u751f\u6210\u539f\u5b50\u670d\u52a1\u91c7\u8d2d\u5355\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<OrderPurchaseItemXbjPO> orderPurchaseRspList = new ArrayList<OrderPurchaseItemXbjPO>();
        try {
            Long purchaseMoney = orderPurchaseItemCrtReqBO.getPurchaserOrderMoney();
            OrderPurchaseXbjPO orderPurchase = this.initOrderPurchase(orderPurchaseItemCrtReqBO, purchaseMoney);
            this.orderPurchaseXbjMapper.insertSelective(orderPurchase);
            List<OrderPurchaseItemXbjPO> orderPurchaseItems = this.initOrderPurchaseItems(orderPurchaseItemCrtReqBO);
            if (null != orderPurchaseItems && orderPurchaseItems.size() > 0) {
                for (OrderPurchaseItemXbjPO orderPurchaseItem : orderPurchaseItems) {
                    this.orderPurchaseItemXbjMapper.insert(orderPurchaseItem);
                    orderPurchaseRspList.add(orderPurchaseItem);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"\u91c7\u8d2d\u5355\uff0c\u91c7\u8d2d\u660e\u7ec6\u751f\u6210\u539f\u5b50\u670d\u52a1\u51fa\u9519", (Throwable)e);
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u91c7\u8d2d\u5355\uff0c\u91c7\u8d2d\u660e\u7ec6\u751f\u6210\u539f\u5b50\u670d\u52a1\u51fa\u9519" + e);
        }
        return orderPurchaseRspList;
    }

    private OrderPurchaseXbjPO initOrderPurchase(OrderPurchaseItemCrtXbjReqBO orderPurchaseItemCrtReqBO, Long purchaseMoney) {
        try {
            OrderPurchaseXbjPO orderPurchase = new OrderPurchaseXbjPO();
            BeanUtils.copyProperties((Object)orderPurchaseItemCrtReqBO, (Object)orderPurchase);
            orderPurchase.setPayType(orderPurchaseItemCrtReqBO.getPayType());
            orderPurchase.setBaseTransportationFee(orderPurchaseItemCrtReqBO.getBaseTransportationFee());
            orderPurchase.setComment(orderPurchaseItemCrtReqBO.getComment());
            orderPurchase.setPurchaseOrderCode(String.valueOf(orderPurchaseItemCrtReqBO.getPurchaseOrderCode()));
            orderPurchase.setExtOrderId(orderPurchaseItemCrtReqBO.getExtOrderId());
            orderPurchase.setExtPerentOrderId(orderPurchaseItemCrtReqBO.getExtPerentOrderId());
            orderPurchase.setGoodsSupplierId(orderPurchaseItemCrtReqBO.getGoodsSupplierId());
            orderPurchase.setNeedContactMobile(orderPurchaseItemCrtReqBO.getNeedContactMobile());
            orderPurchase.setNeedContactName(orderPurchaseItemCrtReqBO.getNeedContactName());
            orderPurchase.setProfessionalOrganizationId(orderPurchaseItemCrtReqBO.getProfessionalOrganizationId());
            orderPurchase.setPurchaseOrderId(orderPurchaseItemCrtReqBO.getPurchaseOrderId());
            orderPurchase.setPurchaseOrderStatus(orderPurchaseItemCrtReqBO.getPurchaseOrderStatus());
            orderPurchase.setPurchaserAccountId(orderPurchaseItemCrtReqBO.getPurchaserAccountId());
            orderPurchase.setPurchaserAccountName(orderPurchaseItemCrtReqBO.getPurchaserAccountName());
            orderPurchase.setPurchaserId(orderPurchaseItemCrtReqBO.getPurchaserId());
            orderPurchase.setSaleOrderType(orderPurchaseItemCrtReqBO.getSaleOrderType());
            orderPurchase.setTatleTransportationFee(orderPurchaseItemCrtReqBO.getTatleTransportationFee());
            orderPurchase.setPurchaseOrderStatus(orderPurchaseItemCrtReqBO.getPurchaseOrderStatus());
            orderPurchase.setExtOrderId(orderPurchaseItemCrtReqBO.getExtOrderId());
            orderPurchase.setExtOrderNakedPrice(orderPurchaseItemCrtReqBO.getExtOrderNakedPrice());
            orderPurchase.setExtOrderPrice(orderPurchaseItemCrtReqBO.getExtOrderPrice());
            orderPurchase.setExtOrderTaxPrice(orderPurchaseItemCrtReqBO.getExtOrderTaxPrice());
            orderPurchase.setExtPerentOrderId(orderPurchaseItemCrtReqBO.getExtPerentOrderId());
            orderPurchase.setSaleOrderId(orderPurchaseItemCrtReqBO.getSaleOrderId());
            orderPurchase.setCreateTime(new Date());
            orderPurchase.setGiveTime(orderPurchaseItemCrtReqBO.getGiveTime());
            orderPurchase.setPurchaserName(orderPurchaseItemCrtReqBO.getPurchaserName());
            orderPurchase.setPurchaserAccount(orderPurchaseItemCrtReqBO.getPurchaserAccount());
            orderPurchase.setExtOrderTotalAmount(orderPurchaseItemCrtReqBO.getExtOrderTotalAmount());
            orderPurchase.setExtPerentOrderId(orderPurchaseItemCrtReqBO.getExtPerentOrderId());
            orderPurchase.setPurchaseOrderName(orderPurchaseItemCrtReqBO.getPurchaseOrderName());
            orderPurchase.setRemoteregionfreight(orderPurchaseItemCrtReqBO.getRemoteregionfreight());
            orderPurchase.setSaleOrderParentId(orderPurchaseItemCrtReqBO.getSaleOrderParentId());
            orderPurchase.setSaleOrderBusiType(orderPurchaseItemCrtReqBO.getSaleOrderBusiType());
            orderPurchase.setSplitReason(orderPurchaseItemCrtReqBO.getSplitReason());
            orderPurchase.setTaxRate(orderPurchaseItemCrtReqBO.getTaxRate());
            orderPurchase.setDeliveryId(orderPurchaseItemCrtReqBO.getDeliveryId());
            orderPurchase.setIsSplit(orderPurchaseItemCrtReqBO.getIsSplit());
            orderPurchase.setStatusReason(orderPurchaseItemCrtReqBO.getStatusReason());
            orderPurchase.setPurchaseOrderCode(orderPurchaseItemCrtReqBO.getPurchaseOrderCode());
            orderPurchase.setPurchaserAccountOrgId(orderPurchaseItemCrtReqBO.getPurchaserAccountOrgId());
            orderPurchase.setDeptId(orderPurchaseItemCrtReqBO.getDeptId());
            orderPurchase.setPurchaserOrderMoney(purchaseMoney);
            orderPurchase.setSaleOrderPurchaseType(orderPurchaseItemCrtReqBO.getSaleOrderPurchaseType());
            orderPurchase.setOrderType(orderPurchaseItemCrtReqBO.getOrderType());
            orderPurchase.setProfessionalName(orderPurchaseItemCrtReqBO.getProfessionalName());
            orderPurchase.setProfessionalMobile(orderPurchaseItemCrtReqBO.getProfessionalMobile());
            orderPurchase.setGoodsSupplierName(orderPurchaseItemCrtReqBO.getGoodsSupplierName());
            orderPurchase.setGoodsSupplierMobile(orderPurchaseItemCrtReqBO.getGoodsSupplierMobile());
            orderPurchase.setPurchaserMobile(orderPurchaseItemCrtReqBO.getPurchaserMobile());
            orderPurchase.setGoodsSupplierRelaman(orderPurchaseItemCrtReqBO.getGoodsSupplierRelaman());
            orderPurchase.setProfessionalOrganizationName(orderPurchaseItemCrtReqBO.getProfessionalOrganizationName());
            orderPurchase.setPlaAgreementCode(orderPurchaseItemCrtReqBO.getPlaAgreementCode());
            orderPurchase.setIsDispatch(orderPurchaseItemCrtReqBO.getIsDisPatch());
            orderPurchase.setArriveTime(orderPurchaseItemCrtReqBO.getArriveTime());
            orderPurchase.setPrePayEnt(orderPurchaseItemCrtReqBO.getPrePayEnt());
            orderPurchase.setMatPayEnt(orderPurchaseItemCrtReqBO.getMatPayEnt());
            orderPurchase.setProPayEnt(orderPurchaseItemCrtReqBO.getProPayEnt());
            orderPurchase.setVerPayEnt(orderPurchaseItemCrtReqBO.getVerPayEnt());
            orderPurchase.setPilPayEnt(orderPurchaseItemCrtReqBO.getPilPayEnt());
            orderPurchase.setQuaPayEnt(orderPurchaseItemCrtReqBO.getQuaPayEnt());
            orderPurchase.setMatPaySup(orderPurchaseItemCrtReqBO.getMatPaySup());
            orderPurchase.setProPaySup(orderPurchaseItemCrtReqBO.getProPaySup());
            orderPurchase.setVerPaySup(orderPurchaseItemCrtReqBO.getVerPaySup());
            orderPurchase.setPilPaySup(orderPurchaseItemCrtReqBO.getPilPaySup());
            orderPurchase.setQuaPaySup(orderPurchaseItemCrtReqBO.getQuaPaySup());
            orderPurchase.setPrePaySup(orderPurchaseItemCrtReqBO.getPrePaySup());
            orderPurchase.setAssignedComment(orderPurchaseItemCrtReqBO.getAssignedComment());
            orderPurchase.setWarantty(orderPurchaseItemCrtReqBO.getWarantty());
            orderPurchase.setArriveType(orderPurchaseItemCrtReqBO.getArriveType());
            return orderPurchase;
        }
        catch (Exception e) {
            log.error((Object)("\u91c7\u8d2d\u5355\uff0c\u91c7\u8d2d\u660e\u7ec6\u751f\u6210\u539f\u5b50\u670d\u52a1\u521d\u59cb\u5316\u91c7\u8d2d\u8ba2\u5355\u8868\u51fa\u9519" + e));
            throw new RuntimeException("\u91c7\u8d2d\u5355\uff0c\u91c7\u8d2d\u660e\u7ec6\u751f\u6210\u539f\u5b50\u670d\u52a1\u521d\u59cb\u5316\u91c7\u8d2d\u8ba2\u5355\u8868\u51fa\u9519");
        }
    }

    private List<OrderPurchaseItemXbjPO> initOrderPurchaseItems(OrderPurchaseItemCrtXbjReqBO orderPurchaseItemCrtReqBO) {
        ArrayList<OrderPurchaseItemXbjPO> orderPurchaseItems = new ArrayList<OrderPurchaseItemXbjPO>();
        for (OrderPurchaseItemXbjBO orderPurchaseItemBO : orderPurchaseItemCrtReqBO.getOrderPurchaseItemBOs()) {
            OrderPurchaseItemXbjPO orderPurchaseItem = new OrderPurchaseItemXbjPO();
            BeanUtils.copyProperties((Object)orderPurchaseItemBO, (Object)orderPurchaseItem);
            BigDecimal purchasePrice = new BigDecimal(orderPurchaseItemBO.getPurchasingPrice());
            orderPurchaseItem.setTotal(orderPurchaseItemBO.getPurchaseCount().multiply(purchasePrice).longValue());
            orderPurchaseItem.setGoodsSupplierId(orderPurchaseItemBO.getGoodsSupplierId());
            orderPurchaseItem.setProfessionalOrganizationId(orderPurchaseItemBO.getProfessionalOrganizationId());
            orderPurchaseItem.setPurchaseOrderId(orderPurchaseItemBO.getPurchaseOrderId());
            orderPurchaseItem.setPurchaseOrderItemId(orderPurchaseItemBO.getPurchaseOrderItemId());
            orderPurchaseItem.setPurchaserAccountId(orderPurchaseItemBO.getPurchaserAccountId());
            orderPurchaseItem.setPurchaserAccountName(orderPurchaseItemBO.getPurchaserAccountName());
            orderPurchaseItem.setPurchaserId(orderPurchaseItemBO.getPurchaserId());
            orderPurchaseItem.setSaleOrderId(orderPurchaseItemBO.getSaleOrderId());
            orderPurchaseItem.setSkuCurrencyType(orderPurchaseItemBO.getSkuCurrencyType());
            orderPurchaseItem.setSaleOrderItemId(orderPurchaseItemBO.getSaleOrderItemId());
            orderPurchaseItem.setUnitName(orderPurchaseItemBO.getUnitName());
            orderPurchaseItem.setSkuName(orderPurchaseItemBO.getSkuName());
            orderPurchaseItem.setSkuSimpleName(orderPurchaseItemBO.getSkuSimpleName());
            orderPurchaseItem.setPurchaseCount(orderPurchaseItemBO.getPurchaseCount());
            orderPurchaseItem.setSendCount(BigDecimal.valueOf(0L));
            orderPurchaseItem.setWaitSendCount(orderPurchaseItemBO.getPurchaseCount());
            orderPurchaseItem.setExtSkuId(orderPurchaseItemBO.getExtSkuId());
            orderPurchaseItem.setExtSkuNakedPrice(orderPurchaseItemBO.getExtSkuNakedPrice());
            orderPurchaseItem.setExtSkuPrice(orderPurchaseItemBO.getExtSkuPrice());
            orderPurchaseItem.setExtSkuTax(orderPurchaseItemBO.getExtSkuTax());
            orderPurchaseItem.setExtSkuTaxPrice(orderPurchaseItemBO.getExtSkuTaxPrice());
            orderPurchaseItem.setPurchaserAccountOrgId(orderPurchaseItemBO.getPurchaserAccountOrgId());
            orderPurchaseItem.setDeptId(orderPurchaseItemBO.getDeptId());
            orderPurchaseItem.setPurchaseOrderItemStatus(orderPurchaseItemBO.getPurchaseItemStatus());
            orderPurchaseItem.setAcceptanceCount(orderPurchaseItemBO.getAcceptanceCount());
            orderPurchaseItem.setCompleteCount(orderPurchaseItemBO.getCompleteCount());
            orderPurchaseItem.setMarkUpRateNew(orderPurchaseItemBO.getMarkUpRateNew());
            orderPurchaseItem.setMarkUpRate(orderPurchaseItemBO.getMarkUpRate());
            orderPurchaseItem.setMaterialCode(orderPurchaseItemBO.getMaterialCode());
            orderPurchaseItem.setMaterialClassId(orderPurchaseItemBO.getMaterialClassId());
            orderPurchaseItem.setBrand(orderPurchaseItemBO.getBrand());
            orderPurchaseItem.setBrandId(orderPurchaseItemBO.getBrandId());
            orderPurchaseItem.setManufacturer(orderPurchaseItemBO.getManufacturer());
            orderPurchaseItem.setUsedCompany(orderPurchaseItemBO.getUsedCompany());
            orderPurchaseItem.setPreSendDate(DateUtil.strToDate(orderPurchaseItemBO.getPreSendDate()));
            orderPurchaseItem.setProjectId(orderPurchaseItemBO.getProjectId());
            orderPurchaseItem.setProjectCode(orderPurchaseItemBO.getProjectCode());
            orderPurchaseItem.setProjectName(orderPurchaseItemBO.getProjectName());
            orderPurchaseItem.setProjectContent(orderPurchaseItemBO.getContentDescription());
            orderPurchaseItems.add(orderPurchaseItem);
        }
        return orderPurchaseItems;
    }

    private Long initPurchaseMoney(OrderPurchaseItemCrtXbjReqBO orderPurchaseItemCrtReqBO, Long transFee) {
        Long purcahseMoney = 0L;
        if (null != orderPurchaseItemCrtReqBO.getOrderPurchaseItemBOs() && orderPurchaseItemCrtReqBO.getOrderPurchaseItemBOs().size() > 0) {
            for (OrderPurchaseItemXbjBO orderPurchaseItemBO : orderPurchaseItemCrtReqBO.getOrderPurchaseItemBOs()) {
                BigDecimal purchasePrice = new BigDecimal(orderPurchaseItemBO.getPurchasingPrice());
                purcahseMoney = purcahseMoney + orderPurchaseItemBO.getPurchaseCount().multiply(purchasePrice).longValue();
            }
            if (null == transFee) {
                transFee = 0L;
            }
            purcahseMoney = purcahseMoney + transFee;
        }
        return purcahseMoney;
    }
}

