/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.intfce.impl;

import com.cgd.base.mq.MqProducer;
import com.cgd.common.exception.BusinessException;
import com.cgd.electricitysupplier.busi.CancelOrderBusiService;
import com.cgd.electricitysupplier.busi.ConfirmOrderBusiService;
import com.cgd.electricitysupplier.busi.bo.CancelOrderReqBO;
import com.cgd.electricitysupplier.busi.bo.CancelOrderRspBO;
import com.cgd.electricitysupplier.busi.bo.ConfirmOrderReqBO;
import com.cgd.electricitysupplier.busi.bo.ConfirmOrderRspBO;
import com.cgd.order.atom.OrderSaleXbjAtomService;
import com.cgd.order.atom.bo.OrderSaleInfoXbjRspBO;
import com.cgd.order.busi.XbjOrderSaleStatusChgBusiService;
import com.cgd.order.busi.bo.XbjBusiPurchaseShipOrderCrtReqBO;
import com.cgd.order.busi.bo.XbjOrderSaleStatusChgReqBO;
import com.cgd.order.busi.bo.XbjOrderSaleStatusChgRspBO;
import com.cgd.order.constant.Constant;
import com.cgd.order.intfce.XbjConfirmOrderExamineIntfceService;
import com.cgd.order.intfce.bo.XbjConfirmOrderExamineIntfceReqBO;
import com.cgd.order.intfce.bo.XbjConfirmOrderExamineIntfceRspBO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

public class XbjConfirmOrderExamineIntfceServiceImpl
implements XbjConfirmOrderExamineIntfceService {
    private static final Log log = LogFactory.getLog(XbjConfirmOrderExamineIntfceServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    private OrderSaleXbjAtomService orderSaleXbjAtomService;
    private ConfirmOrderBusiService confirmOrderBusiService;
    private XbjOrderSaleStatusChgBusiService xbjOrderSaleStatusChgBusiService;
    private CancelOrderBusiService cancelOrderBusiService;

    public XbjConfirmOrderExamineIntfceRspBO confirmOrderExamine(XbjConfirmOrderExamineIntfceReqBO req) {
        if (this.isDebugEnabled) {
            log.debug((Object)("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5ba1\u6838\u786e\u8ba4\u7ec4\u5408\u670d\u52a1\u5165\u53c2\uff1a" + req.toString()));
        }
        try {
            if (StringUtils.isEmpty((Object)req.getSaleOrderId())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5ba1\u6838\u786e\u8ba4\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u9500\u552e\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)req.getPurchaserId())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5ba1\u6838\u786e\u8ba4\u7ec4\u5408\u670d\u52a1\u5165\u53c2\u91c7\u8d2d\u5546\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            XbjConfirmOrderExamineIntfceRspBO rsp = new XbjConfirmOrderExamineIntfceRspBO();
            OrderSaleInfoXbjRspBO xbjOrderSaleInfoRspBO = this.orderSaleXbjAtomService.queryOrderSaleById(req.getSaleOrderId(), req.getPurchaserId());
            if (xbjOrderSaleInfoRspBO == null) {
                rsp.setRespCode("8888");
                rsp.setRespDesc("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u65e0\u6570\u636e");
                rsp.setResultDesc("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u65e0\u6570\u636e");
                return rsp;
            }
            if (this.isDebugEnabled) {
                log.debug((Object)("\u9884\u8ba2\u5355\u786e\u8ba4\u5165\u53c2\uff1aextOrderId:" + xbjOrderSaleInfoRspBO.getExtOrderId() + " \u4f9b\u5e94\u5546ID\uff1a" + xbjOrderSaleInfoRspBO.getGoodsSupplierId()));
            }
            ConfirmOrderReqBO confirmOrderReqBO = new ConfirmOrderReqBO();
            confirmOrderReqBO.setOrderId(xbjOrderSaleInfoRspBO.getExtOrderId());
            confirmOrderReqBO.setSupplierId(xbjOrderSaleInfoRspBO.getGoodsSupplierId());
            ConfirmOrderRspBO confirmOrderRsp = new ConfirmOrderRspBO();
            confirmOrderRsp.setRespCode("0000");
            if ("0000".equals(confirmOrderRsp.getRespCode())) {
                if (this.isDebugEnabled) {
                    log.debug((Object)"\u9500\u552e\u8ba2\u5355\u9884\u5b9a\u5355\u786e\u8ba4\u63a5\u53e3\u670d\u52a1\uff0c\u9884\u5b9a\u5355\u786e\u8ba4\u5b8c\u6210");
                }
                this.updateOrderSaleState(xbjOrderSaleInfoRspBO, Constant.SALSE_ORDER_STATE_TO_SENDING);
                XbjBusiPurchaseShipOrderCrtReqBO busiPurchaseShipOrderCrtReq = new XbjBusiPurchaseShipOrderCrtReqBO();
                busiPurchaseShipOrderCrtReq.setSaleOrderId(req.getSaleOrderId());
                busiPurchaseShipOrderCrtReq.setPurchaserId(req.getPurchaserId());
                busiPurchaseShipOrderCrtReq.setSaleOrderPurchaseType(xbjOrderSaleInfoRspBO.getSaleOrderPurchaseType());
                MqProducer.sendMsg((String)"SEND_ORDER_PURCHASE_TOPIC", (String)"SEND_ORDER_PURCHASE_TAG", (Object)busiPurchaseShipOrderCrtReq);
            } else {
                if (this.isDebugEnabled) {
                    log.debug((Object)"\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5ba1\u6838\u786e\u8ba4\u7ec4\u5408\u670d\u52a1\uff0c\u9884\u5b9a\u5355\u786e\u8ba4\u5931\u8d25");
                }
                this.updateOrderSaleState(xbjOrderSaleInfoRspBO, Constant.SALSE_ORDER_STATE_STATE_CONF_FALL);
                rsp.setRespCode("8888");
                rsp.setRespDesc("\u5931\u8d25");
                rsp.setResultDesc("\u9500\u552e\u8ba2\u5355\u786e\u8ba4\u5931\u8d25");
                CancelOrderReqBO cancelOrderReq = new CancelOrderReqBO();
                cancelOrderReq.setOrderId(xbjOrderSaleInfoRspBO.getExtOrderId());
                cancelOrderReq.setSupplierId(xbjOrderSaleInfoRspBO.getGoodsSupplierId());
                CancelOrderRspBO cancelOrderRsp = new CancelOrderRspBO();
                confirmOrderRsp.setRespCode("0000");
                if ("8888".equals(cancelOrderRsp.getRespCode())) {
                    if (this.isDebugEnabled) {
                        log.debug((Object)"\u9500\u552e\u8ba2\u5355\u9884\u5b9a\u5355\u786e\u8ba4\u63a5\u53e3\u670d\u52a1 \u53d6\u6d88\u7535\u5546\u8ba2\u5355\u5931\u8d25");
                    }
                    throw new BusinessException("RSP_CODE_SALSE_ORDER_STATE_PRE_CONF_FAIL", cancelOrderRsp.getRespDesc());
                }
            }
            return rsp;
        }
        catch (BusinessException e) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", e.getMessage());
        }
        catch (Exception e) {
            log.error((Object)"\u9500\u552e\u8ba2\u5355\u9884\u5b9a\u5355\u786e\u8ba4\u63a5\u53e3\u670d\u52a1\u5f02\u5e38\uff01", (Throwable)e);
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", e.getMessage());
        }
    }

    private void updateOrderSaleState(OrderSaleInfoXbjRspBO orderSaleInfoXbjRsp, Integer state) {
        XbjOrderSaleStatusChgReqBO xbjOrderSaleStatusChgReq = new XbjOrderSaleStatusChgReqBO();
        BeanUtils.copyProperties((Object)orderSaleInfoXbjRsp, (Object)xbjOrderSaleStatusChgReq);
        xbjOrderSaleStatusChgReq.setSaleOrderStatus(state);
        xbjOrderSaleStatusChgReq.setProfessionalOrganizationId(orderSaleInfoXbjRsp.getProfessionalOrganizationId());
        XbjOrderSaleStatusChgRspBO xbjOrderSaleStatusChgRsp = this.xbjOrderSaleStatusChgBusiService.modifyOrderSaleStatus(xbjOrderSaleStatusChgReq);
        if ("0000".equals(xbjOrderSaleStatusChgRsp.getRespCode())) {
            if (this.isDebugEnabled) {
                log.debug((Object)"\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5ba1\u6838\u786e\u8ba4\uff0c\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u5b8c\u6210");
            }
        } else {
            if (this.isDebugEnabled) {
                log.debug((Object)"\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5ba1\u6838\u786e\u8ba4\uff0c\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u5931\u8d25");
            }
            throw new BusinessException("RSP_CODE_STATUS_CHNG_ERR", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5ba1\u6838\u786e\u8ba4\uff0c\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u5931\u8d25");
        }
    }

    public OrderSaleXbjAtomService getOrderSaleXbjAtomService() {
        return this.orderSaleXbjAtomService;
    }

    public void setOrderSaleXbjAtomService(OrderSaleXbjAtomService orderSaleXbjAtomService) {
        this.orderSaleXbjAtomService = orderSaleXbjAtomService;
    }

    public ConfirmOrderBusiService getConfirmOrderBusiService() {
        return this.confirmOrderBusiService;
    }

    public void setConfirmOrderBusiService(ConfirmOrderBusiService confirmOrderBusiService) {
        this.confirmOrderBusiService = confirmOrderBusiService;
    }

    public XbjOrderSaleStatusChgBusiService getXbjOrderSaleStatusChgBusiService() {
        return this.xbjOrderSaleStatusChgBusiService;
    }

    public void setXbjOrderSaleStatusChgBusiService(XbjOrderSaleStatusChgBusiService xbjOrderSaleStatusChgBusiService) {
        this.xbjOrderSaleStatusChgBusiService = xbjOrderSaleStatusChgBusiService;
    }

    public CancelOrderBusiService getCancelOrderBusiService() {
        return this.cancelOrderBusiService;
    }

    public void setCancelOrderBusiService(CancelOrderBusiService cancelOrderBusiService) {
        this.cancelOrderBusiService = cancelOrderBusiService;
    }
}

