/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.alibaba.fastjson.JSON;
import com.cgd.common.bo.RspInfoBO;
import com.cgd.common.busi.bo.RspBusiBaseBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.order.atom.OrderConstrConfirmXbjAtomService;
import com.cgd.order.atom.OrderStatusChangeXbjAtomService;
import com.cgd.order.atom.SaleOrderStatusCheckXbjService;
import com.cgd.order.atom.XbjCreateOrderFlowSheetAtomService;
import com.cgd.order.atom.XbjOrderSendMsgAtomService;
import com.cgd.order.atom.bo.GenerateOrderIdAndCodeXbjRspBO;
import com.cgd.order.atom.bo.OrderConstrConfirmAccessoryXbjBO;
import com.cgd.order.atom.bo.OrderConstrConfirmItemXbjBO;
import com.cgd.order.atom.bo.OrderConstrConfirmXbjReqBO;
import com.cgd.order.atom.bo.OrderSendMsgAtomXbjReqBO;
import com.cgd.order.atom.bo.OrderStatusChangeXbjReqBO;
import com.cgd.order.atom.bo.SaleOrderStatusCheckXbjReqBO;
import com.cgd.order.atom.bo.SaleOrderStatusCheckXbjRspBO;
import com.cgd.order.busi.XbjOrderConstructionConfirmBusiService;
import com.cgd.order.busi.bo.XbjOrderFlowSheetReqBO;
import com.cgd.order.busi.bo.XbjOrderFlowSheetRspBO;
import com.cgd.order.busi.bo.XbjPurchaseAccessoryReqBO;
import com.cgd.order.constant.Constant;
import com.cgd.order.constant.OrderCenterConstant;
import com.cgd.order.constant.XConstant;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.OrderAfterSaleXbjMapper;
import com.cgd.order.dao.OrderConstrCompleteItemXbjMapper;
import com.cgd.order.dao.OrderConstrCompleteXbjMapper;
import com.cgd.order.dao.OrderProtocolItemXbjMapper;
import com.cgd.order.dao.OrderPurchaseItemXbjMapper;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.intfce.bo.XbjConstrInfoBO;
import com.cgd.order.intfce.bo.XbjOrderConstructionConfirmIntfceReqBO;
import com.cgd.order.intfce.bo.XbjOrderConstructionConfirmIntfceRspBO;
import com.cgd.order.po.OrderAfterSaleXbjPO;
import com.cgd.order.po.OrderConstrCompleteItemXbjPO;
import com.cgd.order.po.OrderConstrCompleteXbjPO;
import com.cgd.order.po.OrderProtocolItemXbjPO;
import com.cgd.order.po.OrderPurchaseItemXbjPO;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import com.cgd.pay.busi.PayAddTradeServiceFeeService;
import com.cgd.pay.busi.bo.PayAddTradeServiceFeeReqBO;
import com.cgd.pay.enums.CompanyType;
import com.cgd.user.supplier.busi.SelectSupplierInfoByIdBusiService;
import com.cgd.user.supplier.busi.bo.SelectSupplierInfoByIdReqBO;
import com.cgd.user.supplier.busi.bo.SelectSupplierInfoByIdRspBO;
import com.cgd.user.supplier.documcollect.bo.UpdateDocumentCollectStatusReqBO;
import com.cgd.user.supplier.documcollect.busi.UpdateDocumentCollectStatusBusiService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class XbjOrderConstructionConfirmBusiServiceImpl
implements XbjOrderConstructionConfirmBusiService {
    private static final Logger logger = LoggerFactory.getLogger(XbjOrderConstructionConfirmBusiServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private OrderSaleXbjMapper orderSaleXbjMapper;
    @Autowired
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;
    @Autowired
    private OrderAfterSaleXbjMapper orderAfterSaleXbjMapper;
    @Autowired
    private OrderConstrCompleteItemXbjMapper orderConstrCompleteItemXbjMapper;
    @Autowired
    private OrderStatusChangeXbjAtomService orderStatusChangeXbjAtomService;
    @Autowired
    private OrderConstrConfirmXbjAtomService orderConstrConfirmXbjAtomService;
    @Autowired
    private SaleOrderStatusCheckXbjService saleOrderStatusCheckXbjService;
    @Autowired
    private PayAddTradeServiceFeeService payAddTradeServiceFeeService;
    @Autowired
    private OrderProtocolItemXbjMapper orderProtocolItemXbjMapper;
    @Autowired
    private XbjCreateOrderFlowSheetAtomService createOrderFlowSheetAtomService;
    @Autowired
    private OrderPurchaseItemXbjMapper orderPurchaseItemXbjMapper;
    @Autowired
    private SelectSupplierInfoByIdBusiService selectSupplierInfoByIdBusiService;
    @Autowired
    private XbjOrderSendMsgAtomService xbjOrderSendMsgAtomService;
    @Autowired
    private UpdateDocumentCollectStatusBusiService updateDocumentCollectStatusBusiService;
    @Autowired
    private OrderConstrCompleteXbjMapper orderConstrCompleteXbjMapper;

    public XbjOrderConstructionConfirmIntfceRspBO dealXbjOrderConstructionConfirm(XbjOrderConstructionConfirmIntfceReqBO reqBO) {
        XbjOrderConstructionConfirmIntfceRspBO rspBO;
        block17: {
            rspBO = new XbjOrderConstructionConfirmIntfceRspBO();
            try {
                this.dealWithParamVerify(reqBO);
                if (reqBO.getConstrCompleteOrderId() != null && !"".equals(reqBO.getConstrCompleteOrderId())) {
                    OrderConstrCompleteXbjPO orderConstrCompleteXbjPO = this.orderConstrCompleteXbjMapper.getModelById(reqBO.getConstrCompleteOrderId());
                    if (orderConstrCompleteXbjPO == null) {
                        throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6839\u636e\u65bd\u5de5\u5b8c\u5de5\u5355ID\u3010" + reqBO.getConstrCompleteOrderId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u5b8c\u5de5\u5355\u6570\u636e");
                    }
                    reqBO.setSaleOrderId(orderConstrCompleteXbjPO.getSaleOrderId());
                }
                OrderSaleXbjPO orderSaleXbjPO = this.dealWithOrderSaleExist(reqBO);
                if (reqBO.getPurchaserOrderId() == null) {
                    reqBO.setPurchaserOrderId(orderSaleXbjPO.getPurchaseOrderId());
                }
                this.dealWithBusiVerify(reqBO, orderSaleXbjPO);
                OrderSaleXbjPO orderSaleReqPO = new OrderSaleXbjPO();
                orderSaleReqPO.setSaleOrderId(reqBO.getSaleOrderId());
                orderSaleReqPO.setPurchaserId(reqBO.getPurchaserId());
                OrderSaleXbjPO orderSalePO = this.orderSaleXbjMapper.getModelBy(orderSaleReqPO);
                if (orderSalePO == null) {
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u670d\u52a1\u7ec4\u5408\u670d\u52a1\u5931\u8d25,\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u65e0\u6570\u636e");
                }
                OrderConstrConfirmXbjReqBO orderConstrConfirmXbjReqBO = this.dealWithParamCreate(reqBO);
                GenerateOrderIdAndCodeXbjRspBO orderIdAndCodeRspBO = this.orderConstrConfirmXbjAtomService.insertConstrConfirmDetail(orderConstrConfirmXbjReqBO);
                if (XbjOrderConstants.SALE_ORDER_PURCHASE_WHOLE_ACCEPTANCE_YES.intValue() == reqBO.getCompleteFlag().intValue()) {
                    OrderStatusChangeXbjReqBO orderStatusChangeXbjReqBO = new OrderStatusChangeXbjReqBO();
                    orderStatusChangeXbjReqBO.setOperId(reqBO.getUserId());
                    orderStatusChangeXbjReqBO.setPurchaserId(reqBO.getPurchaserId());
                    orderStatusChangeXbjReqBO.setPurchaseOrderId(reqBO.getPurchaserOrderId());
                    orderStatusChangeXbjReqBO.setPurchaseOrderStatusNew(OrderCenterConstant.SLAE_ORDER_STATUS.FINISH);
                    orderStatusChangeXbjReqBO.setSaleOrderId(reqBO.getSaleOrderId());
                    orderStatusChangeXbjReqBO.setSaleOrderStatusNew(OrderCenterConstant.SLAE_ORDER_STATUS.FINISH);
                    this.orderStatusChangeXbjAtomService.updateStatus(orderStatusChangeXbjReqBO);
                    this.updateWholeAcceptance(reqBO.getPurchaserId(), reqBO.getPurchaserOrderId(), reqBO.getSaleOrderId());
                    RspInfoBO rspInfoBO = this.updateDocumentStatus(orderSalePO.getSaleOrderId());
                    if (rspInfoBO == null || !"0000".equals(rspInfoBO.getRespCode())) {
                        throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u65bd\u5de5\u9a8c\u6536\u8c03\u7528\u66f4\u6539\u5355\u636e\u72b6\u6001\u670d\u52a1\u5931\u8d25");
                    }
                }
                this.updateAcceptanceCount(reqBO.getConstrInfoList(), reqBO);
                PayAddTradeServiceFeeReqBO payAddTradeServiceFeeReqBO = this.initPayAddServicePO(orderSaleXbjPO, orderIdAndCodeRspBO, reqBO);
                if (!(payAddTradeServiceFeeReqBO.getPayMoney().compareTo(BigDecimal.valueOf(0L)) <= 0 || XConstant.SALE_ORDER_TYPE_PROTOCOL.equals(orderSalePO.getSaleOrderType()) && Constant.IS_DISPATCH_NO.equals(orderSalePO.getIsDispatch()))) {
                    try {
                        if (this.isDebugEnabled) {
                            logger.debug("\u8c03\u7528\u7f34\u8d39\u670d\u52a1\u5165\u53c2" + JSON.toJSONString((Object)payAddTradeServiceFeeReqBO));
                        }
                        logger.error("\u8c03\u7528\u7f34\u8d39\u670d\u52a1\u5165\u53c2==============================" + JSON.toJSONString((Object)payAddTradeServiceFeeReqBO));
                        RspBusiBaseBO payAddTradeRspBO = this.payAddTradeServiceFeeService.addTradeServiceFee(payAddTradeServiceFeeReqBO);
                        if (this.isDebugEnabled) {
                            logger.debug("\u8c03\u7528\u7f34\u8d39\u670d\u52a1\u51fa\u53c2" + JSON.toJSONString((Object)payAddTradeRspBO));
                        }
                        if (payAddTradeRspBO != null && !"0000".equalsIgnoreCase(payAddTradeRspBO.getRespCode())) {
                            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u7f34\u8d39\u670d\u52a1\u5f02\u5e38");
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u7f34\u8d39\u670d\u52a1\u5f02\u5e38", (Throwable)e);
                        throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u7f34\u8d39\u670d\u52a1\u5f02\u5e38");
                    }
                }
                this.sendMessage(orderSalePO, reqBO, orderIdAndCodeRspBO.getOrderCode());
                XbjOrderFlowSheetReqBO orderFlowSheetReqBO = new XbjOrderFlowSheetReqBO();
                orderFlowSheetReqBO.setOrderId(Long.valueOf(reqBO.getSaleOrderId()));
                orderFlowSheetReqBO.setPurchaserId(Long.valueOf(reqBO.getPurchaserId()));
                orderFlowSheetReqBO.setOrderType(OrderCenterConstant.ORDER_TYPE.SALE);
                orderFlowSheetReqBO.setOrderBusiType("B_22");
                orderFlowSheetReqBO.setUserId(reqBO.getUserId());
                orderFlowSheetReqBO.setCompanyName(reqBO.getCompanyName());
                orderFlowSheetReqBO.setUserName(reqBO.getUserName());
                orderFlowSheetReqBO.setCompanyName(reqBO.getCompanyName());
                orderFlowSheetReqBO.setOperRole("\u5e93\u7ba1\u5458");
                XbjOrderFlowSheetRspBO orderFlowSheetRspBO = this.createOrderFlowSheetAtomService.createOrderFlowSheet(orderFlowSheetReqBO);
                if (null != orderFlowSheetRspBO && orderFlowSheetRspBO.getRespCode().equals("0000")) {
                    if (this.isDebugEnabled) {
                        logger.debug("\u8ba2\u5355\u5206\u914d\u6210\u529f\uff0c\u6267\u884c\u6d41\u7a0b\u751f\u6210\u4e1a\u52a1\u6210\u529f");
                    }
                    break block17;
                }
                logger.error("\u8ba2\u5355\u5206\u914d\u6210\u529f\uff0c\u6267\u884c\u6d41\u7a0b\u751f\u6210\u4e1a\u52a1\u5931\u8d25\uff1a" + orderFlowSheetRspBO.getRespDesc());
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8ba2\u5355\u5ba1\u6838\u670d\u52a1\u5f02\u5e38\uff1a\u5199\u6d41\u7a0b\u4fe1\u606f\u5931\u8d25\uff01");
            }
            catch (BusinessException e) {
                logger.error("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5230\u8d27\u9a8c\u6536\u7ec4\u5408\u670d\u52a1\u5f02\u5e38\uff01" + e.getMessage(), (Throwable)e);
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(e.getMessage());
                return rspBO;
            }
            catch (Exception e) {
                logger.error("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5230\u8d27\u9a8c\u6536\u7ec4\u5408\u670d\u52a1\u5f02\u5e38\uff01" + e.getMessage(), (Throwable)e);
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5230\u8d27\u9a8c\u6536\u7ec4\u5408\u670d\u52a1\u63d0\u4ea4\u5931\u8d25" + e.getMessage());
                return rspBO;
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8ba2\u5355\u65bd\u5de5\u9a8c\u6536\u6210\u529f");
        return rspBO;
    }

    private OrderConstrConfirmXbjReqBO dealWithParamCreate(XbjOrderConstructionConfirmIntfceReqBO reqBO) {
        OrderConstrConfirmXbjReqBO orderConstrConfirmXbjReqBO = new OrderConstrConfirmXbjReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)orderConstrConfirmXbjReqBO);
        orderConstrConfirmXbjReqBO.setOperId(reqBO.getUserId());
        ArrayList<OrderConstrConfirmItemXbjBO> confirmItemList = new ArrayList<OrderConstrConfirmItemXbjBO>();
        for (XbjConstrInfoBO tempBO : reqBO.getConstrInfoList()) {
            OrderConstrConfirmItemXbjBO orderConstrConfirmItemXbjBO = new OrderConstrConfirmItemXbjBO();
            BeanUtils.copyProperties((Object)tempBO, (Object)orderConstrConfirmItemXbjBO);
            confirmItemList.add(orderConstrConfirmItemXbjBO);
        }
        orderConstrConfirmXbjReqBO.setConfirmItemList(confirmItemList);
        if (reqBO.getAccessoryInfoList() != null && reqBO.getAccessoryInfoList().size() > 0) {
            ArrayList<OrderConstrConfirmAccessoryXbjBO> accessoryList = new ArrayList<OrderConstrConfirmAccessoryXbjBO>();
            for (XbjPurchaseAccessoryReqBO tempBO : reqBO.getAccessoryInfoList()) {
                OrderConstrConfirmAccessoryXbjBO orderConstrConfirmAccessoryXbjBO = new OrderConstrConfirmAccessoryXbjBO();
                BeanUtils.copyProperties((Object)tempBO, (Object)orderConstrConfirmAccessoryXbjBO);
                accessoryList.add(orderConstrConfirmAccessoryXbjBO);
            }
            orderConstrConfirmXbjReqBO.setAccessoryList(accessoryList);
        }
        return orderConstrConfirmXbjReqBO;
    }

    private void updateAcceptanceCount(List<XbjConstrInfoBO> constrInfoList, XbjOrderConstructionConfirmIntfceReqBO req) {
        try {
            for (XbjConstrInfoBO constrInfoTemp : constrInfoList) {
                OrderConstrCompleteItemXbjPO orderConstrCompleteItemReqPO = new OrderConstrCompleteItemXbjPO();
                orderConstrCompleteItemReqPO.setPurchaseOrderItemId(constrInfoTemp.getPurchaseOrderItemId());
                orderConstrCompleteItemReqPO.setConstrCompleteOrderId(constrInfoTemp.getConstrCompleteOrderId());
                OrderConstrCompleteItemXbjPO orderConstrCompleteItemPO = this.orderConstrCompleteItemXbjMapper.getModelBy(orderConstrCompleteItemReqPO);
                BigDecimal acceptanceCountOld = orderConstrCompleteItemPO.getAcceptanceCount();
                acceptanceCountOld = acceptanceCountOld == null ? new BigDecimal(0) : acceptanceCountOld;
                BigDecimal acceptanceCountNew = acceptanceCountOld.add(constrInfoTemp.getConstrCount());
                orderConstrCompleteItemPO.setAcceptanceCount(acceptanceCountNew);
                this.orderConstrCompleteItemXbjMapper.updateById(orderConstrCompleteItemPO);
            }
            if (req.getConstrCompleteOrderId() != null && !"".equals(req.getConstrCompleteOrderId())) {
                BigDecimal sendCountAll = BigDecimal.ZERO;
                BigDecimal acceptCountAll = BigDecimal.ZERO;
                OrderConstrCompleteItemXbjPO orderConstrCompleteItemXbjPO = new OrderConstrCompleteItemXbjPO();
                orderConstrCompleteItemXbjPO.setConstrCompleteOrderId(req.getConstrCompleteOrderId());
                orderConstrCompleteItemXbjPO.setPurchaserId(req.getPurchaserId());
                List<OrderConstrCompleteItemXbjPO> orderConstrCompleteInfos = this.orderConstrCompleteItemXbjMapper.getList(orderConstrCompleteItemXbjPO);
                if (orderConstrCompleteInfos != null && orderConstrCompleteInfos.size() > 0) {
                    for (OrderConstrCompleteItemXbjPO po : orderConstrCompleteInfos) {
                        sendCountAll = sendCountAll.add(po.getOnceCompleteCount());
                        if (po.getAcceptanceCount() == null) continue;
                        acceptCountAll = acceptCountAll.add(po.getAcceptanceCount());
                    }
                }
                if (acceptCountAll.compareTo(sendCountAll) == 0) {
                    OrderConstrCompleteXbjPO orderConstrCompleteXbjPO = new OrderConstrCompleteXbjPO();
                    orderConstrCompleteXbjPO.setConstrCompleteOrderId(req.getConstrCompleteOrderId());
                    orderConstrCompleteXbjPO.setConstrStatus(XbjOrderConstants.SERV_SHIP_STATUS_ACCEPT);
                    orderConstrCompleteXbjPO.setModifyOperId(req.getUserId());
                    orderConstrCompleteXbjPO.setModifyTime(new Date());
                    this.orderConstrCompleteXbjMapper.updateConstrCompleteByOrderId(orderConstrCompleteXbjPO);
                }
            }
        }
        catch (Exception e) {
            if (this.isDebugEnabled) {
                logger.debug("\u66f4\u65b0\u65bd\u5de5\u5b8c\u5de5\u5355\u660e\u7ec6\u7684\u5df2\u9a8c\u6536\u6570\u91cf\u5b57\u6bb5\u5f02\u5e38:{}", (Object)e.getMessage());
                e.printStackTrace();
            }
            logger.error("\u66f4\u65b0\u65bd\u5de5\u5b8c\u5de5\u5355\u660e\u7ec6\u7684\u5df2\u9a8c\u6536\u6570\u91cf\u5b57\u6bb5\u5f02\u5e38:", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u66f4\u65b0\u65bd\u5de5\u5b8c\u5de5\u5355\u660e\u7ec6\u7684\u5df2\u9a8c\u6536\u6570\u91cf\u5b57\u6bb5\u5f02\u5e38:" + e.getMessage());
        }
    }

    private void updateWholeAcceptance(Long purchaserId, Long purchaseOrderId, Long saleOrderId) {
        try {
            OrderSaleXbjPO orderSaleReqPO = new OrderSaleXbjPO();
            orderSaleReqPO.setSaleOrderId(saleOrderId);
            orderSaleReqPO.setPurchaserId(purchaserId);
            OrderSaleXbjPO orderSalePO = this.orderSaleXbjMapper.getModelBy(orderSaleReqPO);
            orderSalePO.setWholeAcceptance(XbjOrderConstants.SALE_ORDER_PURCHASE_WHOLE_ACCEPTANCE_YES);
            this.orderSaleXbjMapper.updateById(orderSalePO);
            OrderPurchaseXbjPO orderPurchaseReqPO = new OrderPurchaseXbjPO();
            orderPurchaseReqPO.setPurchaseOrderId(purchaseOrderId);
            orderPurchaseReqPO.setPurchaserId(purchaserId);
            OrderPurchaseXbjPO orderPurchasePO = this.orderPurchaseXbjMapper.getModelBy(orderPurchaseReqPO);
            orderPurchasePO.setWholeAcceptance(XbjOrderConstants.SALE_ORDER_PURCHASE_WHOLE_ACCEPTANCE_YES);
            this.orderPurchaseXbjMapper.updateById(orderPurchasePO);
        }
        catch (Exception e) {
            if (this.isDebugEnabled) {
                logger.debug("\u66f4\u65b0\u9500\u552e\u8ba2\u5355\u548c\u91c7\u8d2d\u8ba2\u5355\u6574\u5355\u7684\u9a8c\u6536\u6807\u8bc6\u5b57\u6bb5\u4e3a\u5df2\u6574\u5355\u9a8c\u6536\u5f02\u5e38:{}", (Object)e.getMessage());
                e.printStackTrace();
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u66f4\u65b0\u9500\u552e\u8ba2\u5355\u548c\u91c7\u8d2d\u8ba2\u5355\u6574\u5355\u7684\u9a8c\u6536\u6807\u8bc6\u5b57\u6bb5\u4e3a\u5df2\u6574\u5355\u9a8c\u6536\u5f02\u5e38:" + e.getMessage());
        }
    }

    private void dealWithBusiVerify(XbjOrderConstructionConfirmIntfceReqBO reqBO, OrderSaleXbjPO orderSaleXbjPO) {
        OrderAfterSaleXbjPO orderAfterSaleXbjPO = new OrderAfterSaleXbjPO();
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(Integer.valueOf("500"));
        statusList.add(Integer.valueOf("600"));
        orderAfterSaleXbjPO.setStatusList(statusList);
        orderAfterSaleXbjPO.setSaleOrderId(orderSaleXbjPO.getSaleOrderId());
        List<OrderAfterSaleXbjPO> orderAfterSaleLits = this.orderAfterSaleXbjMapper.queryByOrderIdAndInStatusCondition(orderAfterSaleXbjPO);
        if (null != orderAfterSaleLits && orderAfterSaleLits.size() > 0) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9500\u552e\u8ba2\u5355[" + orderSaleXbjPO.getSaleOrderId() + "]\u5b58\u5728\u9000\u8d27\u4e2d\u8ba2\u5355\uff0c\u65e0\u6cd5\u786e\u8ba4\u6536\u8d27!");
        }
        if ("1".equals(reqBO.getCompleteFlag())) {
            SaleOrderStatusCheckXbjReqBO saleOrderStatusCheckReq = new SaleOrderStatusCheckXbjReqBO();
            saleOrderStatusCheckReq.setSaleOrderType(orderSaleXbjPO.getSaleOrderType());
            saleOrderStatusCheckReq.setNewSaleOrderStatus(OrderCenterConstant.SLAE_ORDER_STATUS.FINISH);
            saleOrderStatusCheckReq.setOldSaleOrderStatus(orderSaleXbjPO.getSaleOrderStatus());
            SaleOrderStatusCheckXbjRspBO saleOrderStatusCheckXbjRspBO = this.saleOrderStatusCheckXbjService.notifySaleOrderStatus(saleOrderStatusCheckReq);
            if (!"0000".equals(saleOrderStatusCheckXbjRspBO.getCheckRspCode())) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9500\u552e\u8ba2\u5355[" + orderSaleXbjPO.getSaleOrderId() + "]\u72b6\u6001\u6821\u9a8c\u5931\u8d25!" + saleOrderStatusCheckXbjRspBO.getCheckRspDesc());
            }
        }
        try {
            this.checkCount(reqBO, orderSaleXbjPO);
        }
        catch (BusinessException e) {
            logger.error("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5230\u8d27\u9a8c\u6536\u7ec4\u5408\u670d\u52a1\u5f02\u5e38\uff01" + e.getMessage(), (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "" + e.getMessage());
        }
        catch (Exception e) {
            if (this.isDebugEnabled) {
                logger.debug("\u6821\u9a8c\u9a8c\u6536\u6570\u91cf\u5f02\u5e38:{}", (Object)e.getMessage());
                e.printStackTrace();
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6821\u9a8c\u9a8c\u6536\u6570\u91cf\u5f02\u5e38:" + e.getMessage());
        }
    }

    private void checkCount(XbjOrderConstructionConfirmIntfceReqBO reqBO, OrderSaleXbjPO orderSaleXbjPO) throws Exception {
        BigDecimal finishedCountTotal = new BigDecimal("0");
        BigDecimal checkedCountTotal = new BigDecimal("0");
        BigDecimal nowcheckingCountTotal = new BigDecimal("0");
        List constrInfoList = reqBO.getConstrInfoList();
        for (XbjConstrInfoBO constrInfoBO : constrInfoList) {
            OrderConstrCompleteItemXbjPO completeItemXbjPO = new OrderConstrCompleteItemXbjPO();
            completeItemXbjPO.setPurchaserId(reqBO.getPurchaserId());
            completeItemXbjPO.setConstrCompleteOrderId(constrInfoBO.getConstrCompleteOrderId());
            completeItemXbjPO.setPurchaseOrderItemId(constrInfoBO.getPurchaseOrderItemId());
            OrderConstrCompleteItemXbjPO servItemInfo = this.orderConstrCompleteItemXbjMapper.getModelBy(completeItemXbjPO);
            if (servItemInfo == null) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u65bd\u5de5\u9a8c\u6536\u7ec4\u5408\u670d\u52a1\u5931\u8d25\uff0c\u6839\u636e\u91c7\u8d2d\u660e\u7ec6id\u548c\u65bd\u5de5\u5355ID\u3010" + constrInfoBO.getPurchaseOrderItemId() + "\u3001" + constrInfoBO.getConstrCompleteOrderId() + "\u3011\u672a\u627e\u5230\u6307\u5b9a\u7684\u65bd\u5de5\u8ba2\u5355\u5b8c\u5de5\u660e\u7ec6");
            }
            BigDecimal finishedCount = servItemInfo.getOnceCompleteCount();
            finishedCount = finishedCount == null ? new BigDecimal(0) : finishedCount;
            finishedCountTotal = finishedCountTotal.add(finishedCount);
            BigDecimal checkedCount = servItemInfo.getAcceptanceCount();
            checkedCount = checkedCount == null ? new BigDecimal(0) : checkedCount;
            BigDecimal nowcheckingCount = constrInfoBO.getConstrCount();
            checkedCountTotal = checkedCountTotal.add(checkedCount);
            nowcheckingCountTotal = nowcheckingCountTotal.add(nowcheckingCount);
            BigDecimal checkTotal = checkedCount.add(nowcheckingCount);
            if (XConstant.ORDER_TYPE.TOTAL_TYPE == orderSaleXbjPO.getOrderType()) {
                if (reqBO.getCompleteFlag().equals("1") && nowcheckingCount.compareTo(finishedCount) != 0 && checkTotal.compareTo(finishedCount) != 0) {
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u603b\u4ef7\u578b\u8ba2\u5355\u5fc5\u987b\u5168\u90e8\u4e00\u8d77\u9a8c\u6536");
                }
                if (nowcheckingCount.compareTo(finishedCount) <= 0 || checkTotal.compareTo(finishedCount) <= 0) continue;
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9a8c\u6536\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u5b8c\u5de5\u6570\u91cf");
            }
            if (XConstant.ORDER_TYPE.SINGLE_TYPE == orderSaleXbjPO.getOrderType()) {
                if (nowcheckingCount.divide(finishedCount).compareTo(new BigDecimal("1.2")) <= 0 || checkTotal.divide(finishedCount).compareTo(new BigDecimal("1.2")) <= 0) continue;
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5355\u4ef7\u578b\u9a8c\u6536\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u9a8c\u6536\u6570\u91cf\u76841.2\u500d");
            }
            if (nowcheckingCount.compareTo(finishedCount) <= 0 || checkTotal.compareTo(finishedCount) <= 0) continue;
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9a8c\u6536\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u5b8c\u5de5\u6570\u91cf");
        }
        BigDecimal totalCheck = checkedCountTotal.add(nowcheckingCountTotal);
        if (XConstant.ORDER_TYPE.TOTAL_TYPE == orderSaleXbjPO.getOrderType()) {
            if (reqBO.getCompleteFlag().equals("1") && totalCheck.compareTo(finishedCountTotal) != 0) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u603b\u4ef7\u578b\u8ba2\u5355\u5fc5\u987b\u5168\u90e8\u4e00\u8d77\u9a8c\u6536");
            }
            if (totalCheck.compareTo(finishedCountTotal) > 0) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9a8c\u6536\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u5b8c\u5de5\u6570\u91cf");
            }
        } else if (XConstant.ORDER_TYPE.SINGLE_TYPE == orderSaleXbjPO.getOrderType()) {
            if (totalCheck.divide(finishedCountTotal).compareTo(new BigDecimal("1.2")) > 0) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5355\u4ef7\u578b\u9a8c\u6536\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u53d1\u8d27\u6570\u91cf\u76841.2\u500d");
            }
        } else if (totalCheck.compareTo(finishedCountTotal) > 0) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9a8c\u6536\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u5b8c\u5de5\u6570\u91cf");
        }
    }

    private OrderSaleXbjPO dealWithOrderSaleExist(XbjOrderConstructionConfirmIntfceReqBO reqBO) {
        try {
            OrderSaleXbjPO orderSaleReqPO = new OrderSaleXbjPO();
            orderSaleReqPO.setSaleOrderId(reqBO.getSaleOrderId());
            orderSaleReqPO.setPurchaserId(reqBO.getPurchaserId());
            OrderSaleXbjPO orderSaleXbjPO = this.orderSaleXbjMapper.getModelBy(orderSaleReqPO);
            if (null == orderSaleXbjPO) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u65e0\u6cd5\u5b9a\u4f4d\u5230\u6307\u5b9a\u9500\u552e\u8ba2\u5355\uff01");
            }
            return orderSaleXbjPO;
        }
        catch (Exception e) {
            if (this.isDebugEnabled) {
                logger.debug("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u5f02\u5e38:{}", (Object)e.getMessage());
                e.printStackTrace();
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u5f02\u5e38:" + e.getMessage());
        }
    }

    private void dealWithParamVerify(XbjOrderConstructionConfirmIntfceReqBO reqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u8ba2\u5355\u65bd\u5de5\u9a8c\u6536\u7ec4\u5408\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)reqBO.toString());
        }
        if (null == reqBO) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65bd\u5de5\u9a8c\u6536:\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getPurchaserId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65bd\u5de5\u9a8c\u6536:\u91c7\u8d2d\u5546ID[purchaserId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getSaleOrderId() && null == reqBO.getConstrCompleteOrderId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65bd\u5de5\u9a8c\u6536:\u9500\u552e\u8ba2\u5355ID[saleOrderId]\u548c\u65bd\u5de5\u5b8c\u5de5\u5355ID[constrCompleteOrderId]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getCompleteFlag()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65bd\u5de5\u9a8c\u6536:\u6574\u5355\u9a8c\u6536\u6807\u8bc6[completeFlag]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getConstrInfoList() || reqBO.getConstrInfoList().size() < 1) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65bd\u5de5\u9a8c\u6536:\u65bd\u5de5\u9a8c\u6536\u4fe1\u606f\u96c6\u5408[constrInfoList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List constrInfoList = reqBO.getConstrInfoList();
        for (XbjConstrInfoBO constrInfoBO : constrInfoList) {
            if (null == constrInfoBO.getPurchaseOrderItemId()) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65bd\u5de5\u9a8c\u6536:\u65bd\u5de5\u9a8c\u6536\u4fe1\u606f\u96c6\u5408\u91c7\u8d2d\u660e\u7ec6ID[purchaseOrderItemId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (null == constrInfoBO.getConstrCount() || constrInfoBO.getConstrCount().compareTo(BigDecimal.ZERO) == 0) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65bd\u5de5\u9a8c\u6536:\u65bd\u5de5\u9a8c\u6536\u4fe1\u606f\u96c6\u5408\u9a8c\u6536\u6570\u91cf[constrCount]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (null != constrInfoBO.getConstrCompleteOrderId()) continue;
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65bd\u5de5\u9a8c\u6536:\u65bd\u5de5\u9a8c\u6536\u4fe1\u606f\u96c6\u5408\u65bd\u5de5\u5b8c\u5de5\u5355ID[constrCompleteOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null != reqBO.getAccessoryInfoList() && reqBO.getAccessoryInfoList().size() > 0) {
            List xbjPurchaseAccessoryReqBOList = reqBO.getAccessoryInfoList();
            for (XbjPurchaseAccessoryReqBO xbjPurchaseAccessoryReqBO : xbjPurchaseAccessoryReqBOList) {
                if (StringUtils.isEmpty((Object)xbjPurchaseAccessoryReqBO.getAccessoryName())) {
                    throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65bd\u5de5\u9a8c\u6536:\u9644\u4ef6\u4fe1\u606f\u96c6\u5408\u9644\u4ef6\u540d\u79f0[accessoryName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!StringUtils.isEmpty((Object)xbjPurchaseAccessoryReqBO.getAccessoryUrl())) continue;
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65bd\u5de5\u9a8c\u6536:\u9644\u4ef6\u4fe1\u606f\u96c6\u5408\u9644\u4ef6URL[accessoryUrl]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
    }

    private PayAddTradeServiceFeeReqBO initPayAddServicePO(OrderSaleXbjPO orderSaleXbjPO, GenerateOrderIdAndCodeXbjRspBO orderIdAndCodeRspBO, XbjOrderConstructionConfirmIntfceReqBO reqBO) {
        PayAddTradeServiceFeeReqBO payAddTradeServiceFeeReqBO = new PayAddTradeServiceFeeReqBO();
        try {
            payAddTradeServiceFeeReqBO.setPayOrderNo(orderIdAndCodeRspBO.getOrderId() + "");
            payAddTradeServiceFeeReqBO.setInquiryNo(orderIdAndCodeRspBO.getOrderCode());
            payAddTradeServiceFeeReqBO.setOrderDate(new Date());
            payAddTradeServiceFeeReqBO.setPayOrderName(orderSaleXbjPO.getSaleOrderName());
            BigDecimal totalAmount = BigDecimal.ZERO;
            for (XbjConstrInfoBO constrInfoTemp : reqBO.getConstrInfoList()) {
                OrderPurchaseItemXbjPO orderPurchaseItemPO = new OrderPurchaseItemXbjPO();
                orderPurchaseItemPO.setPurchaseOrderItemId(constrInfoTemp.getPurchaseOrderItemId());
                orderPurchaseItemPO.setPurchaserId(reqBO.getPurchaserId());
                OrderPurchaseItemXbjPO orderPurchaseItemXbjPO = this.orderPurchaseItemXbjMapper.getModelBy(orderPurchaseItemPO);
                if (orderPurchaseItemXbjPO != null) {
                    totalAmount = totalAmount.add(MoneyUtil.Long2BigDecimal((Long)orderPurchaseItemXbjPO.getPurchasingPrice()).multiply(constrInfoTemp.getConstrCount()));
                    continue;
                }
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u65bd\u5de5\u9a8c\u6536\u7ec4\u5408\u670d\u52a1\u5f02\u5e38:\u67e5\u8be2\u91c7\u8d2d\u660e\u7ec6\u660e\u7ec6\u5f02\u5e38\uff01");
            }
            payAddTradeServiceFeeReqBO.setOrderTotalMoney(totalAmount);
            OrderProtocolItemXbjPO orderProtocolItemPO = this.orderProtocolItemXbjMapper.queryBySaleOrderId(orderSaleXbjPO.getSaleOrderId());
            BigDecimal payMoney = BigDecimal.ZERO;
            if (orderProtocolItemPO != null) {
                payMoney = new BigDecimal(orderProtocolItemPO.getServiceRate()).divide(new BigDecimal(100)).multiply(totalAmount);
                payAddTradeServiceFeeReqBO.setOperator(orderProtocolItemPO.getProducerId());
            }
            payAddTradeServiceFeeReqBO.setPayMoney(payMoney);
            payAddTradeServiceFeeReqBO.setCompanyType(CompanyType.SUPPLIER);
            payAddTradeServiceFeeReqBO.setSupplierId(orderSaleXbjPO.getGoodsSupplierId());
            payAddTradeServiceFeeReqBO.setOperUnitNo(orderSaleXbjPO.getProfessionalOrganizationId());
        }
        catch (Exception e) {
            if (this.isDebugEnabled) {
                logger.debug("\u8c03\u7528\u652f\u4ed8\u63a5\u53e3\u521d\u59cb\u5316\u5f02\u5e38:{}", (Object)e.getMessage());
                e.printStackTrace();
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u65bd\u5de5\u9a8c\u6536\u7ec4\u5408\u670d\u52a1\u8c03\u7528\u652f\u4ed8\u670d\u52a1\u521d\u59cb\u5316\u5f02\u5e38:" + e.getMessage());
        }
        return payAddTradeServiceFeeReqBO;
    }

    private void sendMessage(OrderSaleXbjPO orderSale, XbjOrderConstructionConfirmIntfceReqBO req, String inspectionCode) {
        try {
            SelectSupplierInfoByIdReqBO reqBO = new SelectSupplierInfoByIdReqBO();
            reqBO.setSupplierId(orderSale.getGoodsSupplierId());
            SelectSupplierInfoByIdRspBO rspBO = this.selectSupplierInfoByIdBusiService.selectSupplierInfoById(reqBO);
            if (rspBO == null) {
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u65bd\u5de5\u9a8c\u6536\u67e5\u8be2\u4f9b\u5e94\u5546\u4fe1\u606f\u5f02\u5e38\uff01");
            }
            OrderSendMsgAtomXbjReqBO orderSendMsgBusiReq = new OrderSendMsgAtomXbjReqBO();
            ArrayList<String> sendTypes = new ArrayList<String>();
            sendTypes.add("3");
            orderSendMsgBusiReq.setSendTypes(sendTypes);
            HashMap<String, Object> smsParam = new HashMap<String, Object>();
            orderSendMsgBusiReq.setSmsTemplateId(XbjOrderConstants.SEND_ORDER_ARRIVE_SUPPLY_DISPATCH_YES);
            smsParam.put("purchaseCode", orderSale.getPurchaseOrderCode());
            smsParam.put("purchaseName", orderSale.getSaleOrderName());
            smsParam.put("inspectionCode", inspectionCode);
            orderSendMsgBusiReq.setSmsParam(smsParam);
            orderSendMsgBusiReq.setUserId(req.getUserId());
            orderSendMsgBusiReq.setRemindConfigureId(orderSendMsgBusiReq.getSmsTemplateId());
            orderSendMsgBusiReq.setOrderCode(orderSale.getSaleOrderCode());
            orderSendMsgBusiReq.setMessageAccount(rspBO.getManagerId() + "");
            orderSendMsgBusiReq.setRemark1(orderSale.getSaleOrderId().toString());
            orderSendMsgBusiReq.setRemark2(orderSale.getPurchaseOrderId().toString());
            orderSendMsgBusiReq.setRemark3(orderSale.getPurchaserId().toString());
            logger.error("\u65bd\u5de5\u9a8c\u6536\u53d1\u9001\u7ad9\u5185\u4fe1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)orderSendMsgBusiReq));
            RspInfoBO rspInfoBO = this.xbjOrderSendMsgAtomService.dealSendMsg(orderSendMsgBusiReq);
            logger.error("\u65bd\u5de5\u9a8c\u6536\u53d1\u9001\u7ad9\u5185\u4fe1\u8fd4\u56de\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)rspInfoBO));
            if (!"0000".equals(rspInfoBO.getRespCode())) {
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u65bd\u5de5\u9a8c\u6536\u5f02\u5e38\uff0c\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            logger.error("\u65bd\u5de5\u9a8c\u6536\u53d1\u9001\u7ad9\u5185\u4fe1\u5931\u8d25=====", (Throwable)e);
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u65bd\u5de5\u9a8c\u6536\u5f02\u5e38\uff0c\u53d1\u9001\u7ad9\u5185\u4fe1\u5931\u8d25\uff01");
        }
    }

    private RspInfoBO updateDocumentStatus(Long saleOrderId) {
        RspInfoBO rspInfoBO = new RspInfoBO();
        try {
            UpdateDocumentCollectStatusReqBO updateDocumentCollectStatusReqBO = new UpdateDocumentCollectStatusReqBO();
            updateDocumentCollectStatusReqBO.setDocumentId(saleOrderId);
            updateDocumentCollectStatusReqBO.setDocumentStatus(Integer.valueOf(1));
            updateDocumentCollectStatusReqBO.setBusiType(Integer.valueOf(3));
            logger.error("\u65bd\u5de5\u9a8c\u6536\u8c03\u7528\u66f4\u6539\u5355\u636e\u72b6\u6001\u670d\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)updateDocumentCollectStatusReqBO));
            RspBusiBaseBO rspBusiBO = this.updateDocumentCollectStatusBusiService.updateStatus(updateDocumentCollectStatusReqBO);
            logger.error("\u65bd\u5de5\u9a8c\u6536\u8c03\u7528\u66f4\u6539\u5355\u636e\u72b6\u6001\u670d\u52a1\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)rspBusiBO));
            if (rspBusiBO != null && "0000".equals(rspBusiBO.getRespCode())) {
                rspInfoBO.setRespCode("0000");
                rspInfoBO.setRespDesc("\u65bd\u5de5\u9a8c\u6536\u8c03\u7528\u66f4\u6539\u5355\u636e\u72b6\u6001\u670d\u52a1\u6210\u529f");
            } else {
                rspInfoBO.setRespCode("8888");
                rspInfoBO.setRespDesc("\u65bd\u5de5\u9a8c\u6536\u8c03\u7528\u66f4\u6539\u5355\u636e\u72b6\u6001\u670d\u52a1\u5931\u8d25");
            }
            return rspInfoBO;
        }
        catch (Exception e) {
            logger.error("\u65bd\u5de5\u9a8c\u6536\u8c03\u7528\u7968\u636e\u72b6\u6001\u66f4\u65b0\u670d\u52a1\u5931\u8d25=====", (Throwable)e);
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u65bd\u5de5\u9a8c\u6536\u5f02\u5e38\uff0c\u8c03\u7528\u7968\u636e\u72b6\u6001\u66f4\u65b0\u670d\u52a1\u5931\u8d25\uff01");
        }
    }
}

