/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.manage.dic.dict.service.DicDictionaryService;
import com.cgd.order.atom.EaReturnCountModifyXbjAtomService;
import com.cgd.order.atom.GoodsReturnXbjAtomService;
import com.cgd.order.atom.bo.GoodsReturnAtomXbjReqBO;
import com.cgd.order.atom.bo.GoodsReturnAtomXbjRspBO;
import com.cgd.order.atom.bo.ReturnCountModifyXbjReqBO;
import com.cgd.order.busi.XbjReturnCancelBusiService;
import com.cgd.order.busi.bo.XbjReturnCancelReqBO;
import com.cgd.order.busi.bo.XbjReturnCancelRspBO;
import com.cgd.order.constant.OrderCenterConstant;
import com.cgd.order.dao.OrderFlowSheetXbjMapper;
import com.cgd.order.po.OrderFlowSheetXbjPO;
import java.util.Date;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XbjReturnCancelBusiServiceImpl
implements XbjReturnCancelBusiService {
    private static final Log log = LogFactory.getLog(XbjReturnCancelBusiService.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    private DicDictionaryService dicDictionaryService;
    private GoodsReturnXbjAtomService goodsReturnXbjAtomService;
    private OrderFlowSheetXbjMapper orderFlowSheetXbjMapper;
    private EaReturnCountModifyXbjAtomService eaReturnCountModifyXbjAtomService;

    public void setDicDictionaryService(DicDictionaryService dicDictionaryService) {
        this.dicDictionaryService = dicDictionaryService;
    }

    public void setGoodsReturnXbjAtomService(GoodsReturnXbjAtomService goodsReturnXbjAtomService) {
        this.goodsReturnXbjAtomService = goodsReturnXbjAtomService;
    }

    public void setOrderFlowSheetXbjMapper(OrderFlowSheetXbjMapper orderFlowSheetXbjMapper) {
        this.orderFlowSheetXbjMapper = orderFlowSheetXbjMapper;
    }

    public void setEaReturnCountModifyXbjAtomService(EaReturnCountModifyXbjAtomService eaReturnCountModifyXbjAtomService) {
        this.eaReturnCountModifyXbjAtomService = eaReturnCountModifyXbjAtomService;
    }

    public XbjReturnCancelRspBO dealReturnCancel(XbjReturnCancelReqBO xbjReturnCancelReqBO) {
        if (this.isDebugEnabled) {
            log.debug((Object)("\u8be2\u6bd4\u4ef7\u9879\u76ee\u5355\u4f4d\u9000\u8d27\u5355\u67e5\u8be2-\u53d6\u6d88\u7533\u8bf7\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + xbjReturnCancelReqBO.toString()));
        }
        this.validateParams(xbjReturnCancelReqBO);
        XbjReturnCancelRspBO xbjReturnCancelRspBO = new XbjReturnCancelRspBO();
        GoodsReturnAtomXbjReqBO goodsReturnAtomXbjReqBO = new GoodsReturnAtomXbjReqBO();
        goodsReturnAtomXbjReqBO.setGoodsReturnId(xbjReturnCancelReqBO.getGoodsReturnId());
        goodsReturnAtomXbjReqBO.setPurchaserId(xbjReturnCancelReqBO.getPurchaserId());
        GoodsReturnAtomXbjRspBO goodsReturnAtomXbjRspBO = this.goodsReturnXbjAtomService.queryFromReturn(goodsReturnAtomXbjReqBO);
        if (goodsReturnAtomXbjRspBO != null && "0000".equals(goodsReturnAtomXbjRspBO.getRespCode())) {
            Integer oldReturnStatus = goodsReturnAtomXbjRspBO.getReturnStatus();
            if (OrderCenterConstant.RETURN_STATUS.CONFIRM.equals(oldReturnStatus)) {
                GoodsReturnAtomXbjRspBO goodsReturnAtom = this.goodsReturnXbjAtomService.updateGoodsReturnStatus(xbjReturnCancelReqBO.getGoodsReturnId(), xbjReturnCancelReqBO.getPurchaserId(), Integer.valueOf("600"), null);
                if (goodsReturnAtom.getRespCode().equals("0000")) {
                    this.updateReceiveItem(xbjReturnCancelReqBO.getGoodsReturnId(), xbjReturnCancelReqBO.getPurchaserId(), goodsReturnAtomXbjRspBO.getInspectionId());
                    this.insertOrderFlowSheet(xbjReturnCancelReqBO, goodsReturnAtomXbjRspBO);
                    xbjReturnCancelRspBO.setInspectionId(goodsReturnAtomXbjRspBO.getInspectionId());
                    xbjReturnCancelRspBO.setGoodsReturnCode(goodsReturnAtomXbjRspBO.getGoodsReturnCode());
                    xbjReturnCancelRspBO.setProfessionalOrganizationId(goodsReturnAtomXbjRspBO.getProfessionalOrganizationId());
                    xbjReturnCancelRspBO.setPurchaserId(goodsReturnAtomXbjRspBO.getPurchaserId());
                    xbjReturnCancelRspBO.setPurchaserAccountOrgId(goodsReturnAtomXbjRspBO.getPurchaserAccountOrgId());
                    xbjReturnCancelRspBO.setSaleOrderId(goodsReturnAtomXbjRspBO.getSaleOrderId());
                    xbjReturnCancelRspBO.setIsDispatch(goodsReturnAtomXbjRspBO.getIsDispatch());
                    xbjReturnCancelRspBO.setRespCode("0000");
                    xbjReturnCancelRspBO.setRespDesc("\u9000\u8d27\u5355\u53d6\u6d88\u7533\u8bf7\u6210\u529f\uff01");
                } else {
                    xbjReturnCancelRspBO.setRespCode("8888");
                    xbjReturnCancelRspBO.setRespDesc("\u9000\u8d27\u5355\u53d6\u6d88\u7533\u8bf7\u5931\u8d25\uff01");
                }
            } else {
                xbjReturnCancelRspBO.setRespCode("8888");
                xbjReturnCancelRspBO.setRespDesc("\u9000\u8d27\u5355\u975e\u786e\u8ba4\u4e2d\u72b6\u6001,\u4e0d\u80fd\u8fdb\u884c\u9000\u8d27\u5355\u53d6\u6d88\u7533\u8bf7\uff01");
            }
        } else {
            xbjReturnCancelRspBO.setRespCode("8888");
            xbjReturnCancelRspBO.setRespDesc("\u67e5\u8be2\u9000\u8d27\u5355\u8bb0\u5f55\u5931\u8d25");
        }
        if (this.isDebugEnabled) {
            log.debug((Object)("\u8be2\u6bd4\u4ef7\u5f85\u786e\u8ba4\u9000\u8d27\u5355\u67e5\u8be2-\u53d6\u6d88\u7533\u8bf7\u4e1a\u52a1\u670d\u52a1 \u5b8c\u6210\u8c03\u7528 \u51fa\u53c2\uff1aRespCode=" + xbjReturnCancelRspBO.getRespCode() + ", RespDesc=" + xbjReturnCancelRspBO.getRespDesc()));
        }
        return xbjReturnCancelRspBO;
    }

    private void insertOrderFlowSheet(XbjReturnCancelReqBO xbjReturnCancelReqBO, GoodsReturnAtomXbjRspBO goodsReturnAtomXbjRspBO) {
        String busiName;
        OrderFlowSheetXbjPO orderFlowSheetXbjPO = new OrderFlowSheetXbjPO();
        Map<String, String> purchaserOrderMode = this.queryValueByCode("RETURN_ORDER_TYPE");
        if (purchaserOrderMode != null) {
            busiName = purchaserOrderMode.get("R_4");
            if (busiName == null || "".equals(busiName)) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6839\u636e\u6570\u636e\u5b57\u5178code\u83b7\u53d6title\u6570\u636e\u4e3a\u7a7a");
            }
        } else {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u83b7\u53d6\u6570\u636e\u5b57\u5178\u6570\u636e\u4e3a\u7a7a");
        }
        orderFlowSheetXbjPO.setBusiType("R_4");
        orderFlowSheetXbjPO.setBusiName(busiName);
        orderFlowSheetXbjPO.setOperId(xbjReturnCancelReqBO.getUserId());
        orderFlowSheetXbjPO.setOperName(xbjReturnCancelReqBO.getUserName());
        orderFlowSheetXbjPO.setOperDeptId(xbjReturnCancelReqBO.getOrgId());
        orderFlowSheetXbjPO.setOperDeptName(xbjReturnCancelReqBO.getOrgName());
        orderFlowSheetXbjPO.setOperCompId(xbjReturnCancelReqBO.getCompanyId());
        orderFlowSheetXbjPO.setOperCompName(xbjReturnCancelReqBO.getCompanyName());
        orderFlowSheetXbjPO.setOrderId(xbjReturnCancelReqBO.getGoodsReturnId());
        orderFlowSheetXbjPO.setProfessionalOrganizationId(goodsReturnAtomXbjRspBO.getProfessionalOrganizationId());
        orderFlowSheetXbjPO.setPurchaserAccountId(goodsReturnAtomXbjRspBO.getPurchaserAccountId());
        orderFlowSheetXbjPO.setPurchaserId(goodsReturnAtomXbjRspBO.getPurchaserId());
        orderFlowSheetXbjPO.setGoodsSupplierId(goodsReturnAtomXbjRspBO.getGoodsSupplierId());
        orderFlowSheetXbjPO.setOrderType(OrderCenterConstant.ORDER_TYPE.RETURN);
        orderFlowSheetXbjPO.setOperTime(new Date());
        orderFlowSheetXbjPO.setOperRole("\u5e93\u7ba1\u5458");
        this.orderFlowSheetXbjMapper.insertSelective(orderFlowSheetXbjPO);
    }

    private Map<String, String> queryValueByCode(String pCode) {
        try {
            Map purchaserOrderMode = this.dicDictionaryService.getValueByCode(pCode);
            return purchaserOrderMode;
        }
        catch (Exception e) {
            log.error((Object)("\u67e5\u8be2\u6570\u636e\u5b57\u5178\u5931\u8d25" + e));
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u67e5\u8be2\u6570\u636e\u5b57\u5178\u5931\u8d25");
        }
    }

    private void updateReceiveItem(Long goodsReturnId, Long purchaserId, Long inspectionId) {
        ReturnCountModifyXbjReqBO returnCountModifyXbjReqBO = new ReturnCountModifyXbjReqBO();
        returnCountModifyXbjReqBO.setGoodsReturnId(goodsReturnId);
        returnCountModifyXbjReqBO.setPurchaserId(purchaserId);
        returnCountModifyXbjReqBO.setInspectionId(inspectionId);
        this.eaReturnCountModifyXbjAtomService.updateReceiveItemWaitReturnCount(returnCountModifyXbjReqBO);
    }

    private void validateParams(XbjReturnCancelReqBO xbjReturnCancelReqBO) {
        if (xbjReturnCancelReqBO == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjReturnCancelReqBO.getGoodsReturnId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9000\u8d27\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjReturnCancelReqBO.getPurchaserId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u5546id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

