/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.OrderPurchaseItemXbjAtomService;
import com.cgd.order.atom.OrderServXbjAtomService;
import com.cgd.order.atom.XbjCreateOrderFlowSheetAtomService;
import com.cgd.order.atom.bo.OrderServItemXbjAtomBO;
import com.cgd.order.atom.bo.OrderServXbjAtomReqBO;
import com.cgd.order.busi.XbjOrderServCreateBusiService;
import com.cgd.order.busi.bo.XbjOrderFlowSheetReqBO;
import com.cgd.order.busi.bo.XbjOrderFlowSheetRspBO;
import com.cgd.order.busi.bo.XbjOrderServCompleteItemBO;
import com.cgd.order.busi.bo.XbjOrderServCreateReqBO;
import com.cgd.order.busi.bo.XbjOrderServCreateRspBO;
import com.cgd.order.constant.OrderCenterConstant;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.OrderPurchaseItemXbjMapper;
import com.cgd.order.po.OrderPurchaseItemXbjPO;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class XbjOrderServCreateBusiServiceImpl
implements XbjOrderServCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjOrderServCreateBusiServiceImpl.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private OrderServXbjAtomService orderServXbjAtomService;
    @Autowired
    private OrderPurchaseItemXbjAtomService orderPurchaseItemXbjAtomService;
    @Autowired
    private OrderPurchaseItemXbjMapper orderPurchaseItemXbjMapper;
    @Autowired
    private XbjCreateOrderFlowSheetAtomService createOrderFlowSheetAtomService;

    public XbjOrderServCreateRspBO createOrderServ(XbjOrderServCreateReqBO req) {
        XbjOrderServCreateRspBO rsp;
        block8: {
            if (isDebugEnabled) {
                log.debug("\u8be2\u6bd4\u4ef7\u670d\u52a1\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5165\u53c2" + req.toString());
            }
            rsp = new XbjOrderServCreateRspBO();
            try {
                OrderServXbjAtomReqBO orderServXbjAtomReq = new OrderServXbjAtomReqBO();
                BeanUtils.copyProperties((Object)req, (Object)orderServXbjAtomReq);
                orderServXbjAtomReq.setServStatus(XbjOrderConstants.SERV_SHIP_STATUS_COMPLETE);
                ArrayList<OrderServItemXbjAtomBO> orderServItemXbjAtomList = new ArrayList<OrderServItemXbjAtomBO>();
                for (XbjOrderServCompleteItemBO item : req.getXbjOrderServCompleteItemList()) {
                    OrderServItemXbjAtomBO atomItem = new OrderServItemXbjAtomBO();
                    BeanUtils.copyProperties((Object)item, (Object)atomItem);
                    atomItem.setUnitName(item.getUnitName());
                    orderServItemXbjAtomList.add(atomItem);
                }
                orderServXbjAtomReq.setOrderServItemXbjAtomList(orderServItemXbjAtomList);
                this.orderServXbjAtomService.insertOrderServAndDetai(orderServXbjAtomReq);
                ArrayList<OrderServItemXbjAtomBO> servItemInfoList = new ArrayList<OrderServItemXbjAtomBO>();
                for (XbjOrderServCompleteItemBO itemReq : req.getXbjOrderServCompleteItemList()) {
                    OrderServItemXbjAtomBO servItemInfo = new OrderServItemXbjAtomBO();
                    servItemInfo.setPurchaseOrderItemId(itemReq.getPurchaseOrderItemId());
                    servItemInfo.setOnceCompleteCount(itemReq.getOnceCompleteCount());
                    servItemInfoList.add(servItemInfo);
                    OrderPurchaseItemXbjPO orderPurchaseItemXbjPO = new OrderPurchaseItemXbjPO();
                    orderPurchaseItemXbjPO.setSendCount(servItemInfo.getOnceCompleteCount());
                    orderPurchaseItemXbjPO.setWaitSendCount(servItemInfo.getOnceCompleteCount());
                    orderPurchaseItemXbjPO.setPurchaserId(req.getPurchaserId());
                    if (isDebugEnabled) {
                        log.debug("servItemInfo.getPurchaserId():" + servItemInfo.getPurchaserId());
                    }
                    orderPurchaseItemXbjPO.setPurchaseOrderItemId(servItemInfo.getPurchaseOrderItemId());
                    this.orderPurchaseItemXbjMapper.updateSendAndWaitingCount(orderPurchaseItemXbjPO);
                }
                XbjOrderFlowSheetReqBO orderFlowSheetReqBO = new XbjOrderFlowSheetReqBO();
                orderFlowSheetReqBO.setOrderId(Long.valueOf(req.getPurchaseOrderId()));
                orderFlowSheetReqBO.setPurchaserId(Long.valueOf(req.getPurchaserId()));
                orderFlowSheetReqBO.setOrderType(OrderCenterConstant.ORDER_TYPE.PURCHASE);
                orderFlowSheetReqBO.setOrderBusiType("B_21");
                orderFlowSheetReqBO.setUserId(req.getOperId());
                orderFlowSheetReqBO.setCompanyName(req.getCompanyName());
                orderFlowSheetReqBO.setUserName(req.getOperName());
                orderFlowSheetReqBO.setOperRole("\u4f9b\u5e94\u5546");
                XbjOrderFlowSheetRspBO orderFlowSheetRspBO = this.createOrderFlowSheetAtomService.createOrderFlowSheet(orderFlowSheetReqBO);
                if (null != orderFlowSheetRspBO && orderFlowSheetRspBO.getRespCode().equals("0000")) {
                    if (isDebugEnabled) {
                        log.debug("\u8ba2\u5355\u5206\u914d\u6210\u529f\uff0c\u6267\u884c\u6d41\u7a0b\u751f\u6210\u4e1a\u52a1\u6210\u529f");
                    }
                    break block8;
                }
                log.error("\u8ba2\u5355\u5206\u914d\u6210\u529f\uff0c\u6267\u884c\u6d41\u7a0b\u751f\u6210\u4e1a\u52a1\u5931\u8d25\uff1a" + orderFlowSheetRspBO.getRespDesc());
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8ba2\u5355\u5ba1\u6838\u670d\u52a1\u5f02\u5e38\uff1a\u5199\u6d41\u7a0b\u4fe1\u606f\u5931\u8d25\uff01");
            }
            catch (Exception e) {
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u670d\u52a1\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38:" + e.getMessage());
            }
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u8be2\u6bd4\u4ef7\u670d\u52a1\u5355\u751f\u6210\u670d\u52a1\u6210\u529f!");
        return rsp;
    }
}

