/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.GenerateOrderIdAndCodeXbjAtomService;
import com.cgd.order.atom.PurchaseOrderInfoXbjAtomService;
import com.cgd.order.atom.bo.GenerateOrderIdAndCodeXbjReqBO;
import com.cgd.order.atom.bo.GenerateOrderIdAndCodeXbjRspBO;
import com.cgd.order.atom.bo.PurchaseOrderInfoReqBO;
import com.cgd.order.constant.XOrderCenterConstant;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.OrderPurchaseEditXbjMapper;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.po.OrderPurchaseEditXbjPO;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseOrderInfoXbjAtomServiceImpl
implements PurchaseOrderInfoXbjAtomService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseOrderInfoXbjAtomService.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private OrderSaleXbjMapper orderSaleXbjMapper;
    @Autowired
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;
    @Autowired
    private OrderPurchaseEditXbjMapper orderPurchaseEditXbjMapper;
    @Autowired
    private GenerateOrderIdAndCodeXbjAtomService generateOrderIdAndCodeXbjAtomService;

    @Override
    public void updatePurchaseOrderInfo(PurchaseOrderInfoReqBO reqBO) {
        Long saleOrderId = reqBO.getSaleOrderId();
        if (saleOrderId != null) {
            if (this.isDebugEnabled) {
                log.debug("\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u539f\u5b50\u670d\u52a1\u5165\u53c2" + reqBO.toString());
            }
            boolean isUpdate = false;
            OrderSaleXbjPO orderSaleXbjPO = this.orderSaleXbjMapper.selectByPrimaryKey(saleOrderId);
            try {
                if (orderSaleXbjPO != null) {
                    OrderPurchaseXbjPO orderPurchaseXbjPO = this.orderPurchaseXbjMapper.selectByPrimaryKey(orderSaleXbjPO.getPurchaseOrderId());
                    OrderPurchaseEditXbjPO orderPurchaseOldXbjPO = new OrderPurchaseEditXbjPO();
                    BeanUtils.copyProperties((Object)orderPurchaseXbjPO, (Object)orderPurchaseOldXbjPO);
                    if (StringUtils.isNotBlank((CharSequence)reqBO.getArriveTime())) {
                        isUpdate = true;
                        orderSaleXbjPO.setArriveTime(reqBO.getArriveTime());
                        orderPurchaseXbjPO.setArriveTime(reqBO.getArriveTime());
                    }
                    if (StringUtils.isNotBlank((CharSequence)reqBO.getArriveType())) {
                        isUpdate = true;
                        orderSaleXbjPO.setArriveType(reqBO.getArriveType());
                        orderPurchaseXbjPO.setArriveType(reqBO.getArriveType());
                    }
                    if (reqBO.getMatPayEnt() != null) {
                        isUpdate = true;
                        orderSaleXbjPO.setMatPayEnt(reqBO.getMatPayEnt());
                        orderPurchaseXbjPO.setMatPayEnt(reqBO.getMatPayEnt());
                    }
                    if (reqBO.getMatPaySup() != null) {
                        isUpdate = true;
                        orderSaleXbjPO.setMatPaySup(reqBO.getMatPaySup());
                        orderPurchaseXbjPO.setMatPaySup(reqBO.getMatPaySup());
                    }
                    if (reqBO.getVerPaySup() != null) {
                        isUpdate = true;
                        orderSaleXbjPO.setVerPaySup(reqBO.getVerPaySup());
                        orderPurchaseXbjPO.setVerPaySup(reqBO.getVerPaySup());
                    }
                    if (reqBO.getOrderType() != null) {
                        isUpdate = true;
                        orderSaleXbjPO.setOrderType(reqBO.getOrderType());
                        orderPurchaseXbjPO.setOrderType(reqBO.getOrderType());
                    }
                    if (reqBO.getPilPayEnt() != null) {
                        isUpdate = true;
                        orderSaleXbjPO.setPilPayEnt(reqBO.getPilPayEnt());
                        orderPurchaseXbjPO.setPilPayEnt(reqBO.getPilPayEnt());
                    }
                    if (reqBO.getPilPaySup() != null) {
                        isUpdate = true;
                        orderSaleXbjPO.setPilPaySup(reqBO.getPilPaySup());
                        orderPurchaseXbjPO.setPilPaySup(reqBO.getPilPaySup());
                    }
                    if (reqBO.getPrePayEnt() != null) {
                        isUpdate = true;
                        orderSaleXbjPO.setPrePayEnt(reqBO.getPrePayEnt());
                        orderPurchaseXbjPO.setPrePayEnt(reqBO.getPrePayEnt());
                    }
                    if (reqBO.getPrePaySup() != null) {
                        isUpdate = true;
                        orderSaleXbjPO.setPrePaySup(reqBO.getPrePaySup());
                        orderPurchaseXbjPO.setPrePaySup(reqBO.getPrePaySup());
                    }
                    if (reqBO.getProPayEnt() != null) {
                        isUpdate = true;
                        orderSaleXbjPO.setProPayEnt(reqBO.getProPayEnt());
                        orderPurchaseXbjPO.setProPayEnt(reqBO.getProPayEnt());
                    }
                    if (reqBO.getProPaySup() != null) {
                        isUpdate = true;
                        orderSaleXbjPO.setProPaySup(reqBO.getProPaySup());
                        orderPurchaseXbjPO.setProPaySup(reqBO.getProPaySup());
                    }
                    if (reqBO.getQuaPayEnt() != null) {
                        isUpdate = true;
                        orderSaleXbjPO.setQuaPayEnt(reqBO.getQuaPayEnt());
                        orderPurchaseXbjPO.setQuaPayEnt(reqBO.getQuaPayEnt());
                    }
                    if (reqBO.getQuaPaySup() != null) {
                        isUpdate = true;
                        orderSaleXbjPO.setQuaPaySup(reqBO.getQuaPaySup());
                        orderPurchaseXbjPO.setQuaPaySup(reqBO.getQuaPaySup());
                    }
                    if (reqBO.getTaxRate() != null) {
                        isUpdate = true;
                        orderSaleXbjPO.setTaxRate(reqBO.getTaxRate());
                        orderPurchaseXbjPO.setTaxRate(reqBO.getTaxRate());
                    }
                    if (reqBO.getVerPayEnt() != null) {
                        isUpdate = true;
                        orderSaleXbjPO.setVerPayEnt(reqBO.getVerPayEnt());
                        orderPurchaseXbjPO.setVerPayEnt(reqBO.getVerPayEnt());
                    }
                    if (reqBO.getWarantty() != null) {
                        isUpdate = true;
                        orderSaleXbjPO.setWarantty(reqBO.getWarantty());
                        orderPurchaseXbjPO.setWarantty(reqBO.getWarantty());
                    }
                    if (reqBO.getMatPayEnt() != null) {
                        isUpdate = true;
                        orderSaleXbjPO.setMatPayEnt(reqBO.getMatPayEnt());
                        orderPurchaseXbjPO.setMatPayEnt(reqBO.getMatPayEnt());
                    }
                    if (reqBO.getContractMark() != null) {
                        isUpdate = true;
                        orderSaleXbjPO.setContractMark(reqBO.getContractMark());
                        orderPurchaseXbjPO.setContractMark(reqBO.getContractMark());
                    }
                    if (isUpdate) {
                        OrderPurchaseEditXbjPO orderPurchaseNewXbjPO = new OrderPurchaseEditXbjPO();
                        BeanUtils.copyProperties((Object)orderPurchaseXbjPO, (Object)orderPurchaseNewXbjPO);
                        GenerateOrderIdAndCodeXbjReqBO idAndCodeXbjReqBO = new GenerateOrderIdAndCodeXbjReqBO();
                        idAndCodeXbjReqBO.setGenerateOrderType(XbjOrderConstants.GENERATE_ORDER_TYPE.BATCH_SEQ);
                        GenerateOrderIdAndCodeXbjRspBO rspBO = this.generateOrderIdAndCodeXbjAtomService.generateOrderIdAndCode(idAndCodeXbjReqBO);
                        Long batchId = rspBO.getOrderId();
                        orderPurchaseOldXbjPO.setBatchId(batchId);
                        orderPurchaseOldXbjPO.setProfessionalAccount(String.valueOf(orderPurchaseXbjPO.getProfessionalAccount()));
                        orderPurchaseOldXbjPO.setIsNew(XbjOrderConstants.PURCHASE_ORDER_OLD);
                        this.orderPurchaseEditXbjMapper.insert(orderPurchaseOldXbjPO);
                        orderPurchaseNewXbjPO.setBatchId(batchId);
                        orderPurchaseNewXbjPO.setProfessionalAccount(String.valueOf(orderPurchaseXbjPO.getProfessionalAccount()));
                        orderPurchaseNewXbjPO.setIsNew(XbjOrderConstants.PURCHASE_ORDER_NEW);
                        if (orderSaleXbjPO.getSaleOrderType().equals(XOrderCenterConstant.ORDER_SOURCE_TYPE.INQUIREIES_OTHER) && reqBO.getUpdateFlag() != null) {
                            orderSaleXbjPO.setPurchaserAccountId(reqBO.getUserId());
                            orderPurchaseXbjPO.setPurchaserAccountId(reqBO.getUserId());
                        }
                        this.orderPurchaseEditXbjMapper.insert(orderPurchaseNewXbjPO);
                        this.orderSaleXbjMapper.updateById(orderSaleXbjPO);
                        this.orderPurchaseXbjMapper.updateById(orderPurchaseXbjPO);
                    }
                }
            }
            catch (BusinessException e) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", e.getMessage());
            }
            catch (Exception e) {
                log.error("\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u539f\u5b50\u670d\u52a1\u5f02\u5e38", (Throwable)e);
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u539f\u5b50\u670d\u52a1\u5f02\u5e38");
            }
        }
    }
}

