/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.intfce.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.electricitysupplier.busi.CancelOrderBusiService;
import com.cgd.electricitysupplier.busi.bo.CancelOrderReqBO;
import com.cgd.electricitysupplier.busi.bo.CancelOrderRspBO;
import com.cgd.order.atom.OrderSaleXbjAtomService;
import com.cgd.order.atom.bo.OrderSaleInfoXbjRspBO;
import com.cgd.order.busi.XbjOrderSaleStatusChgBusiService;
import com.cgd.order.busi.bo.XbjOrderSaleStatusChgReqBO;
import com.cgd.order.busi.bo.XbjOrderSaleStatusChgRspBO;
import com.cgd.order.constant.Constant;
import com.cgd.order.intfce.XbjCancelOrderExamineIntfceService;
import com.cgd.order.intfce.bo.XbjCancelOrderExamineIntfceReqBO;
import com.cgd.order.intfce.bo.XbjCancelOrderExamineIntfceRspBO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

public class XbjCancelOrderExamineIntfceServiceImpl
implements XbjCancelOrderExamineIntfceService {
    private static final Logger log = LoggerFactory.getLogger(XbjCancelOrderExamineIntfceServiceImpl.class);
    private final Boolean isDebugEnabled = log.isDebugEnabled();
    private OrderSaleXbjAtomService orderSaleXbjAtomService;
    private CancelOrderBusiService cancelOrderBusiService;
    private XbjOrderSaleStatusChgBusiService xbjOrderSaleStatusChgBusiService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XbjCancelOrderExamineIntfceRspBO xbjCancelOrderExamine(XbjCancelOrderExamineIntfceReqBO req) {
        if (this.isDebugEnabled.booleanValue()) {
            log.debug("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5ba1\u6838\u53d6\u6d88\u7ec4\u5408\u670d\u52a1!" + req.toString());
        }
        try {
            if (StringUtils.isEmpty((Object)req.getSaleOrderId())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u5ba1\u6838\u9a73\u56de\u7ec4\u5408\u670d\u52a1\uff0c\u9500\u552e\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            if (StringUtils.isEmpty((Object)req.getPurchaserId())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u5ba1\u6838\u9a73\u56de\u7ec4\u5408\u670d\u52a1\uff0c\u91c7\u8d2d\u5355\u4f4d\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            XbjCancelOrderExamineIntfceRspBO rsp = new XbjCancelOrderExamineIntfceRspBO();
            OrderSaleInfoXbjRspBO xbjOrderSaleInfoRspBO = this.orderSaleXbjAtomService.queryOrderSaleById(req.getSaleOrderId(), req.getPurchaserId());
            if (xbjOrderSaleInfoRspBO == null) {
                rsp.setRespCode("8888");
                rsp.setRespDesc("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u65e0\u6570\u636e");
                return rsp;
            }
            CancelOrderReqBO cancelOrderReq = new CancelOrderReqBO();
            cancelOrderReq.setOrderId(xbjOrderSaleInfoRspBO.getExtOrderId());
            cancelOrderReq.setSupplierId(xbjOrderSaleInfoRspBO.getGoodsSupplierId());
            CancelOrderRspBO cancelOrderRsp = new CancelOrderRspBO();
            cancelOrderRsp.setRespCode("0000");
            if (null == cancelOrderRsp || !"0000".equals(cancelOrderRsp.getRespCode())) throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5ba1\u6838\u53d6\u6d88\u7ec4\u5408\u670d\u52a1\u5931\u8d25:" + cancelOrderRsp.getRespDesc());
            XbjOrderSaleStatusChgReqBO xbjOrderSaleStatusChgReq = new XbjOrderSaleStatusChgReqBO();
            BeanUtils.copyProperties((Object)xbjOrderSaleInfoRspBO, (Object)xbjOrderSaleStatusChgReq);
            xbjOrderSaleStatusChgReq.setSaleOrderStatus(Constant.SALSE_ORDER_STATE_CANCEL);
            xbjOrderSaleStatusChgReq.setProfessionalOrganizationId(xbjOrderSaleInfoRspBO.getProfessionalOrganizationId());
            XbjOrderSaleStatusChgRspBO xbjOrderSaleStatusChgRsp = this.xbjOrderSaleStatusChgBusiService.modifyOrderSaleStatus(xbjOrderSaleStatusChgReq);
            if ("0000".equals(xbjOrderSaleStatusChgRsp.getRespCode())) {
                if (this.isDebugEnabled.booleanValue()) {
                    log.debug("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5ba1\u6838\u53d6\u6d88\u7ec4\u5408\u670d\u52a1\uff0c\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u5b8c\u6210");
                }
            } else {
                if (!this.isDebugEnabled.booleanValue()) throw new BusinessException("RSP_CODE_STATUS_CHNG_ERR", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5ba1\u6838\u53d6\u6d88\u7ec4\u5408\u670d\u52a1\uff0c\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u5931\u8d25");
                log.debug("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5ba1\u6838\u53d6\u6d88\u7ec4\u5408\u670d\u52a1\uff0c\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u5931\u8d25");
                throw new BusinessException("RSP_CODE_STATUS_CHNG_ERR", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5ba1\u6838\u53d6\u6d88\u7ec4\u5408\u670d\u52a1\uff0c\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u5931\u8d25");
            }
            rsp.setRespCode("0000");
            rsp.setRespDesc("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5ba1\u6838\u53d6\u6d88\u7ec4\u5408\u670d\u52a1\u6210\u529f");
            return rsp;
        }
        catch (BusinessException e) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", e.getMessage());
        }
        catch (Exception e) {
            log.error("\u6bd4\u4ef7\u8ba2\u5355\u5ba1\u6838\u53d6\u6d88\u7ec4\u5408\u670d\u52a1\u5f02\u5e38\uff01", (Throwable)e);
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", e.getMessage());
        }
    }

    public OrderSaleXbjAtomService getOrderSaleXbjAtomService() {
        return this.orderSaleXbjAtomService;
    }

    public void setOrderSaleXbjAtomService(OrderSaleXbjAtomService orderSaleXbjAtomService) {
        this.orderSaleXbjAtomService = orderSaleXbjAtomService;
    }

    public CancelOrderBusiService getCancelOrderBusiService() {
        return this.cancelOrderBusiService;
    }

    public void setCancelOrderBusiService(CancelOrderBusiService cancelOrderBusiService) {
        this.cancelOrderBusiService = cancelOrderBusiService;
    }

    public XbjOrderSaleStatusChgBusiService getXbjOrderSaleStatusChgBusiService() {
        return this.xbjOrderSaleStatusChgBusiService;
    }

    public void setXbjOrderSaleStatusChgBusiService(XbjOrderSaleStatusChgBusiService xbjOrderSaleStatusChgBusiService) {
        this.xbjOrderSaleStatusChgBusiService = xbjOrderSaleStatusChgBusiService;
    }
}

