/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.cgd.order.atom.OrderReciveItemXbjService;
import com.cgd.order.atom.bo.OrderReciveItemAtomXbjRspBO;
import com.cgd.order.atom.bo.OrderReciveItemXbjReqBO;
import com.cgd.order.atom.bo.OrderReciveItemXbjRspBO;
import com.cgd.order.dao.InspectionXbjMapper;
import com.cgd.order.dao.OrderReceiveItemXbjMapper;
import com.cgd.order.dao.OrderSaleItemXbjMapper;
import com.cgd.order.dao.OrderShipItemXbjMapper;
import com.cgd.order.po.InspectionXbjPO;
import com.cgd.order.po.OrderReceiveItemXbjPO;
import com.cgd.order.po.OrderSaleItemXbjPO;
import com.cgd.order.po.OrderShipItemXbjPO;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;

public class OrderReciveItemXbjServiceImpl
implements OrderReciveItemXbjService {
    private static final Log log = LogFactory.getLog(OrderReciveItemXbjServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    private OrderShipItemXbjMapper orderShipItemXbjMapper;
    private OrderReceiveItemXbjMapper orderReceiveItemXbjMapper;
    private OrderSaleItemXbjMapper orderSaleItemXbjMapper;
    private InspectionXbjMapper inspectionXbjMapper;

    @Override
    public OrderReciveItemXbjRspBO createOrderReciveItem(OrderReciveItemXbjReqBO orderReciveItemReqBO) {
        OrderReciveItemXbjRspBO orderReciveItemRspBO = new OrderReciveItemXbjRspBO();
        try {
            Long purchaseFee;
            Long saleFee;
            if (this.isDebugEnabled) {
                log.debug((Object)("\u6536\u8d27\u660e\u7ec6\u5199\u5165\u53c2\u6570\u5f00\u59cb" + orderReciveItemReqBO.toString()));
            }
            OrderShipItemXbjPO orderShipItem = new OrderShipItemXbjPO();
            orderShipItem.setShipOrderId(orderReciveItemReqBO.getShipOrderId());
            List<OrderShipItemXbjPO> ordeShipItemList = this.orderShipItemXbjMapper.selectByInShipOrderId(orderReciveItemReqBO.getOrderShipList());
            HashMap<Long, Long> itemMapper = new HashMap<Long, Long>();
            if (null != ordeShipItemList && ordeShipItemList.size() > 0) {
                for (OrderShipItemXbjPO orderShipItemInfo : ordeShipItemList) {
                    itemMapper.put(orderShipItemInfo.getSkuId(), orderShipItemInfo.getShipItemId());
                }
                saleFee = 0L;
                purchaseFee = 0L;
                for (Map.Entry sku : itemMapper.entrySet()) {
                    OrderShipItemXbjPO item = new OrderShipItemXbjPO();
                    BigDecimal purchaseCount = BigDecimal.ZERO;
                    BigDecimal arriveCount = BigDecimal.ZERO;
                    BigDecimal returnCount = BigDecimal.ZERO;
                    for (OrderShipItemXbjPO shipItemInfo : ordeShipItemList) {
                        if (0 != Long.valueOf(shipItemInfo.getSkuId()).compareTo((Long)sku.getKey())) continue;
                        BeanUtils.copyProperties((Object)shipItemInfo, (Object)item);
                        purchaseCount = null != shipItemInfo.getPurchaseCount() ? purchaseCount.add(shipItemInfo.getPurchaseCount()) : purchaseCount.add(BigDecimal.ZERO);
                        arriveCount = null != shipItemInfo.getArriveCount() ? arriveCount.add(shipItemInfo.getArriveCount()) : arriveCount.add(BigDecimal.ZERO);
                        if (null != shipItemInfo.getReturnCount()) {
                            returnCount = returnCount.add(shipItemInfo.getReturnCount());
                            continue;
                        }
                        returnCount = returnCount.add(BigDecimal.ZERO);
                    }
                    item.setPurchaseCount(purchaseCount);
                    item.setArriveCount(arriveCount);
                    item.setReturnCount(returnCount);
                    OrderReceiveItemXbjPO record = new OrderReceiveItemXbjPO();
                    record.setInspectionId(orderReciveItemReqBO.getInspectionId());
                    record.setSaleOrderItemId(item.getSaleOrderItemId());
                    record.setPurchaseOrderItemId(item.getPurchaseOrderItemId());
                    record.setSaleOrderId((long)item.getSaleOrderId());
                    record.setPurchaseOrderId(item.getPurchaseOrderId());
                    record.setPurchaserId(item.getPurchaserId());
                    record.setPurchaserAccountId(item.getPurchaserAccountId());
                    record.setPurchaserAccountName(item.getPurchaserAccountName());
                    record.setProfessionalOrganizationId(item.getProfessionalOrganizationId());
                    record.setGoodsSupplierId(item.getGoodsSupplierId());
                    record.setSkuId(item.getSkuId());
                    record.setSkuName(item.getSkuName());
                    record.setPurchaseCount(item.getPurchaseCount().subtract(item.getReturnCount()));
                    record.setUnitName(item.getUnitName());
                    record.setRemark(item.getRemark());
                    OrderSaleItemXbjPO orderSaleItemXbjPO = new OrderSaleItemXbjPO();
                    orderSaleItemXbjPO.setSaleOrderItemId(item.getSaleOrderItemId());
                    OrderSaleItemXbjPO orderSaleItem = this.orderSaleItemXbjMapper.selectBySaleOrderItemId(orderSaleItemXbjPO);
                    record.setPurchasingPrice(orderSaleItem.getPurchasingPrice());
                    record.setSellingPrice(orderSaleItem.getSellingPrice());
                    Long saleFeeCount = orderSaleItem.getSellingPrice() * record.getPurchaseCount().longValue();
                    Long purchaseFeeCount = orderSaleItem.getPurchasingPrice() * record.getPurchaseCount().longValue();
                    record.setSaleFeeCount(saleFeeCount);
                    record.setPurchaseFeeCount(purchaseFeeCount);
                    record.setExtSkuPrice(orderSaleItem.getExtSkuPrice());
                    record.setExtSkuNakedPrice(orderSaleItem.getExtSkuNakedPrice());
                    record.setExtSkuTax(orderSaleItem.getExtSkuTax());
                    record.setExtSkuTaxPrice(orderSaleItem.getExtSkuTaxPrice());
                    record.setInspectionId(orderReciveItemReqBO.getInspectionId());
                    record.setPurchaserAccountOrgId(orderSaleItem.getPurchaserAccountOrgId());
                    record.setDeptId(orderSaleItem.getDeptId());
                    if (this.isDebugEnabled) {
                        log.debug((Object)("\u6536\u8d27\u660e\u7ec6\u5199\u5165\u53c2\u6570\uff1a" + record.toString()));
                    }
                    saleFee = saleFee + saleFeeCount;
                    purchaseFee = purchaseFee + purchaseFeeCount;
                    this.orderReceiveItemXbjMapper.insertOrderReceiveItem(record);
                }
            } else {
                orderReciveItemRspBO.setRespCode("8888");
                orderReciveItemRspBO.setRespDesc("\u6b64\u53d1\u8d27\u5355[" + orderReciveItemReqBO.getShipOrderId() + "]\u65e0\u6cd5\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u53d1\u8d27\u660e\u7ec6");
                return orderReciveItemRspBO;
            }
            InspectionXbjPO ins = new InspectionXbjPO();
            ins.setInspectionId(orderReciveItemReqBO.getInspectionId());
            ins.setSaleFee(saleFee);
            ins.setPurchaseFee(purchaseFee);
            this.inspectionXbjMapper.updateByInspectionId(ins);
            orderReciveItemRspBO.setRespCode("0000");
            orderReciveItemRspBO.setRespDesc("\u6536\u8d27\u660e\u7ec6\u5199\u5165\u6b63\u5e38\u7ed3\u675f");
        }
        catch (Exception e) {
            if (this.isDebugEnabled) {
                log.debug((Object)("\u6536\u8d27\u660e\u7ec6\u5199\u5165\u539f\u5b50\u670d\u52a1\u5f02\u5e38:" + e.getMessage()));
            }
            orderReciveItemRspBO.setRespCode("8888");
            orderReciveItemRspBO.setRespDesc("\u6536\u8d27\u660e\u7ec6\u5199\u5165\u539f\u5b50\u670d\u52a1\u5f02\u5e38:" + e.getMessage());
        }
        return orderReciveItemRspBO;
    }

    public void setOrderReceiveItemXbjMapper(OrderReceiveItemXbjMapper orderReceiveItemXbjMapper) {
        this.orderReceiveItemXbjMapper = orderReceiveItemXbjMapper;
    }

    public void setOrderSaleItemXbjMapper(OrderSaleItemXbjMapper orderSaleItemXbjMapper) {
        this.orderSaleItemXbjMapper = orderSaleItemXbjMapper;
    }

    public void setInspectionXbjMapper(InspectionXbjMapper inspectionXbjMapper) {
        this.inspectionXbjMapper = inspectionXbjMapper;
    }

    public void setOrderShipItemXbjMapper(OrderShipItemXbjMapper orderShipItemXbjMapper) {
        this.orderShipItemXbjMapper = orderShipItemXbjMapper;
    }

    @Override
    public OrderReciveItemAtomXbjRspBO qryOrderReciveItem(Long inspectionId, Long id, Long purchaserId) {
        OrderReceiveItemXbjPO inspectionIdRsp = this.orderReceiveItemXbjMapper.selectByInspectionIdAndMaterialId(inspectionId, purchaserId, id);
        OrderReciveItemAtomXbjRspBO orderReciveItemAtom = new OrderReciveItemAtomXbjRspBO();
        if (null != inspectionIdRsp) {
            orderReciveItemAtom.setSaleOrderItemId(inspectionIdRsp.getSaleOrderItemId());
            orderReciveItemAtom.setPurchaseOrderItemId(inspectionIdRsp.getPurchaseOrderItemId());
            orderReciveItemAtom.setSaleOrderId(inspectionIdRsp.getSaleOrderId());
            orderReciveItemAtom.setPurchaseOrderId(inspectionIdRsp.getPurchaseOrderId());
            orderReciveItemAtom.setCheckStatus(inspectionIdRsp.getCheckStatus());
            orderReciveItemAtom.setSkuId(inspectionIdRsp.getSkuId());
            orderReciveItemAtom.setSkuName(inspectionIdRsp.getSkuName());
            orderReciveItemAtom.setPurchaseCount(inspectionIdRsp.getPurchaseCount());
            orderReciveItemAtom.setUnitName(inspectionIdRsp.getUnitName());
            orderReciveItemAtom.setRemark(inspectionIdRsp.getRemark());
            orderReciveItemAtom.setPurchasingPrice(inspectionIdRsp.getPurchasingPrice());
            orderReciveItemAtom.setSellingPrice(inspectionIdRsp.getSellingPrice());
            orderReciveItemAtom.setUpStatus(inspectionIdRsp.getUpStatus());
            orderReciveItemAtom.setDownStatus(inspectionIdRsp.getDownStatus());
            orderReciveItemAtom.setSaleFeeCount(inspectionIdRsp.getSaleFeeCount());
            orderReciveItemAtom.setPurchaseFeeCount(inspectionIdRsp.getPurchaseFeeCount());
            orderReciveItemAtom.setExtSkuPrice(inspectionIdRsp.getExtSkuPrice());
            orderReciveItemAtom.setExtSkuTaxPrice(inspectionIdRsp.getExtSkuTaxPrice());
            orderReciveItemAtom.setExtSkuTax(inspectionIdRsp.getExtSkuTax());
            orderReciveItemAtom.setExtSkuNakedPrice(inspectionIdRsp.getExtSkuNakedPrice());
            orderReciveItemAtom.setMaterialId(inspectionIdRsp.getMaterialId());
            orderReciveItemAtom.setMaterialClassId(inspectionIdRsp.getMaterialClassId());
            orderReciveItemAtom.setMaterialName(inspectionIdRsp.getMaterialName());
            orderReciveItemAtom.setMaterialQuality(inspectionIdRsp.getMaterialQuality());
            orderReciveItemAtom.setSpecifications(inspectionIdRsp.getSpecifications());
            orderReciveItemAtom.setModel(inspectionIdRsp.getModel());
            orderReciveItemAtom.setFigureNo(inspectionIdRsp.getFigureNo());
            orderReciveItemAtom.setSpecifications(inspectionIdRsp.getSpecifications());
            orderReciveItemAtom.setBrandId(inspectionIdRsp.getBrandId());
            orderReciveItemAtom.setBrand(inspectionIdRsp.getBrand());
        }
        return orderReciveItemAtom;
    }
}

