/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.alibaba.fastjson.JSON;
import com.cgd.common.bo.RspPageBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.loader.perms.DataPermissionBean;
import com.cgd.common.loader.perms.PermissionCacheService;
import com.cgd.common.util.MoneyUtil;
import com.cgd.feature.orm.mybatis.Page;
import com.cgd.manage.dic.dict.service.DicDictionaryService;
import com.cgd.order.atom.AccessoryXbjAtomService;
import com.cgd.order.atom.OrderSaleXbjAtomService;
import com.cgd.order.atom.QryTaskXbjAtomService;
import com.cgd.order.atom.bo.AccessoryAtomXbjRspBO;
import com.cgd.order.atom.bo.ExtOrderIdXbjReqBO;
import com.cgd.order.atom.bo.OrderPayStatusReqBO;
import com.cgd.order.atom.bo.OrderSaleInfoXbjRspBO;
import com.cgd.order.atom.bo.OrderSaleXbjReqBO;
import com.cgd.order.busi.bo.XbjAccessoryRspBO;
import com.cgd.order.busi.bo.XbjSaleOrderReqBO;
import com.cgd.order.constant.XConstant;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.AccessoryXbjMapper;
import com.cgd.order.dao.OrderSaleItemXbjMapper;
import com.cgd.order.dao.OrderSaleStatusChngLogXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.dao.OrderTabMappingOrderStatusXbjMapper;
import com.cgd.order.intfce.bo.XbjSaleOrderRespIntfceRspBO;
import com.cgd.order.po.AccessoryXbjPO;
import com.cgd.order.po.OrderSaleItemXbjPO;
import com.cgd.order.po.OrderSaleStatusChngLogXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import com.cgd.order.po.OrderTabMappingOrderStatusXbjPO;
import com.cgd.user.userInfo.busi.SelectUserInfoByUserIdBusiService;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdReqBO;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class OrderSaleXbjAtomServiceImpl
implements OrderSaleXbjAtomService {
    private static final Log log = LogFactory.getLog(OrderSaleXbjAtomServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    private OrderSaleXbjMapper orderSaleXbjMapper;
    private OrderSaleStatusChngLogXbjMapper orderSaleStatusChngLogXbjMapper;
    private OrderTabMappingOrderStatusXbjMapper orderTabMappingOrderStatusXbjMapper;
    private DicDictionaryService dicDictionaryService;
    @Autowired
    private PermissionCacheService permissionCacheService;
    @Autowired
    private AccessoryXbjAtomService accessoryXbjAtomService;
    @Autowired
    QryTaskXbjAtomService qryTaskXbjAtomService;
    @Autowired
    SelectUserInfoByUserIdBusiService selectUserInfoByUserIdBusiService;
    @Autowired
    AccessoryXbjMapper accessoryXbjMapper;
    @Autowired
    private OrderSaleItemXbjMapper orderSaleItemXbjMapper;

    public void setOrderTabMappingOrderStatusXbjMapper(OrderTabMappingOrderStatusXbjMapper orderTabMappingOrderStatusXbjMapper) {
        this.orderTabMappingOrderStatusXbjMapper = orderTabMappingOrderStatusXbjMapper;
    }

    public void setDicDictionaryService(DicDictionaryService dicDictionaryService) {
        this.dicDictionaryService = dicDictionaryService;
    }

    public OrderSaleXbjMapper getOrderSaleXbjMapper() {
        return this.orderSaleXbjMapper;
    }

    public void setOrderSaleXbjMapper(OrderSaleXbjMapper orderSaleXbjMapper) {
        this.orderSaleXbjMapper = orderSaleXbjMapper;
    }

    public OrderSaleStatusChngLogXbjMapper getOrderSaleStatusChngLogXbjMapper() {
        return this.orderSaleStatusChngLogXbjMapper;
    }

    public void setOrderSaleStatusChngLogXbjMapper(OrderSaleStatusChngLogXbjMapper orderSaleStatusChngLogXbjMapper) {
        this.orderSaleStatusChngLogXbjMapper = orderSaleStatusChngLogXbjMapper;
    }

    @Override
    public void salerOrderStatusChange(OrderSaleXbjReqBO orderSaleReqBO) {
        try {
            if (this.isDebugEnabled) {
                log.debug((Object)("\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u539f\u5b50\u5165\u53c2\uff1a" + orderSaleReqBO.toString()));
            }
            if (orderSaleReqBO == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355,\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u539f\u5b50\u670d\u52a1,\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (orderSaleReqBO.getOperId() == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355,\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u539f\u5b50\u670d\u52a1,\u64cd\u4f5c\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
            }
            OrderSaleXbjPO po = new OrderSaleXbjPO();
            po.setSaleOrderStatus(orderSaleReqBO.getSaleOrderStatus());
            po.setSaleOrderId(orderSaleReqBO.getSaleOrderId());
            po.setCancelReason(orderSaleReqBO.getCancelReason());
            po.setPurchaserId(orderSaleReqBO.getPurchaserId());
            po.setModifyOperId(orderSaleReqBO.getModifyOprId());
            po.setArriveTime(orderSaleReqBO.getArriveTime());
            po.setContractMark(orderSaleReqBO.getContractMark());
            this.orderSaleXbjMapper.updateSaleOrderStatus(po);
            OrderSaleStatusChngLogXbjPO hisPo = new OrderSaleStatusChngLogXbjPO();
            hisPo.setPurchaserId(orderSaleReqBO.getPurchaserId());
            hisPo.setPurchaserAccountId(orderSaleReqBO.getPurchaserAccountId());
            hisPo.setPurchaserAccountName(orderSaleReqBO.getPurchaserAccountName());
            hisPo.setGoodsSupplierId(orderSaleReqBO.getGoodsSupplierId());
            hisPo.setSaleOrderId(orderSaleReqBO.getSaleOrderId());
            hisPo.setOldSaleOrderStatus(orderSaleReqBO.getSaleOrderOldStatus());
            hisPo.setNewSaleOrderStatus(orderSaleReqBO.getSaleOrderStatus());
            hisPo.setProfessionalOrganizationId(orderSaleReqBO.getProfessionalOrganizationId());
            hisPo.setCreateDate(new Date());
            hisPo.setOperId(orderSaleReqBO.getOperId());
            this.orderSaleStatusChngLogXbjMapper.insertSelective(hisPo);
        }
        catch (Exception e) {
            log.error((Object)("\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u539f\u5b50\u670d\u52a1" + e));
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u539f\u5b50\u670d\u52a1\u5f02\u5e38:" + e);
        }
    }

    @Override
    public void orderPayStatusChange(OrderPayStatusReqBO orderPayStatusReq) {
        if (orderPayStatusReq == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355,\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u53d8\u66f4\u539f\u5b50\u670d\u52a1,\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (orderPayStatusReq.getSaleOrderId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355,\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u53d8\u66f4\u539f\u5b50\u670d\u52a1,\u9500\u552e\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (orderPayStatusReq.getPayStatus() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355,\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u53d8\u66f4\u539f\u5b50\u670d\u52a1,\u9500\u552e\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (orderPayStatusReq.getPurchaserId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355,\u8ba2\u5355\u652f\u4ed8\u72b6\u6001\u53d8\u66f4\u539f\u5b50\u670d\u52a1,\u91c7\u8d2d\u5546\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OrderSaleXbjPO orderSale = new OrderSaleXbjPO();
        orderSale.setPayStatus(orderPayStatusReq.getPayStatus());
        orderSale.setSaleOrderId(orderPayStatusReq.getSaleOrderId());
        orderSale.setPurchaserId(orderPayStatusReq.getPurchaserId());
    }

    @Override
    public void extOrderIdChange(ExtOrderIdXbjReqBO extOrderIdReqBO) {
        if (extOrderIdReqBO == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355,\u5916\u90e8\u8ba2\u5355\u7f16\u53f7\u66f4\u65b0\u539f\u5b50\u670d\u52a1,\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (extOrderIdReqBO.getSaleOrderId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355,\u5916\u90e8\u8ba2\u5355\u7f16\u53f7\u66f4\u65b0\u539f\u5b50\u670d\u52a1,\u9500\u552e\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (extOrderIdReqBO.getExtOrderId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355,\u5916\u90e8\u8ba2\u5355\u7f16\u53f7\u66f4\u65b0\u539f\u5b50\u670d\u52a1,\u5916\u90e8\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (extOrderIdReqBO.getPurchaserId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355,\u5916\u90e8\u8ba2\u5355\u7f16\u53f7\u66f4\u65b0\u539f\u5b50\u670d\u52a1,\u91c7\u8d2d\u5546\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OrderSaleXbjPO orderSale = new OrderSaleXbjPO();
        orderSale.setExtOrderId(extOrderIdReqBO.getExtOrderId());
        orderSale.setSaleOrderId(extOrderIdReqBO.getSaleOrderId());
        orderSale.setPurchaserId(extOrderIdReqBO.getPurchaserId());
    }

    @Override
    public OrderSaleInfoXbjRspBO selectOrderSaleById(Long saleOrderId, Long purchaserId) {
        OrderSaleXbjPO orderSale = this.orderSaleXbjMapper.selectOrderSaleByCondition(saleOrderId, purchaserId);
        OrderSaleInfoXbjRspBO orderSaleRsp = null;
        if (orderSale != null) {
            orderSaleRsp = new OrderSaleInfoXbjRspBO();
            orderSaleRsp.setSaleOrderParentId(orderSale.getSaleOrderParentId());
            orderSaleRsp.setSaleOrderStatus(orderSale.getSaleOrderStatus());
            orderSaleRsp.setSaleOrderCode(orderSale.getSaleOrderCode());
            orderSaleRsp.setPayStatus(orderSale.getPayStatus());
            orderSaleRsp.setIsSplit(orderSale.getIsSplit());
            orderSaleRsp.setSaleOrderId(orderSale.getSaleOrderId());
            orderSaleRsp.setSaleOrderName(orderSale.getSaleOrderName());
            orderSaleRsp.setSaleOrderType(orderSale.getSaleOrderType());
            orderSaleRsp.setSaleOrderBusiType(orderSale.getSaleOrderBusiType());
            orderSaleRsp.setSaleOrderMoney(orderSale.getSaleOrderMoney());
            orderSaleRsp.setNeedContactMobile(orderSale.getNeedContactMobile());
            orderSaleRsp.setNeedContactName(orderSale.getNeedContactName());
            orderSaleRsp.setBaseTransportationFee(orderSale.getBaseTransportationFee());
            orderSaleRsp.setRemoteregionfreight(orderSale.getRemoteregionfreight());
            orderSaleRsp.setTatleTransportationFee(orderSale.getTatleTransportationFee());
            orderSaleRsp.setPurchaserAccount(orderSale.getPurchaserAccount());
            orderSaleRsp.setPurchaserName(orderSale.getPurchaserName());
            orderSaleRsp.setPurchaserId(orderSale.getPurchaserId());
            orderSaleRsp.setPurchaserAccountId(orderSale.getPurchaserAccountId());
            orderSaleRsp.setPurchaserAccountName(orderSale.getPurchaserAccountName());
            orderSaleRsp.setProfessionalOrganizationId(orderSale.getProfessionalOrganizationId());
            orderSaleRsp.setGoodsSupplierId(orderSale.getGoodsSupplierId());
            orderSaleRsp.setPayType(orderSale.getPayType());
            orderSaleRsp.setPayMode(orderSale.getPayMode());
            orderSaleRsp.setGiveTime(orderSale.getGiveTime());
            orderSaleRsp.setComment(orderSale.getComment());
            orderSaleRsp.setPurchaseOrderCode(orderSale.getSaleOrderCode());
            orderSaleRsp.setPurchaseOrderId(orderSale.getPurchaseOrderId());
            orderSaleRsp.setProfessionalAccount(orderSale.getProfessionalAccount());
            orderSaleRsp.setPurchaserPath(orderSale.getPurchaserPath());
            orderSaleRsp.setCreateTime(orderSale.getCreateTime());
            orderSaleRsp.setExtOrderId(orderSale.getExtOrderId());
            orderSaleRsp.setPurchaserAccountOrgId(orderSale.getPurchaserAccountOrgId());
            orderSaleRsp.setDeptId(orderSale.getDeptId());
            orderSaleRsp.setPlaAgreementCode(orderSale.getPlaAgreementCode());
            orderSaleRsp.setDeliveryId(orderSale.getDeliveryId());
        }
        return orderSaleRsp;
    }

    @Override
    public OrderSaleInfoXbjRspBO queryOrderByCondition(Long saleOrderId, Long purchaserId) {
        OrderSaleInfoXbjRspBO orderSaleRsp = new OrderSaleInfoXbjRspBO();
        try {
            OrderSaleXbjPO orderSale = null;
            if (orderSale != null) {
                orderSaleRsp = new OrderSaleInfoXbjRspBO();
                BeanUtils.copyProperties(orderSale, (Object)orderSaleRsp);
                orderSaleRsp.setSaleOrderParentId(orderSale.getSaleOrderParentId());
                orderSaleRsp.setSaleOrderStatus(orderSale.getSaleOrderStatus());
                orderSaleRsp.setSaleOrderCode(orderSale.getSaleOrderCode());
                orderSaleRsp.setPayStatus(orderSale.getPayStatus());
                orderSaleRsp.setIsSplit(orderSale.getIsSplit());
                orderSaleRsp.setSaleOrderId(orderSale.getSaleOrderId());
                orderSaleRsp.setSaleOrderName(orderSale.getSaleOrderName());
                orderSaleRsp.setSaleOrderType(orderSale.getSaleOrderType());
                orderSaleRsp.setSaleOrderBusiType(orderSale.getSaleOrderBusiType());
                orderSaleRsp.setSaleOrderMoney(orderSale.getSaleOrderMoney());
                orderSaleRsp.setNeedContactMobile(orderSale.getNeedContactMobile());
                orderSaleRsp.setNeedContactName(orderSale.getNeedContactName());
                orderSaleRsp.setBaseTransportationFee(orderSale.getBaseTransportationFee());
                orderSaleRsp.setRemoteregionfreight(orderSale.getRemoteregionfreight());
                orderSaleRsp.setTatleTransportationFee(orderSale.getTatleTransportationFee());
                orderSaleRsp.setPurchaserAccount(orderSale.getPurchaserAccount());
                orderSaleRsp.setPurchaserName(orderSale.getPurchaserName());
                orderSaleRsp.setPurchaserId(orderSale.getPurchaserId());
                orderSaleRsp.setPurchaserAccountId(orderSale.getPurchaserAccountId());
                orderSaleRsp.setPurchaserAccountName(orderSale.getPurchaserAccountName());
                orderSaleRsp.setProfessionalOrganizationId(orderSale.getProfessionalOrganizationId());
                orderSaleRsp.setGoodsSupplierId(orderSale.getGoodsSupplierId());
                orderSaleRsp.setPayType(orderSale.getPayType());
                orderSaleRsp.setPayMode(orderSale.getPayMode());
                orderSaleRsp.setGiveTime(orderSale.getGiveTime());
                orderSaleRsp.setComment(orderSale.getComment());
                orderSaleRsp.setPurchaseOrderCode(orderSale.getSaleOrderCode());
                orderSaleRsp.setPurchaseOrderId(orderSale.getPurchaseOrderId());
                orderSaleRsp.setProfessionalAccount(orderSale.getProfessionalAccount());
                orderSaleRsp.setPurchaserPath(orderSale.getPurchaserPath());
                orderSaleRsp.setCreateTime(orderSale.getCreateTime());
                orderSaleRsp.setExtOrderId(orderSale.getExtOrderId());
                orderSaleRsp.setPurchaserAccountOrgId(orderSale.getPurchaserAccountOrgId());
                orderSaleRsp.setDeptId(orderSale.getDeptId());
                orderSaleRsp.setRespCode("0000");
                orderSaleRsp.setRespDesc("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u5b8c\u6210");
            } else {
                orderSaleRsp.setRespCode("8888");
                orderSaleRsp.setRespDesc("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u7ed3\u679c\u4e3a\u7a7a\uff01");
            }
        }
        catch (Exception e) {
            orderSaleRsp.setRespCode("8888");
            orderSaleRsp.setRespDesc("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return orderSaleRsp;
    }

    @Override
    public OrderSaleInfoXbjRspBO queryOrderSaleById(Long saleOrderId, Long purchaserId) {
        if (this.isDebugEnabled) {
            log.debug((Object)("\u6839\u636esaleOrderId, purchaserId \u67e5\u8be2\u83b7\u53d6\u8ba2\u5355\u4e3b\u8868\u5bf9\u8c61\u539f\u5b50\u5165\u53c2\uff1asaleOrderId=" + saleOrderId + ",purchaserId=" + purchaserId));
        }
        if (StringUtils.isEmpty((Object)saleOrderId)) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u9500\u552e\u8ba2\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)purchaserId)) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u91c7\u8d2d\u5355\u4f4d\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OrderSaleInfoXbjRspBO rsp = new OrderSaleInfoXbjRspBO();
        OrderSaleXbjPO po = new OrderSaleXbjPO();
        po.setSaleOrderId(saleOrderId);
        po.setPurchaserId(purchaserId);
        try {
            OrderSaleXbjPO rspPo = this.orderSaleXbjMapper.selectOrderSaleById(po);
            if (rspPo != null) {
                BeanUtils.copyProperties((Object)rspPo, (Object)rsp);
            } else {
                rsp = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u539f\u5b50\u670d\u52a1\u5f02\u5e38");
        }
        return rsp;
    }

    @Override
    public void updateSaleOrderStatus(OrderSaleXbjReqBO req) {
        try {
            if (this.isDebugEnabled) {
                log.debug((Object)("\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u539f\u5b50\u5165\u53c2\uff1a" + req.toString()));
            }
            if (req == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355,\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u539f\u5b50\u670d\u52a1,\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)req.getSaleOrderId())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355,\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u539f\u5b50\u670d\u52a1,\u9500\u552e\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)req.getSaleOrderStatus())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355,\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u539f\u5b50\u670d\u52a1,\u9500\u552e\u8ba2\u5355\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)req.getPurchaserId())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355,\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u539f\u5b50\u670d\u52a1,\u91c7\u8d2d\u5546\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)req.getPurchaserAccountId())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355,\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u539f\u5b50\u670d\u52a1,\u91c7\u8d2d\u5546\u4e0b\u5355\u4eba\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)req.getModifyOprId())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355,\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u539f\u5b50\u670d\u52a1,\u64cd\u4f5c\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)req.getProfessionalOrganizationId())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355,\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u539f\u5b50\u670d\u52a1,\u4e13\u4e1a\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a");
            }
            OrderSaleXbjPO po = new OrderSaleXbjPO();
            po.setSaleOrderStatus(req.getSaleOrderStatus());
            po.setSaleOrderId(req.getSaleOrderId());
            po.setCancelReason(req.getCancelReason());
            po.setPurchaserId(req.getPurchaserId());
            po.setModifyOperId(req.getModifyOprId());
            po.setArriveTime(req.getArriveTime());
            this.orderSaleXbjMapper.updateSaleOrderStatus(po);
            OrderSaleStatusChngLogXbjPO hisPo = new OrderSaleStatusChngLogXbjPO();
            BeanUtils.copyProperties((Object)req, (Object)hisPo);
            hisPo.setNewSaleOrderStatus(req.getSaleOrderStatus());
            hisPo.setCreateDate(new Date());
            this.orderSaleStatusChngLogXbjMapper.insertSelective(hisPo);
        }
        catch (Exception e) {
            log.error((Object)("\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u539f\u5b50\u670d\u52a1" + e));
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u539f\u5b50\u670d\u52a1\u5f02\u5e38:" + e);
        }
    }

    @Override
    public RspPageBO<XbjSaleOrderRespIntfceRspBO> qryOrderList(XbjSaleOrderReqBO xbjSaleOrderReqBO) {
        List<String> procInstIdList;
        String checkType;
        Page page = new Page(xbjSaleOrderReqBO.getPageNo(), xbjSaleOrderReqBO.getPageSize());
        RspPageBO resultPage = new RspPageBO();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        if ("purchase".equals(xbjSaleOrderReqBO.getRoleType())) {
            condition.put("purchaserId", xbjSaleOrderReqBO.getCompanyId());
        } else if ("proOrg".equals(xbjSaleOrderReqBO.getRoleType())) {
            condition.put("professionalOrganizationId", xbjSaleOrderReqBO.getCompanyId());
        } else if ("proOrgDelivery".equals(xbjSaleOrderReqBO.getRoleType())) {
            condition.put("deliveryId", xbjSaleOrderReqBO.getUserId());
            condition.put("deliveryPurchaserId", xbjSaleOrderReqBO.getCompanyId());
        } else if ("delivery".equals(xbjSaleOrderReqBO.getRoleType())) {
            condition.put("deliveryId", xbjSaleOrderReqBO.getUserId());
            condition.put("deliveryPurchaserId", xbjSaleOrderReqBO.getCompanyId());
        } else if ("check".equals(xbjSaleOrderReqBO.getRoleType())) {
            checkType = xbjSaleOrderReqBO.getTabId().equals(XbjOrderConstants.ORDER_TAB_ID.ORDER_CHECKING) ? "checking" : (xbjSaleOrderReqBO.getTabId().equals(XbjOrderConstants.ORDER_TAB_ID.ORDER_CHECKED) ? "checked" : (xbjSaleOrderReqBO.getTabId().equals(XbjOrderConstants.ORDER_TAB_ID.EXAMORDER_CHECK_ALL) ? "all" : "all"));
            procInstIdList = this.qryTaskXbjAtomService.qryProcInstIds(xbjSaleOrderReqBO.getUserId(), checkType, "50");
            if (procInstIdList == null || procInstIdList.size() == 0) {
                return resultPage;
            }
            condition.put("procInstIds", procInstIdList);
        } else if ("priceAdjustCheck".equals(xbjSaleOrderReqBO.getRoleType())) {
            checkType = xbjSaleOrderReqBO.getTabId().equals(XbjOrderConstants.ORDER_TAB_ID.PRICE_ADJUST_CHECKING) ? "checking" : (xbjSaleOrderReqBO.getTabId().equals(XbjOrderConstants.ORDER_TAB_ID.PRICE_ADJUST_CHECKED) ? "checked" : (xbjSaleOrderReqBO.getTabId().equals(XbjOrderConstants.ORDER_TAB_ID.PRICE_ADJUST_CHECK_ALL) ? "all" : "all"));
            procInstIdList = this.qryTaskXbjAtomService.qryProcInstIds(xbjSaleOrderReqBO.getUserId(), checkType, "51");
            if (procInstIdList == null || procInstIdList.size() == 0) {
                return resultPage;
            }
            condition.put("procInstIds", procInstIdList);
        } else if ("qryOrderInfo".equals(xbjSaleOrderReqBO.getRoleType())) {
            List<Long> orgAndDownOrgList;
            if ("0".equals(xbjSaleOrderReqBO.getIsprofess())) {
                condition.put("professionalOrganizationId", xbjSaleOrderReqBO.getCompanyId());
            } else if ("1".equals(xbjSaleOrderReqBO.getIsprofess()) && (orgAndDownOrgList = this.getOrgAndDownOrgByCompId(xbjSaleOrderReqBO.getUserId())) != null && orgAndDownOrgList.size() > 0) {
                condition.put("orgAndDownOrgList", orgAndDownOrgList);
            }
        } else {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5217\u8868\u591a\u6761\u4ef6\u67e5\u8be2\u7ec4\u5408\u670d\u52a1  \u4f20\u5165\u7684roleType\u4e0eorderSubType\u6709\u8bef");
        }
        ArrayList<Integer> orderPurchaseTypeList = new ArrayList<Integer>();
        if (XbjOrderConstants.ORDER_PURCHASE_TYPE_ALL.equals(xbjSaleOrderReqBO.getOrderPurchaseType())) {
            orderPurchaseTypeList.add(XbjOrderConstants.ORDER_PURCHASE_TYPE_SHIP);
            orderPurchaseTypeList.add(XbjOrderConstants.ORDER_PURCHASE_TYPE_CONSTR);
            orderPurchaseTypeList.add(XbjOrderConstants.ORDER_PURCHASE_TYPE_SERV);
            condition.put("salePurchaseTypeList", orderPurchaseTypeList);
        } else {
            orderPurchaseTypeList.add(xbjSaleOrderReqBO.getOrderPurchaseType());
            condition.put("salePurchaseTypeList", orderPurchaseTypeList);
        }
        List<Object> listOrderStatus = new ArrayList();
        listOrderStatus = null != xbjSaleOrderReqBO.getTabId() ? this.orderTabMappingOrderStatusXbjMapper.selectByTabId(xbjSaleOrderReqBO.getTabId()) : this.orderTabMappingOrderStatusXbjMapper.selectByTabId(99);
        if (CollectionUtils.isNotEmpty(listOrderStatus)) {
            ArrayList<Integer> statusList = new ArrayList<Integer>(listOrderStatus.size());
            for (OrderTabMappingOrderStatusXbjPO orderTabMappingOrderStatusXbjPO : listOrderStatus) {
                statusList.add(orderTabMappingOrderStatusXbjPO.getSaleOrderStatusCode());
            }
            condition.put("saleOrderStatusList", statusList);
        }
        List orderTypeList = xbjSaleOrderReqBO.getSaleOrderType();
        condition.put("saleOrderTypeList", orderTypeList);
        if (!StringUtils.isEmpty((Object)xbjSaleOrderReqBO.getSaleOrderCode())) {
            condition.put("saleOrderCode", xbjSaleOrderReqBO.getSaleOrderCode());
        }
        if (xbjSaleOrderReqBO.getPurchaserAccount() != null) {
            condition.put("purchaserAccount", xbjSaleOrderReqBO.getPurchaserAccount());
        }
        if (null != xbjSaleOrderReqBO.getOrderCreateStartTime()) {
            condition.put("orderCreateStartTime", xbjSaleOrderReqBO.getOrderCreateStartTime());
        }
        if (null != xbjSaleOrderReqBO.getOrderCreateEndTime()) {
            condition.put("orderCreateEndTime", xbjSaleOrderReqBO.getOrderCreateEndTime());
        }
        if (null != xbjSaleOrderReqBO.getOrderStatus()) {
            condition.put("orderStatus", xbjSaleOrderReqBO.getOrderStatus());
        }
        if (!StringUtils.isEmpty((Object)xbjSaleOrderReqBO.getGoodsSupplierId())) {
            condition.put("goodsSupplierId", xbjSaleOrderReqBO.getGoodsSupplierId());
        }
        if (!StringUtils.isEmpty((Object)xbjSaleOrderReqBO.getOrderName())) {
            condition.put("orderName", xbjSaleOrderReqBO.getOrderName());
        }
        if (!StringUtils.isEmpty((Object)xbjSaleOrderReqBO.getProtocolCode())) {
            condition.put("protocolCode", xbjSaleOrderReqBO.getProtocolCode());
        }
        if (!StringUtils.isEmpty((Object)xbjSaleOrderReqBO.getProtocolName())) {
            condition.put("protocolName", xbjSaleOrderReqBO.getProtocolName());
        }
        if (!StringUtils.isEmpty((Object)xbjSaleOrderReqBO.getIsDispatch())) {
            condition.put("isDispatch", xbjSaleOrderReqBO.getIsDispatch());
        }
        condition.put("purchaserName", xbjSaleOrderReqBO.getPurchaserName());
        List<XbjSaleOrderRespIntfceRspBO> list = this.orderSaleXbjMapper.selectOrderSale(condition, (Page<OrderSaleXbjPO>)page);
        if (CollectionUtils.isEmpty(list)) {
            resultPage.setRespCode("0000");
            resultPage.setRespDesc("\u65e0\u8ba2\u5355\u8bb0\u5f55");
            return resultPage;
        }
        Map map = this.dicDictionaryService.getValueByCode("ORDER_STATUS");
        Map cancelReasonMap = this.dicDictionaryService.getValueByCode("ELECTRIC_ORDER_CANCEL_REASON");
        Map servOrderStatusMap = this.dicDictionaryService.getValueByCode("SERV_ORDER_STATUS");
        Map constrOrderStatusMap = this.dicDictionaryService.getValueByCode("CONSTR_ORDER_STATUS");
        Map orderSourceMap = this.dicDictionaryService.getValueByCode("ORDER_SOURCE");
        Map orderCancelTypeMap = this.dicDictionaryService.getValueByCode("ORDER_CANCEL_TYPE");
        for (XbjSaleOrderRespIntfceRspBO xbjSaleOrderRespIntfceRspBO : list) {
            SelectUserInfoByUserIdRspBO userRsp;
            SelectUserInfoByUserIdReqBO selectUserInfoReqBO;
            if (null != xbjSaleOrderRespIntfceRspBO.getSaleOrderType() && null != orderSourceMap) {
                xbjSaleOrderRespIntfceRspBO.setOrderSource((String)orderSourceMap.get(String.valueOf(xbjSaleOrderRespIntfceRspBO.getSaleOrderType())));
            }
            if (null != xbjSaleOrderRespIntfceRspBO.getCancelUid()) {
                selectUserInfoReqBO = new SelectUserInfoByUserIdReqBO();
                selectUserInfoReqBO.setUserId(Long.valueOf(xbjSaleOrderRespIntfceRspBO.getCancelUid()));
                userRsp = this.selectUserInfoByUserIdBusiService.selectUserInfoByUserId(selectUserInfoReqBO);
                if (userRsp != null) {
                    xbjSaleOrderRespIntfceRspBO.setCancelUid(userRsp.getName());
                }
            }
            if (null != xbjSaleOrderRespIntfceRspBO.getCancelReason() && null != orderCancelTypeMap) {
                xbjSaleOrderRespIntfceRspBO.setCancelReason((String)orderCancelTypeMap.get(String.valueOf(xbjSaleOrderRespIntfceRspBO.getCancelReason())));
            }
            if (null != xbjSaleOrderRespIntfceRspBO.getSaleOrderMoney()) {
                xbjSaleOrderRespIntfceRspBO.setSaleOrderMoney(this.moneyCalculation(xbjSaleOrderRespIntfceRspBO.getSaleOrderMoney()));
            }
            if (null != xbjSaleOrderRespIntfceRspBO.getSaleOrderPurchaseType()) {
                if (xbjSaleOrderRespIntfceRspBO.getSaleOrderPurchaseType() == XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_WUZI) {
                    xbjSaleOrderRespIntfceRspBO.setSaleOrderPurchaseName("\u7269\u8d44");
                    if (null != xbjSaleOrderRespIntfceRspBO.getSaleOrderStatus() && null != map) {
                        xbjSaleOrderRespIntfceRspBO.setSaleOrderStatusName((String)map.get(String.valueOf(xbjSaleOrderRespIntfceRspBO.getSaleOrderStatus())));
                    }
                } else if (xbjSaleOrderRespIntfceRspBO.getSaleOrderPurchaseType() == XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_SHIGONG) {
                    xbjSaleOrderRespIntfceRspBO.setSaleOrderPurchaseName("\u65bd\u5de5");
                    if (null != xbjSaleOrderRespIntfceRspBO.getSaleOrderStatus() && null != constrOrderStatusMap) {
                        xbjSaleOrderRespIntfceRspBO.setSaleOrderStatusName((String)constrOrderStatusMap.get(String.valueOf(xbjSaleOrderRespIntfceRspBO.getSaleOrderStatus())));
                    }
                } else if (xbjSaleOrderRespIntfceRspBO.getSaleOrderPurchaseType() == XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_FUWU) {
                    xbjSaleOrderRespIntfceRspBO.setSaleOrderPurchaseName("\u670d\u52a1");
                    if (null != xbjSaleOrderRespIntfceRspBO.getSaleOrderStatus() && null != servOrderStatusMap) {
                        xbjSaleOrderRespIntfceRspBO.setSaleOrderStatusName((String)servOrderStatusMap.get(String.valueOf(xbjSaleOrderRespIntfceRspBO.getSaleOrderStatus())));
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)xbjSaleOrderRespIntfceRspBO.getDeliveryId()) && !org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)xbjSaleOrderRespIntfceRspBO.getDeliveryName())) {
                    selectUserInfoReqBO = new SelectUserInfoByUserIdReqBO();
                    selectUserInfoReqBO.setUserId(Long.valueOf(xbjSaleOrderRespIntfceRspBO.getDeliveryId()));
                    userRsp = this.selectUserInfoByUserIdBusiService.selectUserInfoByUserId(selectUserInfoReqBO);
                    if (userRsp != null) {
                        xbjSaleOrderRespIntfceRspBO.setDeliveryName(userRsp.getName());
                    }
                }
            }
            if (xbjSaleOrderRespIntfceRspBO.getSaleOrderStatus().equals(XConstant.SALE_ORDER_STATE_REJECT_TO_DEAL)) {
                List<AccessoryAtomXbjRspBO> accessoryXbjPOlist = null;
                try {
                    accessoryXbjPOlist = this.accessoryXbjAtomService.selectByObjectIdAndObjectType(Long.valueOf(xbjSaleOrderRespIntfceRspBO.getSaleOrderId()), XConstant.REJECT_OBJECT_TYPE);
                }
                catch (Exception e) {
                    throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u62d2\u5355\u9644\u4ef6\u5931\u8d25");
                }
                ArrayList<XbjAccessoryRspBO> accessoryList = new ArrayList<XbjAccessoryRspBO>();
                for (AccessoryAtomXbjRspBO accessoryXbjPOTmp : accessoryXbjPOlist) {
                    XbjAccessoryRspBO xbjAccessoryRspBO = new XbjAccessoryRspBO();
                    xbjAccessoryRspBO.setAccessoryName(accessoryXbjPOTmp.getAccessoryName());
                    xbjAccessoryRspBO.setAccessoryId(accessoryXbjPOTmp.getId());
                    xbjAccessoryRspBO.setAccessoryUrl(accessoryXbjPOTmp.getAccessoryUrl());
                    accessoryList.add(xbjAccessoryRspBO);
                }
                xbjSaleOrderRespIntfceRspBO.setRefuseFiles(accessoryList);
            }
            List<OrderSaleItemXbjPO> orderSaleItemList = this.orderSaleItemXbjMapper.selectBySaleOrderAndPurchaserId(Long.parseLong(xbjSaleOrderRespIntfceRspBO.getSaleOrderId()), Long.parseLong(xbjSaleOrderRespIntfceRspBO.getPurchaserId()));
            BigDecimal newSaleOrderMoney = BigDecimal.ZERO;
            BigDecimal newPurchaseOrderMoney = BigDecimal.ZERO;
            if (orderSaleItemList != null && !orderSaleItemList.isEmpty()) {
                for (OrderSaleItemXbjPO po : orderSaleItemList) {
                    if (po == null) continue;
                    try {
                        if (po.getNewSellingPrice() != null) {
                            BigDecimal newSellingPirce = MoneyUtil.Long2BigDecimal((Long)po.getNewSellingPrice());
                            BigDecimal newTotalSalePrice = newSellingPirce.multiply(po.getPurchaseCount());
                            newSaleOrderMoney = newSaleOrderMoney.add(newTotalSalePrice.setScale(2, 4));
                        }
                        if (po.getNewPurchasingPrice() == null) continue;
                        BigDecimal newPurchasingPirce = MoneyUtil.Long2BigDecimal((Long)po.getNewPurchasingPrice());
                        BigDecimal newTotalPurchasePrice = newPurchasingPirce.multiply(po.getPurchaseCount());
                        newPurchaseOrderMoney = newPurchaseOrderMoney.add(newTotalPurchasePrice.setScale(2, 4));
                    }
                    catch (Exception e) {
                        log.error((Object)"\u8ba2\u5355\u67e5\u8be2\u8ba1\u7b97\u4ef7\u683c\u5f02\u5e38", (Throwable)e);
                        throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u91c7\u8d2d\u8ba2\u5355\u5217\u8868\u591a\u6761\u4ef6\u67e5\u8be2\u7ec4\u5408\u670d\u52a1  \u8ba1\u7b97\u4ef7\u683c\u5f02\u5e38");
                    }
                }
                xbjSaleOrderRespIntfceRspBO.setNewOrderMoney(String.valueOf(newSaleOrderMoney));
                xbjSaleOrderRespIntfceRspBO.setNewPurchaseMoney(String.valueOf(newPurchaseOrderMoney));
                continue;
            }
            resultPage.setRespCode("0000");
            resultPage.setRespDesc("\u65e0\u8be5\u9500\u552e\u8ba2\u5355\u7684\u660e\u7ec6\u4fe1\u606f");
            return resultPage;
        }
        resultPage.setRecordsTotal(page.getTotalCount());
        resultPage.setTotal(page.getTotalPages());
        resultPage.setRespCode("0000");
        resultPage.setRespDesc("\u67e5\u8be2\u5206\u9875\u9500\u552e\u8ba2\u5355\u6210\u529f\uff01");
        resultPage.setRows(list);
        return resultPage;
    }

    @Override
    public RspPageBO<XbjSaleOrderRespIntfceRspBO> qryOrderListExp(XbjSaleOrderReqBO xbjSaleOrderReqBO) {
        List<XbjSaleOrderRespIntfceRspBO> list;
        List<String> procInstIdList;
        String checkType;
        RspPageBO resultPage = new RspPageBO();
        HashMap<String, Object> condition = new HashMap<String, Object>();
        if ("purchase".equals(xbjSaleOrderReqBO.getRoleType())) {
            condition.put("purchaserId", xbjSaleOrderReqBO.getCompanyId());
        } else if ("proOrg".equals(xbjSaleOrderReqBO.getRoleType())) {
            condition.put("professionalOrganizationId", xbjSaleOrderReqBO.getCompanyId());
        } else if ("proOrgDelivery".equals(xbjSaleOrderReqBO.getRoleType())) {
            condition.put("deliveryId", xbjSaleOrderReqBO.getUserId());
        } else if ("delivery".equals(xbjSaleOrderReqBO.getRoleType())) {
            condition.put("deliveryId", xbjSaleOrderReqBO.getUserId());
            condition.put("deliveryPurchaserId", xbjSaleOrderReqBO.getCompanyId());
        } else if ("check".equals(xbjSaleOrderReqBO.getRoleType())) {
            checkType = xbjSaleOrderReqBO.getTabId().equals(XbjOrderConstants.ORDER_TAB_ID.ORDER_CHECKING) ? "checking" : (xbjSaleOrderReqBO.getTabId().equals(XbjOrderConstants.ORDER_TAB_ID.ORDER_CHECKED) ? "checked" : (xbjSaleOrderReqBO.getTabId().equals(XbjOrderConstants.ORDER_TAB_ID.EXAMORDER_CHECK_ALL) ? "all" : "all"));
            procInstIdList = this.qryTaskXbjAtomService.qryProcInstIds(xbjSaleOrderReqBO.getUserId(), checkType, "50");
            if (procInstIdList == null || procInstIdList.size() == 0) {
                return resultPage;
            }
            condition.put("procInstIds", procInstIdList);
        } else if ("priceAdjustCheck".equals(xbjSaleOrderReqBO.getRoleType())) {
            checkType = xbjSaleOrderReqBO.getTabId().equals(XbjOrderConstants.ORDER_TAB_ID.PRICE_ADJUST_CHECKING) ? "checking" : (xbjSaleOrderReqBO.getTabId().equals(XbjOrderConstants.ORDER_TAB_ID.PRICE_ADJUST_CHECKED) ? "checked" : (xbjSaleOrderReqBO.getTabId().equals(XbjOrderConstants.ORDER_TAB_ID.PRICE_ADJUST_CHECK_ALL) ? "all" : "all"));
            procInstIdList = this.qryTaskXbjAtomService.qryProcInstIds(xbjSaleOrderReqBO.getUserId(), checkType, "51");
            if (procInstIdList == null || procInstIdList.size() == 0) {
                return resultPage;
            }
            condition.put("procInstIds", procInstIdList);
        } else if ("qryOrderInfo".equals(xbjSaleOrderReqBO.getRoleType())) {
            List<Long> orgAndDownOrgList;
            if ("0".equals(xbjSaleOrderReqBO.getIsprofess())) {
                condition.put("professionalOrganizationId", xbjSaleOrderReqBO.getCompanyId());
            } else if ("1".equals(xbjSaleOrderReqBO.getIsprofess()) && (orgAndDownOrgList = this.getOrgAndDownOrgByCompId(xbjSaleOrderReqBO.getUserId())) != null && orgAndDownOrgList.size() > 0) {
                condition.put("orgAndDownOrgList", orgAndDownOrgList);
            }
        } else {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5217\u8868\u591a\u6761\u4ef6\u67e5\u8be2\u7ec4\u5408\u670d\u52a1  \u4f20\u5165\u7684roleType\u4e0eorderSubType\u6709\u8bef");
        }
        ArrayList<Integer> orderPurchaseTypeList = new ArrayList<Integer>();
        if (XbjOrderConstants.ORDER_PURCHASE_TYPE_ALL.equals(xbjSaleOrderReqBO.getOrderPurchaseType())) {
            orderPurchaseTypeList.add(XbjOrderConstants.ORDER_PURCHASE_TYPE_SHIP);
            orderPurchaseTypeList.add(XbjOrderConstants.ORDER_PURCHASE_TYPE_CONSTR);
            orderPurchaseTypeList.add(XbjOrderConstants.ORDER_PURCHASE_TYPE_SERV);
            condition.put("salePurchaseTypeList", orderPurchaseTypeList);
        } else {
            orderPurchaseTypeList.add(xbjSaleOrderReqBO.getOrderPurchaseType());
            condition.put("salePurchaseTypeList", orderPurchaseTypeList);
        }
        List<Object> listOrderStatus = new ArrayList();
        listOrderStatus = null != xbjSaleOrderReqBO.getTabId() ? this.orderTabMappingOrderStatusXbjMapper.selectByTabId(xbjSaleOrderReqBO.getTabId()) : this.orderTabMappingOrderStatusXbjMapper.selectByTabId(99);
        if (CollectionUtils.isNotEmpty(listOrderStatus)) {
            ArrayList<Integer> statusList = new ArrayList<Integer>(listOrderStatus.size());
            for (OrderTabMappingOrderStatusXbjPO orderTabMappingOrderStatusXbjPO : listOrderStatus) {
                statusList.add(orderTabMappingOrderStatusXbjPO.getSaleOrderStatusCode());
            }
            condition.put("saleOrderStatusList", statusList);
        }
        List orderTypeList = xbjSaleOrderReqBO.getSaleOrderType();
        condition.put("saleOrderTypeList", orderTypeList);
        if (!StringUtils.isEmpty((Object)xbjSaleOrderReqBO.getSaleOrderCode())) {
            condition.put("saleOrderCode", xbjSaleOrderReqBO.getSaleOrderCode());
        }
        if (null != xbjSaleOrderReqBO.getOrderCreateStartTime()) {
            condition.put("orderCreateStartTime", xbjSaleOrderReqBO.getOrderCreateStartTime());
        }
        if (null != xbjSaleOrderReqBO.getOrderCreateEndTime()) {
            condition.put("orderCreateEndTime", xbjSaleOrderReqBO.getOrderCreateEndTime());
        }
        if (null != xbjSaleOrderReqBO.getOrderStatus()) {
            condition.put("orderStatus", xbjSaleOrderReqBO.getOrderStatus());
        }
        if (!StringUtils.isEmpty((Object)xbjSaleOrderReqBO.getGoodsSupplierId())) {
            condition.put("goodsSupplierId", xbjSaleOrderReqBO.getGoodsSupplierId());
        }
        if (!StringUtils.isEmpty((Object)xbjSaleOrderReqBO.getOrderName())) {
            condition.put("orderName", xbjSaleOrderReqBO.getOrderName());
        }
        if (!StringUtils.isEmpty((Object)xbjSaleOrderReqBO.getProtocolCode())) {
            condition.put("protocolCode", xbjSaleOrderReqBO.getProtocolCode());
        }
        if (!StringUtils.isEmpty((Object)xbjSaleOrderReqBO.getProtocolName())) {
            condition.put("protocolName", xbjSaleOrderReqBO.getProtocolName());
        }
        if (!StringUtils.isEmpty((Object)xbjSaleOrderReqBO.getIsDispatch())) {
            condition.put("isDispatch", xbjSaleOrderReqBO.getIsDispatch());
        }
        if (CollectionUtils.isEmpty(list = this.orderSaleXbjMapper.selectOrderSaleExp(condition))) {
            resultPage.setRespCode("0000");
            resultPage.setRespDesc("\u65e0\u8ba2\u5355\u8bb0\u5f55");
            return resultPage;
        }
        Map map = this.dicDictionaryService.getValueByCode("ORDER_STATUS");
        Map cancelReasonMap = this.dicDictionaryService.getValueByCode("ELECTRIC_ORDER_CANCEL_REASON");
        Map servOrderStatusMap = this.dicDictionaryService.getValueByCode("SERV_ORDER_STATUS");
        Map constrOrderStatusMap = this.dicDictionaryService.getValueByCode("CONSTR_ORDER_STATUS");
        Map orderSourceMap = this.dicDictionaryService.getValueByCode("ORDER_SOURCE");
        for (XbjSaleOrderRespIntfceRspBO xbjSaleOrderRespIntfceRspBO : list) {
            SelectUserInfoByUserIdRspBO userRsp;
            SelectUserInfoByUserIdReqBO selectUserInfoReqBO;
            if (null != xbjSaleOrderRespIntfceRspBO.getSaleOrderType() && null != orderSourceMap) {
                xbjSaleOrderRespIntfceRspBO.setOrderSource((String)orderSourceMap.get(String.valueOf(xbjSaleOrderRespIntfceRspBO.getSaleOrderType())));
            }
            if (null != xbjSaleOrderRespIntfceRspBO.getCancelUid()) {
                selectUserInfoReqBO = new SelectUserInfoByUserIdReqBO();
                selectUserInfoReqBO.setUserId(Long.valueOf(xbjSaleOrderRespIntfceRspBO.getCancelUid()));
                userRsp = this.selectUserInfoByUserIdBusiService.selectUserInfoByUserId(selectUserInfoReqBO);
                if (userRsp != null) {
                    xbjSaleOrderRespIntfceRspBO.setCancelUid(userRsp.getName());
                }
            }
            if (null != xbjSaleOrderRespIntfceRspBO.getCancelReason() && null != cancelReasonMap) {
                xbjSaleOrderRespIntfceRspBO.setCancelReason((String)cancelReasonMap.get(String.valueOf(xbjSaleOrderRespIntfceRspBO.getCancelReason())));
            }
            if (null != xbjSaleOrderRespIntfceRspBO.getSaleOrderMoney()) {
                xbjSaleOrderRespIntfceRspBO.setSaleOrderMoney(this.moneyCalculation(xbjSaleOrderRespIntfceRspBO.getSaleOrderMoney()));
            }
            if (null != xbjSaleOrderRespIntfceRspBO.getSaleOrderPurchaseType()) {
                if (xbjSaleOrderRespIntfceRspBO.getSaleOrderPurchaseType() == XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_WUZI) {
                    xbjSaleOrderRespIntfceRspBO.setSaleOrderPurchaseName("\u7269\u8d44");
                    if (null != xbjSaleOrderRespIntfceRspBO.getSaleOrderStatus() && null != map) {
                        xbjSaleOrderRespIntfceRspBO.setSaleOrderStatusName((String)map.get(String.valueOf(xbjSaleOrderRespIntfceRspBO.getSaleOrderStatus())));
                    }
                } else if (xbjSaleOrderRespIntfceRspBO.getSaleOrderPurchaseType() == XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_SHIGONG) {
                    xbjSaleOrderRespIntfceRspBO.setSaleOrderPurchaseName("\u65bd\u5de5");
                    if (null != xbjSaleOrderRespIntfceRspBO.getSaleOrderStatus() && null != constrOrderStatusMap) {
                        xbjSaleOrderRespIntfceRspBO.setSaleOrderStatusName((String)constrOrderStatusMap.get(String.valueOf(xbjSaleOrderRespIntfceRspBO.getSaleOrderStatus())));
                    }
                } else if (xbjSaleOrderRespIntfceRspBO.getSaleOrderPurchaseType() == XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_FUWU) {
                    xbjSaleOrderRespIntfceRspBO.setSaleOrderPurchaseName("\u670d\u52a1");
                    if (null != xbjSaleOrderRespIntfceRspBO.getSaleOrderStatus() && null != servOrderStatusMap) {
                        xbjSaleOrderRespIntfceRspBO.setSaleOrderStatusName((String)servOrderStatusMap.get(String.valueOf(xbjSaleOrderRespIntfceRspBO.getSaleOrderStatus())));
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)xbjSaleOrderRespIntfceRspBO.getDeliveryId()) && !org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)xbjSaleOrderRespIntfceRspBO.getDeliveryName())) {
                    selectUserInfoReqBO = new SelectUserInfoByUserIdReqBO();
                    selectUserInfoReqBO.setUserId(Long.valueOf(xbjSaleOrderRespIntfceRspBO.getDeliveryId()));
                    userRsp = this.selectUserInfoByUserIdBusiService.selectUserInfoByUserId(selectUserInfoReqBO);
                    if (userRsp != null) {
                        xbjSaleOrderRespIntfceRspBO.setDeliveryName(userRsp.getName());
                    }
                }
            }
            if (!xbjSaleOrderRespIntfceRspBO.getSaleOrderStatus().equals(XConstant.SALE_ORDER_STATE_REJECT_TO_DEAL)) continue;
            AccessoryXbjPO accessoryXbjPO = new AccessoryXbjPO();
            accessoryXbjPO.setObjectType(XConstant.REJECT_OBJECT_TYPE);
            accessoryXbjPO.setObjectId(Long.valueOf(xbjSaleOrderRespIntfceRspBO.getPurchaseOrderId()));
            List<AccessoryAtomXbjRspBO> accessoryXbjPOlist = null;
            try {
                accessoryXbjPOlist = this.accessoryXbjAtomService.selectByObjectIdAndObjectType(Long.valueOf(xbjSaleOrderRespIntfceRspBO.getPurchaseOrderId()), XConstant.REJECT_OBJECT_TYPE);
            }
            catch (Exception e) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u62d2\u5355\u9644\u4ef6\u5931\u8d25");
            }
            ArrayList<XbjAccessoryRspBO> accessoryList = new ArrayList<XbjAccessoryRspBO>();
            for (AccessoryAtomXbjRspBO accessoryXbjPOTmp : accessoryXbjPOlist) {
                XbjAccessoryRspBO xbjAccessoryRspBO = new XbjAccessoryRspBO();
                xbjAccessoryRspBO.setAccessoryName(accessoryXbjPOTmp.getAccessoryName());
                xbjAccessoryRspBO.setAccessoryId(accessoryXbjPOTmp.getId());
                xbjAccessoryRspBO.setAccessoryUrl(accessoryXbjPOTmp.getAccessoryUrl());
                accessoryList.add(xbjAccessoryRspBO);
            }
            xbjSaleOrderRespIntfceRspBO.setRefuseFiles(accessoryList);
        }
        resultPage.setRespCode("0000");
        resultPage.setRespDesc("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u6210\u529f\uff01");
        resultPage.setRows(list);
        return resultPage;
    }

    private String moneyCalculation(String money) {
        String retMoney = "";
        try {
            Long moneyNum = Long.valueOf(money);
            BigDecimal newMoney = MoneyUtil.Long2BigDecimal((Long)moneyNum);
            retMoney = String.valueOf(newMoney);
        }
        catch (Exception e) {
            log.error((Object)"\u521d\u59cb\u5316\u8ba2\u5355\u603b\u4ef7\u4fe1\u606f\u5f02\u5e38:", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u521d\u59cb\u5316\u8ba2\u5355\u603b\u4ef7\u4fe1\u606f\u5f02\u5e38:" + e.getMessage());
        }
        return retMoney;
    }

    private List<Long> getOrgAndDownOrgByCompId(Long userId) {
        ArrayList orgIdList = null;
        DataPermissionBean dataPermission = this.permissionCacheService.getDataPermission(PermissionCacheService.ResrcCode.getEnum((String)"qry_order_purchase"), userId);
        log.error((Object)("\u67e5\u8be2\u9500\u552e\u5355\u5217\u8868 \u67e5\u8be2\u6570\u636e\u6743\u9650\u8fd4\u56de\uff1a" + JSON.toJSONString((Object)dataPermission)));
        if (dataPermission != null) {
            if (dataPermission.isAuthorisedAll()) {
                return null;
            }
            Set orgIds = dataPermission.getAuthorisedOrgIds();
            if (orgIds != null) {
                orgIdList = new ArrayList(orgIds);
            }
        }
        return orgIdList;
    }
}

