/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.feature.orm.mybatis.Page;
import com.cgd.manage.dic.dict.service.DicDictionaryService;
import com.cgd.order.atom.AccessoryXbjAtomService;
import com.cgd.order.atom.bo.AccessoryAtomXbjRspBO;
import com.cgd.order.busi.XbjQryOrderConstrDetailBusiService;
import com.cgd.order.busi.bo.CompleteItemRspBO;
import com.cgd.order.busi.bo.XbjQryOrderConstrDetailReqBO;
import com.cgd.order.busi.bo.XbjQryOrderConstrDetailRspBO;
import com.cgd.order.busi.bo.XbjQuerySaleOrderItemRspBO;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.AccessoryXbjMapper;
import com.cgd.order.dao.OrderConstrCompleteItemXbjMapper;
import com.cgd.order.dao.OrderConstrCompleteXbjMapper;
import com.cgd.order.dao.OrderConstrInspectionItemXbjMapper;
import com.cgd.order.dao.OrderPurchaseItemXbjMapper;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.intfce.bo.XbjAccessoryBO;
import com.cgd.order.po.AccessoryXbjPO;
import com.cgd.order.po.OrderConstrCompleteItemXbjPO;
import com.cgd.order.po.OrderConstrCompleteXbjPO;
import com.cgd.order.po.OrderConstrInspectionItemXbjPO;
import com.cgd.order.po.OrderPurchaseItemXbjPO;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import com.cgd.order.util.DateUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class XbjQryOrderConstrDetailBusiServiceImpl
implements XbjQryOrderConstrDetailBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjQryOrderConstrDetailBusiService.class);
    private final Boolean isDebugEnabled = log.isDebugEnabled();
    private OrderConstrCompleteXbjMapper orderConstrXbjMapper;
    private OrderConstrCompleteItemXbjMapper orderConstrItemXbjMapper;
    private AccessoryXbjMapper accessoryXbjMapper;
    @Autowired
    private OrderSaleXbjMapper orderSaleXbjMapper;
    @Autowired
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;
    @Autowired
    private AccessoryXbjAtomService accessoryXbjAtomService;
    @Autowired
    OrderPurchaseItemXbjMapper orderPurchaseItemXbjMapper;
    @Autowired
    OrderConstrInspectionItemXbjMapper orderConstrInspectionItemXbjMapper;
    @Autowired
    private DicDictionaryService dicDictionaryService;

    public void setOrderConstrXbjMapper(OrderConstrCompleteXbjMapper orderConstrXbjMapper) {
        this.orderConstrXbjMapper = orderConstrXbjMapper;
    }

    public void setOrderConstrItemXbjMapper(OrderConstrCompleteItemXbjMapper orderConstrItemXbjMapper) {
        this.orderConstrItemXbjMapper = orderConstrItemXbjMapper;
    }

    public void setAccessoryXbjMapper(AccessoryXbjMapper accessoryXbjMapper) {
        this.accessoryXbjMapper = accessoryXbjMapper;
    }

    public XbjQryOrderConstrDetailRspBO selectConstrInspectionDetail(XbjQryOrderConstrDetailReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65bd\u5de5\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\uff0c\u5165\u53c2constrCompleteOrderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.isDebugEnabled.booleanValue()) {
            log.debug("\u5386\u53f2\u65bd\u5de5\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1  -> \u5165\u53c2BO:" + reqBO.toString());
        }
        XbjQryOrderConstrDetailRspBO rspBo = new XbjQryOrderConstrDetailRspBO();
        OrderConstrCompleteItemXbjPO orderConstrItemPO = new OrderConstrCompleteItemXbjPO();
        try {
            Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
            if (!StringUtils.isEmpty((CharSequence)reqBO.getConstrCompleteOrderId())) {
                ArrayList<XbjAccessoryBO> accessoryBOList = new ArrayList<XbjAccessoryBO>();
                OrderConstrCompleteXbjPO orderConstr = this.orderConstrXbjMapper.getModelById(Long.valueOf(reqBO.getConstrCompleteOrderId()));
                if (orderConstr != null) {
                    orderConstrItemPO.setConstrCompleteOrderId(orderConstr.getConstrCompleteOrderId());
                    BeanUtils.copyProperties((Object)rspBo, (Object)orderConstr);
                    rspBo.setOpenDateStr(DateUtil.dateToStrLong(orderConstr.getOpenDate()));
                    rspBo.setConstrCompleteOrderId(String.valueOf(orderConstr.getConstrCompleteOrderId()));
                    rspBo.setConstrStatus(orderConstr.getConstrStatus() + "");
                    Map constrStatusMap = this.dicDictionaryService.getValueByCode("SERV_SHIP_STATUS");
                    if (constrStatusMap != null) {
                        rspBo.setConstrStatusName((String)constrStatusMap.get(orderConstr.getConstrStatus() + ""));
                    }
                    AccessoryXbjPO accessoryPO = new AccessoryXbjPO();
                    accessoryPO.setObjectId((long)orderConstr.getConstrCompleteOrderId());
                    accessoryPO.setObjectType(XbjOrderConstants.ACCESSORY_TYPE.CONSTR_COMPLETE);
                    List<AccessoryAtomXbjRspBO> accessoryXbjPOlist = this.accessoryXbjAtomService.selectByObjectIdAndObjectType(accessoryPO.getObjectId(), accessoryPO.getObjectType());
                    if (accessoryXbjPOlist != null) {
                        for (AccessoryAtomXbjRspBO accessory : accessoryXbjPOlist) {
                            XbjAccessoryBO accessoryBO = new XbjAccessoryBO();
                            BeanUtils.copyProperties((Object)accessoryBO, (Object)accessory);
                            accessoryBOList.add(accessoryBO);
                        }
                        rspBo.setDownLoadFiles(accessoryBOList);
                    }
                }
            } else if (reqBO.getPurchaseOrderId() != null || reqBO.getSaleOrderId() != null) {
                Serializable po;
                Integer orderType = null;
                if (reqBO.getSaleOrderId() != null) {
                    po = this.orderSaleXbjMapper.getModelById(reqBO.getSaleOrderId());
                    if (po == null) {
                        throw new BusinessException("RSP_CODE_SALSE_ORDER_NOT_EXIST", "\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728");
                    }
                    orderConstrItemPO.setSaleOrderId(((OrderSaleXbjPO)po).getSaleOrderId());
                    orderConstrItemPO.setPurchaseOrderId(((OrderSaleXbjPO)po).getPurchaseOrderId());
                    orderType = ((OrderSaleXbjPO)po).getOrderType();
                }
                if (reqBO.getPurchaseOrderId() != null) {
                    po = this.orderPurchaseXbjMapper.getModelById(reqBO.getPurchaseOrderId());
                    if (po == null) {
                        throw new BusinessException("RSP_CODE_SALSE_ORDER_NOT_EXIST", "\u91c7\u8d2d\u8ba2\u5355\u4e0d\u5b58\u5728");
                    }
                    orderConstrItemPO.setPurchaseOrderId(((OrderPurchaseXbjPO)po).getPurchaseOrderId());
                    orderConstrItemPO.setSaleOrderId(((OrderPurchaseXbjPO)po).getSaleOrderId());
                    orderType = ((OrderPurchaseXbjPO)po).getOrderType();
                }
                OrderPurchaseItemXbjPO condition = new OrderPurchaseItemXbjPO();
                condition.setPurchaseOrderId((long)reqBO.getPurchaseOrderId());
                List<OrderPurchaseItemXbjPO> orderPurchaseItemList = this.orderPurchaseItemXbjMapper.getList(condition);
                ArrayList<XbjQuerySaleOrderItemRspBO> rspList = new ArrayList<XbjQuerySaleOrderItemRspBO>();
                for (OrderPurchaseItemXbjPO ItemPO : orderPurchaseItemList) {
                    OrderConstrInspectionItemXbjPO orderReciveItemCondition = new OrderConstrInspectionItemXbjPO();
                    orderReciveItemCondition.setPurchaseOrderItemId(ItemPO.getPurchaseOrderItemId());
                    List<OrderConstrInspectionItemXbjPO> OrderReceiveItemList = this.orderConstrInspectionItemXbjMapper.getList(orderReciveItemCondition);
                    BigDecimal acceptanceCount = BigDecimal.valueOf(0L);
                    for (OrderConstrInspectionItemXbjPO itemPO : OrderReceiveItemList) {
                        acceptanceCount = acceptanceCount.add(itemPO.getOnceAcceptanceCount());
                        if (!this.isDebugEnabled.booleanValue()) continue;
                        log.debug("\u5386\u53f2\u53d1\u8d27\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1  -------> \u5df2\u9a8c\u6536\u6570\u91cfacceptanceCount\u5faa\u73af:" + acceptanceCount);
                    }
                    if (this.isDebugEnabled.booleanValue()) {
                        log.debug("\u5386\u53f2\u53d1\u8d27\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1  -------> \u5df2\u9a8c\u6536\u6570\u91cfacceptanceCount\u5168\u90e8:" + acceptanceCount);
                    }
                    XbjQuerySaleOrderItemRspBO rspBO = new XbjQuerySaleOrderItemRspBO();
                    BeanUtils.copyProperties((Object)ItemPO, (Object)rspBo);
                    rspBO.setSaleOrderItemId(ItemPO.getSaleOrderItemId() + "");
                    rspBO.setPurchaseOrderItemId(ItemPO.getPurchaseOrderItemId());
                    rspBO.setAcceptanceCount(acceptanceCount);
                    rspBO.setPurchaseCount(ItemPO.getPurchaseCount());
                    if (orderType == XbjOrderConstants.SALE_ORDER_TYPE.SINGLE) {
                        BigDecimal maxAcceptanceCount = ItemPO.getPurchaseCount().multiply(BigDecimal.valueOf(1.2));
                        if (this.isDebugEnabled.booleanValue()) {
                            log.debug("\u5386\u53f2\u53d1\u8d27\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1  -------> \u6700\u5927\u9a8c\u6536\u6570\u91cfmaxAcceptanceCount\u5168\u90e8:" + maxAcceptanceCount);
                            log.debug("\u5386\u53f2\u53d1\u8d27\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1  -------> \u6700\u5927\u9a8c\u6536\u6570\u91cfItemPO.getPurchaseCount()\u5168\u90e8:" + ItemPO.getPurchaseCount());
                            log.debug("\u5386\u53f2\u53d1\u8d27\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1  -------> \u6700\u5927\u9a8c\u6536\u6570\u91cfmaxAcceptanceCount.subtract(acceptanceCount)\u5168\u90e8:" + maxAcceptanceCount.subtract(acceptanceCount));
                            log.debug("\u5386\u53f2\u53d1\u8d27\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1  -------> \u6700\u5927\u9a8c\u6536\u6570\u91cfacceptanceCount\u5168\u90e8:" + acceptanceCount);
                        }
                        rspBO.setResidualAcceptanceCount(maxAcceptanceCount.subtract(acceptanceCount));
                    } else {
                        rspBO.setResidualAcceptanceCount(ItemPO.getPurchaseCount().subtract(acceptanceCount));
                    }
                    rspList.add(rspBO);
                }
                rspBo.setSaleOrderItemRspBOS(rspList);
            } else {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65bd\u5de5\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\uff0c\u5165\u53c2constrCompleteOrderId saleOrderId purchaseOrderId \u5fc5\u4f20\u5176\u4e00");
            }
            ArrayList<CompleteItemRspBO> completeItemRspBOList = new ArrayList<CompleteItemRspBO>();
            List<OrderConstrCompleteItemXbjPO> constrItemList = this.orderConstrItemXbjMapper.getListPage(orderConstrItemPO, (Page<OrderConstrCompleteItemXbjPO>)page, "");
            if (constrItemList != null) {
                for (OrderConstrCompleteItemXbjPO constrItemXbjPO : constrItemList) {
                    CompleteItemRspBO completeItemRspBO = new CompleteItemRspBO();
                    BeanUtils.copyProperties((Object)completeItemRspBO, (Object)constrItemXbjPO);
                    completeItemRspBO.setOnceCompleteCount(constrItemXbjPO.getOnceCompleteCount());
                    completeItemRspBO.setOpenDate(DateUtil.dateToStrLong(constrItemXbjPO.getOpenDate()));
                    completeItemRspBO.setFinishDate(DateUtil.dateToStrLong(constrItemXbjPO.getFinishDate()));
                    completeItemRspBO.setSellingPrice(MoneyUtil.Long2BigDecimal((Long)constrItemXbjPO.getSellingPrice()));
                    completeItemRspBO.setConstrCompleteOrderId(constrItemXbjPO.getConstrCompleteOrderId() + "");
                    completeItemRspBO.setOpenOrderNo(constrItemXbjPO.getOpenOrderNo());
                    OrderPurchaseItemXbjPO itemXbjPO = this.orderPurchaseItemXbjMapper.getModelById(Long.parseLong(completeItemRspBO.getPurchaseOrderItemId()));
                    completeItemRspBO.setOrderCount(itemXbjPO.getPurchaseCount() + "");
                    completeItemRspBOList.add(completeItemRspBO);
                }
            }
            rspBo.setRows(completeItemRspBOList);
            rspBo.setRecordsTotal(page.getTotalCount());
            rspBo.setTotal(page.getTotalPages());
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u5386\u53f2\u65bd\u5de5\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5b8c\u6210\uff01");
        }
        catch (Exception e) {
            log.error("\u65bd\u5de5\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u65bd\u5de5\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38");
        }
        if (this.isDebugEnabled.booleanValue()) {
            log.debug("\u5386\u53f2\u65bd\u5de5\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1  -> \u51fa\u53c2BO:" + rspBo.toString());
        }
        return rspBo;
    }
}

