/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.AccessoryXbjAtomService;
import com.cgd.order.atom.ArrivalRegistrationXbjAtomService;
import com.cgd.order.atom.OrderPurchaseStatusChngXbjService;
import com.cgd.order.atom.OrderSaleXbjAtomService;
import com.cgd.order.atom.XbjCreateOrderFlowSheetAtomService;
import com.cgd.order.atom.bo.ArrivalRegistrationAtomXbjReqBO;
import com.cgd.order.atom.bo.OrderPurchaseStatusChngReqBo;
import com.cgd.order.atom.bo.OrderSaleXbjReqBO;
import com.cgd.order.busi.XbjArrivalRegistrationBusiService;
import com.cgd.order.busi.bo.XbjArrivalRegistrationBusiReqBO;
import com.cgd.order.busi.bo.XbjArrivalRegistrationBusiRspBO;
import com.cgd.order.busi.bo.XbjArrivalRegistrationShipBusiReqBO;
import com.cgd.order.busi.bo.XbjOrderFlowSheetReqBO;
import com.cgd.order.busi.bo.XbjOrderFlowSheetRspBO;
import com.cgd.order.busi.bo.XbjPurchaseAccessoryReqBO;
import com.cgd.order.constant.Constant;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.OrderPurchaseItemXbjMapper;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.dao.OrderShipItemXbjMapper;
import com.cgd.order.dao.OrderShipXbjMapper;
import com.cgd.order.po.AccessoryXbjPO;
import com.cgd.order.po.OrderPurchaseItemXbjPO;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import com.cgd.order.po.OrderShipItemXbjPO;
import com.cgd.order.po.OrderShipXbjPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class XbjArrivalRegistrationBusiServiceImpl
implements XbjArrivalRegistrationBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjArrivalRegistrationBusiServiceImpl.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private ArrivalRegistrationXbjAtomService arrivalRegistrationXbjAtomService;
    @Autowired
    private AccessoryXbjAtomService accessoryXbjAtomService;
    @Autowired
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;
    @Autowired
    private OrderSaleXbjMapper orderSaleXbjMapper;
    @Autowired
    private OrderPurchaseStatusChngXbjService orderPurchaseStatusChngXbjService;
    @Autowired
    private OrderSaleXbjAtomService orderSaleXbjAtomService;
    @Autowired
    private OrderPurchaseItemXbjMapper orderPurchaseItemXbjMapper;
    @Autowired
    private OrderShipItemXbjMapper orderShipItemXbjMapper;
    @Autowired
    private XbjCreateOrderFlowSheetAtomService xbjCreateOrderFlowSheetAtomService;
    @Autowired
    private OrderShipXbjMapper orderShipXbjMapper;

    public XbjArrivalRegistrationBusiRspBO saveArrivalRegistration(XbjArrivalRegistrationBusiReqBO xbjArrivalRegistrationBusiReqBO) {
        if (isDebugEnabled) {
            log.debug("\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u5165\u53c2" + JSON.toJSONString((Object)xbjArrivalRegistrationBusiReqBO));
        }
        this.validateBOData(xbjArrivalRegistrationBusiReqBO);
        try {
            if (xbjArrivalRegistrationBusiReqBO.getShipOrderId() != null && !"".equals(xbjArrivalRegistrationBusiReqBO.getShipOrderId())) {
                OrderShipXbjPO orderShipXbjPO = this.orderShipXbjMapper.getModelById(xbjArrivalRegistrationBusiReqBO.getShipOrderId());
                if (orderShipXbjPO == null) {
                    if (isDebugEnabled) {
                        log.debug("\u6839\u636e\u53d1\u8d27\u5355ID\u3010" + xbjArrivalRegistrationBusiReqBO.getShipOrderId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u53d1\u8d27\u5355\u6570\u636e");
                    }
                    throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6839\u636e\u53d1\u8d27\u5355ID\u3010" + xbjArrivalRegistrationBusiReqBO.getShipOrderId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u53d1\u8d27\u5355\u6570\u636e");
                }
                xbjArrivalRegistrationBusiReqBO.setPurchaseOrderId(orderShipXbjPO.getPurchaseOrderId());
                xbjArrivalRegistrationBusiReqBO.setPurchaserId(orderShipXbjPO.getPurchaserId());
            }
        }
        catch (BusinessException e) {
            log.error("\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", e.getMessage());
        }
        catch (Exception e) {
            log.error("\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff01");
        }
        OrderPurchaseXbjPO orderPurchaseXbjPO = this.orderPurchaseXbjMapper.selectByPurchaseOrderIdAndPurchaserId(xbjArrivalRegistrationBusiReqBO.getPurchaseOrderId(), xbjArrivalRegistrationBusiReqBO.getPurchaserId());
        if (orderPurchaseXbjPO == null) {
            if (isDebugEnabled) {
                log.debug("\u6839\u636e\u8ba2\u5355ID\u3010" + xbjArrivalRegistrationBusiReqBO.getPurchaseOrderId() + "\u3011" + "\uff0c\u91c7\u8d2d\u5355\u4f4dID\u3010" + xbjArrivalRegistrationBusiReqBO.getPurchaserId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u8ba2\u5355\u6570\u636e");
            }
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6839\u636e\u8ba2\u5355ID\u3010" + xbjArrivalRegistrationBusiReqBO.getPurchaseOrderId() + "\u3011" + "\uff0c\u91c7\u8d2d\u5355\u4f4dID\u3010" + xbjArrivalRegistrationBusiReqBO.getPurchaserId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u8ba2\u5355\u6570\u636e");
        }
        if (null == orderPurchaseXbjPO.getWholeAcceptance() || XbjOrderConstants.SALE_ORDER_PURCHASE_WHOLE_ACCEPTANCE_YES == orderPurchaseXbjPO.getWholeAcceptance()) {
            if (isDebugEnabled) {
                log.debug("\u6b64\u8ba2\u5355[" + xbjArrivalRegistrationBusiReqBO.getPurchaseOrderId() + "]\u5df2\u7ecf\u6574\u5355\u9a8c\u6536,\u65e0\u6cd5\u8fdb\u884c\u5230\u8d27\u767b\u8bb0\u64cd\u4f5c");
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6b64\u8ba2\u5355\u5df2\u7ecf\u6574\u5355\u9a8c\u6536,\u65e0\u6cd5\u8fdb\u884c\u5230\u8d27\u767b\u8bb0\u64cd\u4f5c");
        }
        OrderShipItemXbjPO orderShipItemXbjPO = new OrderShipItemXbjPO();
        orderShipItemXbjPO.setShipOrderId(xbjArrivalRegistrationBusiReqBO.getShipOrderId());
        orderShipItemXbjPO.setPurchaserId(xbjArrivalRegistrationBusiReqBO.getPurchaserId());
        ArrayList<XbjArrivalRegistrationShipBusiReqBO> xbjShipItemList = new ArrayList<XbjArrivalRegistrationShipBusiReqBO>();
        try {
            List<OrderShipItemXbjPO> shipItemXbjList = this.orderShipItemXbjMapper.getList(orderShipItemXbjPO);
            if (shipItemXbjList != null && shipItemXbjList.size() > 0) {
                for (OrderShipItemXbjPO shipItemXbjPO : shipItemXbjList) {
                    XbjArrivalRegistrationShipBusiReqBO xbjArrivalRegistrationShipBusiReqBO = new XbjArrivalRegistrationShipBusiReqBO();
                    xbjArrivalRegistrationShipBusiReqBO.setShipOrderId(shipItemXbjPO.getShipOrderId());
                    xbjArrivalRegistrationShipBusiReqBO.setShipItemId(shipItemXbjPO.getShipItemId());
                    xbjShipItemList.add(xbjArrivalRegistrationShipBusiReqBO);
                }
                xbjArrivalRegistrationBusiReqBO.setOrderShipList(xbjShipItemList);
                log.error("\u5230\u8d27\u767b\u8bb0\u5165\u53c2list\u53c2\u6570\uff1a" + JSON.toJSONString((Object)xbjArrivalRegistrationBusiReqBO));
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u53d1\u8d27\u660e\u7ec6\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u53d1\u8d27\u660e\u7ec6\u5f02\u5e38");
        }
        try {
            ArrivalRegistrationAtomXbjReqBO arrivalRegistrationAtomXbjReq = new ArrivalRegistrationAtomXbjReqBO();
            BeanUtils.copyProperties((Object)xbjArrivalRegistrationBusiReqBO, (Object)arrivalRegistrationAtomXbjReq);
            arrivalRegistrationAtomXbjReq.setSaleOrderId(orderPurchaseXbjPO.getSaleOrderId());
            this.arrivalRegistrationXbjAtomService.saveArrivalRegistration(arrivalRegistrationAtomXbjReq);
            this.assembleAccessoryData(orderPurchaseXbjPO, xbjArrivalRegistrationBusiReqBO.getPurchaseAccessoryList(), xbjArrivalRegistrationBusiReqBO.getShipOrderId());
            if (!Constant.SALSE_ORDER_STATE_COMPLETED.equals(orderPurchaseXbjPO.getPurchaseOrderStatus())) {
                this.checkAllArrived(orderPurchaseXbjPO.getPurchaseOrderId(), orderPurchaseXbjPO.getPurchaserId(), xbjArrivalRegistrationBusiReqBO);
            }
            if (xbjArrivalRegistrationBusiReqBO.getShipOrderId() == null || "".equals(xbjArrivalRegistrationBusiReqBO.getShipOrderId())) {
                XbjOrderFlowSheetRspBO xbjOrderFlowSheetRspBO;
                XbjOrderFlowSheetReqBO xbjOrderFlowSheetReqBO = new XbjOrderFlowSheetReqBO();
                BeanUtils.copyProperties((Object)xbjArrivalRegistrationBusiReqBO, (Object)xbjOrderFlowSheetReqBO);
                xbjOrderFlowSheetReqBO.setOrderId(xbjArrivalRegistrationBusiReqBO.getPurchaseOrderId());
                xbjOrderFlowSheetReqBO.setOrderType(Constant.ORDER_TYPE_PURCHASE);
                xbjOrderFlowSheetReqBO.setPurchaserId(xbjArrivalRegistrationBusiReqBO.getPurchaserId());
                xbjOrderFlowSheetReqBO.setOrderBusiType("B_18");
                xbjOrderFlowSheetReqBO.setOperRole("\u4f9b\u5e94\u5546");
                xbjOrderFlowSheetReqBO.setUserId(xbjArrivalRegistrationBusiReqBO.getUserId());
                xbjOrderFlowSheetReqBO.setCompanyName(xbjArrivalRegistrationBusiReqBO.getCompanyName());
                xbjOrderFlowSheetReqBO.setUserName(xbjArrivalRegistrationBusiReqBO.getUserName());
                if (isDebugEnabled) {
                    log.debug("\u8ba2\u5355\u6267\u884c\u6d41\u7a0b\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5165\u53c2-----------------------------------------------------");
                    log.debug(JSON.toJSONString((Object)xbjOrderFlowSheetReqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                }
                if ((xbjOrderFlowSheetRspBO = this.xbjCreateOrderFlowSheetAtomService.createOrderFlowSheet(xbjOrderFlowSheetReqBO)) != null && "8888".equals(xbjOrderFlowSheetRspBO.getRespCode())) {
                    throw new BusinessException(xbjOrderFlowSheetRspBO.getRespCode(), xbjOrderFlowSheetRspBO.getRespDesc());
                }
            }
            XbjArrivalRegistrationBusiRspBO eaArrivalRegistrationBusiRsp = new XbjArrivalRegistrationBusiRspBO();
            eaArrivalRegistrationBusiRsp.setRespCode("0000");
            eaArrivalRegistrationBusiRsp.setRespDesc("\u5230\u8d27\u7b7e\u6536\u6210\u529f");
            return eaArrivalRegistrationBusiRsp;
        }
        catch (BusinessException e) {
            log.error("\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", e.getMessage());
        }
        catch (Exception e) {
            log.error("\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff01");
        }
    }

    private void validateBOData(XbjArrivalRegistrationBusiReqBO xbjArrivalRegistrationBusiReqBO) {
        if (xbjArrivalRegistrationBusiReqBO == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1  \u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjArrivalRegistrationBusiReqBO.getPurchaseOrderId() == null && xbjArrivalRegistrationBusiReqBO.getShipOrderId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1  \u91c7\u8d2d\u5355ID\u3010purchaseOrderId\u3011\u548c\u53d1\u8d27\u5355ID\u3010shipOrderId\u3011\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (xbjArrivalRegistrationBusiReqBO.getPurchaserId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1  \u91c7\u8d2d\u5355\u4f4dID\u3010purchaserId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.isBlank((CharSequence)xbjArrivalRegistrationBusiReqBO.getArriveRemark()) && xbjArrivalRegistrationBusiReqBO.getArriveRemark().length() > 200) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1  \u53d1\u8d27\u5907\u6ce8\u8f93\u5165\u5b57\u7b26\u4e0d\u80fd\u8d85\u51fa200\u4e2a");
        }
    }

    private void assembleAccessoryData(OrderPurchaseXbjPO orderPurchaseXbjPO, List<XbjPurchaseAccessoryReqBO> purchaseAccessoryList, Long shipOrderId) {
        if (purchaseAccessoryList != null && purchaseAccessoryList.size() > 0) {
            ArrayList<AccessoryXbjPO> accessoryList = new ArrayList<AccessoryXbjPO>();
            for (XbjPurchaseAccessoryReqBO xbjPurchaseAccessoryReqBO : purchaseAccessoryList) {
                AccessoryXbjPO accessory = new AccessoryXbjPO();
                accessory.setAccessoryId(xbjPurchaseAccessoryReqBO.getAccessoryId());
                accessory.setAccessoryName(xbjPurchaseAccessoryReqBO.getAccessoryName());
                accessory.setAccessoryUrl(xbjPurchaseAccessoryReqBO.getAccessoryUrl());
                accessory.setCreateDate(new Date());
                accessory.setGoodsSupplierId(String.valueOf(orderPurchaseXbjPO.getGoodsSupplierId()));
                if (shipOrderId != null) {
                    accessory.setObjectId(shipOrderId);
                } else {
                    accessory.setObjectId(orderPurchaseXbjPO.getPurchaseOrderId());
                }
                accessory.setObjectType(Constant.REGISTRATION_OBJECT_TYPE);
                accessory.setProfessionalOrganizationId(String.valueOf(orderPurchaseXbjPO.getProfessionalOrganizationId()));
                accessory.setPurchaserAccountId(orderPurchaseXbjPO.getPurchaserAccountId());
                accessory.setPurchaserAccountName(orderPurchaseXbjPO.getPurchaserAccountName());
                accessory.setPurchaserId(orderPurchaseXbjPO.getPurchaserId());
                accessory.setRemark("\u5230\u8d27\u767b\u8bb0");
                accessoryList.add(accessory);
            }
            int count = this.accessoryXbjAtomService.batchSave(accessoryList);
            if (count == 0) {
                if (isDebugEnabled) {
                    log.debug("\u6b64\u8ba2\u5355[" + orderPurchaseXbjPO.getPurchaseOrderId() + "]\u9644\u4ef6\u4fdd\u5b58\u5931\u8d25");
                }
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u6b64\u8ba2\u5355[" + orderPurchaseXbjPO.getPurchaseOrderId() + "]\u9644\u4ef6\u4fdd\u5b58\u5931\u8d25");
            }
        }
    }

    private void checkAllArrived(Long purchaseOrderId, Long purchaserId, XbjArrivalRegistrationBusiReqBO xbjArrivalRegistrationBusiReqBO) {
        if (purchaseOrderId != null && purchaserId != null) {
            try {
                boolean arrivalFlag = true;
                OrderPurchaseItemXbjPO condition = new OrderPurchaseItemXbjPO();
                OrderPurchaseXbjPO orderPurchase = this.orderPurchaseXbjMapper.getModelById(purchaseOrderId);
                OrderSaleXbjPO orderSaleXbjPO = new OrderSaleXbjPO();
                orderSaleXbjPO.setSaleOrderId((long)orderPurchase.getSaleOrderId());
                orderSaleXbjPO = this.orderSaleXbjMapper.getModelBy(orderSaleXbjPO);
                condition.setPurchaseOrderId(purchaseOrderId);
                condition.setPurchaserId(purchaserId);
                List<OrderPurchaseItemXbjPO> purchaseItemList = this.orderPurchaseItemXbjMapper.getList(condition);
                for (OrderPurchaseItemXbjPO orderPurchaseItemPO : purchaseItemList) {
                    OrderShipItemXbjPO condition2 = new OrderShipItemXbjPO();
                    condition2.setPurchaseOrderItemId(orderPurchaseItemPO.getPurchaseOrderItemId());
                    condition2.setPurchaserId(orderPurchaseItemPO.getPurchaserId());
                    List<OrderShipItemXbjPO> shipItemList = this.orderShipItemXbjMapper.getList(condition2);
                    BigDecimal allArriveCount = BigDecimal.valueOf(0L);
                    for (OrderShipItemXbjPO shipItemPO : shipItemList) {
                        if (shipItemPO.getArriveCount() == null) {
                            shipItemPO.setArriveCount(BigDecimal.valueOf(0L));
                            if (isDebugEnabled) {
                                log.debug("\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1 \u5230\u8d27 0");
                            }
                        }
                        allArriveCount = allArriveCount.add(shipItemPO.getArriveCount());
                        if (!isDebugEnabled) continue;
                        log.debug("\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u5df2\u5230\u8d27\u6570\u91cf" + allArriveCount);
                    }
                    if (isDebugEnabled) {
                        log.debug("\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u5df2\u5230\u8d27\u6570\u91cf\u548c" + allArriveCount);
                        log.debug("\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u91c7\u8d2d\u6570\u91cf\u6570\u91cf\u548c" + orderPurchaseItemPO.getPurchaseCount());
                    }
                    if (orderPurchaseItemPO.getPurchaseCount().compareTo(allArriveCount) <= 0) continue;
                    arrivalFlag = false;
                    if (!isDebugEnabled) break;
                    log.debug("\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u4e0d\u540c\u5df2\u5230\u8d27\u6570\u91cf\u548c" + allArriveCount);
                    log.debug("\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u4e0d\u540c\u91c7\u8d2d\u6570\u91cf\u6570\u91cf\u548c" + orderPurchaseItemPO.getPurchaseCount());
                    break;
                }
                if (arrivalFlag) {
                    Integer saleOrderNewStatus = Constant.SALSE_ORDER_STATE_TUOTOU;
                    if (isDebugEnabled) {
                        log.debug("\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u4e0d\u540c\u5df2\u5230\u8d27\u6570\u91cf\u548c" + saleOrderNewStatus);
                    }
                    OrderSaleXbjReqBO orderSaleReqBO = this.transferOrderSaleReqBO(orderSaleXbjPO, orderSaleXbjPO.getSaleOrderStatus(), saleOrderNewStatus, xbjArrivalRegistrationBusiReqBO.getUserId());
                    this.orderSaleXbjAtomService.salerOrderStatusChange(orderSaleReqBO);
                    Integer purchaseOrderNewStatus = Constant.SALSE_ORDER_STATE_TUOTOU;
                    OrderPurchaseStatusChngReqBo orderPurchaseStatusChngReqBo = this.transferOrderPurchaseStatusChngReqBO(xbjArrivalRegistrationBusiReqBO.getUserId(), orderPurchase, purchaseOrderNewStatus);
                    this.orderPurchaseStatusChngXbjService.dealOrderPurchaseStatus(orderPurchaseStatusChngReqBo);
                }
            }
            catch (Exception e) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1 \u53d8\u66f4\u4e3a\u5df2\u5230\u8d27\u5931\u8d25");
            }
        }
    }

    private OrderPurchaseStatusChngReqBo transferOrderPurchaseStatusChngReqBO(Long userId, OrderPurchaseXbjPO orderPurchase, Integer purchaseOrderStatus) {
        OrderPurchaseStatusChngReqBo req = new OrderPurchaseStatusChngReqBo();
        req.setPurchaseOrderId(orderPurchase.getPurchaseOrderId());
        req.setPurchaseOrderOldStatus(orderPurchase.getPurchaseOrderStatus());
        req.setPurchaseOrderStatus(purchaseOrderStatus);
        req.setPurchaserId(orderPurchase.getPurchaserId());
        req.setPurchaserAccountId(orderPurchase.getPurchaserAccountId());
        req.setOperId(userId + "");
        req.setProfessionalOrganizationId(orderPurchase.getProfessionalOrganizationId());
        req.setGoodsSupplierId(orderPurchase.getGoodsSupplierId());
        req.setPurchaserAccountName(orderPurchase.getPurchaserAccountName());
        req.setSaleOrderId(orderPurchase.getSaleOrderId());
        return req;
    }

    private OrderSaleXbjReqBO transferOrderSaleReqBO(OrderSaleXbjPO orderSale, Integer oldStatus, Integer newStatus, Long userId) {
        OrderSaleXbjReqBO req = new OrderSaleXbjReqBO();
        req.setSaleOrderId(orderSale.getSaleOrderId());
        req.setSaleOrderStatus(newStatus);
        req.setSaleOrderOldStatus(oldStatus);
        req.setPurchaserId(orderSale.getPurchaserId());
        req.setPurchaserAccountId(orderSale.getPurchaserAccountId());
        req.setOperId(userId + "");
        req.setProfessionalOrganizationId(orderSale.getProfessionalOrganizationId());
        req.setGoodsSupplierId(orderSale.getGoodsSupplierId());
        req.setModifyOprId(userId);
        req.setPurchaserAccountName(orderSale.getPurchaserAccountName());
        req.setSaleOrderType(orderSale.getSaleOrderType());
        return req;
    }
}

