/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.alibaba.fastjson.JSON;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.DateUtil;
import com.cgd.common.util.MoneyUtil;
import com.cgd.inquiry.busi.bo.execution.QuerySingleDealNoticeDetailInfoReqBO;
import com.cgd.inquiry.busi.bo.execution.QuerySingleDealNoticeDetailInfoRspBO;
import com.cgd.inquiry.busi.execution.dealnotice.QueryDealNoticeBusiService;
import com.cgd.order.busi.XbjSaleOrderVerifyBusiService;
import com.cgd.order.busi.bo.ProAccountInfoBO;
import com.cgd.order.busi.bo.XbjDetailInfoRspBO;
import com.cgd.order.busi.bo.XbjOrderDealNoticeItemReqBO;
import com.cgd.order.busi.bo.XbjOrderSaleBusiReqBO;
import com.cgd.order.busi.bo.XbjOrderSaleVerifyBaseInfoBO;
import com.cgd.order.busi.bo.XbjSaleOrderInfoIntfceReqBO;
import com.cgd.order.busi.bo.XbjSaleOrderItemIntfceBO;
import com.cgd.order.busi.bo.XbjSaleOrderVerifyReqBO;
import com.cgd.order.busi.bo.XbjSaleOrderVerifyRspBO;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.OrderDistributionItemXbjMapper;
import com.cgd.order.dao.OrderDistributionXbjMapper;
import com.cgd.order.po.OrderDistributionItemXbjPO;
import com.cgd.order.po.OrderDistributionXbjPO;
import com.cgd.user.account.busi.CheckAccountFitUserBusiService;
import com.cgd.user.account.busi.QryAccountByIdBusiService;
import com.cgd.user.account.busi.QryEffActInfoByOrgBusiService;
import com.cgd.user.account.busi.bo.CheckAccountFitUserReqBO;
import com.cgd.user.account.busi.bo.CheckAccountFitUserRspBO;
import com.cgd.user.account.busi.bo.QryAccountByIdReqBO;
import com.cgd.user.account.busi.bo.QryAccountByIdRspBO;
import com.cgd.user.account.busi.bo.QryActInfoByOrgReq;
import com.cgd.user.account.busi.bo.QryActInfoByOrgRsp;
import com.cgd.user.userInfo.busi.SelectUserInfoByUserIdBusiService;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdReqBO;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class XbjSaleOrderVerifyBusiServiceImpl
implements XbjSaleOrderVerifyBusiService {
    private static final Logger log = Logger.getLogger(XbjSaleOrderVerifyBusiServiceImpl.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private CheckAccountFitUserBusiService checkAccountFitUserBusiService;
    @Autowired
    private QryEffActInfoByOrgBusiService qryEffActInfoByOrgBusiService;
    @Autowired
    private QueryDealNoticeBusiService queryDealNoticeBusiService;
    @Autowired
    private OrderDistributionXbjMapper orderDistributionXbjMapper;
    @Autowired
    private OrderDistributionItemXbjMapper orderDistributionItemXbjMapper;
    @Autowired
    private SelectUserInfoByUserIdBusiService selectUserInfoByUserIdBusiService;
    @Autowired
    private QryAccountByIdBusiService qryAccountByIdBusiService;

    public XbjSaleOrderVerifyRspBO dealXbjSaleOrderVerify(XbjSaleOrderVerifyReqBO xbjSaleOrderVerifyReqBO) {
        XbjSaleOrderVerifyRspBO resultBo = new XbjSaleOrderVerifyRspBO();
        this.verifyParamIn(xbjSaleOrderVerifyReqBO);
        List saleOrderInfoList = xbjSaleOrderVerifyReqBO.getSaleOrderInfoList();
        List<Object> parseToOrderInfo = new ArrayList();
        try {
            parseToOrderInfo = this.parseToOrderInfo(saleOrderInfoList, xbjSaleOrderVerifyReqBO);
        }
        catch (Exception e) {
            log.error((Object)"\u521d\u59cb\u5316\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\uff08\u4e00\u5355\u4e00\u91c7\uff09\u521d\u59cb\u5316\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38:" + e.getMessage());
        }
        resultBo.setXbjOrderSaleVerifyBaseInfoList(parseToOrderInfo);
        resultBo.setRespCode("0000");
        resultBo.setRespDesc("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u6821\u9a8c\u6210\u529f");
        return resultBo;
    }

    private List<XbjOrderSaleVerifyBaseInfoBO> parseToOrderInfo(List<XbjSaleOrderInfoIntfceReqBO> saleOrderInfoList, XbjSaleOrderVerifyReqBO xbjSaleOrderVerifyReqBO) throws Exception {
        ArrayList<XbjOrderSaleVerifyBaseInfoBO> resultBos = new ArrayList<XbjOrderSaleVerifyBaseInfoBO>();
        log.error((Object)("\u4e00\u5355\u4e00\u91c7\u4e0b\u5355\u5165\u53c2List\u503c\u4e3a===========\uff1a" + JSON.toJSONString(saleOrderInfoList)));
        for (XbjSaleOrderInfoIntfceReqBO bo : saleOrderInfoList) {
            XbjOrderSaleVerifyBaseInfoBO rBo = new XbjOrderSaleVerifyBaseInfoBO();
            XbjOrderDealNoticeItemReqBO itemBo = this.parseOrderDealNoticeItem(bo);
            rBo.setXbjOrderDealNoticeItem(itemBo);
            ArrayList aList = new ArrayList();
            rBo.setAgrAttach(aList);
            if (isDebugEnabled) {
                log.debug((Object)("\u7ec4\u88c5\u6210\u4ea4\u901a\u77e5\u4e66\u63a5\u53e3\u8fd4\u56de\u6570\u636e:" + itemBo.toString()));
            }
            XbjOrderSaleBusiReqBO xbjOrderSaleBusiReqBO = new XbjOrderSaleBusiReqBO();
            this.setOrderIntBoToOrderBusiBo(itemBo, xbjOrderSaleBusiReqBO, xbjSaleOrderVerifyReqBO, bo);
            ArrayList<XbjDetailInfoRspBO> dBos = new ArrayList<XbjDetailInfoRspBO>();
            List saleOrderItemList = bo.getSaleOrderItemList();
            Long purchaseFee = 0L;
            ArrayList<Integer> supplyCycleList = new ArrayList<Integer>();
            Date arriveTime = new Date(0L);
            log.error((Object)("\u4e00\u5355\u4e00\u91c7\u8ba2\u5355\u660e\u7ec6===Null===arriveTime=====\uff1a" + arriveTime.getTime()));
            for (XbjSaleOrderItemIntfceBO iBo : saleOrderItemList) {
                if (iBo == null) continue;
                XbjDetailInfoRspBO dBo = new XbjDetailInfoRspBO();
                this.setOrderItemProperty(iBo, dBo, itemBo, xbjSaleOrderVerifyReqBO, bo);
                BigDecimal fee = dBo.getPurchaseCount().multiply(MoneyUtil.Long2BigDecimal((Long)dBo.getPurchasingPrice()));
                purchaseFee = purchaseFee + MoneyUtil.BigDecimal2Long((BigDecimal)fee.setScale(2, 4));
                log.debug((Object)("\u4e00\u5355\u4e00\u91c7\u8ba2\u5355\u660e\u7ec6=====SupplyCycle====\uff1a" + iBo.getSupplyCycle()));
                if (iBo.getSupplyCycle() != null) {
                    supplyCycleList.add(iBo.getSupplyCycle());
                }
                log.debug((Object)("\u4e00\u5355\u4e00\u91c7\u8ba2\u5355\u660e\u7ec6=====PrenSendDate====\uff1a" + DateUtil.dateToStrLong((Date)iBo.getPreSendDate())));
                if (iBo.getPreSendDate() != null) {
                    if (arriveTime.getTime() == 0L) {
                        arriveTime.setTime(iBo.getPreSendDate().getTime());
                        log.debug((Object)("\u4e00\u5355\u4e00\u91c7\u8ba2\u5355\u660e\u7ec6===Null====PrenSendDate====\uff1a" + DateUtil.dateToStrLong((Date)iBo.getPreSendDate())));
                        log.debug((Object)("\u4e00\u5355\u4e00\u91c7\u8ba2\u5355\u660e\u7ec6===Null===arriveTime=====\uff1a" + DateUtil.dateToStrLong((Date)arriveTime)));
                    } else if (arriveTime.getTime() > iBo.getPreSendDate().getTime()) {
                        arriveTime.setTime(iBo.getPreSendDate().getTime());
                        arriveTime.setTime(iBo.getPreSendDate().getTime());
                        log.debug((Object)("\u4e00\u5355\u4e00\u91c7\u8ba2\u5355\u660e\u7ec6====Not===PrenSendDate====\uff1a" + DateUtil.dateToStrLong((Date)iBo.getPreSendDate())));
                        log.debug((Object)("\u4e00\u5355\u4e00\u91c7\u8ba2\u5355\u660e\u7ec6====Not==arriveTime=====\uff1a" + DateUtil.dateToStrLong((Date)arriveTime)));
                    }
                }
                log.debug((Object)("\u4e00\u5355\u4e00\u91c7\u8ba2\u5355\u660e\u7ec6===\u6700\u540e===arriveTime=====\uff1a" + DateUtil.dateToStrLong((Date)arriveTime)));
                dBos.add(dBo);
            }
            xbjOrderSaleBusiReqBO.setSaleOrderMoney(purchaseFee);
            rBo.setOrderSaleBusiReq(xbjOrderSaleBusiReqBO);
            if (arriveTime.getTime() != 0L) {
                log.error((Object)("\u4e00\u5355\u4e00\u91c7\u8ba2\u5355\u660e\u7ec6===set===PrenSendDate=====\uff1a" + DateUtil.dateToStrLong((Date)arriveTime)));
                xbjOrderSaleBusiReqBO.setArriveTime(DateUtil.dateToStr((Date)arriveTime));
                xbjOrderSaleBusiReqBO.setArriveType("1");
            } else if (!CollectionUtils.isEmpty(supplyCycleList)) {
                log.error((Object)("\u4e00\u5355\u4e00\u91c7\u8ba2\u5355\u660e\u7ec6===set===SupplyCycle=====\uff1a" + Collections.min(supplyCycleList)));
                xbjOrderSaleBusiReqBO.setArriveTime(Collections.min(supplyCycleList) + "");
                xbjOrderSaleBusiReqBO.setArriveType("2");
            }
            rBo.setDetailInfoList(dBos);
            resultBos.add(rBo);
        }
        log.error((Object)("\u6821\u9a8c\u8fd4\u56de\u53c2\u6570\u7ed3\u679cCCCCCCCCCCCCCC\uff1a" + JSON.toJSONString(resultBos)));
        return resultBos;
    }

    private void setOrderItemProperty(XbjSaleOrderItemIntfceBO ibo, XbjDetailInfoRspBO dbo, XbjOrderDealNoticeItemReqBO itemBo, XbjSaleOrderVerifyReqBO bo, XbjSaleOrderInfoIntfceReqBO bo1) throws Exception {
        dbo.setPurchaserId(bo1.getOrgId());
        if (itemBo.getPurchaserAccountId() != null) {
            dbo.setPurchaserAccountId(Long.valueOf(itemBo.getPurchaserAccountId()));
        }
        dbo.setPurchaserAccountName(itemBo.getPurchaserAccountName());
        dbo.setGoodsSupplierId(itemBo.getGoodsSupplierId());
        dbo.setProfessionalOrganizationId(itemBo.getProfessionalOrganizationId());
        dbo.setMaterialId(ibo.getMaterialId());
        dbo.setMaterialCode(ibo.getMaterialCode());
        dbo.setMaterialName(ibo.getMaterialName());
        dbo.setMaterialClassId(ibo.getMaterialClassId());
        dbo.setModel(ibo.getModel());
        dbo.setSpecifications(ibo.getSpecifications());
        dbo.setFigureNo(ibo.getFigureNo());
        dbo.setMaterialQuality(ibo.getMaterialQuality());
        log.error((Object)("\u6821\u9a8c\u6253\u5370brandId========" + ibo.getBrandId()));
        if (ibo.getBrandId() != null && !"".equals(ibo.getBrandId())) {
            dbo.setBrandId(ibo.getBrandId() + "");
        }
        dbo.setBrandName(ibo.getBrand());
        dbo.setManufacturer(ibo.getManufacturer());
        if (ibo.getProjectId() != null && !"".equals(ibo.getProjectId())) {
            dbo.setProjectId(ibo.getProjectId() + "");
        }
        if (ibo.getProjectCode() != null && !"".equals(ibo.getProjectCode())) {
            dbo.setProjectCode(ibo.getProjectCode() + "");
        }
        dbo.setProjectName(ibo.getProjectName());
        dbo.setProjectContent(ibo.getContentDescription());
        if (ibo.getPurchasingPrice() != null) {
            dbo.setPurchasingPrice(MoneyUtil.BigDecimal2Long((BigDecimal)ibo.getPurchasingPrice()));
        }
        if (ibo.getSalePrice() != null) {
            dbo.setSellingPrice(MoneyUtil.BigDecimal2Long((BigDecimal)ibo.getPurchasingPrice()));
        } else {
            dbo.setSellingPrice(MoneyUtil.BigDecimal2Long((BigDecimal)ibo.getSalePrice()));
        }
        if (ibo.getPurchaseCount() != null) {
            dbo.setPurchaseCount(ibo.getPurchaseCount());
        }
        dbo.setUnitName(ibo.getUnitName());
        dbo.setTotal(Long.valueOf((long)dbo.getPurchaseCount().toBigInteger().intValue() * dbo.getPurchasingPrice()));
        dbo.setSkuCurrencyType(itemBo.getCurrencyType());
        dbo.setUsedCompany(ibo.getUsedCompany());
        dbo.setPreSendDate(ibo.getPreSendDate());
        dbo.setRecvAddr(ibo.getRecvAddr());
        dbo.setPlanId(ibo.getPlanId());
        dbo.setPlanDetailId(ibo.getPlanDetailId());
        dbo.setPlanUserId(ibo.getPlanUserId());
        dbo.setPlanCode(ibo.getPlanCode());
    }

    private void setOrderIntBoToOrderBusiBo(XbjOrderDealNoticeItemReqBO bo2, XbjOrderSaleBusiReqBO bo1, XbjSaleOrderVerifyReqBO xbjSaleOrderVerifyReqBO, XbjSaleOrderInfoIntfceReqBO bo) throws Exception {
        OrderDistributionXbjPO orderDistributionXbjPO;
        bo1.setUserId(xbjSaleOrderVerifyReqBO.getUserId());
        bo1.setUserName(xbjSaleOrderVerifyReqBO.getUserName());
        bo1.setIsDispatch(bo2.getIsDispatch());
        bo1.setSaleOrderType(XbjOrderConstants.SALE_ORDER_TYPE_XBJ);
        bo1.setSaleOrderStatus(XbjOrderConstants.SALE_ORDER_STATUS_XBJ_START);
        bo1.setSaleOrderName(bo2.getDealNoticeName());
        bo1.setPlaAgreementCode(bo2.getDealNoticeCode());
        bo1.setNeedContactName(bo.getNeedContactName());
        if (!CollectionUtils.isEmpty((Collection)bo.getSaleOrderItemList())) {
            bo1.setNeedContactMobile(((XbjSaleOrderItemIntfceBO)bo.getSaleOrderItemList().get(0)).getReceiverMobile());
            bo1.setPurchaserMobile(((XbjSaleOrderItemIntfceBO)bo.getSaleOrderItemList().get(0)).getReceiverMobile());
        }
        bo1.setPurchaserName(bo.getPurchaserName());
        bo1.setPurchaserId(bo.getOrgId());
        bo1.setPurchaserAccount(bo.getPurchaserAccount());
        bo1.setPurchaserAccountOrgId(bo.getPurchaserAccountOrgId());
        if (bo2.getPurchaserAccountId() != null) {
            bo1.setPurchaserAccountId(Long.valueOf(bo2.getPurchaserAccountId()));
        }
        bo1.setPurchaserAccountName(bo2.getPurchaserAccountName());
        bo1.setReceiverName(bo.getReceiverName());
        bo1.setReceiverMobile(bo.getReceiverMobile());
        if (this.qryEffActInfoByOrgBusiService != null) {
            ProAccountInfoBO initProfreesionnalAccount = this.initProfreesionnalAccount(bo2.getProfessionalOrganizationId());
            bo1.setProfessionalAccount(initProfreesionnalAccount.getAccountId());
            bo1.setProfessionalMobile(initProfreesionnalAccount.getTelephone());
        } else {
            bo1.setProfessionalAccount(Long.valueOf(0L));
        }
        QryAccountByIdReqBO AccountCondition = new QryAccountByIdReqBO();
        AccountCondition.setAccountId(Long.valueOf(bo.getPurchaserAccount()));
        QryAccountByIdRspBO qryAccountByIdRspBO = this.qryAccountByIdBusiService.qryAccountById(AccountCondition);
        if (qryAccountByIdRspBO == null) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u8d26\u5957\u4fe1\u606f PurchaseAccount" + bo2.getPurchaserAccount());
        }
        bo1.setProfessionalOrganizationId(qryAccountByIdRspBO.getAccountInfoBO().getDeliveryCenterId());
        bo1.setProfessionalOrganizationName(qryAccountByIdRspBO.getAccountInfoBO().getDeliveryCenterName());
        log.error((Object)("\u7ec4\u88c5\u6210\u4ea4\u901a\u77e5\u4e66\u63a5\u53e3\u8fd4\u56de\u6570\u636e==================bo2.getSupplyCycle():" + bo2.getSupplyCycle()));
        bo1.setSupplyCycle(bo2.getSupplyCycle());
        bo1.setProfessionalName(bo2.getProfessionalName());
        bo1.setGoodsSupplierId(bo2.getGoodsSupplierId());
        bo1.setGoodsSupplierName(bo2.getGoodsSupplierName());
        bo1.setGoodsSupplierRelaman(bo2.getGoodsSupplierRelaName());
        bo1.setGoodsSupplierMobile(bo2.getGoodsSupplierMobile());
        bo1.setTaxRate(bo2.getTaxRate());
        bo1.setPayType(bo.getPayType());
        bo1.setPayMode(bo2.getPay());
        bo1.setGiveTime(bo.getGiveTime());
        bo1.setMatPaySup(bo2.getMatPaySup());
        bo1.setProPaySup(bo2.getProPaySup());
        bo1.setVerPaySup(bo2.getVerPaySup());
        bo1.setPilPaySup(bo2.getPilPaySup());
        bo1.setQuaPaySup(bo2.getQuaPaySup());
        bo1.setPrePaySup(bo2.getPrePaySup());
        bo1.setOrderType(bo2.getOrderType());
        bo1.setSaleOrderPurchaseType(bo2.getPurchaseType());
        OrderDistributionXbjPO condition = new OrderDistributionXbjPO();
        condition.setProfessionalOrganizationId(qryAccountByIdRspBO.getAccountInfoBO().getDeliveryCenterId());
        condition.setApplyOrderType("purchase");
        condition.setSaleOrderType(XbjOrderConstants.SALE_ORDER_TYPE_XBJ.toString());
        if (isDebugEnabled) {
            log.debug((Object)("\u6839\u636e\u4e13\u4e1a\u673a\u6784\u67e5\u8be2\u5206\u914d\u89c4\u5219\uff1a" + JSON.toJSONString((Object)condition)));
        }
        if ((orderDistributionXbjPO = this.orderDistributionXbjMapper.getModelBy(condition)) != null) {
            if (isDebugEnabled) {
                log.debug((Object)("\u6839\u636e\u4e13\u4e1a\u673a\u6784\u67e5\u8be2\u5206\u914d\u89c4\u5219\u6709\u503c\uff1a" + JSON.toJSONString((Object)condition)));
            }
            if (orderDistributionXbjPO.getRuleType().equals("1")) {
                OrderDistributionItemXbjPO PO;
                OrderDistributionItemXbjPO itemCondition = new OrderDistributionItemXbjPO();
                itemCondition.setDistributionRuleId(orderDistributionXbjPO.getDistributionRuleId());
                itemCondition.setBusiScope(bo.getOrgId());
                if (isDebugEnabled) {
                    log.debug((Object)("\u9879\u76ee\u5355\u4f4d\u67e5\u8be2\u89c4\u5219\u660e\u7ec6\uff1a" + JSON.toJSONString((Object)itemCondition)));
                }
                if ((PO = this.orderDistributionItemXbjMapper.getModelBy(itemCondition)) != null) {
                    if (isDebugEnabled) {
                        log.debug((Object)("\u9879\u76ee\u5355\u4f4d\u67e5\u8be2\u89c4\u5219\u660e\u7ec6\u6709\u503c\uff1a" + JSON.toJSONString((Object)itemCondition)));
                    }
                    log.error((Object)("\u81ea\u52a8\u5206\u914d\u5224\u65ad\u7ed3\u679c1\uff1a" + this.checkDeliveryIdStatus(PO.getDeliveryId())));
                    if (this.checkDeliveryIdStatus(PO.getDeliveryId())) {
                        bo1.setDeliveryId(PO.getDeliveryId());
                        bo1.setDeliveryName(this.getUserName(PO.getDeliveryId()));
                    }
                }
            } else if (orderDistributionXbjPO.getRuleType().equals("2")) {
                OrderDistributionItemXbjPO PO;
                OrderDistributionItemXbjPO itemCondition = new OrderDistributionItemXbjPO();
                itemCondition.setDistributionRuleId(orderDistributionXbjPO.getDistributionRuleId());
                itemCondition.setBusiScope(bo2.getCreateLoginId());
                if (isDebugEnabled) {
                    log.debug((Object)("\u91c7\u8d2d\u4e13\u8d23\u67e5\u8be2\u89c4\u5219\u660e\u7ec6\uff1a" + JSON.toJSONString((Object)itemCondition)));
                }
                if ((PO = this.orderDistributionItemXbjMapper.getModelBy(itemCondition)) != null) {
                    if (isDebugEnabled) {
                        log.debug((Object)("\u91c7\u8d2d\u4e13\u8d23\u67e5\u8be2\u89c4\u5219\u660e\u7ec6\u6709\u503c\uff1a" + JSON.toJSONString((Object)itemCondition)));
                    }
                    log.error((Object)("\u81ea\u52a8\u5206\u914d\u5224\u65ad\u7ed3\u679c2\uff1a" + this.checkDeliveryIdStatus(PO.getDeliveryId())));
                    if (this.checkDeliveryIdStatus(PO.getDeliveryId())) {
                        bo1.setDeliveryId(PO.getDeliveryId());
                        bo1.setDeliveryName(this.getUserName(PO.getDeliveryId()));
                    }
                }
            }
        }
    }

    private String getUserName(Long operId) {
        SelectUserInfoByUserIdReqBO selectUserInfoReqBO = new SelectUserInfoByUserIdReqBO();
        selectUserInfoReqBO.setUserId(operId);
        SelectUserInfoByUserIdRspBO userRsp = this.selectUserInfoByUserIdBusiService.selectUserInfoByUserId(selectUserInfoReqBO);
        if (userRsp != null) {
            return userRsp.getName();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ProAccountInfoBO initProfreesionnalAccount(Long professionalOrganizationId) {
        ProAccountInfoBO accountInfo = new ProAccountInfoBO();
        try {
            QryActInfoByOrgRsp qryActInfoByOrgRsp;
            if (null == professionalOrganizationId) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u4e13\u4e1a\u673a\u6784\u8d26\u5957\u67e5\u8be2\uff0c\u5165\u53c2\u4e13\u4e1a\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            QryActInfoByOrgReq qryActInfoByOrgReq = new QryActInfoByOrgReq();
            qryActInfoByOrgReq.setParamOrgId(professionalOrganizationId);
            if (isDebugEnabled) {
                log.debug((Object)("\u4e13\u4e1a\u673a\u6784\u8d26\u5957\u67e5\u8be2\u5165\u53c2:" + professionalOrganizationId));
            }
            if (null == (qryActInfoByOrgRsp = this.qryEffActInfoByOrgBusiService.qryEffActInfoByOrg(qryActInfoByOrgReq))) {
                if (!isDebugEnabled) throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u4e13\u4e1a\u673a\u6784\u8d26\u5957\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
                log.debug((Object)"\u4e13\u4e1a\u673a\u6784\u8d26\u5957\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u4e13\u4e1a\u673a\u6784\u8d26\u5957\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            }
            if (isDebugEnabled) {
                log.debug((Object)("\u4e13\u4e1a\u673a\u6784\u8d26\u5957\u67e5\u8be2\u51fa\u53c2:" + qryActInfoByOrgRsp.toString()));
            }
            if (!qryActInfoByOrgRsp.getRespCode().equals("0000")) {
                if (!isDebugEnabled) throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u4e13\u4e1a\u673a\u6784\u8d26\u5957\u67e5\u8be2\u7ed3\u679c\u5f02\u5e38\uff01" + qryActInfoByOrgRsp.getRespDesc());
                log.debug((Object)("\u4e13\u4e1a\u673a\u6784\u8d26\u5957\u67e5\u8be2\u7ed3\u679c\u5f02\u5e38\uff01" + qryActInfoByOrgRsp.getRespDesc()));
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u4e13\u4e1a\u673a\u6784\u8d26\u5957\u67e5\u8be2\u7ed3\u679c\u5f02\u5e38\uff01" + qryActInfoByOrgRsp.getRespDesc());
            }
            List accountInfoBOs = qryActInfoByOrgRsp.getAccountInfoBOs();
            if (null != accountInfoBOs && accountInfoBOs.size() == 1) {
                BeanUtils.copyProperties(accountInfoBOs.get(0), (Object)accountInfo);
                return accountInfo;
            }
            if (!isDebugEnabled) throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u4e13\u4e1a\u673a\u6784\u8d26\u5957\u67e5\u8be2,\u8d26\u5957\u4fe1\u606f\u4e3a\u7a7a\u6216\u4e0d\u662f\u4e00\u6761\uff01");
            log.debug((Object)"\u4e13\u4e1a\u673a\u6784\u8d26\u5957\u67e5\u8be2,\u8d26\u5957\u4fe1\u606f\u4e3a\u7a7a\u6216\u4e0d\u662f\u4e00\u6761\uff01");
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u4e13\u4e1a\u673a\u6784\u8d26\u5957\u67e5\u8be2,\u8d26\u5957\u4fe1\u606f\u4e3a\u7a7a\u6216\u4e0d\u662f\u4e00\u6761\uff01");
        }
        catch (Exception e) {
            if (!isDebugEnabled) throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u4e13\u4e1a\u673a\u6784\u8d26\u5957\u67e5\u8be2\u5f02\u5e38:" + e.getMessage());
            log.debug((Object)("\u4e13\u4e1a\u673a\u6784\u8d26\u5957\u67e5\u8be2\u5f02\u5e38:" + e.getMessage()));
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u4e13\u4e1a\u673a\u6784\u8d26\u5957\u67e5\u8be2\u5f02\u5e38:" + e.getMessage());
        }
    }

    private XbjOrderDealNoticeItemReqBO parseOrderDealNoticeItem(XbjSaleOrderInfoIntfceReqBO bo) {
        XbjOrderDealNoticeItemReqBO parseObject = new XbjOrderDealNoticeItemReqBO();
        QuerySingleDealNoticeDetailInfoReqBO bo1 = new QuerySingleDealNoticeDetailInfoReqBO();
        BeanUtils.copyProperties((Object)bo, (Object)bo1);
        QuerySingleDealNoticeDetailInfoRspBO querySingleDealNoticeDetailInfo = this.queryDealNoticeBusiService.querySingleDealNoticeDetailInfo(bo1);
        log.error((Object)("\u8be2\u6bd4\u4ef7\u4e0b\u5355\uff08\u4e00\u5355\u4e00\u91c7\uff09\u9a8c\u8bc1\u6210\u4ea4\u901a\u77e5\u4e66\u8fd4\u56de\u6570\u636e" + JSON.toJSONString((Object)querySingleDealNoticeDetailInfo)));
        log.error((Object)("\u8be2\u6bd4\u4ef7\u4e0b\u5355\uff08\u4e00\u5355\u4e00\u91c7\uff09\u9a8c\u8bc1\u6210\u4ea4\u901a\u77e5\u4e66\u8fd4\u56de\u6570\u636e" + DateUtil.dateToStrLong((Date)querySingleDealNoticeDetailInfo.getPromiseDeliveryDate())));
        this.validateReturnObject(querySingleDealNoticeDetailInfo);
        BeanUtils.copyProperties((Object)querySingleDealNoticeDetailInfo, (Object)parseObject);
        return parseObject;
    }

    private void validateReturnObject(QuerySingleDealNoticeDetailInfoRspBO querySingleDealNoticeDetailInfo) {
        log.info((Object)"-----------------------------------------------------------------\u8be2\u6bd4\u4ef7\u4e0b\u5355\uff08\u4e00\u5355\u4e00\u91c7\uff09\u9a8c\u8bc1\u6210\u4ea4\u901a\u77e5\u4e66\u8fd4\u56de\u6570\u636e------------------------------------------------------------------------");
        if (querySingleDealNoticeDetailInfo == null) {
            log.error((Object)"\u8be2\u6bd4\u4ef7\u4e0b\u5355\uff08\u4e00\u5355\u4e00\u91c7\uff09\u9a8c\u8bc1\u6210\u4ea4\u901a\u77e5\u4e66\u8fd4\u56de\u6570\u636e\u51fa\u9519\uff1a\u51fa\u53c2\u4e3a\u7a7a");
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u4e0b\u5355\uff08\u4e00\u5355\u4e00\u91c7\uff09\u9a8c\u8bc1\u6210\u4ea4\u901a\u77e5\u4e66\u8fd4\u56de\u6570\u636e\u51fa\u9519\uff1a\u51fa\u53c2\u4e3a\u7a7a");
        }
    }

    private void verifyPurchaseCount(XbjSaleOrderVerifyReqBO xbjSaleOrderVerifyReqBO) {
        block10: {
            if (this.checkAccountFitUserBusiService == null) {
                return;
            }
            try {
                CheckAccountFitUserReqBO checkAccountFitUserReqBO = new CheckAccountFitUserReqBO();
                checkAccountFitUserReqBO.setParamUserId(xbjSaleOrderVerifyReqBO.getUserId());
                log.debug((Object)("\u91c7\u8d2d\u8d26\u5957\u6821\u9a8c\u5165\u53c2:\u7528\u6237ID:" + checkAccountFitUserReqBO.getParamUserId() + "\u8d26\u5957ID:" + checkAccountFitUserReqBO.getAccountId()));
                CheckAccountFitUserRspBO checkAccountFitUserRspBO = this.checkAccountFitUserBusiService.checkAccountFitUser(checkAccountFitUserReqBO);
                if (null != checkAccountFitUserRspBO) {
                    log.debug((Object)("\u91c7\u8d2d\u8d26\u5957\u6821\u9a8c\u51fa\u53c2:" + checkAccountFitUserRspBO.getFit()));
                    if (checkAccountFitUserRspBO.getRespCode().equals("0000")) {
                        if (!checkAccountFitUserRspBO.getFit().booleanValue()) {
                            if (isDebugEnabled) {
                                log.debug((Object)("\u91c7\u8d2d\u8d26\u5957\u6821\u9a8c,\u6b64\u8d26\u5957:\u7528\u6237Id[" + checkAccountFitUserReqBO.getParamUserId() + "],\u8d26\u5957ID[" + checkAccountFitUserReqBO.getAccountId() + "]\u4e0d\u53ef\u7528\uff01"));
                            }
                            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u91c7\u8d2d\u8d26\u5957\u6821\u9a8c,\u6b64\u8d26\u5957:\u7528\u6237Id[" + checkAccountFitUserReqBO.getParamUserId() + "],\u8d26\u5957ID[" + checkAccountFitUserReqBO.getAccountId() + "]\u4e0d\u53ef\u7528\uff01");
                        }
                        break block10;
                    }
                    if (isDebugEnabled) {
                        log.debug((Object)("\u91c7\u8d2d\u8d26\u5957\u67e5\u8be2\u7ed3\u679c\u5f02\u5e38\uff01" + checkAccountFitUserRspBO.getRespDesc()));
                    }
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u91c7\u8d2d\u8d26\u5957\u67e5\u8be2\u7ed3\u679c\u5f02\u5e38\uff01" + checkAccountFitUserRspBO.getRespDesc());
                }
                if (isDebugEnabled) {
                    log.debug((Object)"\u91c7\u8d2d\u8d26\u5957\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
                }
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u91c7\u8d2d\u8d26\u5957\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            }
            catch (Exception e) {
                if (isDebugEnabled) {
                    log.debug((Object)("\u91c7\u8d2d\u8d26\u5957\u6821\u9a8c\u5f02\u5e38:" + e));
                }
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u91c7\u8d2d\u8d26\u5957\u6821\u9a8c\u5f02\u5e38:" + e.getMessage());
            }
        }
    }

    private void verifyTotalFee(XbjSaleOrderVerifyReqBO XbjSaleOrderVerifyReqBO2) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        List saleOrderInfoList = XbjSaleOrderVerifyReqBO2.getSaleOrderInfoList();
        BigDecimal totalAmountCount = BigDecimal.ZERO;
        for (XbjSaleOrderInfoIntfceReqBO bo : saleOrderInfoList) {
            List saleOrderItemList = bo.getSaleOrderItemList();
            for (XbjSaleOrderItemIntfceBO iBo : saleOrderItemList) {
                totalAmountCount = totalAmountCount.add(iBo.getPurchaseCount().multiply(iBo.getPurchasingPrice()));
            }
        }
        if (totalAmountCount.compareTo(totalAmount) != 0) {
            log.info((Object)("\u8be2\u6bd4\u4ef7\u5165\u53c2\u603b\u4ef7\u8ba1\u7b97\u6709\u8bef\uff01\u53c2\u8003\u8ba1\u7b97\u4ef7\u683c:[" + totalAmountCount + "]"));
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1\u670d\u52a1,\u5165\u53c2\u603b\u4ef7\u8ba1\u7b97\u6709\u8bef!\u53c2\u8003\u8ba1\u7b97\u4ef7\u683c:[" + totalAmountCount + "]");
        }
    }

    private void verifyParamIn(XbjSaleOrderVerifyReqBO xbjSaleOrderVerifyReqBO) {
        if (null == xbjSaleOrderVerifyReqBO) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (xbjSaleOrderVerifyReqBO.getSaleOrderInfoList() == null || xbjSaleOrderVerifyReqBO.getSaleOrderInfoList().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:SaleOrderInfoList\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List saleOrderInfoList = xbjSaleOrderVerifyReqBO.getSaleOrderInfoList();
        if (saleOrderInfoList == null || saleOrderInfoList.isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:saleOrderInfoList\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (XbjSaleOrderInfoIntfceReqBO bo : saleOrderInfoList) {
            if (bo == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:saleOrderInfoList\u4e2d\u7684bo\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            Integer saleOrderPurchaseType = bo.getSaleOrderPurchaseType();
            if (saleOrderPurchaseType == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:saleOrderInfoList\u4e2d\u7684bo\u7684saleOrderPurchaseType\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (bo.getDealNoticeId() == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:saleOrderInfoList\u4e2d\u7684bo\u7684DealNoticeId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (bo.getDealNoticeCode() == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:saleOrderInfoList\u4e2d\u7684bo\u7684DealNoticeCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (bo.getPurchaserId() == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:saleOrderInfoList\u4e2d\u7684bo\u7684PurchaserId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (bo.getPurchaserName() == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:saleOrderInfoList\u4e2d\u7684bo\u7684PurchaserName\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            List saleOrderItemList = bo.getSaleOrderItemList();
            if (saleOrderItemList == null || saleOrderItemList.isEmpty()) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:saleOrderInfoList\u4e2d\u7684bo\u7684saleOrderItemList\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            for (XbjSaleOrderItemIntfceBO iBo : saleOrderItemList) {
                if (iBo == null) {
                    throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:saleOrderInfoList\u4e2d\u7684bo\u7684saleOrderItemList\u4e2d\u7684bo\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (iBo.getPurchaseCount() == null || iBo.getPurchaseCount().compareTo(new BigDecimal(0)) <= 0) {
                    throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:saleOrderInfoList\u4e2d\u7684bo\u7684saleOrderItemList\u4e2d\u7684bo\u7684PurchaseCount\u5fc5\u987b\u4e0d\u4e3a\u7a7a\u4e14\u5927\u4e8e0\uff01");
                }
                if (iBo.getPurchasingPrice() == null || iBo.getPurchasingPrice().compareTo(new BigDecimal(0)) <= 0) {
                    iBo.setPurchasingPrice(BigDecimal.ZERO);
                }
                if (iBo.getSalePrice() == null || iBo.getSalePrice().compareTo(new BigDecimal(0)) <= 0) {
                    iBo.setSalePrice(new BigDecimal(0));
                }
                if (iBo.getRecvAddr() == null || iBo.getRecvAddr().trim().isEmpty()) {
                    throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:saleOrderInfoList\u4e2d\u7684bo\u7684saleOrderItemList\u4e2d\u7684bo\u7684RecvAddr\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (iBo.getPreSendDate() == null && iBo.getSupplyCycle() == null) {
                    throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:saleOrderInfoList\u4e2d\u7684bo\u7684saleOrderItemList\u4e2d\u7684bo\u7684PreSendDate\u548csupplyCycle\u4e0d\u80fd\u90fd\u4e3a\u7a7a\uff01");
                }
                if (saleOrderPurchaseType == XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_WUZI) {
                    if (iBo.getMaterialClassId() == null) {
                        throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u4e0b\u5355\uff08\u4e00\u5355\u4e00\u91c7\uff09\u7ec4\u5408\u4e1a\u52a1:saleOrderInfoList\u4e2d\u7684bo\u7684saleOrderItemList\u4e2d\u7684bo\u7684MaterialClassId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (iBo.getMaterialName() == null) {
                        throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:saleOrderInfoList\u4e2d\u7684bo\u7684saleOrderItemList\u4e2d\u7684bo\u7684MaterialName\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (iBo.getFigureNo() == null) {
                        if (iBo.getModel() == null) {
                            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:saleOrderInfoList\u4e2d\u7684bo\u7684saleOrderItemList\u4e2d\u7684bo\u7684Model\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        }
                        if (iBo.getSpecifications() == null) {
                            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:saleOrderInfoList\u4e2d\u7684bo\u7684saleOrderItemList\u4e2d\u7684bo\u7684Specifications\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        }
                    }
                    if (iBo.getMaterialQuality() == null) {
                        throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:saleOrderInfoList\u4e2d\u7684bo\u7684saleOrderItemList\u4e2d\u7684bo\u7684MaterialQuality\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (iBo.getBrand() == null) {
                        throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:saleOrderInfoList\u4e2d\u7684bo\u7684saleOrderItemList\u4e2d\u7684bo\u7684Brand\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    if (iBo.getManufacturer() != null) continue;
                    throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:saleOrderInfoList\u4e2d\u7684bo\u7684saleOrderItemList\u4e2d\u7684bo\u7684Manufacturer\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (saleOrderPurchaseType != XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_SHIGONG && saleOrderPurchaseType != XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_FUWU || saleOrderPurchaseType != XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_FUWU || iBo.getContentDescription() != null) continue;
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u4e0b\u5355\u6821\u9a8c\u4e1a\u52a1:saleOrderInfoList\u4e2d\u7684bo\u7684saleOrderItemList\u4e2d\u7684bo\u7684ContentDescription\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
    }

    private boolean checkDeliveryIdStatus(Long userId) {
        SelectUserInfoByUserIdReqBO selectUserInfoReqBO = new SelectUserInfoByUserIdReqBO();
        selectUserInfoReqBO.setUserId(userId);
        SelectUserInfoByUserIdRspBO userRsp = this.selectUserInfoByUserIdBusiService.selectUserInfoByUserId(selectUserInfoReqBO);
        if (userRsp != null) {
            log.error((Object)("\u5224\u65ad\u7528\u6237\u662f\u5426\u6709\u6548\u8fd4\u56de\u503c\uff1a" + JSON.toJSONString((Object)userRsp)));
            return userRsp.getDelFlag() == XbjOrderConstants.USER_DIS_FLAG;
        }
        return false;
    }
}

