/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.CreateAgreementAttachXbjAtomService;
import com.cgd.order.atom.bo.EaOrderProtocolItemAtomXbjRspBO;
import com.cgd.order.atom.bo.OrderProtocolItemAtomXbjReqBO;
import com.cgd.order.busi.bo.XbjAgreementAttachReqBO;
import com.cgd.order.dao.AgreementAttachXbjMapper;
import com.cgd.order.dao.OrderProtocolItemXbjMapper;
import com.cgd.order.po.AgreementAttachXbjPO;
import com.cgd.order.po.OrderProtocolItemXbjPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class CreateAgreementAttachXbjAtomServiceImpl
implements CreateAgreementAttachXbjAtomService {
    private static final Logger log = LoggerFactory.getLogger(CreateAgreementAttachXbjAtomServiceImpl.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private OrderProtocolItemXbjMapper orderProtocolItemXbjMapper;
    private AgreementAttachXbjMapper agreementAttachXbjMapper;

    public void setOrderProtocolItemXbjMapper(OrderProtocolItemXbjMapper orderProtocolItemXbjMapper) {
        this.orderProtocolItemXbjMapper = orderProtocolItemXbjMapper;
    }

    public void setAgreementAttachXbjMapper(AgreementAttachXbjMapper agreementAttachXbjMapper) {
        this.agreementAttachXbjMapper = agreementAttachXbjMapper;
    }

    @Override
    public void createAgreementAttachAtomService(OrderProtocolItemAtomXbjReqBO eaOrderProtocolItemAtom) {
        if (isDebugEnabled) {
            log.debug("\u534f\u8bae\u660e\u7ec6\u548c\u534f\u8bae\u9644\u4ef6\u5165\u53c2\uff1a" + eaOrderProtocolItemAtom);
        }
        try {
            OrderProtocolItemXbjPO orderProtocolItem = new OrderProtocolItemXbjPO();
            BeanUtils.copyProperties((Object)eaOrderProtocolItemAtom, (Object)orderProtocolItem);
            orderProtocolItem.setProfessionalOrganizationId(eaOrderProtocolItemAtom.getProfessionalOrganizationId());
            orderProtocolItem.setEffDate(eaOrderProtocolItemAtom.getEffDate());
            orderProtocolItem.setExpDate(eaOrderProtocolItemAtom.getExpDate());
            orderProtocolItem.setSignTime(eaOrderProtocolItemAtom.getSignTime());
            orderProtocolItem.setProduceTime(eaOrderProtocolItemAtom.getProduceTime());
            orderProtocolItem.setUpdateTime(eaOrderProtocolItemAtom.getUpdateTime());
            orderProtocolItem.setCreateTime(new Date());
            orderProtocolItem.setScopeType(eaOrderProtocolItemAtom.getScopeType().byteValue());
            this.orderProtocolItemXbjMapper.insertSelective(orderProtocolItem);
            List<XbjAgreementAttachReqBO> eaAgreementAttachList = eaOrderProtocolItemAtom.getXbjAgreementAttachList();
            if (null != eaAgreementAttachList && !eaAgreementAttachList.isEmpty()) {
                ArrayList<AgreementAttachXbjPO> agreementAttachList = new ArrayList<AgreementAttachXbjPO>(eaAgreementAttachList.size());
                for (int i = 0; i < eaAgreementAttachList.size(); ++i) {
                    AgreementAttachXbjPO agreementAttach = new AgreementAttachXbjPO();
                    BeanUtils.copyProperties((Object)eaAgreementAttachList.get(i), (Object)agreementAttach);
                    agreementAttach.setCreateTime(new Date());
                    agreementAttach.setUpdateTime(eaAgreementAttachList.get(i).getUpdateTime());
                    agreementAttach.setProtocolItemId(orderProtocolItem.getProtocolItemId());
                    agreementAttach.setPurchaserId(orderProtocolItem.getPurchaserId());
                    agreementAttach.setPurchaserAccountId(orderProtocolItem.getPurchaserAccountId());
                    agreementAttach.setPurchaserAccountName(orderProtocolItem.getPurchaserAccountName());
                    agreementAttach.setProfessionalOrganizationId(eaOrderProtocolItemAtom.getProfessionalOrganizationId());
                    agreementAttach.setGoodsSupplierId(eaOrderProtocolItemAtom.getGoodsSupplierId());
                    agreementAttach.setSaleOrderId(orderProtocolItem.getSaleOrderId());
                    agreementAttach.setSupplierId(orderProtocolItem.getSupplierId());
                    agreementAttach.setAgreementId(orderProtocolItem.getAgreementId());
                    agreementAttach.setCreateLoginId(orderProtocolItem.getCreateLoginId());
                    agreementAttach.setUpdateLoginId(orderProtocolItem.getUpdateLoginId());
                    agreementAttachList.add(agreementAttach);
                }
                this.agreementAttachXbjMapper.insertSelectiveBatch(agreementAttachList);
            }
        }
        catch (Exception e) {
            if (isDebugEnabled) {
                log.debug("\u534f\u8bae\u660e\u7ec6\u548c\u534f\u8bae\u9644\u4ef6\u5165\u53c2:", (Throwable)e);
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u534f\u8bae\u660e\u7ec6\u548c\u534f\u8bae\u9644\u4ef6\u539f\u5b50\u670d\u52a1\u751f\u6210\u5f02\u5e38\uff01");
        }
    }

    @Override
    public EaOrderProtocolItemAtomXbjRspBO queryByorderIdAndPurchaseId(Long saleOrderId, Long purchaseId) {
        EaOrderProtocolItemAtomXbjRspBO eaOrderProtocolItemAtomRsp = new EaOrderProtocolItemAtomXbjRspBO();
        try {
            Object orderProtocolItem = null;
            if (null == orderProtocolItem) {
                if (isDebugEnabled) {
                    log.debug("\u6839\u636e[" + saleOrderId + "]\u534f\u8bae\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de\u4e3a\u7a7a\uff01");
                }
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u534f\u8bae\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de\u4e3a\u7a7a\uff01");
            }
            BeanUtils.copyProperties(orderProtocolItem, (Object)eaOrderProtocolItemAtomRsp);
        }
        catch (Exception e) {
            if (isDebugEnabled) {
                log.debug("\u534f\u8bae\u660e\u7ec6\u67e5\u8be2\u5f02\u5e38:" + e.getMessage());
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u534f\u8bae\u660e\u7ec6\u67e5\u8be2\u5f02\u5e38\uff01" + e.getMessage());
        }
        return eaOrderProtocolItemAtomRsp;
    }
}

