/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.SaleOrderStatusCheckXbjService;
import com.cgd.order.atom.SaleOrderVerifyXbjService;
import com.cgd.order.atom.bo.SaleOrderStatusCheckXbjReqBO;
import com.cgd.order.atom.bo.SaleOrderStatusCheckXbjRspBO;
import com.cgd.order.atom.bo.SaleOrderVerifyXbjReqBO;
import com.cgd.order.atom.bo.SaleOrderVerifyXbjRspBO;
import com.cgd.order.constant.OrderCenterConstant;
import com.cgd.order.dao.OrderAfterSaleXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.po.OrderAfterSaleXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaleOrderVerifyXbjServiceImpl
implements SaleOrderVerifyXbjService {
    private static final Logger logger = LoggerFactory.getLogger(SaleOrderVerifyXbjServiceImpl.class);
    private static final boolean isDebugEnabled = logger.isDebugEnabled();
    private OrderSaleXbjMapper orderSaleMapper;
    private OrderAfterSaleXbjMapper orderAfterSaleMapper;
    private SaleOrderStatusCheckXbjService saleOrderStatusCheckService;

    @Override
    public SaleOrderVerifyXbjRspBO dealSaleOrderVerify(SaleOrderVerifyXbjReqBO saleOrderVerifyReq) {
        if (isDebugEnabled) {
            logger.debug("\u9500\u552e\u8ba2\u5355\u786e\u8ba4\u524d\u6821\u9a8c\u5f00\u59cb:" + saleOrderVerifyReq.toString());
        }
        if (saleOrderVerifyReq == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355\u786e\u8ba4\u524d\u6821\u9a8c,\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (saleOrderVerifyReq.getPurchaserId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355\u786e\u8ba4\u524d\u6821\u9a8c,\u91c7\u8d2d\u5546\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (saleOrderVerifyReq.getSaleOrderId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355\u786e\u8ba4\u524d\u6821\u9a8c,\u9500\u552e\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        SaleOrderVerifyXbjRspBO saleOrderVerifyRsp = new SaleOrderVerifyXbjRspBO();
        try {
            OrderSaleXbjPO saleOrderInfo = null;
            if (null != saleOrderInfo && (saleOrderInfo.getSaleOrderStatus() == OrderCenterConstant.SLAE_ORDER_STATUS.COMPLETE || saleOrderInfo.getSaleOrderStatus() == OrderCenterConstant.SLAE_ORDER_STATUS.PART)) {
                OrderAfterSaleXbjPO orderAfterSale = new OrderAfterSaleXbjPO();
                ArrayList<Integer> statusList = new ArrayList<Integer>();
                statusList.add(OrderCenterConstant.AFTER_SALE.CANCEL);
                statusList.add(OrderCenterConstant.AFTER_SALE.COMPLETE);
                statusList.add(OrderCenterConstant.AFTER_SALE.REQUEST_FALSE);
                orderAfterSale.setSaleOrderId(saleOrderInfo.getSaleOrderId());
                List orderAfterSaleLits = null;
                if (null != orderAfterSaleLits && orderAfterSaleLits.size() > 0) {
                    if (isDebugEnabled) {
                        logger.debug("\u8ba2\u5355\u53f7\u3010" + saleOrderInfo.getSaleOrderId() + "\u3011\u5b58\u5728\u9000\u8d27\u4e2d\u8ba2\u5355!");
                    }
                    throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u6b64\u8ba2\u5355\u5b58\u5728\u9000\u8d27\u4e2d\u8ba2\u5355!");
                }
                SaleOrderStatusCheckXbjReqBO saleOrderStatusCheckReq = new SaleOrderStatusCheckXbjReqBO();
                saleOrderStatusCheckReq.setSaleOrderType(saleOrderInfo.getSaleOrderType());
                saleOrderStatusCheckReq.setNewSaleOrderStatus(OrderCenterConstant.SLAE_ORDER_STATUS.FINISH);
                saleOrderStatusCheckReq.setOldSaleOrderStatus(saleOrderInfo.getSaleOrderStatus());
                SaleOrderStatusCheckXbjRspBO saleOrderStatusCheckRsp = this.saleOrderStatusCheckService.notifySaleOrderStatus(saleOrderStatusCheckReq);
                if (!"0000".equals(saleOrderStatusCheckRsp.getCheckRspCode())) {
                    if (isDebugEnabled) {
                        logger.debug(saleOrderStatusCheckRsp.getCheckRspDesc());
                    }
                    throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", saleOrderStatusCheckRsp.getCheckRspDesc());
                }
            } else {
                if (isDebugEnabled) {
                    logger.debug("\u9500\u552e\u8ba2\u5355\u3010" + saleOrderVerifyReq.getSaleOrderId() + "\u3011\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u59a5\u6295\u72b6\u6001!");
                }
                throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u6b64\u8ba2\u5355\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u59a5\u6295\u72b6\u6001!");
            }
            saleOrderVerifyRsp.setRespCode("0000");
            saleOrderVerifyRsp.setRespDesc("\u6821\u9a8c\u901a\u8fc7\uff0c\u53ef\u4ee5\u53d1\u8d77\u786e\u8ba4\uff01");
            saleOrderVerifyRsp.setExtOrderId(saleOrderInfo.getExtOrderId());
            saleOrderVerifyRsp.setGoodsSupplierId(saleOrderInfo.getGoodsSupplierId());
        }
        catch (Exception e) {
            if (isDebugEnabled) {
                logger.debug("\u9500\u552e\u8ba2\u5355\u786e\u8ba4\u524d\u6821\u9a8c\u539f\u5b50\u670d\u52a1\u5f02\u5e38:" + e);
            }
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", e.getMessage());
        }
        return saleOrderVerifyRsp;
    }

    public void setOrderSaleMapper(OrderSaleXbjMapper orderSaleMapper) {
        this.orderSaleMapper = orderSaleMapper;
    }

    public void setOrderAfterSaleMapper(OrderAfterSaleXbjMapper orderAfterSaleMapper) {
        this.orderAfterSaleMapper = orderAfterSaleMapper;
    }

    public void setSaleOrderStatusCheckService(SaleOrderStatusCheckXbjService saleOrderStatusCheckService) {
        this.saleOrderStatusCheckService = saleOrderStatusCheckService;
    }
}

