/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.order.busi.XbjCheckWhetherShipAllService;
import com.cgd.order.busi.bo.XbjCheckWhetherShipAllReqBO;
import com.cgd.order.busi.bo.XbjCheckWhetherShipAllRspBO;
import com.cgd.order.constant.Constant;
import com.cgd.order.dao.OrderPurchaseItemXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.po.OrderPurchaseItemXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="xbjCheckWhetherShipAllService")
public class XbjCheckWhetherShipAllServiceImpl
implements XbjCheckWhetherShipAllService {
    private static final Logger log = LoggerFactory.getLogger(XbjCheckWhetherShipAllServiceImpl.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private OrderSaleXbjMapper orderSaleXbjMapper;
    @Autowired
    private OrderPurchaseItemXbjMapper orderPurchaseItemXbjMapper;

    public XbjCheckWhetherShipAllRspBO checkWhetherShipAll(XbjCheckWhetherShipAllReqBO checkWhetherShipAll) {
        Boolean allShip;
        XbjCheckWhetherShipAllRspBO checkWhetherShipAllRspBO;
        block8: {
            checkWhetherShipAllRspBO = new XbjCheckWhetherShipAllRspBO();
            allShip = true;
            try {
                List<OrderPurchaseItemXbjPO> selectByPurchaserOrderId;
                if (isDebugEnabled) {
                    log.debug("\u6821\u9a8c\u91c7\u8d2d\u8ba2\u5355\u662f\u5426\u5168\u90e8\u53d1\u8d27\u5b8c\u6210\u5165\u53c2" + checkWhetherShipAll);
                }
                if (null == checkWhetherShipAll.getSaleOrderId()) {
                    throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7535\u529b\u4e13\u533a\u9500\u552e\u8ba2\u5355\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (null == checkWhetherShipAll.getPurchaserId()) {
                    throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7535\u529b\u4e13\u533a\u91c7\u8d2d\u5546\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
                }
                OrderSaleXbjPO orderSale = this.orderSaleXbjMapper.selectOrderSaleByCondition(Long.valueOf(checkWhetherShipAll.getSaleOrderId()), checkWhetherShipAll.getPurchaserId());
                if (orderSale == null) {
                    allShip = false;
                }
                if (!Constant.SALSE_ORDER_STATE_TO_SENDING.equals(orderSale.getSaleOrderStatus()) && !Constant.SALSE_ORDER_STATE_TOBO_SEND.equals(orderSale.getSaleOrderStatus()) || null == (selectByPurchaserOrderId = this.orderPurchaseItemXbjMapper.selectByPurchaserOrderId(orderSale.getPurchaseOrderId(), orderSale.getPurchaserId())) || selectByPurchaserOrderId.isEmpty()) break block8;
                for (OrderPurchaseItemXbjPO orderPurchaseItem : selectByPurchaserOrderId) {
                    if (orderPurchaseItem.getSendCount().compareTo(orderPurchaseItem.getPurchaseCount()) == 0) continue;
                    allShip = false;
                    break;
                }
            }
            catch (Exception e) {
                if (isDebugEnabled) {
                    log.debug("\u6821\u9a8c\u91c7\u8d2d\u8ba2\u5355\u662f\u5426\u5168\u90e8\u53d1\u8d27\u5f02\u5e38\uff1a" + e);
                }
                allShip = false;
                checkWhetherShipAllRspBO.setRespCode("8888");
                checkWhetherShipAllRspBO.setRespDesc("\u5931\u8d25");
            }
        }
        checkWhetherShipAllRspBO.setAllShip(allShip);
        return checkWhetherShipAllRspBO;
    }
}

