/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.loader.perms.DataPermissionBean;
import com.cgd.common.loader.perms.PermissionCacheService;
import com.cgd.order.busi.XbjPurchaseOrderTabStatusCountBusiService;
import com.cgd.order.busi.bo.XbjOrderTabCountReqBO;
import com.cgd.order.busi.bo.XbjOrderTabCountRspBO;
import com.cgd.order.busi.bo.XbjTabInfoBO;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.OrderTabMappingOrderStatusXbjMapper;
import com.cgd.order.po.OrderTabMappingOrderStatusXbjPO;
import com.cgd.user.supplier.busi.SelectSupplierInfoByOrgCodeBusiService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class XbjPurchaseOrderTabStatusCountBusiServiceImpl
implements XbjPurchaseOrderTabStatusCountBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjPurchaseOrderTabStatusCountBusiServiceImpl.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private OrderTabMappingOrderStatusXbjMapper orderTabMappingOrderStatusXbjMapper;
    private SelectSupplierInfoByOrgCodeBusiService selectSupplierInfoByOrgCodeBusiService;
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;
    @Autowired
    PermissionCacheService permissionCacheService;

    public void setOrderTabMappingOrderStatusXbjMapper(OrderTabMappingOrderStatusXbjMapper orderTabMappingOrderStatusXbjMapper) {
        this.orderTabMappingOrderStatusXbjMapper = orderTabMappingOrderStatusXbjMapper;
    }

    public void setSelectSupplierInfoByOrgCodeBusiService(SelectSupplierInfoByOrgCodeBusiService selectSupplierInfoByOrgCodeBusiService) {
        this.selectSupplierInfoByOrgCodeBusiService = selectSupplierInfoByOrgCodeBusiService;
    }

    public void setOrderPurchaseXbjMapper(OrderPurchaseXbjMapper orderPurchaseXbjMapper) {
        this.orderPurchaseXbjMapper = orderPurchaseXbjMapper;
    }

    public XbjOrderTabCountRspBO PurchaseOrderStatusCount(XbjOrderTabCountReqBO xbjOrderTabCountReqBO) {
        this.validateParams(xbjOrderTabCountReqBO);
        if (isDebugEnabled) {
            log.debug("\u91c7\u8d2d\u8ba2\u5355\u9875\u7b7e\u67e5\u8be2\u5165\u53c2:" + xbjOrderTabCountReqBO.toString());
        }
        XbjOrderTabCountRspBO xbjOrderTabCountRspBO = new XbjOrderTabCountRspBO();
        ArrayList<XbjTabInfoBO> tabInfoRspList = new ArrayList<XbjTabInfoBO>();
        List xbjTabInfoBOList = xbjOrderTabCountReqBO.getTabInfoList();
        for (XbjTabInfoBO xbjTabInfoBO : xbjTabInfoBOList) {
            XbjTabInfoBO xbjTabInfoRspBO = new XbjTabInfoBO();
            List<OrderTabMappingOrderStatusXbjPO> orderTabMappingOrderStatusXbjPOList = null;
            try {
                orderTabMappingOrderStatusXbjPOList = this.orderTabMappingOrderStatusXbjMapper.selectByTabId(xbjTabInfoBO.getTabId());
            }
            catch (Exception e) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u7f3a\u5c11\u5bf9\u5e94\u5b57\u5178\u8868\u6620\u5c04\u53d6\u4ef6\u65b9\u5f0f\uff01");
            }
            if (orderTabMappingOrderStatusXbjPOList != null && orderTabMappingOrderStatusXbjPOList.size() > 0) {
                HashMap<String, Object> condition = new HashMap<String, Object>();
                Map<String, List<Long>> promossionList = this.getOrgAndDownOrgByCompId(xbjOrderTabCountReqBO.getUserId());
                log.debug("\u7528\u6237\u8fd4\u56de\u6743\u9650\u67e5\u8be2" + JSON.toJSONString(promossionList));
                if ("supplier".equals(xbjOrderTabCountReqBO.getRoleType())) {
                    condition.put("goodsSupplierId", xbjOrderTabCountReqBO.getSupId());
                } else if ("proOrg".equals(xbjOrderTabCountReqBO.getRoleType())) {
                    condition.put("professionalOrganizationId", xbjOrderTabCountReqBO.getCompanyId());
                } else if ("proOrgDelivery".equals(xbjOrderTabCountReqBO.getRoleType())) {
                    condition.put("deliveryId", xbjOrderTabCountReqBO.getUserId());
                } else if ("delivery".equals(xbjOrderTabCountReqBO.getRoleType())) {
                    condition.put("deliveryId", xbjOrderTabCountReqBO.getUserId());
                } else if ("qryOrderInfo".equals(xbjOrderTabCountReqBO.getRoleType())) {
                    List<Long> orgAndDownOrgList = promossionList.get("orgList");
                    if (orgAndDownOrgList != null && orgAndDownOrgList.size() > 0) {
                        condition.put("orgAndDownOrgList", orgAndDownOrgList);
                    }
                } else {
                    throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u91c7\u8d2d\u8ba2\u5355\u5217\u8868\u591a\u6761\u4ef6\u67e5\u8be2\u7ec4\u5408\u670d\u52a1  \u4f20\u5165\u7684roleType\u4e0eorderSubType\u6709\u8bef");
                }
                log.debug("\u7528\u6237\u8fd4\u56de\u6743\u9650condition\u67e5\u8be2" + JSON.toJSONString(condition));
                ArrayList<Integer> saleOrderStatusList = new ArrayList<Integer>(orderTabMappingOrderStatusXbjPOList.size());
                for (OrderTabMappingOrderStatusXbjPO orderTabMappingOrderStatusXbjPO : orderTabMappingOrderStatusXbjPOList) {
                    saleOrderStatusList.add(orderTabMappingOrderStatusXbjPO.getSaleOrderStatusCode());
                }
                condition.put("saleOrderStatusList", saleOrderStatusList);
                condition.put("typeList", xbjOrderTabCountReqBO.getTypeList());
                ArrayList<Integer> orderPurchaseTypeList = new ArrayList<Integer>();
                if (XbjOrderConstants.ORDER_PURCHASE_TYPE_ALL.equals(xbjOrderTabCountReqBO.getOrderPurchaseType())) {
                    orderPurchaseTypeList.add(XbjOrderConstants.ORDER_PURCHASE_TYPE_SHIP);
                    orderPurchaseTypeList.add(XbjOrderConstants.ORDER_PURCHASE_TYPE_CONSTR);
                    orderPurchaseTypeList.add(XbjOrderConstants.ORDER_PURCHASE_TYPE_SERV);
                    condition.put("orderPurchaseTypeList", orderPurchaseTypeList);
                } else {
                    orderPurchaseTypeList.add(xbjOrderTabCountReqBO.getOrderPurchaseType());
                    condition.put("orderPurchaseTypeList", orderPurchaseTypeList);
                }
                condition.put("isDispatch", xbjOrderTabCountReqBO.getIsDispatch());
                Integer saleOrderCount = this.orderPurchaseXbjMapper.queryOrderStatusTabCount(condition);
                if (saleOrderCount == null) {
                    saleOrderCount = 0;
                }
                xbjTabInfoRspBO.setTabName(orderTabMappingOrderStatusXbjPOList.get(0).getTabName());
                xbjTabInfoRspBO.setTabCount(saleOrderCount);
                xbjTabInfoRspBO.setSaleOrderStatusCode(orderTabMappingOrderStatusXbjPOList.get(0).getSaleOrderStatusCode());
                xbjTabInfoRspBO.setSaleOrderStatusName(orderTabMappingOrderStatusXbjPOList.get(0).getSaleOrderStatusName());
                xbjTabInfoRspBO.setTabId(xbjTabInfoBO.getTabId());
            }
            tabInfoRspList.add(xbjTabInfoRspBO);
        }
        xbjOrderTabCountRspBO.setRespCode("0000");
        xbjOrderTabCountRspBO.setRespDesc("\u8be2\u6bd4\u4ef7\u91c7\u8d2d\u8ba2\u5355\u6570\u91cf\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u6210\u529f");
        xbjOrderTabCountRspBO.setTabInfoList(tabInfoRspList);
        return xbjOrderTabCountRspBO;
    }

    private void validateParams(XbjOrderTabCountReqBO xbjOrderTabCountReqBO) {
        if (null == xbjOrderTabCountReqBO) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjOrderTabCountReqBO.getTabInfoList() == null || xbjOrderTabCountReqBO.getTabInfoList().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9875\u7b7e\u96c6\u5408[tabInfoList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjOrderTabCountReqBO.getTypeList() == null || xbjOrderTabCountReqBO.getTypeList().isEmpty()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u6765\u6e90\u96c6\u5408[typeList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)xbjOrderTabCountReqBO.getRoleType())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u89d2\u8272[roleType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjOrderTabCountReqBO.getOrderPurchaseType() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u7c7b\u522b[orderPurchaseType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private Map<String, List<Long>> getOrgAndDownOrgByCompId(Long userId) {
        HashMap<String, List<Long>> permissionMap = new HashMap<String, List<Long>>();
        DataPermissionBean dataPermission = this.permissionCacheService.getDataPermission(PermissionCacheService.ResrcCode.getEnum((String)"qry_order_purchase"), userId);
        log.debug("\u67e5\u8be2\u9500\u552e\u5355\u5217\u8868 \u67e5\u8be2\u6570\u636e\u6743\u9650\u8fd4\u56de\uff1a" + JSON.toJSONString((Object)dataPermission));
        if (dataPermission != null) {
            Set userIds;
            Set compIds;
            if (dataPermission.isAuthorisedAll()) {
                return null;
            }
            Set orgIds = dataPermission.getAuthorisedOrgIds();
            if (orgIds != null) {
                ArrayList orgIdList = new ArrayList(orgIds);
                permissionMap.put("orgList", orgIdList);
            }
            if ((compIds = dataPermission.getAuthorisedCompIds()) != null) {
                ArrayList userIdList = new ArrayList(compIds);
                permissionMap.put("compList", userIdList);
            }
            if ((userIds = dataPermission.getAuthorisedUserIds()) != null) {
                ArrayList compIdList = new ArrayList(userIds);
                permissionMap.put("userList", compIdList);
            }
        }
        return permissionMap;
    }
}

