/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.alibaba.fastjson.JSON;
import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.OrderPurchaseStatusChngXbjService;
import com.cgd.order.atom.OrderPurchaseXbjAtomService;
import com.cgd.order.atom.OrderSaleXbjAtomService;
import com.cgd.order.atom.bo.OrderPurchaseStatusChngReqBo;
import com.cgd.order.atom.bo.OrderSaleXbjReqBO;
import com.cgd.order.busi.XbjOrderPurchaseBusiService;
import com.cgd.order.busi.bo.XbjUpdateOrderPurchaseStatusRspBO;
import com.cgd.order.constant.Constant;
import com.cgd.order.po.OrderPurchaseXbjPO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XbjOrderPurchaseBusiServiceImpl
implements XbjOrderPurchaseBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjOrderPurchaseBusiServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    private OrderPurchaseXbjAtomService orderPurchaseXbjAtomService;
    private OrderPurchaseStatusChngXbjService orderPurchaseStatusChngXbjService;
    private OrderSaleXbjAtomService orderSaleXbjAtomService;

    public void setOrderPurchaseXbjAtomService(OrderPurchaseXbjAtomService orderPurchaseXbjAtomService) {
        this.orderPurchaseXbjAtomService = orderPurchaseXbjAtomService;
    }

    public void setOrderPurchaseStatusChngXbjService(OrderPurchaseStatusChngXbjService orderPurchaseStatusChngXbjService) {
        this.orderPurchaseStatusChngXbjService = orderPurchaseStatusChngXbjService;
    }

    public void setOrderSaleXbjAtomService(OrderSaleXbjAtomService orderSaleXbjAtomService) {
        this.orderSaleXbjAtomService = orderSaleXbjAtomService;
    }

    public XbjUpdateOrderPurchaseStatusRspBO updateOrderPurchaseStatus(Long purchaseOrderId, String comment, Integer oldStatus, Integer newStatus, Long userId, String arriveTime) {
        if (this.isDebugEnabled) {
            log.debug("\u91c7\u8d2d\u8ba2\u5355\u72b6\u6001\u66f4\u65b0\u5165\u53c2:" + purchaseOrderId + "," + comment + "," + oldStatus + "," + newStatus + "," + userId + "," + arriveTime);
        }
        this.validateParams(purchaseOrderId, oldStatus, newStatus, userId);
        OrderPurchaseXbjPO orderPurchaseXbjPO = this.orderPurchaseXbjAtomService.queryOrderPurchaseInfo(purchaseOrderId);
        this.validateOrderPurchaseStatus(orderPurchaseXbjPO);
        if (this.isDebugEnabled) {
            log.debug("\u91c7\u8d2d\u8ba2\u5355\u72b6\u6001\u66f4\u65b0 -------------------------------------------------------------");
            log.debug("\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f:------------------------------>" + JSON.toJSONString((Object)orderPurchaseXbjPO));
        }
        OrderPurchaseStatusChngReqBo orderPurchaseStatusChngReqBo = this.transferOrderPurchaseStatusChngReqBO(userId, orderPurchaseXbjPO, newStatus, arriveTime);
        if (this.isDebugEnabled) {
            log.debug("\u91c7\u8d2d\u8ba2\u5355\u72b6\u6001\u53d8\u5316\u539f\u5b50\u670d\u52a1\u5165\u53c2-------------------------------------------------------");
            log.debug(JSON.toJSONString((Object)orderPurchaseStatusChngReqBo));
        }
        this.orderPurchaseStatusChngXbjService.dealOrderPurchaseStatus(orderPurchaseStatusChngReqBo);
        OrderSaleXbjReqBO orderSaleXbjReqBO = this.transferOrderSaleReqBO(orderPurchaseXbjPO, oldStatus, newStatus, userId, arriveTime);
        if (this.isDebugEnabled) {
            log.debug("\u9500\u552e\u8ba2\u5355\u72b6\u6001\u53d8\u5316\u539f\u5b50\u670d\u52a1\u5165\u53c2---------------------------------------------------");
            log.debug(JSON.toJSONString((Object)orderSaleXbjReqBO));
        }
        this.orderSaleXbjAtomService.salerOrderStatusChange(orderSaleXbjReqBO);
        XbjUpdateOrderPurchaseStatusRspBO rsp = new XbjUpdateOrderPurchaseStatusRspBO();
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u6210\u529f");
        return rsp;
    }

    private OrderSaleXbjReqBO transferOrderSaleReqBO(OrderPurchaseXbjPO orderPurchaseXbjPO, Integer oldStatus, Integer newStatus, Long userId, String arriveTime) {
        OrderSaleXbjReqBO req = new OrderSaleXbjReqBO();
        req.setSaleOrderId(orderPurchaseXbjPO.getSaleOrderId());
        req.setSaleOrderStatus(newStatus);
        req.setSaleOrderOldStatus(oldStatus);
        req.setPurchaserId(orderPurchaseXbjPO.getPurchaserId());
        req.setPurchaserAccountId(orderPurchaseXbjPO.getPurchaserAccountId());
        req.setOperId(userId + "");
        req.setProfessionalOrganizationId(orderPurchaseXbjPO.getProfessionalOrganizationId());
        req.setArriveTime(arriveTime);
        return req;
    }

    private OrderPurchaseStatusChngReqBo transferOrderPurchaseStatusChngReqBO(Long userId, OrderPurchaseXbjPO orderPurchaseXbjPO, Integer newStatus, String arriveTime) {
        OrderPurchaseStatusChngReqBo req = new OrderPurchaseStatusChngReqBo();
        req.setPurchaseOrderId(orderPurchaseXbjPO.getPurchaseOrderId());
        req.setPurchaseOrderOldStatus(orderPurchaseXbjPO.getPurchaseOrderStatus());
        req.setPurchaseOrderStatus(newStatus);
        req.setPurchaserId(orderPurchaseXbjPO.getPurchaserId());
        req.setPurchaserAccountId(orderPurchaseXbjPO.getPurchaserAccountId());
        req.setOperId(userId + "");
        req.setProfessionalOrganizationId(orderPurchaseXbjPO.getProfessionalOrganizationId());
        req.setSaleOrderId(orderPurchaseXbjPO.getSaleOrderId());
        req.setArriveTime(arriveTime);
        req.setGoodsSupplierId(orderPurchaseXbjPO.getGoodsSupplierId());
        req.setPurchaserAccountName(orderPurchaseXbjPO.getPurchaserAccountName());
        req.setSaleOrderType(orderPurchaseXbjPO.getSaleOrderType());
        return req;
    }

    private void validateOrderPurchaseStatus(OrderPurchaseXbjPO orderPurchaseXbjPO) {
        if (orderPurchaseXbjPO == null) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6839\u636e\u91c7\u8d2d\u8ba2\u5355id[purchaseOrderId]\u67e5\u8be2\u4e0d\u5230\u91c7\u8d2d\u8ba2\u5355\u8bb0\u5f55");
        }
        if (Constant.SALSE_ORDER_STATE_CANCEL.equals(orderPurchaseXbjPO.getPurchaseOrderStatus())) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u91c7\u8d2d\u8ba2\u5355\u72b6\u6001[purchaseOrderStatus]\u4e3a\u5df2\u53d6\u6d88\uff0c\u4e0d\u53ef\u8fdb\u884c\u72b6\u6001\u66f4\u65b0");
        }
    }

    private void validateParams(Long purchaseOrderId, Integer oldStatus, Integer newStatus, Long userId) {
        if (purchaseOrderId == null || purchaseOrderId == 0L) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u5355id[purchaseOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (oldStatus == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u914d\u9001\u4e13\u8d23\u53d1\u9001\u91c7\u8d2d\u8ba2\u5355\t\u8ba2\u5355\u524d\u72b6\u6001[oldStatus]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (newStatus == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u914d\u9001\u4e13\u8d23\u53d1\u9001\u91c7\u8d2d\u8ba2\u5355\t\u65b0\u8ba2\u5355\u72b6\u6001[newStatus]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (userId == null || userId == 0L) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7528\u6237id[userId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

