/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.SaleOrderItemStatusChangeXbjService;
import com.cgd.order.atom.bo.SaleOrderItemChangeRspBO;
import com.cgd.order.atom.bo.SaleOrderItemChangeXbjReqBO;
import com.cgd.order.dao.OrderSaleItemXbjMapper;
import com.cgd.order.po.OrderSaleItemXbjPO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaleOrderItemStatusChangeXbjServiceImpl
implements SaleOrderItemStatusChangeXbjService {
    private static final Logger log = LoggerFactory.getLogger(SaleOrderItemStatusChangeXbjServiceImpl.class);
    private OrderSaleItemXbjMapper orderSaleItemXbjMapper;

    @Override
    public SaleOrderItemChangeRspBO updateSaleOrderItemStatus(SaleOrderItemChangeXbjReqBO saleOrderItemChangeReq) {
        SaleOrderItemChangeRspBO saleOrderItemChangeRsp = new SaleOrderItemChangeRspBO();
        try {
            if (saleOrderItemChangeReq == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u72b6\u6001\u53d8\u66f4\u539f\u5b50\u670d\u52a1,\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (saleOrderItemChangeReq.getSaleOrderId() == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u72b6\u6001\u53d8\u66f4\u539f\u5b50\u670d\u52a1,\u9500\u552e\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (saleOrderItemChangeReq.getSaleOrderStatus() == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u72b6\u6001\u53d8\u66f4\u539f\u5b50\u670d\u52a1,\u8ba2\u5355\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (saleOrderItemChangeReq.getPurchaserId() == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u72b6\u6001\u53d8\u66f4\u539f\u5b50\u670d\u52a1,\u91c7\u8d2d\u5546\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            OrderSaleItemXbjPO po = new OrderSaleItemXbjPO();
            po.setSaleOrderId(saleOrderItemChangeReq.getSaleOrderId());
            po.setPurchaserId(saleOrderItemChangeReq.getPurchaserId());
            List<OrderSaleItemXbjPO> orderItemList = this.orderSaleItemXbjMapper.selectBySaleOrderAndPurchaserId(po);
            if (null != orderItemList && orderItemList.size() > 0) {
                for (OrderSaleItemXbjPO orderSaleItem : orderItemList) {
                    orderSaleItem.setSaleOrderItemStatus(saleOrderItemChangeReq.getSaleOrderStatus());
                    this.orderSaleItemXbjMapper.updateSaleOrderStatusByCondition(orderSaleItem);
                }
            }
        }
        catch (Exception e) {
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u72b6\u6001\u53d8\u66f4\u539f\u5b50\u670d\u52a1\u5f02\u5e38:" + e);
        }
        return saleOrderItemChangeRsp;
    }

    public OrderSaleItemXbjMapper getOrderSaleItemXbjMapper() {
        return this.orderSaleItemXbjMapper;
    }

    public void setOrderSaleItemXbjMapper(OrderSaleItemXbjMapper orderSaleItemXbjMapper) {
        this.orderSaleItemXbjMapper = orderSaleItemXbjMapper;
    }
}

