/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.OrderCountModifyXbjService;
import com.cgd.order.atom.bo.OrderCountModifyXbjReqBO;
import com.cgd.order.atom.bo.OrderShipServConstrItemXbjBO;
import com.cgd.order.dao.OrderPurchaseItemXbjMapper;
import com.cgd.order.po.OrderPurchaseItemXbjPO;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderCountModifyXbjServiceImpl
implements OrderCountModifyXbjService {
    private static final Logger logger = LoggerFactory.getLogger(OrderCountModifyXbjServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private OrderPurchaseItemXbjMapper orderPurchaseItemXbjMapper;

    public void setOrderPurchaseItemXbjMapper(OrderPurchaseItemXbjMapper orderPurchaseItemXbjMapper) {
        this.orderPurchaseItemXbjMapper = orderPurchaseItemXbjMapper;
    }

    @Override
    public void dealWithOrderPurchaseItem(OrderCountModifyXbjReqBO reqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u66f4\u65b0\u91c7\u8d2d\u660e\u7ec6\u5df2\u53d1\u6570\u91cf\u548c\u5f85\u53d1\u6570\u91cf\u539f\u5b50\u670d\u52a1\u5165\u53c2" + reqBO.toString());
        }
        if (null == reqBO.getOrderShipItemList() || reqBO.getOrderShipItemList().size() < 1) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u66f4\u65b0\u91c7\u8d2d\u660e\u7ec6\u5df2\u53d1\u6570\u91cf\u548c\u5f85\u53d1\u6570\u91cf\u5f02\u5e38\uff0c\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        try {
            for (OrderShipServConstrItemXbjBO orderShipServConstrItem : reqBO.getOrderShipItemList()) {
                if (null == orderShipServConstrItem.getPurchaseOrderItemId()) {
                    throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u5355\u660e\u7ec6ID\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
                }
                OrderPurchaseItemXbjPO orderPurchaseItem = this.orderPurchaseItemXbjMapper.getModelById(orderShipServConstrItem.getPurchaseOrderItemId());
                if (null == orderPurchaseItem) {
                    throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u91c7\u8d2d\u5355\u660e\u7ec6ID\u4e0d\u5b58\u5728");
                }
                BigDecimal waitSendCount = orderPurchaseItem.getWaitSendCount();
                BigDecimal orderSendCount = orderPurchaseItem.getSendCount();
                BigDecimal onceSendCount = orderShipServConstrItem.getOnceSendCount();
                if (onceSendCount.compareTo(waitSendCount) == 1) {
                    throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u66f4\u65b0\u91c7\u8d2d\u660e\u7ec6\u5df2\u53d1\u6570\u91cf\u548c\u5f85\u53d1\u6570\u91cf\u5f02\u5e38\uff0c\u5f85\u53d1\u6570\u91cf\u5c0f\u4e8e\u53d1\u8d27\u6216\u5b8c\u5de5\u6570\u91cf!");
                }
                BigDecimal waitSendCountNew = waitSendCount.subtract(onceSendCount);
                BigDecimal orderSendCountNew = orderSendCount.add(onceSendCount);
                orderPurchaseItem.setWaitSendCount(waitSendCountNew);
                orderPurchaseItem.setSendCount(orderSendCountNew);
                this.orderPurchaseItemXbjMapper.updateById(orderPurchaseItem);
            }
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u91c7\u8d2d\u660e\u7ec6\u5df2\u53d1\u6570\u91cf\u548c\u5f85\u53d1\u6570\u91cf\u539f\u5b50\u670d\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u66f4\u65b0\u91c7\u8d2d\u660e\u7ec6\u5df2\u53d1\u6570\u91cf\u548c\u5f85\u53d1\u6570\u91cf\u539f\u5b50\u670d\u52a1\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }
}

