/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.OrderShipDetailCrtXbjAtomService;
import com.cgd.order.atom.bo.OrderShipDetaiCrtXbjReqBO;
import com.cgd.order.atom.bo.OrderShipItemXbjBO;
import com.cgd.order.dao.OrderPurchaseItemXbjMapper;
import com.cgd.order.dao.OrderShipItemXbjMapper;
import com.cgd.order.dao.OrderShipXbjMapper;
import com.cgd.order.po.OrderPurchaseItemXbjPO;
import com.cgd.order.po.OrderShipItemXbjPO;
import com.cgd.order.po.OrderShipXbjPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class OrderShipDetailCrtXbjAtomServiceImpl
implements OrderShipDetailCrtXbjAtomService {
    private static final Log log = LogFactory.getLog(OrderShipDetailCrtXbjAtomServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    private OrderShipXbjMapper orderShipXbjMapper;
    private OrderShipItemXbjMapper orderShipItemXbjMapper;
    @Autowired
    private OrderPurchaseItemXbjMapper orderPurchaseItemXbjMapper;

    public void setOrderShipXbjMapper(OrderShipXbjMapper orderShipXbjMapper) {
        this.orderShipXbjMapper = orderShipXbjMapper;
    }

    public void setOrderShipItemXbjMapper(OrderShipItemXbjMapper orderShipItemXbjMapper) {
        this.orderShipItemXbjMapper = orderShipItemXbjMapper;
    }

    @Override
    public void insertOrderShipDetai(OrderShipDetaiCrtXbjReqBO orderShipDetaiCrtReqBO) {
        if (this.isDebugEnabled) {
            log.debug((Object)("\u53d1\u8d27\u5355\uff0c\u53d1\u8d27\u660e\u7ec6\uff0c\u53d1\u8d27\u9644\u4ef6\u751f\u6210\u539f\u5b50\u670d\u52a1\u5165\u53c2" + orderShipDetaiCrtReqBO.toString()));
        }
        if (null == orderShipDetaiCrtReqBO.getShipOrderId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u53d1\u8d27\u5355\uff0c\u53d1\u8d27\u660e\u7ec6\uff0c\u53d1\u8d27\u9644\u4ef6\u751f\u6210\u539f\u5b50\u670d\u52a1\u53d1\u8d27\u5355ID[shipOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == orderShipDetaiCrtReqBO.getPurchaseOrderId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u53d1\u8d27\u5355\uff0c\u53d1\u8d27\u660e\u7ec6\uff0c\u53d1\u8d27\u9644\u4ef6\u751f\u6210\u539f\u5b50\u670d\u91c7\u8d2d\u5355\u7f16\u53f7[purchaseOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == orderShipDetaiCrtReqBO.getPurchaserId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u53d1\u8d27\u5355\uff0c\u53d1\u8d27\u660e\u7ec6\uff0c\u53d1\u8d27\u9644\u4ef6\u751f\u6210\u539f\u5b50\u670d\u52a1\u91c7\u8d2d\u5546\u7f16\u53f7[purchaserId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == orderShipDetaiCrtReqBO.getPurchaserAccountId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u53d1\u8d27\u5355\uff0c\u53d1\u8d27\u660e\u7ec6\uff0c\u53d1\u8d27\u9644\u4ef6\u751f\u6210\u539f\u5b50\u670d\u52a1\u91c7\u8d2d\u5546\u4e0b\u5355\u4eba\u7f16\u53f7[purchaserAccountId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == orderShipDetaiCrtReqBO.getProfessionalOrganizationId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u53d1\u8d27\u5355\uff0c\u53d1\u8d27\u660e\u7ec6\uff0c\u53d1\u8d27\u9644\u4ef6\u751f\u6210\u539f\u5b50\u670d\u52a1\u4e13\u4e1a\u673a\u6784\u7f16\u53f7[professionalOrganizationId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == orderShipDetaiCrtReqBO.getSaleOrderId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u53d1\u8d27\u5355\uff0c\u53d1\u8d27\u660e\u7ec6\uff0c\u53d1\u8d27\u9644\u4ef6\u751f\u6210\u539f\u5b50\u670d\u52a1\u9500\u552e\u8ba2\u5355\u7f16\u53f7[saleOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == orderShipDetaiCrtReqBO.getOrderShipItemBOs() || orderShipDetaiCrtReqBO.getOrderShipItemBOs().size() < 1) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u53d1\u8d27\u5355\uff0c\u53d1\u8d27\u660e\u7ec6\uff0c\u53d1\u8d27\u9644\u4ef6\u751f\u6210\u539f\u5b50\u670d\u52a1\u53d1\u8d27\u660e\u7ec6\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<OrderShipItemXbjPO> orderShipItemRsp = new ArrayList<OrderShipItemXbjPO>();
        try {
            OrderShipXbjPO orderShip = this.initOrderShip(orderShipDetaiCrtReqBO);
            this.orderShipXbjMapper.insert(orderShip);
            List<OrderShipItemXbjPO> orderShipItems = this.initOrderShipItems(orderShipDetaiCrtReqBO);
            if (null != orderShipItems && orderShipItems.size() > 0) {
                for (OrderShipItemXbjPO orderShipItem : orderShipItems) {
                    this.orderShipItemXbjMapper.insert(orderShipItem);
                    orderShipItemRsp.add(orderShipItem);
                    OrderPurchaseItemXbjPO orderPurchaseItemXbjPO = new OrderPurchaseItemXbjPO();
                    orderPurchaseItemXbjPO.setSendCount(orderShipItem.getPurchaseCount());
                    orderPurchaseItemXbjPO.setWaitSendCount(orderShipItem.getPurchaseCount());
                    orderPurchaseItemXbjPO.setPurchaserId(orderShipItem.getPurchaserId());
                    orderPurchaseItemXbjPO.setPurchaseOrderItemId(orderShipItem.getPurchaseOrderItemId());
                    this.orderPurchaseItemXbjMapper.updateSendAndWaitingCount(orderPurchaseItemXbjPO);
                }
            }
        }
        catch (Exception e) {
            if (this.isDebugEnabled) {
                log.debug((Object)("\u53d1\u8d27\u5355\uff0c\u53d1\u8d27\u660e\u7ec6\uff0c\u53d1\u8d27\u9644\u4ef6\u751f\u6210\u539f\u5b50\u670d\u52a1\u51fa\u9519" + e));
            }
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u53d1\u8d27\u5355\uff0c\u53d1\u8d27\u660e\u7ec6\uff0c\u53d1\u8d27\u9644\u4ef6\u751f\u6210\u539f\u5b50\u670d\u52a1\u51fa\u9519" + e);
        }
    }

    private OrderShipXbjPO initOrderShip(OrderShipDetaiCrtXbjReqBO orderShipDetaiCrtReqBO) {
        try {
            OrderShipXbjPO orderShip = new OrderShipXbjPO();
            BeanUtils.copyProperties((Object)orderShipDetaiCrtReqBO, (Object)orderShip);
            orderShip.setSaleOrderId(orderShipDetaiCrtReqBO.getSaleOrderId());
            orderShip.setPurchaseOrderCode(orderShipDetaiCrtReqBO.getPurchaseOrderCode());
            orderShip.setInspectionId(orderShipDetaiCrtReqBO.getInspectionId());
            orderShip.setPurchaseOrderId(orderShipDetaiCrtReqBO.getPurchaseOrderId());
            orderShip.setPurchaserAccountId(orderShipDetaiCrtReqBO.getPurchaserAccountId());
            orderShip.setPurchaserAccountName(orderShipDetaiCrtReqBO.getPurchaserAccountName());
            orderShip.setRemark(orderShipDetaiCrtReqBO.getRemark());
            orderShip.setSaleOrderId(orderShipDetaiCrtReqBO.getSaleOrderId());
            orderShip.setSaleOrderCode(orderShipDetaiCrtReqBO.getSaleOrderCode());
            orderShip.setShipCompanyName(orderShipDetaiCrtReqBO.getShipCompanyName());
            orderShip.setShipDate(orderShipDetaiCrtReqBO.getShipDate());
            orderShip.setShipId(orderShipDetaiCrtReqBO.getShipId());
            orderShip.setShipOrderId(orderShipDetaiCrtReqBO.getShipOrderId());
            orderShip.setShipStatus("4");
            orderShip.setPurchaserId(orderShipDetaiCrtReqBO.getPurchaserId());
            orderShip.setOperId(orderShipDetaiCrtReqBO.getPurchaserAccountId());
            orderShip.setCreateTime(new Date());
            orderShip.setModifyOperId(orderShipDetaiCrtReqBO.getModifyOperId());
            orderShip.setModifyTime(orderShipDetaiCrtReqBO.getModifyTime());
            orderShip.setPurchaseOrderCode(orderShipDetaiCrtReqBO.getPurchaseOrderCode());
            orderShip.setPackageId(orderShipDetaiCrtReqBO.getPackageId());
            orderShip.setExtOrderId(orderShipDetaiCrtReqBO.getExtOrderId());
            orderShip.setShipOrderCode(orderShipDetaiCrtReqBO.getShipOrderCode());
            orderShip.setIsEnclosure(orderShipDetaiCrtReqBO.getIsEnclosure());
            orderShip.setShipPhone(orderShipDetaiCrtReqBO.getShipPhone());
            return orderShip;
        }
        catch (Exception e) {
            if (this.isDebugEnabled) {
                log.debug((Object)("\u53d1\u8d27\u5355\uff0c\u53d1\u8d27\u660e\u7ec6\uff0c\u53d1\u8d27\u9644\u4ef6\u751f\u6210\u539f\u5b50\u670d\u52a1\u53d1\u8d27\u5355\u521d\u59cb\u5316\u51fa\u9519" + e));
            }
            throw new RuntimeException("\u53d1\u8d27\u5355\uff0c\u53d1\u8d27\u660e\u7ec6\uff0c\u53d1\u8d27\u9644\u4ef6\u751f\u6210\u539f\u5b50\u670d\u52a1\u53d1\u8d27\u5355\u521d\u59cb\u5316\u51fa\u9519");
        }
    }

    private List<OrderShipItemXbjPO> initOrderShipItems(OrderShipDetaiCrtXbjReqBO orderShipDetaiCrtReqBO) {
        try {
            ArrayList<OrderShipItemXbjPO> orderShipItems = new ArrayList<OrderShipItemXbjPO>();
            for (OrderShipItemXbjBO orderShipItemBO : orderShipDetaiCrtReqBO.getOrderShipItemBOs()) {
                OrderShipItemXbjPO orderShipItem = new OrderShipItemXbjPO();
                BeanUtils.copyProperties((Object)orderShipItemBO, (Object)orderShipItem);
                orderShipItem.setSkuName(orderShipItemBO.getSkuName());
                orderShipItem.setGoodsSupplierId(orderShipItemBO.getGoodsSupplierId());
                orderShipItem.setProfessionalOrganizationId(orderShipItemBO.getProfessionalOrganizationId());
                orderShipItem.setPurchaseCount(orderShipItemBO.getPurchaseCount());
                orderShipItem.setPurchaseOrderId(orderShipItemBO.getPurchaseOrderId());
                orderShipItem.setPurchaserAccountId(orderShipItemBO.getPurchaserAccountId());
                orderShipItem.setPurchaserAccountName(orderShipItemBO.getPurchaserAccountName());
                orderShipItem.setPurchaserId(orderShipItemBO.getPurchaserId());
                orderShipItem.setRemark(orderShipItemBO.getRemark());
                orderShipItem.setSaleOrderId(orderShipItemBO.getSaleOrderId());
                orderShipItem.setShipItemId(orderShipItemBO.getShipItemId());
                orderShipItem.setShipOrderId(orderShipItemBO.getShipOrderId());
                orderShipItem.setSkuId(orderShipItemBO.getSkuId());
                orderShipItem.setUnitName(orderShipItemBO.getUnitName());
                orderShipItem.setSaleOrderItemId(orderShipItemBO.getSaleOrderItemId());
                orderShipItem.setExtSkuId(orderShipItemBO.getExtSkuId());
                orderShipItems.add(orderShipItem);
            }
            return orderShipItems;
        }
        catch (Exception e) {
            if (this.isDebugEnabled) {
                log.debug((Object)("\u53d1\u8d27\u5355\uff0c\u53d1\u8d27\u660e\u7ec6\uff0c\u53d1\u8d27\u9644\u4ef6\u751f\u6210\u539f\u5b50\u670d\u52a1\u53d1\u8d27\u660e\u7ec6\u521d\u59cb\u5316\u51fa\u9519" + e));
            }
            throw new RuntimeException("\u53d1\u8d27\u5355\uff0c\u53d1\u8d27\u660e\u7ec6\uff0c\u53d1\u8d27\u9644\u4ef6\u751f\u6210\u539f\u5b50\u670d\u52a1\u53d1\u8d27\u660e\u7ec6\u521d\u59cb\u5316\u51fa\u9519");
        }
    }
}

