/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.feature.orm.mybatis.Page;
import com.cgd.order.atom.QryPurchaserInfoXbjAtomService;
import com.cgd.order.atom.bo.PurchaserInfoXbjReqBO;
import com.cgd.order.atom.bo.PurchaserInfoXbjRspBO;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.po.OrderPurchaseXbjPO;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QryPurchaserInfoXbjAtomServiceImpl
implements QryPurchaserInfoXbjAtomService {
    private static final Log log = LogFactory.getLog(QryPurchaserInfoXbjAtomServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    private OrderPurchaseXbjMapper orderPurchaseMapper;

    public void setOrderPurchaseMapper(OrderPurchaseXbjMapper orderPurchaseMapper) {
        this.orderPurchaseMapper = orderPurchaseMapper;
    }

    @Override
    public List<PurchaserInfoXbjRspBO> selectPurchaserInfo(PurchaserInfoXbjReqBO purchaserInfoReqBO, Page<OrderPurchaseXbjPO> page) {
        this.validatePurchaseData(purchaserInfoReqBO.getGoodsSupplierId());
        if (this.isDebugEnabled) {
            log.debug((Object)("\u7535\u529b\u4e13\u533a\u4f9b\u5e94\u5546\u91c7\u8d2d\u5355\u4f4d\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\uff1a" + purchaserInfoReqBO));
        }
        List<PurchaserInfoXbjRspBO> purchaserInfoRspList = null;
        try {
            List orderPurchaseList = null;
            if (null != orderPurchaseList && orderPurchaseList.size() > 0) {
                purchaserInfoRspList = this.assemblePurchaseData(orderPurchaseList);
            }
        }
        catch (Exception e) {
            log.error((Object)("\u7535\u529b\u4e13\u533a\u4f9b\u5e94\u5546\u91c7\u8d2d\u5355\u4f4d\u67e5\u8be2\u539f\u5b50\u670d\u52a1" + e));
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u7535\u529b\u4e13\u533a\u4f9b\u5e94\u5546\u91c7\u8d2d\u5355\u4f4d\u67e5\u8be2\u539f\u5b50\u670d\u52a1" + e);
        }
        return purchaserInfoRspList;
    }

    private void validatePurchaseData(Long goodsSupplierId) {
        if (goodsSupplierId == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7535\u529b\u4e13\u533a\u4f9b\u5e94\u5546\u91c7\u8d2d\u5355\u4f4d\u67e5\u8be2\u539f\u5b50\u670d\u52a1  \u4f9b\u5e94\u5546ID\u3010goodsSupplierId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private List<PurchaserInfoXbjRspBO> assemblePurchaseData(List<OrderPurchaseXbjPO> orderPurchaseList) {
        ArrayList<PurchaserInfoXbjRspBO> purchaserInfoRspList = new ArrayList<PurchaserInfoXbjRspBO>();
        try {
            for (OrderPurchaseXbjPO orderPurchase : orderPurchaseList) {
                PurchaserInfoXbjRspBO purchaserInfoRsp = new PurchaserInfoXbjRspBO();
                purchaserInfoRsp.setPurchaserId(orderPurchase.getPurchaserId());
                purchaserInfoRsp.setPurchaserName(orderPurchase.getPurchaserName());
                purchaserInfoRsp.setProfessionalOrganizationId(orderPurchase.getProfessionalOrganizationId());
                purchaserInfoRspList.add(purchaserInfoRsp);
            }
        }
        catch (Exception e) {
            log.error((Object)("\u7535\u529b\u4e13\u533a\u4f9b\u5e94\u5546\u91c7\u8d2d\u5355\u4f4d\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u7ec4\u88c5\u91c7\u8d2d\u5355\u4f4d\u6570\u636e\u51fa\u9519" + e));
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u7535\u529b\u4e13\u533a\u4f9b\u5e94\u5546\u91c7\u8d2d\u5355\u4f4d\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u7ec4\u88c5\u91c7\u8d2d\u5355\u4f4d\u6570\u636e\u51fa\u9519" + e);
        }
        return purchaserInfoRspList;
    }
}

