/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.GenerateOrderIdAndCodeXbjAtomService;
import com.cgd.order.atom.bo.GenerateOrderIdAndCodeXbjReqBO;
import com.cgd.order.atom.bo.GenerateOrderIdAndCodeXbjRspBO;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.InspectionXbjMapper;
import com.cgd.order.dao.OrderConstrCompleteXbjMapper;
import com.cgd.order.dao.OrderConstrInspectionXbjMapper;
import com.cgd.order.dao.OrderDistributionXbjMapper;
import com.cgd.order.dao.OrderProfessionalOrganizationXbjMapper;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.dao.OrderServCompleteXbjMapper;
import com.cgd.order.dao.OrderServInspectionXbjMapper;
import com.cgd.order.dao.OrderShipXbjMapper;
import com.cgd.order.dao.ReturnXbjMapper;
import com.cgd.order.dao.SequenceXbjMapper;
import com.cgd.order.po.InspectionXbjPO;
import com.cgd.order.po.OrderConstrCompleteXbjPO;
import com.cgd.order.po.OrderConstrInspectionXbjPO;
import com.cgd.order.po.OrderProfessionalOrganizationXbjPO;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import com.cgd.order.po.OrderServCompleteXbjPO;
import com.cgd.order.po.OrderServInspectionXbjPO;
import com.cgd.order.po.OrderShipXbjPO;
import com.cgd.order.po.ReturnXbjPO;
import com.cgd.order.po.SequenceXbjPO;
import com.cgd.order.util.FormatCodeUtilXbj;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class GenerateOrderIdAndCodeXbjAtomServiceImpl
implements GenerateOrderIdAndCodeXbjAtomService {
    private static final Logger logger = LoggerFactory.getLogger(GenerateOrderIdAndCodeXbjAtomServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private static final String TYPE_FLAG_SHIP = "FHD";
    private static final String TYPE_FLAG_CONSTR_COMPLETE = "WGD";
    private static final String TYPE_FLAG_SERV_COMPLETE = "WGD";
    private static final String TYPE_FLAG_INSPECTION = "YSD";
    private static final String TYPE_FLAG_CONSTR_INSPECTION = "YSD";
    private static final String TYPE_FLAG_SERV_INSPECTION = "YSD";
    private static final String TYPE_FLAG_SALE = "XSDD";
    private static final String TYPE_FLAG_PURCHASE = "CGDD";
    private static final String TYPE_FLAG_RETURN = "THD";
    private static final String TYPE_FLAG_DISTRIBUTION_RULE = "FPGZ";
    @Autowired
    private SequenceXbjMapper sequenceXbjMapper;
    @Autowired
    private OrderShipXbjMapper orderShipXbjMapper;
    @Autowired
    private OrderServCompleteXbjMapper orderServCompleteXbjMapper;
    @Autowired
    private OrderConstrCompleteXbjMapper orderConstrCompleteXbjMapper;
    @Autowired
    private InspectionXbjMapper inspectionXbjMapper;
    @Autowired
    private OrderConstrInspectionXbjMapper orderConstrInspectionXbjMapper;
    @Autowired
    private OrderServInspectionXbjMapper orderServInspectionXbjMapper;
    @Autowired
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;
    @Autowired
    private OrderSaleXbjMapper orderSaleXbjMapper;
    @Autowired
    private ReturnXbjMapper returnXbjMapper;
    @Autowired
    private OrderProfessionalOrganizationXbjMapper orderProfessionalOrganizationXbjMapper;
    @Autowired
    private OrderDistributionXbjMapper orderDistributionXbjMapper;

    @Override
    public GenerateOrderIdAndCodeXbjRspBO generateOrderIdAndCode(GenerateOrderIdAndCodeXbjReqBO reqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u8ba2\u5355ID\u548cCODE\u751f\u6210\u539f\u5b50\u670d\u52a1\u5165\u53c2:{}", (Object)reqBO.toString());
        }
        if (null == reqBO.getGenerateOrderType()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u751f\u6210\u8ba2\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        try {
            if (XbjOrderConstants.GENERATE_ORDER_TYPE.SHIP == reqBO.getGenerateOrderType()) {
                return this.generateOrderShip(reqBO);
            }
            if (XbjOrderConstants.GENERATE_ORDER_TYPE.CONSTR_COMPLETE == reqBO.getGenerateOrderType()) {
                return this.generateOrderConstrComplete(reqBO);
            }
            if (XbjOrderConstants.GENERATE_ORDER_TYPE.SERV_COMPLETE == reqBO.getGenerateOrderType()) {
                return this.generateOrderServComplete(reqBO);
            }
            if (XbjOrderConstants.GENERATE_ORDER_TYPE.INSPECTION == reqBO.getGenerateOrderType()) {
                return this.generateOrderInspection(reqBO);
            }
            if (XbjOrderConstants.GENERATE_ORDER_TYPE.CONSTR_INSPECTION == reqBO.getGenerateOrderType()) {
                return this.generateOrderConstrInspection(reqBO);
            }
            if (XbjOrderConstants.GENERATE_ORDER_TYPE.SERV_INSPECTION == reqBO.getGenerateOrderType()) {
                return this.generateOrderServInspection(reqBO);
            }
            if (XbjOrderConstants.GENERATE_ORDER_TYPE.SALE == reqBO.getGenerateOrderType()) {
                return this.generateOrderSale(reqBO);
            }
            if (XbjOrderConstants.GENERATE_ORDER_TYPE.PURCHASE == reqBO.getGenerateOrderType()) {
                return this.generateOrderPurchase(reqBO);
            }
            if (XbjOrderConstants.GENERATE_ORDER_TYPE.RETURN == reqBO.getGenerateOrderType()) {
                return this.generateOrderReturn(reqBO);
            }
            if (XbjOrderConstants.GENERATE_ORDER_TYPE.BATCH_SEQ == reqBO.getGenerateOrderType()) {
                return this.generateOrderBatchSeq(reqBO);
            }
            if (XbjOrderConstants.GENERATE_ORDER_TYPE.DISTRIBUTION_RULE_SEQ == reqBO.getGenerateOrderType()) {
                return this.generateDistributionRuleId(reqBO);
            }
            if (XbjOrderConstants.GENERATE_ORDER_TYPE.DEAL_SERVICE == reqBO.getGenerateOrderType()) {
                return this.generateDealServiceId(reqBO);
            }
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "This generateOrderType [" + reqBO.getGenerateOrderType() + "] is not support. Please see [com.cgd.order.constant.XbjOrderConstants.GENERATE_ORDER_TYPE].");
        }
        catch (Exception e) {
            if (this.isDebugEnabled) {
                logger.debug("\u8ba2\u5355ID\u548cCODE\u751f\u6210\u539f\u5b50\u670d\u52a1\u5f02\u5e38:{}", (Throwable)e);
                e.printStackTrace();
            }
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u8ba2\u5355ID\u548cCODE\u751f\u6210\u539f\u5b50\u670d\u52a1\u5f02\u5e38:" + e.getMessage());
        }
    }

    private GenerateOrderIdAndCodeXbjRspBO generateOrderBatchSeq(GenerateOrderIdAndCodeXbjReqBO reqBO) {
        GenerateOrderIdAndCodeXbjRspBO rspBO = new GenerateOrderIdAndCodeXbjRspBO();
        Long seqId = this.generateSequence("SEQ_D_ORDER_BATCH_SN");
        rspBO.setGenerateOrderType(reqBO.getGenerateOrderType());
        rspBO.setOrderId(seqId);
        return rspBO;
    }

    private GenerateOrderIdAndCodeXbjRspBO generateOrderReturn(GenerateOrderIdAndCodeXbjReqBO reqBO) throws Exception {
        GenerateOrderIdAndCodeXbjRspBO rspBO = new GenerateOrderIdAndCodeXbjRspBO();
        StringBuffer orderCode = new StringBuffer();
        orderCode.append(this.getSaleOrderCode(reqBO.getSaleOrderId(), reqBO.getPurchaseId()));
        orderCode.append("-");
        orderCode.append(TYPE_FLAG_RETURN);
        orderCode.append("-");
        orderCode.append(this.getDateYearMonthStr());
        ReturnXbjPO reqPO = new ReturnXbjPO();
        reqPO.setSaleOrderId(reqBO.getSaleOrderId());
        reqPO.setPurchaserId(reqBO.getPurchaseId());
        List<ReturnXbjPO> lists = this.returnXbjMapper.getList(reqPO);
        orderCode.append(this.getFlowNumber(lists, "goodsReturnCode"));
        rspBO.setGenerateOrderType(reqBO.getGenerateOrderType());
        rspBO.setOrderId(this.generateOrderReturnId());
        rspBO.setOrderCode(orderCode.toString());
        return rspBO;
    }

    private GenerateOrderIdAndCodeXbjRspBO generateOrderPurchase(GenerateOrderIdAndCodeXbjReqBO reqBO) throws Exception {
        String saleOrderCode = reqBO.getSaleOrderCode();
        String prefix = saleOrderCode.substring(0, 4);
        String flowNumber = saleOrderCode.substring(saleOrderCode.length() - 4, saleOrderCode.length());
        GenerateOrderIdAndCodeXbjRspBO rspBO = new GenerateOrderIdAndCodeXbjRspBO();
        StringBuffer orderCode = new StringBuffer();
        orderCode.append(prefix);
        orderCode.append("-");
        orderCode.append(TYPE_FLAG_PURCHASE);
        orderCode.append("-");
        orderCode.append(this.getDateYearMonthStr());
        orderCode.append(flowNumber);
        rspBO.setGenerateOrderType(reqBO.getGenerateOrderType());
        rspBO.setOrderId(this.generateOrderPurchaseId());
        rspBO.setOrderCode(orderCode.toString());
        return rspBO;
    }

    private GenerateOrderIdAndCodeXbjRspBO generateOrderSale(GenerateOrderIdAndCodeXbjReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getPrefix())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u914d\u9001\u4e2d\u5fc3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        GenerateOrderIdAndCodeXbjRspBO rspBO = new GenerateOrderIdAndCodeXbjRspBO();
        StringBuffer orderCode = new StringBuffer();
        orderCode.append(reqBO.getPrefix());
        orderCode.append("-");
        orderCode.append(TYPE_FLAG_SALE);
        orderCode.append("-");
        orderCode.append(this.getDateYearMonthStr());
        orderCode.append(this.getFlowNumberSale(reqBO.getPrefix()));
        rspBO.setGenerateOrderType(reqBO.getGenerateOrderType());
        rspBO.setOrderId(this.generateOrderSaleId());
        rspBO.setOrderCode(orderCode.toString());
        return rspBO;
    }

    private GenerateOrderIdAndCodeXbjRspBO generateOrderServInspection(GenerateOrderIdAndCodeXbjReqBO reqBO) throws Exception {
        GenerateOrderIdAndCodeXbjRspBO rspBO = new GenerateOrderIdAndCodeXbjRspBO();
        StringBuffer orderCode = new StringBuffer();
        orderCode.append(this.getSaleOrderCode(reqBO.getSaleOrderId(), reqBO.getPurchaseId()));
        orderCode.append("-");
        orderCode.append("YSD");
        orderCode.append("-");
        orderCode.append(this.getDateYearMonthStr());
        OrderServInspectionXbjPO reqPO = new OrderServInspectionXbjPO();
        reqPO.setSaleOrderId(reqBO.getSaleOrderId());
        reqPO.setPurchaserId(reqBO.getPurchaseId());
        List<OrderServInspectionXbjPO> lists = this.orderServInspectionXbjMapper.getList(reqPO);
        orderCode.append(this.getFlowNumber(lists, "servInspectionOrderCode"));
        rspBO.setGenerateOrderType(reqBO.getGenerateOrderType());
        rspBO.setOrderId(this.generateOrderInspectionServConstrId());
        rspBO.setOrderCode(orderCode.toString());
        return rspBO;
    }

    private GenerateOrderIdAndCodeXbjRspBO generateOrderConstrInspection(GenerateOrderIdAndCodeXbjReqBO reqBO) throws Exception {
        GenerateOrderIdAndCodeXbjRspBO rspBO = new GenerateOrderIdAndCodeXbjRspBO();
        StringBuffer orderCode = new StringBuffer();
        orderCode.append(this.getSaleOrderCode(reqBO.getSaleOrderId(), reqBO.getPurchaseId()));
        orderCode.append("-");
        orderCode.append("YSD");
        orderCode.append("-");
        orderCode.append(this.getDateYearMonthStr());
        OrderConstrInspectionXbjPO reqPO = new OrderConstrInspectionXbjPO();
        reqPO.setSaleOrderId(reqBO.getSaleOrderId());
        reqPO.setPurchaserId(reqBO.getPurchaseId());
        List<OrderConstrInspectionXbjPO> lists = this.orderConstrInspectionXbjMapper.getList(reqPO);
        orderCode.append(this.getFlowNumber(lists, "constrInspectionOrderCode"));
        rspBO.setGenerateOrderType(reqBO.getGenerateOrderType());
        rspBO.setOrderId(this.generateOrderInspectionServConstrId());
        rspBO.setOrderCode(orderCode.toString());
        return rspBO;
    }

    private GenerateOrderIdAndCodeXbjRspBO generateOrderInspection(GenerateOrderIdAndCodeXbjReqBO reqBO) throws Exception {
        GenerateOrderIdAndCodeXbjRspBO rspBO = new GenerateOrderIdAndCodeXbjRspBO();
        StringBuffer orderCode = new StringBuffer();
        orderCode.append(this.getSaleOrderCode(reqBO.getSaleOrderId(), reqBO.getPurchaseId()));
        orderCode.append("-");
        orderCode.append("YSD");
        orderCode.append("-");
        orderCode.append(this.getDateYearMonthStr());
        InspectionXbjPO reqPO = new InspectionXbjPO();
        reqPO.setSaleOrderId(reqBO.getSaleOrderId());
        reqPO.setPurchaserId(reqBO.getPurchaseId());
        List<InspectionXbjPO> lists = this.inspectionXbjMapper.getList(reqPO);
        orderCode.append(this.getFlowNumber(lists, "inspectionCode"));
        rspBO.setGenerateOrderType(reqBO.getGenerateOrderType());
        rspBO.setOrderId(this.generateOrderInspectionServConstrId());
        rspBO.setOrderCode(orderCode.toString());
        return rspBO;
    }

    private GenerateOrderIdAndCodeXbjRspBO generateOrderConstrComplete(GenerateOrderIdAndCodeXbjReqBO reqBO) throws Exception {
        GenerateOrderIdAndCodeXbjRspBO rspBO = new GenerateOrderIdAndCodeXbjRspBO();
        StringBuffer orderCode = new StringBuffer();
        orderCode.append(this.getPrucashseOrderCode(reqBO.getPurchaseOrderId(), reqBO.getPurchaseId()));
        orderCode.append("-");
        orderCode.append("WGD");
        orderCode.append("-");
        orderCode.append(this.getDateYearMonthStr());
        OrderConstrCompleteXbjPO orderConstrCompleteXbjPO = new OrderConstrCompleteXbjPO();
        orderConstrCompleteXbjPO.setPurchaseOrderId(reqBO.getPurchaseOrderId());
        orderConstrCompleteXbjPO.setPurchaserId(reqBO.getPurchaseId());
        List<OrderConstrCompleteXbjPO> orderConstrCompleteXbjPOList = this.orderConstrCompleteXbjMapper.getList(orderConstrCompleteXbjPO);
        orderCode.append(this.getFlowNumber(orderConstrCompleteXbjPOList, "constrCompleteOrderCode"));
        rspBO.setGenerateOrderType(reqBO.getGenerateOrderType());
        rspBO.setOrderId(this.generateOrderShipServConstrId());
        rspBO.setOrderCode(orderCode.toString());
        return rspBO;
    }

    private GenerateOrderIdAndCodeXbjRspBO generateOrderServComplete(GenerateOrderIdAndCodeXbjReqBO reqBO) throws Exception {
        GenerateOrderIdAndCodeXbjRspBO rspBO = new GenerateOrderIdAndCodeXbjRspBO();
        StringBuffer orderCode = new StringBuffer();
        orderCode.append(this.getPrucashseOrderCode(reqBO.getPurchaseOrderId(), reqBO.getPurchaseId()));
        orderCode.append("-");
        orderCode.append("WGD");
        orderCode.append("-");
        orderCode.append(this.getDateYearMonthStr());
        OrderServCompleteXbjPO orderServCompleteXbjPO = new OrderServCompleteXbjPO();
        orderServCompleteXbjPO.setPurchaseOrderId(reqBO.getPurchaseOrderId());
        orderServCompleteXbjPO.setPurchaserId(reqBO.getPurchaseId());
        List<OrderServCompleteXbjPO> orderServCompleteXbjPOList = this.orderServCompleteXbjMapper.getList(orderServCompleteXbjPO);
        orderCode.append(this.getFlowNumber(orderServCompleteXbjPOList, "servCompleteOrderCode"));
        rspBO.setGenerateOrderType(reqBO.getGenerateOrderType());
        rspBO.setOrderId(this.generateOrderShipServConstrId());
        rspBO.setOrderCode(orderCode.toString());
        return rspBO;
    }

    private GenerateOrderIdAndCodeXbjRspBO generateOrderShip(GenerateOrderIdAndCodeXbjReqBO reqBO) throws Exception {
        GenerateOrderIdAndCodeXbjRspBO rspBO = new GenerateOrderIdAndCodeXbjRspBO();
        StringBuffer orderCode = new StringBuffer();
        orderCode.append(this.getPrucashseOrderCode(reqBO.getPurchaseOrderId(), reqBO.getPurchaseId()));
        orderCode.append("-");
        orderCode.append(TYPE_FLAG_SHIP);
        orderCode.append("-");
        orderCode.append(this.getDateYearMonthStr());
        OrderShipXbjPO orderShipXbjPO = new OrderShipXbjPO();
        orderShipXbjPO.setPurchaseOrderId(reqBO.getPurchaseOrderId());
        orderShipXbjPO.setPurchaserId(reqBO.getPurchaseId());
        List<OrderShipXbjPO> orderShipXbjPOList = this.orderShipXbjMapper.getList(orderShipXbjPO);
        orderCode.append(this.getFlowNumber(orderShipXbjPOList, "shipOrderCode"));
        rspBO.setGenerateOrderType(reqBO.getGenerateOrderType());
        rspBO.setOrderId(this.generateOrderShipServConstrId());
        rspBO.setOrderCode(orderCode.toString());
        return rspBO;
    }

    private GenerateOrderIdAndCodeXbjRspBO generateDistributionRuleId(GenerateOrderIdAndCodeXbjReqBO reqBO) throws Exception {
        GenerateOrderIdAndCodeXbjRspBO rspBO = new GenerateOrderIdAndCodeXbjRspBO();
        StringBuffer orderCode = new StringBuffer();
        reqBO.setPrefix(this.getProfessnalOrgPrefix(reqBO.getProfessionalOrganizationId()));
        orderCode.append(reqBO.getPrefix());
        orderCode.append("-");
        orderCode.append(TYPE_FLAG_DISTRIBUTION_RULE);
        orderCode.append("-");
        String seqName = reqBO.getPrefix() + "-" + TYPE_FLAG_DISTRIBUTION_RULE;
        Long seqId = this.sequenceXbjMapper.selectValue(seqName);
        if (seqId == null) {
            SequenceXbjPO sequencePO = new SequenceXbjPO();
            sequencePO.setSeqName(seqName);
            sequencePO.setCurrentValue(2L);
            sequencePO.setIncrement(1);
            this.sequenceXbjMapper.insert(sequencePO);
            rspBO.setOrderCode(seqName + "-" + 1);
        } else {
            Long seqIdNew = this.generateSequence(seqName);
            rspBO.setOrderCode(seqName + "-" + seqIdNew);
        }
        rspBO.setGenerateOrderType(reqBO.getGenerateOrderType());
        rspBO.setOrderId(this.generateDistributionRuleId());
        return rspBO;
    }

    private GenerateOrderIdAndCodeXbjRspBO generateDealServiceId(GenerateOrderIdAndCodeXbjReqBO reqBO) throws Exception {
        GenerateOrderIdAndCodeXbjRspBO rspBO = new GenerateOrderIdAndCodeXbjRspBO();
        rspBO.setOrderId(this.generateDealServiceId());
        return rspBO;
    }

    private String getDateYearMonthStr() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
        Date time = new Date();
        return sdf.format(time);
    }

    private String getPrucashseOrderCode(Long purchaseOrderId, Long purchaseId) throws Exception {
        OrderPurchaseXbjPO orderPurchaseXbjPO = new OrderPurchaseXbjPO();
        orderPurchaseXbjPO.setPurchaseOrderId(purchaseOrderId);
        orderPurchaseXbjPO.setPurchaserId(purchaseId);
        OrderPurchaseXbjPO orderPurchaseRsp = this.orderPurchaseXbjMapper.getModelBy(orderPurchaseXbjPO);
        if (null == orderPurchaseRsp) {
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u91c7\u8d2d\u8ba2\u5355ID[" + purchaseOrderId + "]\u4e0d\u5b58\u5728\uff01");
        }
        if (null == orderPurchaseRsp.getPurchaseOrderCode()) {
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u91c7\u8d2d\u8ba2\u5355ID[" + purchaseOrderId + "]\u7684\u91c7\u8d2d\u8ba2\u5355\u7f16\u53f7\u4e3a\u7a7a\uff01");
        }
        return orderPurchaseRsp.getPurchaseOrderCode();
    }

    private String getProfessnalOrgPrefix(Long professionalOrganizationId) throws Exception {
        OrderProfessionalOrganizationXbjPO condition = new OrderProfessionalOrganizationXbjPO();
        condition.setProfessionalOrganizationId(professionalOrganizationId);
        OrderProfessionalOrganizationXbjPO orderProfessionalOrganizationXbjPO = this.orderProfessionalOrganizationXbjMapper.getModelBy(condition);
        if (null == orderProfessionalOrganizationXbjPO) {
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u4e13\u4e1a\u516c\u53f8[" + professionalOrganizationId + "]\u4e0d\u5b58\u5728\uff01");
        }
        if (null == orderProfessionalOrganizationXbjPO.getPrefix()) {
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u4e13\u4e1a\u516c\u53f8ID[" + professionalOrganizationId + "]\u7684\u4e13\u4e1a\u516c\u53f8 PreFix\u4e3a\u7a7a\uff01");
        }
        return orderProfessionalOrganizationXbjPO.getPrefix();
    }

    private String getSaleOrderCode(Long saleOrderId, Long purchaseId) throws Exception {
        OrderSaleXbjPO reqPO = new OrderSaleXbjPO();
        reqPO.setSaleOrderId(saleOrderId);
        reqPO.setPurchaserId(purchaseId);
        OrderSaleXbjPO rspPO = this.orderSaleXbjMapper.getModelBy(reqPO);
        if (null == rspPO) {
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u9500\u552e\u8ba2\u5355ID[" + saleOrderId + "]\u4e0d\u5b58\u5728\uff01");
        }
        if (null == rspPO.getSaleOrderCode()) {
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u9500\u552e\u8ba2\u5355ID[" + saleOrderId + "]\u7684\u9500\u552e\u8ba2\u5355\u7f16\u53f7\u4e3a\u7a7a\uff01");
        }
        return rspPO.getSaleOrderCode();
    }

    private String getFlowNumberSale(String prefix) {
        Long seqId = this.generateSequence(prefix + this.getDateYearMonthStr());
        String zeroStr = "0000";
        String numStr = String.valueOf(seqId);
        if (zeroStr.length() > numStr.length()) {
            zeroStr = zeroStr.substring(0, zeroStr.length() - numStr.length());
            return zeroStr + numStr;
        }
        return numStr;
    }

    private <T> String getFlowNumber(List<T> typeList, String typeFieldName) throws Exception {
        if (null == typeList || typeList.size() < 1) {
            return "001";
        }
        int maxNumber = 0;
        for (T type : typeList) {
            String lastOrderCode = BeanUtils.getProperty(type, (String)typeFieldName);
            if (null == lastOrderCode) {
                throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u6d41\u6c34\u53f7\u751f\u6210\u5f02\u5e38\uff0c\u8be5\u751f\u6210\u8ba2\u5355\u7c7b\u578b\u4e4b\u524d\u7684\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            int length = lastOrderCode.toCharArray().length;
            String last = lastOrderCode.substring(length - 3);
            int lastNumber = Integer.parseInt(last);
            maxNumber = maxNumber > lastNumber ? maxNumber : lastNumber;
        }
        if (++maxNumber > 999) {
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u6d41\u6c34\u53f7\u751f\u6210\u5f02\u5e38\uff0c\u6d41\u6c34\u53f7\u957f\u5ea6\u5df2\u5230\u4e0a\u9650\uff01");
        }
        String resultCode = String.valueOf(maxNumber);
        if (resultCode.toCharArray().length == 1) {
            resultCode = "00" + resultCode;
        }
        if (resultCode.toCharArray().length == 2) {
            resultCode = "0" + resultCode;
        }
        return resultCode;
    }

    private Long generateOrderShipServConstrId() {
        Long seqId = this.generateSequence("SEQ_D_ORDER_SHIP_SN");
        return FormatCodeUtilXbj.leftFormat("4", seqId);
    }

    private Long generateOrderInspectionServConstrId() {
        Long seqId = this.generateSequence("SEQ_D_INSPECTION_SN");
        return seqId;
    }

    private Long generateOrderSaleId() {
        Long seqId = this.generateSequence("SEQ_D_ORDER_SALE_SN");
        return FormatCodeUtilXbj.leftFormat("1", seqId);
    }

    private Long generateOrderPurchaseId() {
        Long seqId = this.generateSequence("SEQ_ORDER_PURCHASE_SN");
        return FormatCodeUtilXbj.leftFormat("4", seqId);
    }

    private Long generateOrderReturnId() {
        Long seqId = this.generateSequence("SEQ_D_ORDER_RETURN_SN");
        return seqId;
    }

    private Long generateDistributionRuleId() {
        Long seqId = this.generateSequence("SEQ_R_ORDER_DISTRIBUTION_SN");
        return seqId;
    }

    private Long generateDealServiceId() {
        Long seqId = this.generateSequence("SEQ_D_ORDER_SERVICE_SN");
        return seqId;
    }

    private Long generateSequence(String seqName) {
        try {
            Long seqId = this.sequenceXbjMapper.selectValue(seqName);
            if (seqId != null) {
                this.sequenceXbjMapper.updateValue(seqName);
            } else {
                SequenceXbjPO sequenceXbjPO = new SequenceXbjPO();
                sequenceXbjPO.setSeqName(seqName);
                sequenceXbjPO.setCurrentValue(2L);
                sequenceXbjPO.setIncrement(1);
                this.sequenceXbjMapper.insert(sequenceXbjPO);
                seqId = 1L;
            }
            return seqId;
        }
        catch (Exception e) {
            if (this.isDebugEnabled) {
                logger.error("\u5e8f\u5217\u751f\u6210\u539f\u5b50\u670d\u52a1\u51fa\u9519-\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38", (Throwable)e);
            }
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u5e8f\u5217\u751f\u6210\u539f\u5b50\u670d\u52a1\u51fa\u9519-\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38");
        }
    }
}

