/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.cgd.common.busi.bo.RspBusiBaseBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.order.busi.XbjOrderWorkFlowCompleteBusiService;
import com.cgd.order.busi.bo.XbjOrderWorkFlowCompleteReqBO;
import com.cgd.order.busi.bo.XbjOrderWorkFlowCompleteRspBO;
import com.cgd.order.dao.OrderProcessCodeXbjMapper;
import com.cgd.order.po.OrderProcessCodeXbjPO;
import com.cgd.workflow.bo.DoTaskRejectReqBO;
import com.cgd.workflow.busin.service.DoTaskRejectBusinService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XbjOrderWorkFlowCompleteBusiServiceImpl
implements XbjOrderWorkFlowCompleteBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjOrderWorkFlowCompleteBusiServiceImpl.class);
    private OrderProcessCodeXbjMapper orderProcessCodeXbjMapper;
    private DoTaskRejectBusinService doTaskRejectBusinService;

    public void setOrderProcessCodeXbjMapper(OrderProcessCodeXbjMapper orderProcessCodeXbjMapper) {
        this.orderProcessCodeXbjMapper = orderProcessCodeXbjMapper;
    }

    public void setDoTaskRejectBusinService(DoTaskRejectBusinService doTaskRejectBusinService) {
        this.doTaskRejectBusinService = doTaskRejectBusinService;
    }

    public XbjOrderWorkFlowCompleteRspBO orderWorkFlowComplete(XbjOrderWorkFlowCompleteReqBO xbjOrderWorkFlowCompleteReqBO) {
        log.debug("\u8ba2\u5355\u53d6\u6d88\u7ed3\u675f\u5de5\u4f5c\u6d41===================================================================start");
        log.debug("\u5165\u53c2:" + xbjOrderWorkFlowCompleteReqBO.getSaleOrderId());
        Long saleOrderId = xbjOrderWorkFlowCompleteReqBO.getSaleOrderId();
        if (saleOrderId == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u9500\u552e\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        XbjOrderWorkFlowCompleteRspBO xbjOrderWorkFlowCompleteRspBO = new XbjOrderWorkFlowCompleteRspBO();
        try {
            List<OrderProcessCodeXbjPO> processCodes = this.orderProcessCodeXbjMapper.selectCodesBySaleOrderId(saleOrderId);
            if (processCodes != null && processCodes.size() > 0) {
                for (OrderProcessCodeXbjPO processCode : processCodes) {
                    log.debug("\u5bf9\u5e94processCode:" + processCode.getProcessCode());
                    DoTaskRejectReqBO doTaskRejectReqBO = new DoTaskRejectReqBO();
                    doTaskRejectReqBO.setProcInstId(processCode.getProcessCode());
                    RspBusiBaseBO doTaskReject = this.doTaskRejectBusinService.doTaskReject(doTaskRejectReqBO);
                    if ("0000".equals(doTaskReject.getRespCode())) {
                        xbjOrderWorkFlowCompleteRspBO.setRespCode("0000");
                        xbjOrderWorkFlowCompleteRspBO.setRespDesc("\u53d6\u6d88\u8ba2\u5355\u7ed3\u675f\u5de5\u4f5c\u6d41\u6210\u529f");
                        continue;
                    }
                    xbjOrderWorkFlowCompleteRspBO.setRespCode("8888");
                    xbjOrderWorkFlowCompleteRspBO.setRespDesc("\u53d6\u6d88\u8ba2\u5355\u7ed3\u675f\u5de5\u4f5c\u6d41\u5931\u8d25");
                }
            } else {
                xbjOrderWorkFlowCompleteRspBO.setRespCode("0000");
                xbjOrderWorkFlowCompleteRspBO.setRespDesc("\u5f53\u524d\u8ba2\u5355\u65e0\u5f85\u529e\u6d41\u7a0b");
            }
        }
        catch (Exception e) {
            log.error("\u53d6\u6d88\u8ba2\u5355\u7ed3\u675f\u5de5\u4f5c\u6d41\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw e;
        }
        log.debug("\u8ba2\u5355\u53d6\u6d88\u7ed3\u675f\u5de5\u4f5c\u6d41===================================================================end");
        return xbjOrderWorkFlowCompleteRspBO;
    }
}

