/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.OrderStatusChangeXbjAtomService;
import com.cgd.order.atom.bo.OrderStatusChangeXbjReqBO;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.OrderSaleStatusChngLogXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.dao.PurchaseOrderStatusChngXbjMapper;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.po.OrderSaleStatusChngLogXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import com.cgd.order.po.PurchaseOrderStatusChngXbjPO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderStatusChangeXbjAtomServiceImpl
implements OrderStatusChangeXbjAtomService {
    private static final Logger logger = LoggerFactory.getLogger(OrderStatusChangeXbjAtomServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private OrderSaleXbjMapper orderSaleXbjMapper;
    @Autowired
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;
    @Autowired
    private OrderSaleStatusChngLogXbjMapper orderSaleStatusChngLogXbjMapper;
    @Autowired
    private PurchaseOrderStatusChngXbjMapper purchaseOrderStatusChngXbjMapper;

    @Override
    public void updateStatus(OrderStatusChangeXbjReqBO reqBO) {
        try {
            this.updateSaleStatus(reqBO);
            this.updatePurchaseStatus(reqBO);
        }
        catch (Exception e) {
            if (this.isDebugEnabled) {
                logger.debug("\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u539f\u5b50\u670d\u52a1\u5f02\u5e38:{}", (Object)e.getMessage());
                e.printStackTrace();
            }
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u539f\u5b50\u670d\u52a1\u5f02\u5e38:" + e.getMessage());
        }
    }

    private void updateSaleStatus(OrderStatusChangeXbjReqBO reqBO) throws Exception {
        OrderSaleXbjPO orderSaleReqPO = new OrderSaleXbjPO();
        orderSaleReqPO.setSaleOrderId(reqBO.getSaleOrderId());
        orderSaleReqPO.setPurchaserId(reqBO.getPurchaserId());
        OrderSaleXbjPO orderSalePO = this.orderSaleXbjMapper.getModelBy(orderSaleReqPO);
        Integer saleOrderStatusOld = orderSalePO.getSaleOrderStatus();
        orderSalePO.setSaleOrderStatus(reqBO.getSaleOrderStatusNew());
        this.orderSaleXbjMapper.updateById(orderSalePO);
        OrderSaleStatusChngLogXbjPO chngLog = new OrderSaleStatusChngLogXbjPO();
        chngLog.setPurchaserId(orderSalePO.getPurchaserId());
        chngLog.setPurchaserAccountId(orderSalePO.getPurchaserAccountId());
        chngLog.setPurchaserAccountName(orderSalePO.getPurchaserAccountName());
        chngLog.setProfessionalOrganizationId(orderSalePO.getProfessionalOrganizationId());
        chngLog.setGoodsSupplierId(orderSalePO.getGoodsSupplierId());
        chngLog.setSaleOrderId(orderSalePO.getSaleOrderId());
        chngLog.setOldSaleOrderStatus(saleOrderStatusOld);
        chngLog.setNewSaleOrderStatus(reqBO.getSaleOrderStatusNew());
        chngLog.setCreateDate(new Date());
        chngLog.setOperId(String.valueOf(reqBO.getOperId()));
        this.orderSaleStatusChngLogXbjMapper.insert(chngLog);
    }

    private void updatePurchaseStatus(OrderStatusChangeXbjReqBO reqBO) throws Exception {
        OrderPurchaseXbjPO orderPurchaseReqPO = new OrderPurchaseXbjPO();
        orderPurchaseReqPO.setPurchaseOrderId(reqBO.getPurchaseOrderId());
        orderPurchaseReqPO.setPurchaserId(reqBO.getPurchaserId());
        OrderPurchaseXbjPO orderPurchasePO = this.orderPurchaseXbjMapper.getModelBy(orderPurchaseReqPO);
        Integer purchaseOrderStatusOld = orderPurchasePO.getPurchaseOrderStatus();
        orderPurchasePO.setPurchaseOrderStatus(reqBO.getPurchaseOrderStatusNew());
        this.orderPurchaseXbjMapper.updateById(orderPurchasePO);
        PurchaseOrderStatusChngXbjPO chngLog = new PurchaseOrderStatusChngXbjPO();
        chngLog.setPurchaserId(orderPurchasePO.getPurchaserId());
        chngLog.setPurchaserAccountId(orderPurchasePO.getPurchaserAccountId());
        chngLog.setPurchaserAccountName(orderPurchasePO.getPurchaserAccountName());
        chngLog.setProfessionalOrganizationId(orderPurchasePO.getProfessionalOrganizationId());
        chngLog.setGoodsSupplierId(orderPurchasePO.getGoodsSupplierId());
        chngLog.setPurchaseOrderId(reqBO.getPurchaseOrderId());
        chngLog.setSaleOrderId(reqBO.getSaleOrderId());
        chngLog.setOldSaleOrderStatus(purchaseOrderStatusOld);
        chngLog.setNewSaleOrderStatus(reqBO.getPurchaseOrderStatusNew());
        chngLog.setCreateDate(new Date());
        chngLog.setOperId(String.valueOf(reqBO.getOperId()));
        this.purchaseOrderStatusChngXbjMapper.insert(chngLog);
    }
}

