/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.cgd.common.bo.RspInfoBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.OrderPurchaseStatusChngXbjService;
import com.cgd.order.atom.OrderPurchaseXbjAtomService;
import com.cgd.order.atom.OrderSaleXbjAtomService;
import com.cgd.order.atom.XbjCreateOrderFlowSheetAtomService;
import com.cgd.order.atom.XbjOrderSendMsgAtomService;
import com.cgd.order.atom.bo.OrderPurchaseStatusChngReqBo;
import com.cgd.order.atom.bo.OrderSaleXbjReqBO;
import com.cgd.order.atom.bo.OrderSendMsgAtomXbjReqBO;
import com.cgd.order.busi.XbjAccessoryBusiService;
import com.cgd.order.busi.XbjCreateOrderFlowSheetBusiService;
import com.cgd.order.busi.XbjSupplierPurchaseOrderRejectBusiService;
import com.cgd.order.busi.bo.XbjOrderFlowSheetReqBO;
import com.cgd.order.busi.bo.XbjOrderFlowSheetRspBO;
import com.cgd.order.busi.bo.XbjRejectPurchaseOrderReqBO;
import com.cgd.order.busi.bo.XbjRejectPurchaseOrderRspBO;
import com.cgd.order.constant.Constant;
import com.cgd.order.constant.XConstant;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import com.cgd.user.userInfo.busi.SelectUserInfoByUserIdBusiService;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdReqBO;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdRspBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class XbjSupplierPurchaseOrderRejectBusiServiceImpl
implements XbjSupplierPurchaseOrderRejectBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjSupplierPurchaseOrderRejectBusiServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    private OrderPurchaseStatusChngXbjService orderPurchaseStatusChngXbjService;
    private XbjAccessoryBusiService xbjAccessoryBusiService;
    private OrderPurchaseXbjAtomService orderPurchaseXbjAtomService;
    private XbjCreateOrderFlowSheetBusiService xbjCreateOrderFlowSheetBusiService;
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;
    private OrderSaleXbjAtomService orderSaleXbjAtomService;
    private OrderSaleXbjMapper orderSaleXbjMapper;
    @Autowired
    private XbjCreateOrderFlowSheetAtomService xbjCreateOrderFlowSheetAtomService;
    @Autowired
    private XbjOrderSendMsgAtomService xbjOrderSendMsgAtomService;
    @Autowired
    private SelectUserInfoByUserIdBusiService selectUserInfoByUserIdBusiService;

    public void setOrderPurchaseStatusChngXbjService(OrderPurchaseStatusChngXbjService orderPurchaseStatusChngXbjService) {
        this.orderPurchaseStatusChngXbjService = orderPurchaseStatusChngXbjService;
    }

    public void setXbjAccessoryBusiService(XbjAccessoryBusiService xbjAccessoryBusiService) {
        this.xbjAccessoryBusiService = xbjAccessoryBusiService;
    }

    public void setOrderPurchaseXbjAtomService(OrderPurchaseXbjAtomService orderPurchaseXbjAtomService) {
        this.orderPurchaseXbjAtomService = orderPurchaseXbjAtomService;
    }

    public void setXbjCreateOrderFlowSheetBusiService(XbjCreateOrderFlowSheetBusiService xbjCreateOrderFlowSheetBusiService) {
        this.xbjCreateOrderFlowSheetBusiService = xbjCreateOrderFlowSheetBusiService;
    }

    public void setOrderPurchaseXbjMapper(OrderPurchaseXbjMapper orderPurchaseXbjMapper) {
        this.orderPurchaseXbjMapper = orderPurchaseXbjMapper;
    }

    public void setOrderSaleXbjAtomService(OrderSaleXbjAtomService orderSaleXbjAtomService) {
        this.orderSaleXbjAtomService = orderSaleXbjAtomService;
    }

    public void setOrderSaleXbjMapper(OrderSaleXbjMapper orderSaleXbjMapper) {
        this.orderSaleXbjMapper = orderSaleXbjMapper;
    }

    public XbjRejectPurchaseOrderRspBO cancelSupplierPurchaseOrder(XbjRejectPurchaseOrderReqBO xbjRejectPurchaseOrderReqBO) {
        Integer newStatus = XConstant.SALE_ORDER_STATE_REJECT_TO_DEAL;
        log.error("\u8ba2\u5355\u6267\u884c\u6d41\u7a0b\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5165\u53c2-----------------------------------------------------" + JSON.toJSONString((Object)xbjRejectPurchaseOrderReqBO));
        this.validateParams(xbjRejectPurchaseOrderReqBO);
        OrderPurchaseXbjPO orderPurchaseXbjPO = this.orderPurchaseXbjAtomService.queryOrderPurchaseInfo(xbjRejectPurchaseOrderReqBO.getPurchaseOrderId());
        Integer newSaleOrderStatus = orderPurchaseXbjPO.getIsDispatch().equals(XConstant.IS_DISPATCH_NO) ? XConstant.SALE_ORDER_STATE_REJECT_TO_DEAL : XConstant.SALE_ORDER_STATE_TO_CONF;
        this.validate(orderPurchaseXbjPO);
        XbjRejectPurchaseOrderRspBO rsp = new XbjRejectPurchaseOrderRspBO();
        try {
            XbjOrderFlowSheetRspBO xbjOrderFlowSheetRspBO;
            OrderPurchaseStatusChngReqBo orderPurchaseStatusChngReqBo = this.transferOrderPurchaseStatusChngReqBO(xbjRejectPurchaseOrderReqBO.getUserId(), orderPurchaseXbjPO, newStatus, null);
            this.orderPurchaseStatusChngXbjService.dealOrderPurchaseStatus(orderPurchaseStatusChngReqBo);
            this.orderPurchaseXbjMapper.updateCancelInfo(orderPurchaseXbjPO.getPurchaseOrderId(), "GOODS_SUPPLIER_CANCEL", xbjRejectPurchaseOrderReqBO.getCancelRemark(), new Date(), xbjRejectPurchaseOrderReqBO.getUserId());
            OrderSaleXbjPO orderSaleXbjPO = this.orderSaleXbjMapper.selectOrderSaleByCondition(orderPurchaseXbjPO.getSaleOrderId(), orderPurchaseXbjPO.getPurchaserId());
            if (orderSaleXbjPO != null) {
                OrderSaleXbjReqBO orderSaleXbjReqBO = this.transferOrderSaleReqBO(orderSaleXbjPO, "GOODS_SUPPLIER_CANCEL", orderSaleXbjPO.getSaleOrderStatus(), newSaleOrderStatus, xbjRejectPurchaseOrderReqBO.getUserId());
                this.orderSaleXbjAtomService.salerOrderStatusChange(orderSaleXbjReqBO);
                this.orderSaleXbjMapper.updateCancelInfo(orderSaleXbjPO.getSaleOrderId(), "GOODS_SUPPLIER_CANCEL", xbjRejectPurchaseOrderReqBO.getCancelRemark(), new Date(), xbjRejectPurchaseOrderReqBO.getUserId());
            }
            if (xbjRejectPurchaseOrderReqBO.getXbjPurchaseAccessoryReqBOs() != null && xbjRejectPurchaseOrderReqBO.getXbjPurchaseAccessoryReqBOs().size() > 0) {
                log.error("\u8ba2\u5355\u6267\u884c\u6d41\u7a0b\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5165\u53c2-----------------------------------------------------" + JSON.toJSONString((Object)xbjRejectPurchaseOrderReqBO.getXbjPurchaseAccessoryReqBOs()));
                this.xbjAccessoryBusiService.saveAccessoryByPurchaseOrder(xbjRejectPurchaseOrderReqBO.getPurchaseOrderId(), Constant.REJECT_OBJECT_TYPE, xbjRejectPurchaseOrderReqBO.getXbjPurchaseAccessoryReqBOs());
            }
            this.sendMessage(orderSaleXbjPO, xbjRejectPurchaseOrderReqBO);
            XbjOrderFlowSheetReqBO xbjOrderFlowSheetReqBO = new XbjOrderFlowSheetReqBO();
            BeanUtils.copyProperties((Object)xbjRejectPurchaseOrderReqBO, (Object)xbjOrderFlowSheetReqBO);
            xbjOrderFlowSheetReqBO.setOrderId(xbjRejectPurchaseOrderReqBO.getPurchaseOrderId());
            xbjOrderFlowSheetReqBO.setOrderType(Constant.ORDER_TYPE_PURCHASE);
            xbjOrderFlowSheetReqBO.setPurchaserId(orderPurchaseXbjPO.getPurchaserId());
            xbjOrderFlowSheetReqBO.setOrderBusiType("B_5");
            xbjOrderFlowSheetReqBO.setUserId(xbjRejectPurchaseOrderReqBO.getUserId());
            xbjOrderFlowSheetReqBO.setCompanyName(xbjRejectPurchaseOrderReqBO.getCompanyName());
            xbjOrderFlowSheetReqBO.setOperRole("\u4f9b\u5e94\u5546");
            xbjOrderFlowSheetReqBO.setUserName(xbjRejectPurchaseOrderReqBO.getUserName());
            if (this.isDebugEnabled) {
                log.debug("\u8ba2\u5355\u6267\u884c\u6d41\u7a0b\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5165\u53c2-----------------------------------------------------");
                log.debug(JSON.toJSONString((Object)xbjOrderFlowSheetReqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            }
            if ((xbjOrderFlowSheetRspBO = this.xbjCreateOrderFlowSheetAtomService.createOrderFlowSheet(xbjOrderFlowSheetReqBO)) != null && "8888".equals(xbjOrderFlowSheetRspBO.getRespCode())) {
                throw new BusinessException(xbjOrderFlowSheetRspBO.getRespCode(), xbjOrderFlowSheetRspBO.getRespDesc());
            }
        }
        catch (BusinessException e) {
            throw new BusinessException(e.getMsgCode(), e.getMessage());
        }
        catch (Exception e) {
            log.error("\u62d2\u5355\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u62d2\u5355\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38");
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u6210\u529f");
        return rsp;
    }

    private OrderSaleXbjReqBO transferOrderSaleReqBO(OrderSaleXbjPO orderSaleXbjPO, String cancelReason, Integer oldStatus, Integer newStatus, Long userId) {
        OrderSaleXbjReqBO req = new OrderSaleXbjReqBO();
        req.setSaleOrderId(orderSaleXbjPO.getSaleOrderId());
        req.setSaleOrderStatus(newStatus);
        req.setSaleOrderOldStatus(oldStatus);
        req.setPurchaserId(orderSaleXbjPO.getPurchaserId());
        req.setPurchaserAccountId(orderSaleXbjPO.getPurchaserAccountId());
        req.setOperId(userId + "");
        req.setProfessionalOrganizationId(orderSaleXbjPO.getProfessionalOrganizationId());
        req.setCancelReason(cancelReason);
        req.setGoodsSupplierId(orderSaleXbjPO.getGoodsSupplierId());
        req.setModifyOprId(userId);
        req.setPurchaserAccountName(orderSaleXbjPO.getPurchaserAccountName());
        req.setSaleOrderType(orderSaleXbjPO.getSaleOrderType());
        return req;
    }

    private OrderPurchaseStatusChngReqBo transferOrderPurchaseStatusChngReqBO(Long userId, OrderPurchaseXbjPO orderPurchaseXbjPO, Integer purchaseOrderStatus, String arriveTime) {
        OrderPurchaseStatusChngReqBo req = new OrderPurchaseStatusChngReqBo();
        req.setPurchaseOrderId(orderPurchaseXbjPO.getPurchaseOrderId());
        req.setPurchaseOrderOldStatus(orderPurchaseXbjPO.getPurchaseOrderStatus());
        req.setPurchaseOrderStatus(purchaseOrderStatus);
        req.setPurchaserId(orderPurchaseXbjPO.getPurchaserId());
        req.setPurchaserAccountId(orderPurchaseXbjPO.getPurchaserAccountId());
        req.setOperId(userId + "");
        req.setProfessionalOrganizationId(orderPurchaseXbjPO.getProfessionalOrganizationId());
        req.setSaleOrderId(orderPurchaseXbjPO.getSaleOrderId());
        req.setArriveTime(arriveTime);
        return req;
    }

    private void validate(OrderPurchaseXbjPO orderPurchaseXbjPO) {
        if (orderPurchaseXbjPO == null) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6839\u636e\u91c7\u8d2d\u8ba2\u5355id[purchaseOrderId]\u67e5\u8be2\u4e0d\u5230\u91c7\u8d2d\u8ba2\u5355\u8bb0\u5f55");
        }
        if (!Constant.SALSE_ORDER_STATE_SUPPLY_CONFIRMING.equals(orderPurchaseXbjPO.getPurchaseOrderStatus()) && !Constant.SALSE_ORDER_STATE_TO_CONF.equals(orderPurchaseXbjPO.getPurchaseOrderStatus())) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u91c7\u8d2d\u8ba2\u5355\u72b6\u6001[purchaseOrderStatus]\u4e0d\u7b26\u5408\u8981\u6c42,\u91c7\u8d2d\u8ba2\u5355\u72b6\u6001\u5e94\u8be5\u4e3a  -> \u4f9b\u5e94\u5546\u786e\u8ba4\u4e2d \u6216 \u8ba2\u5355\u786e\u8ba4\u4e2d");
        }
    }

    private void validateParams(XbjRejectPurchaseOrderReqBO xbjRejectPurchaseOrderReqBO) {
        if (xbjRejectPurchaseOrderReqBO == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u7535\u529b\u4e13\u533a\u4f9b\u5e94\u5546\u91c7\u8d2d\u5355\u62d2\u5355\u5165\u53c2\u4e3a\u7a7a");
        }
        if (xbjRejectPurchaseOrderReqBO.getPurchaseOrderId() == null || xbjRejectPurchaseOrderReqBO.getPurchaseOrderId() == 0L) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u8ba2\u5355id[purchaseOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)xbjRejectPurchaseOrderReqBO.getCancelRemark())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u62d2\u5355\u539f\u56e0[cancelRemark]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void sendMessage(OrderSaleXbjPO orderSale, XbjRejectPurchaseOrderReqBO req) {
        try {
            SelectUserInfoByUserIdReqBO selectUserReq = new SelectUserInfoByUserIdReqBO();
            selectUserReq.setUserId(orderSale.getPurchaserAccountId());
            SelectUserInfoByUserIdRspBO userRspBO = this.selectUserInfoByUserIdBusiService.selectUserInfoByUserId(selectUserReq);
            if (userRspBO == null) {
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u4f9b\u5e94\u5546\u62d2\u5355\u5f02\u5e38\uff0c\u53d1\u9001\u77ed\u4fe1\u65f6\u67e5\u8be2\u7528\u6237\u65e0\u8bb0\u5f55\uff01");
            }
            SelectUserInfoByUserIdReqBO selectUserReq1 = new SelectUserInfoByUserIdReqBO();
            selectUserReq1.setUserId(orderSale.getDeliveryId());
            SelectUserInfoByUserIdRspBO userRspBO1 = this.selectUserInfoByUserIdBusiService.selectUserInfoByUserId(selectUserReq1);
            if (userRspBO1 == null) {
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u4f9b\u5e94\u5546\u62d2\u5355\u5f02\u5e38\uff0c\u53d1\u9001\u77ed\u4fe1\u65f6\u67e5\u8be2\u7528\u6237\u65e0\u8bb0\u5f55\uff01");
            }
            OrderSendMsgAtomXbjReqBO orderSendMsgBusiReq = new OrderSendMsgAtomXbjReqBO();
            HashMap<String, Object> smsParam = new HashMap<String, Object>();
            if (XbjOrderConstants.IS_DISPATCH_YES.equals(orderSale.getIsDispatch())) {
                orderSendMsgBusiReq.setSmsTemplateId(XbjOrderConstants.SEND_ORDER_REFUSE_DISPATCH_YES_JHCGY);
                smsParam.put("orderId", orderSale.getSaleOrderCode());
                smsParam.put("orderName", orderSale.getSaleOrderName());
                orderSendMsgBusiReq.setMessageAccount(orderSale.getDeliveryId() + "");
                orderSendMsgBusiReq.setMobile(userRspBO1.getCellphone());
            } else if (XbjOrderConstants.IS_DISPATCH_NO.equals(orderSale.getIsDispatch())) {
                orderSendMsgBusiReq.setSmsTemplateId(XbjOrderConstants.SEND_ORDER_REFUSE_DISPATCH_NO_JHCGY);
                smsParam.put("orderId", orderSale.getSaleOrderCode());
                smsParam.put("orderName", orderSale.getSaleOrderName());
                smsParam.put("supplyName", orderSale.getGoodsSupplierName());
                orderSendMsgBusiReq.setMessageAccount(orderSale.getPurchaserAccountId() + "");
                orderSendMsgBusiReq.setMobile(userRspBO.getCellphone());
            }
            orderSendMsgBusiReq.setSmsParam(smsParam);
            ArrayList<String> sendTypes = new ArrayList<String>();
            sendTypes.add("1");
            sendTypes.add("3");
            orderSendMsgBusiReq.setSendTypes(sendTypes);
            orderSendMsgBusiReq.setUserId(req.getUserId());
            orderSendMsgBusiReq.setRemindConfigureId(orderSendMsgBusiReq.getSmsTemplateId());
            orderSendMsgBusiReq.setOrderCode(orderSale.getSaleOrderCode());
            orderSendMsgBusiReq.setRemark1(orderSale.getSaleOrderId().toString());
            orderSendMsgBusiReq.setRemark2(orderSale.getPurchaseOrderId().toString());
            orderSendMsgBusiReq.setRemark3(orderSale.getPurchaserId().toString());
            RspInfoBO rspInfoBO = this.xbjOrderSendMsgAtomService.dealSendMsg(orderSendMsgBusiReq);
            if (!"0000".equals(rspInfoBO.getRespCode())) {
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u4f9b\u5e94\u5546\u62d2\u5355\u5f02\u5e38\uff0c\u53d1\u9001\u77ed\u4fe1\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            log.error("\u4f9b\u5e94\u5546\u62d2\u5355\u53d1\u9001\u7ad9\u5185\u4fe1\u5931\u8d25=====", (Throwable)e);
        }
    }
}

