/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.cgd.common.bo.RspInfoBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.AccessoryXbjAtomService;
import com.cgd.order.atom.GenerateOrderIdAndCodeXbjAtomService;
import com.cgd.order.atom.OrderPurchaseStatusChngXbjService;
import com.cgd.order.atom.OrderPurchaseXbjAtomService;
import com.cgd.order.atom.OrderSaleXbjAtomService;
import com.cgd.order.atom.XbjCreateOrderFlowSheetAtomService;
import com.cgd.order.atom.XbjCreateShipAndItemAtomService;
import com.cgd.order.atom.XbjOrderSendMsgAtomService;
import com.cgd.order.atom.bo.GenerateOrderIdAndCodeXbjReqBO;
import com.cgd.order.atom.bo.GenerateOrderIdAndCodeXbjRspBO;
import com.cgd.order.atom.bo.OrderPurchaseAtomServiceXbjRspBO;
import com.cgd.order.atom.bo.OrderPurchaseStatusChngReqBo;
import com.cgd.order.atom.bo.OrderSaleInfoXbjRspBO;
import com.cgd.order.atom.bo.OrderSaleXbjReqBO;
import com.cgd.order.atom.bo.OrderSendMsgAtomXbjReqBO;
import com.cgd.order.busi.XbjOrderDeliveryBusiService;
import com.cgd.order.busi.bo.XbjOrderFlowSheetReqBO;
import com.cgd.order.busi.bo.XbjOrderFlowSheetRspBO;
import com.cgd.order.busi.bo.XbjPurchaseAccessoryReqBO;
import com.cgd.order.busi.bo.XbjShipAndItemBusiReqBO;
import com.cgd.order.busi.bo.XbjShipAndItemBusiRspBO;
import com.cgd.order.busi.bo.XbjShipItemReqBO;
import com.cgd.order.constant.Constant;
import com.cgd.order.constant.OrderCenterConstant;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.OrderPurchaseItemXbjMapper;
import com.cgd.order.dao.OrderSaleItemXbjMapper;
import com.cgd.order.intfce.bo.XbjOrderDeliveryCreateReqBO;
import com.cgd.order.intfce.bo.XbjOrderDeliveryCreateRspBO;
import com.cgd.order.intfce.bo.XbjShipMaterielInfoBO;
import com.cgd.order.po.AccessoryXbjPO;
import com.cgd.order.po.OrderPurchaseItemXbjPO;
import com.cgd.order.po.OrderSaleItemXbjPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class XbjOrderDeliveryBusiServiceImpl
implements XbjOrderDeliveryBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjOrderDeliveryBusiServiceImpl.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private OrderPurchaseXbjAtomService orderPurchaseXbjAtomService;
    private OrderPurchaseItemXbjMapper orderPurchaseItemXbjMapper;
    private OrderSaleXbjAtomService orderSaleXbjAtomService;
    private XbjCreateShipAndItemAtomService xbjCreateShipAndItemAtomService;
    private AccessoryXbjAtomService accessoryXbjAtomService;
    private GenerateOrderIdAndCodeXbjAtomService generateOrderIdAndCodeXbjAtomService;
    private OrderPurchaseStatusChngXbjService orderPurchaseStatusChngXbjService;
    @Autowired
    private XbjCreateOrderFlowSheetAtomService xbjCreateOrderFlowSheetAtomService;
    @Autowired
    private XbjOrderSendMsgAtomService xbjOrderSendMsgAtomService;
    @Autowired
    private OrderSaleItemXbjMapper orderSaleItemXbjMapper;

    public void setOrderPurchaseXbjAtomService(OrderPurchaseXbjAtomService orderPurchaseXbjAtomService) {
        this.orderPurchaseXbjAtomService = orderPurchaseXbjAtomService;
    }

    public void setOrderPurchaseItemXbjMapper(OrderPurchaseItemXbjMapper orderPurchaseItemXbjMapper) {
        this.orderPurchaseItemXbjMapper = orderPurchaseItemXbjMapper;
    }

    public void setOrderSaleXbjAtomService(OrderSaleXbjAtomService orderSaleXbjAtomService) {
        this.orderSaleXbjAtomService = orderSaleXbjAtomService;
    }

    public void setXbjCreateShipAndItemAtomService(XbjCreateShipAndItemAtomService xbjCreateShipAndItemAtomService) {
        this.xbjCreateShipAndItemAtomService = xbjCreateShipAndItemAtomService;
    }

    public void setAccessoryXbjAtomService(AccessoryXbjAtomService accessoryXbjAtomService) {
        this.accessoryXbjAtomService = accessoryXbjAtomService;
    }

    public void setGenerateOrderIdAndCodeXbjAtomService(GenerateOrderIdAndCodeXbjAtomService generateOrderIdAndCodeXbjAtomService) {
        this.generateOrderIdAndCodeXbjAtomService = generateOrderIdAndCodeXbjAtomService;
    }

    public void setOrderPurchaseStatusChngXbjService(OrderPurchaseStatusChngXbjService orderPurchaseStatusChngXbjService) {
        this.orderPurchaseStatusChngXbjService = orderPurchaseStatusChngXbjService;
    }

    public XbjOrderDeliveryCreateRspBO dealWithXbjOrderShipCreate(XbjOrderDeliveryCreateReqBO xbjOrderDeliveryCreateReqBO) {
        XbjOrderDeliveryCreateRspBO rspBO = new XbjOrderDeliveryCreateRspBO();
        try {
            XbjOrderFlowSheetRspBO xbjOrderFlowSheetRspBO;
            OrderSaleInfoXbjRspBO orderSaleRspBO;
            this.dealWithParamVerify(xbjOrderDeliveryCreateReqBO);
            OrderPurchaseAtomServiceXbjRspBO orderPurchaseXbjBO = this.orderPurchaseXbjAtomService.qryOrderPurchase(xbjOrderDeliveryCreateReqBO.getPurchaseOrderId(), xbjOrderDeliveryCreateReqBO.getPurchaserId());
            if (!"0000".equals(orderPurchaseXbjBO.getRespCode())) {
                rspBO.setRespCode(orderPurchaseXbjBO.getRespCode());
                rspBO.setRespDesc("\u53d1\u8d27\u64cd\u4f5c\u53d6\u6d88");
                rspBO.setResultDesc("\u672a\u67e5\u8be2\u5230\u8be5\u91c7\u8d2d\u5355\u4fe1\u606f");
                return rspBO;
            }
            List<OrderPurchaseItemXbjPO> orderPurchaseItemXbjList = this.dealWithBusiVerify(xbjOrderDeliveryCreateReqBO, orderPurchaseXbjBO);
            if (orderPurchaseItemXbjList == null || orderPurchaseItemXbjList.size() < 1) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u53d1\u8d27\u64cd\u4f5c\u5df2\u53d6\u6d88");
                rspBO.setResultDesc("\u672a\u67e5\u8be2\u5230\u8be5\u91c7\u8d2d\u8ba2\u5355\u7684\u8be6\u7ec6\u4fe1\u606f");
                return rspBO;
            }
            XbjShipAndItemBusiReqBO xbjShipAndItemBusiReqBO = new XbjShipAndItemBusiReqBO();
            xbjShipAndItemBusiReqBO = this.initParams(orderPurchaseXbjBO, orderPurchaseItemXbjList, xbjOrderDeliveryCreateReqBO);
            XbjShipAndItemBusiRspBO xbjShipAndItemBusiRspBO = this.xbjCreateShipAndItemAtomService.createXbjShipAndItem(xbjShipAndItemBusiReqBO);
            if (null == xbjShipAndItemBusiRspBO || !xbjShipAndItemBusiRspBO.getRespCode().equals("0000")) {
                if (isDebugEnabled) {
                    log.debug("\u8be2\u6bd4\u4ef7\u7269\u8d44\u53d1\u8d27\u5355\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38:" + xbjShipAndItemBusiRspBO.getRespDesc());
                }
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u53d1\u8d27\u5355\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38:" + xbjShipAndItemBusiRspBO.getRespDesc());
            }
            if (null != xbjOrderDeliveryCreateReqBO.getPurchaseAccessoryReqList() && xbjOrderDeliveryCreateReqBO.getPurchaseAccessoryReqList().size() > 0) {
                List<AccessoryXbjPO> accessoryXbjPoList = this.assembleAccessoryData(xbjShipAndItemBusiRspBO.getShipOrderId(), orderPurchaseXbjBO, OrderCenterConstant.OBJRCT_TYPE.SHIP_ORDER, xbjOrderDeliveryCreateReqBO.getPurchaseAccessoryReqList());
                this.accessoryXbjAtomService.batchSave(accessoryXbjPoList);
            }
            if ((orderSaleRspBO = this.orderSaleXbjAtomService.selectOrderSaleById(orderPurchaseXbjBO.getSaleOrderId(), orderPurchaseXbjBO.getPurchaserId())) != null) {
                if (XbjOrderConstants.XBJ_SALE_ORDER_STATUS.WAIT_SENDING.equals(orderSaleRspBO.getSaleOrderStatus())) {
                    OrderSaleXbjReqBO statusReqBO = new OrderSaleXbjReqBO();
                    statusReqBO.setSaleOrderId(orderPurchaseXbjBO.getSaleOrderId());
                    statusReqBO.setSaleOrderStatus(XbjOrderConstants.XBJ_SALE_PURCHASE_ORDER_STATUS.SENDING);
                    statusReqBO.setPurchaserId(orderPurchaseXbjBO.getPurchaserId());
                    statusReqBO.setPurchaserAccountId(orderPurchaseXbjBO.getPurchaserAccountId());
                    statusReqBO.setModifyOprId(xbjOrderDeliveryCreateReqBO.getUserId());
                    statusReqBO.setOperId(String.valueOf(xbjOrderDeliveryCreateReqBO.getUserId()));
                    statusReqBO.setProfessionalOrganizationId(orderPurchaseXbjBO.getProfessionalOrganizationId());
                    this.orderSaleXbjAtomService.updateSaleOrderStatus(statusReqBO);
                }
            } else {
                log.error("\u8be2\u6bd4\u4ef7\u7269\u8d44\u53d1\u8d27\u5355\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u5f02\u5e38:\u9500\u552e\u8ba2\u5355\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u53d1\u8d27\u5355\u521b\u5efa\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38:\u672a\u67e5\u8be2\u5230\u9500\u552e\u8ba2\u5355");
            }
            if (XbjOrderConstants.XBJ_SALE_PURCHASE_ORDER_STATUS.WAIT_SENDING.equals(orderPurchaseXbjBO.getPurchaseOrderStatus())) {
                OrderPurchaseStatusChngReqBo orderPurchaseStatusChngReqBo = new OrderPurchaseStatusChngReqBo();
                orderPurchaseStatusChngReqBo.setPurchaseOrderId(orderPurchaseXbjBO.getPurchaseOrderId());
                orderPurchaseStatusChngReqBo.setPurchaseOrderOldStatus(orderPurchaseXbjBO.getPurchaseOrderStatus());
                orderPurchaseStatusChngReqBo.setPurchaseOrderStatus(XbjOrderConstants.XBJ_SALE_PURCHASE_ORDER_STATUS.SENDING);
                orderPurchaseStatusChngReqBo.setPurchaserId(orderPurchaseXbjBO.getPurchaserId());
                orderPurchaseStatusChngReqBo.setPurchaserAccountId(orderPurchaseXbjBO.getPurchaserAccountId());
                orderPurchaseStatusChngReqBo.setOperId(xbjOrderDeliveryCreateReqBO.getUserId() + "");
                orderPurchaseStatusChngReqBo.setProfessionalOrganizationId(orderPurchaseXbjBO.getProfessionalOrganizationId());
                orderPurchaseStatusChngReqBo.setSaleOrderId(orderPurchaseXbjBO.getSaleOrderId());
                this.orderPurchaseStatusChngXbjService.dealOrderPurchaseStatus(orderPurchaseStatusChngReqBo);
            }
            this.sendMessage(orderSaleRspBO, xbjOrderDeliveryCreateReqBO, xbjShipAndItemBusiReqBO.getShipOrderCode(), orderPurchaseXbjBO.getIsDispatch());
            XbjOrderFlowSheetReqBO xbjOrderFlowSheetReqBO = new XbjOrderFlowSheetReqBO();
            BeanUtils.copyProperties((Object)xbjOrderDeliveryCreateReqBO, (Object)xbjOrderFlowSheetReqBO);
            xbjOrderFlowSheetReqBO.setOrderId(xbjOrderDeliveryCreateReqBO.getPurchaseOrderId());
            xbjOrderFlowSheetReqBO.setOrderType(Constant.ORDER_TYPE_PURCHASE);
            xbjOrderFlowSheetReqBO.setPurchaserId(xbjOrderDeliveryCreateReqBO.getPurchaserId());
            xbjOrderFlowSheetReqBO.setOrderBusiType("B_17");
            xbjOrderFlowSheetReqBO.setOperRole("\u4f9b\u5e94\u5546");
            xbjOrderFlowSheetReqBO.setUserId(xbjOrderDeliveryCreateReqBO.getUserId());
            xbjOrderFlowSheetReqBO.setCompanyName(xbjOrderDeliveryCreateReqBO.getCompanyName());
            xbjOrderFlowSheetReqBO.setUserName(xbjOrderDeliveryCreateReqBO.getUserName());
            if (isDebugEnabled) {
                log.debug("\u8ba2\u5355\u6267\u884c\u6d41\u7a0b\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5165\u53c2-----------------------------------------------------");
                log.debug(JSON.toJSONString((Object)xbjOrderFlowSheetReqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            }
            if ((xbjOrderFlowSheetRspBO = this.xbjCreateOrderFlowSheetAtomService.createOrderFlowSheet(xbjOrderFlowSheetReqBO)) != null && "8888".equals(xbjOrderFlowSheetRspBO.getRespCode())) {
                throw new BusinessException(xbjOrderFlowSheetRspBO.getRespCode(), xbjOrderFlowSheetRspBO.getRespDesc());
            }
            return rspBO;
        }
        catch (BusinessException e) {
            if (isDebugEnabled) {
                log.debug("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u53d1\u8d27\u7ec4\u5408\u670d\u52a1BusinessException");
            }
            log.error("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u53d1\u8d27\u7ec4\u5408\u670d\u52a1\u63d0\u4ea4\u5f02\u5e38\uff01" + e.getMessage(), (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u53d1\u8d27\u7ec4\u5408\u670d\u52a1\u63d0\u4ea4\u5931\u8d25" + e.getMessage());
            return rspBO;
        }
        catch (Exception e) {
            log.error("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u53d1\u8d27\u7ec4\u5408\u670d\u52a1 \u5f02\u5e38", (Throwable)e);
            if (isDebugEnabled) {
                log.debug("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u53d1\u8d27\u7ec4\u5408\u670d\u52a1BusinessException");
            }
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u53d1\u8d27\u7ec4\u5408\u670d\u52a1\u63d0\u4ea4\u5931\u8d25" + e.getMessage());
            return rspBO;
        }
    }

    private void dealWithParamVerify(XbjOrderDeliveryCreateReqBO xbjOrderDeliveryCreateReqBO) {
        try {
            if (xbjOrderDeliveryCreateReqBO == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u7269\u8d44\u53d1\u8d27\u5355\u751f\u6210:\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (xbjOrderDeliveryCreateReqBO.getPurchaseOrderId() == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u7269\u8d44\u53d1\u8d27\u5355\u751f\u6210:\u5165\u53c2\u91c7\u8d2d\u8ba2\u5355Id[PurchaseOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (xbjOrderDeliveryCreateReqBO.getPurchaserId() == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u7269\u8d44\u53d1\u8d27\u5355\u751f\u6210:\u5165\u53c2\u91c7\u8d2d\u5546Id[PurchaserId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (xbjOrderDeliveryCreateReqBO.getShipName() == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u7269\u8d44\u53d1\u8d27\u5355\u751f\u6210:\u53d1\u8d27\u8054\u7cfb\u4eba\u59d3\u540d[ShipName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (xbjOrderDeliveryCreateReqBO.getShipPhone() == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u7269\u8d44\u53d1\u8d27\u5355\u751f\u6210:\u53d1\u8d27\u8054\u7cfb\u4eba\u7535\u8bdd[ShipPhone]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (xbjOrderDeliveryCreateReqBO.getShipMaterielInfoList() == null || xbjOrderDeliveryCreateReqBO.getShipMaterielInfoList().size() < 1) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u7269\u8d44\u53d1\u8d27\u5355\u751f\u6210:\u7269\u6599\u4fe1\u606f\u96c6\u5408[shipMaterielInfoList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            List shipMaterielInfoList = xbjOrderDeliveryCreateReqBO.getShipMaterielInfoList();
            for (XbjShipMaterielInfoBO xbjShipMaterielInfoBO : shipMaterielInfoList) {
                if (StringUtils.isEmpty((Object)xbjShipMaterielInfoBO.getPurchaseOrderItemId())) {
                    throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u7269\u8d44\u53d1\u8d27\u5355\u751f\u6210:\u91c7\u8d2d\u660e\u7ec6\u7f16\u7801\uff01");
                }
                if (xbjShipMaterielInfoBO.getShipCount() != null && xbjShipMaterielInfoBO.getShipCount().compareTo(BigDecimal.ZERO) >= 1) continue;
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u7269\u8d44\u53d1\u8d27\u5355\u751f\u6210:\u7269\u6599\u4fe1\u606f\u96c6\u5408\u4e2d\u7269\u6599\u6570\u91cf\u4fe1\u606f\u6709\u8bef\uff01");
            }
        }
        catch (Exception e) {
            log.error("\u8be2\u6bd4\u4ef7\u7269\u8d44\u53d1\u8d27\u5355\u751f\u6210\u5165\u53c2\u6821\u9a8c\u5f02\u5e38:", (Throwable)e);
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", e.getMessage());
        }
    }

    private List<OrderPurchaseItemXbjPO> dealWithBusiVerify(XbjOrderDeliveryCreateReqBO xbjOrderDeliveryCreateReqBO, OrderPurchaseAtomServiceXbjRspBO orderPurchaseXbjBO) {
        ArrayList<OrderPurchaseItemXbjPO> orderPurchaseItemList = new ArrayList<OrderPurchaseItemXbjPO>();
        try {
            if (orderPurchaseXbjBO.getPurchaseOrderStatus() == null) {
                if (isDebugEnabled) {
                    log.debug("\u91c7\u8d2d\u8ba2\u5355[" + orderPurchaseXbjBO.getPurchaseOrderId() + "]\u5f53\u524d\u72b6\u6001\u65e0\u6cd5\u53d1\u8d27\uff1a\u72b6\u6001\u4e3a\u7a7a");
                }
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u91c7\u8d2d\u8ba2\u5355\u5f53\u524d\u72b6\u6001\u65e0\u6cd5\u53d1\u8d27\uff01");
            }
            if (!XbjOrderConstants.XBJ_SALE_PURCHASE_ORDER_STATUS.WAIT_SENDING.equals(orderPurchaseXbjBO.getPurchaseOrderStatus()) && !XbjOrderConstants.XBJ_SALE_PURCHASE_ORDER_STATUS.SENDING.equals(orderPurchaseXbjBO.getPurchaseOrderStatus())) {
                if (isDebugEnabled) {
                    log.debug("\u91c7\u8d2d\u8ba2\u5355[" + orderPurchaseXbjBO.getPurchaseOrderId() + "]\u5f53\u524d\u72b6\u6001[" + orderPurchaseXbjBO.getPurchaseOrderStatus() + "]\u65e0\u6cd5\u53d1\u8d27\uff01");
                }
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u91c7\u8d2d\u8ba2\u5355\u5f53\u524d\u72b6\u6001[" + orderPurchaseXbjBO.getPurchaseOrderStatus() + "]\u65e0\u6cd5\u53d1\u8d27\uff01");
            }
            if (!XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_WUZI.equals(orderPurchaseXbjBO.getSaleOrderPurchaseType())) {
                if (isDebugEnabled) {
                    log.debug("\u91c7\u8d2d\u8ba2\u5355[" + orderPurchaseXbjBO.getPurchaseOrderId() + "]\u5f53\u524d\u7c7b\u578b[" + orderPurchaseXbjBO.getSaleOrderPurchaseType() + "]\u65e0\u6cd5\u53d1\u8d27\uff01");
                }
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u91c7\u8d2d\u8ba2\u5355\u5f53\u524d\u7c7b\u578b[" + orderPurchaseXbjBO.getSaleOrderPurchaseType() + "]\u65e0\u6cd5\u53d1\u8d27\uff01");
            }
            if (orderPurchaseXbjBO.getWholeAcceptance() == null) {
                if (isDebugEnabled) {
                    log.debug("\u91c7\u8d2d\u8ba2\u5355[" + orderPurchaseXbjBO.getPurchaseOrderId() + "]\u5f53\u524d\u6574\u5355\u9a8c\u6536\u6807\u8bc6\u65e0\u6cd5\u53d1\u8d27\uff1a\u6574\u5355\u9a8c\u6536\u6807\u8bc6\u4e3a\u7a7a");
                }
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u91c7\u8d2d\u8ba2\u5355\u5f53\u524d\u6574\u5355\u9a8c\u6536\u6807\u8bc6\u65e0\u6cd5\u53d1\u8d27\uff01");
            }
            if (XbjOrderConstants.SALE_ORDER_PURCHASE_WHOLE_ACCEPTANCE_YES == orderPurchaseXbjBO.getWholeAcceptance()) {
                if (isDebugEnabled) {
                    log.debug("\u91c7\u8d2d\u8ba2\u5355[" + orderPurchaseXbjBO.getPurchaseOrderId() + "]\u5f53\u524d\u9a8c\u6536\u6807\u8bc6[" + orderPurchaseXbjBO.getWholeAcceptance() + "]\u65e0\u6cd5\u53d1\u8d27\uff01");
                }
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u91c7\u8d2d\u8ba2\u5355\u5f53\u524d\u6574\u5355\u9a8c\u6536\u6807\u8bc6\u72b6\u6001\u65e0\u6cd5\u53d1\u8d27\uff01");
            }
            if (isDebugEnabled) {
                log.debug("\u91c7\u8d2d\u8ba2\u5355[\u4e2d------------------------------------");
            }
            List shipMaterielInfoList = xbjOrderDeliveryCreateReqBO.getShipMaterielInfoList();
            for (XbjShipMaterielInfoBO shipMaterielInfoBO : shipMaterielInfoList) {
                if (isDebugEnabled) {
                    log.debug("\u91c7\u8d2d\u8ba2\u5355[\u5faa\u73af------------------------------------");
                }
                OrderPurchaseItemXbjPO record = new OrderPurchaseItemXbjPO();
                record.setPurchaseOrderId(orderPurchaseXbjBO.getPurchaseOrderId());
                record.setPurchaserId(orderPurchaseXbjBO.getPurchaserId());
                record.setPurchaseOrderItemId(shipMaterielInfoBO.getPurchaseOrderItemId());
                OrderPurchaseItemXbjPO orderPurchaseItem = this.orderPurchaseItemXbjMapper.selectByCondition(record);
                if (null == orderPurchaseItem) {
                    if (isDebugEnabled) {
                        log.debug("\u6570\u636e\u4fe1\u606f\u5f02\u5e38\uff0cmaterialId[" + record.toString() + "]\u65e0\u6cd5\u5b9a\u4f4d\u5230\u6307\u5b9a\u91c7\u8d2d\u5355\u660e\u7ec6");
                    }
                    throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u6570\u636e\u4fe1\u606f\u5f02\u5e38\uff0c\u65e0\u6cd5\u5b9a\u4f4d\u5230\u6307\u5b9a\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6");
                }
                BigDecimal shipTotalCount = orderPurchaseItem.getSendCount().add(shipMaterielInfoBO.getShipCount());
                BigDecimal purchaseTotalCount = orderPurchaseItem.getPurchaseCount();
                if (isDebugEnabled) {
                    log.debug("\u7edf\u8ba1\u6240\u6709\u91c7\u8d2d\u8ba2\u5355\u7684\u53d1\u8d27\u6570\u91cf" + shipTotalCount);
                    log.debug("\u7edf\u8ba1\u6240\u6709\u91c7\u8d2d\u8ba2\u5355\u7684\u91c7\u8d2d\u6570\u91cf" + purchaseTotalCount);
                }
                if (XbjOrderConstants.SALE_ORDER_TYPE.FRAME.equals(orderPurchaseXbjBO.getOrderType()) || XbjOrderConstants.SALE_ORDER_TYPE.TOTAL.equals(orderPurchaseXbjBO.getOrderType())) {
                    if (isDebugEnabled) {
                        log.debug("\u603b\u4ef7\u6027\u6216\u8005 \u6846\u67b6\u578b" + orderPurchaseXbjBO.getOrderType());
                        log.debug("\u7edf\u8ba1\u6240\u6709\u91c7\u8d2d\u8ba2\u5355\u7684\u53d1\u8d27\u6570\u91cf" + shipTotalCount);
                        log.debug("\u7edf\u8ba1\u6240\u6709\u91c7\u8d2d\u8ba2\u5355\u7684\u91c7\u8d2d\u6570\u91cf" + purchaseTotalCount);
                    }
                    if (shipTotalCount.compareTo(purchaseTotalCount) > 0) {
                        if (isDebugEnabled) {
                            log.debug("\u6570\u636e\u4fe1\u606f\u5f02\u5e38\uff0c\u5f53\u524d\u53d1\u8d27\u603b\u91cf\u5927\u4e8e\u6b64\u8ba2\u5355\u91c7\u8d2d\u6570\u91cf");
                        }
                        throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", orderPurchaseItem.getMaterialName() + "\u7684\u5f53\u524d\u53d1\u8d27\u603b\u91cf\u5927\u4e8e\u6b64\u8ba2\u5355\u91c7\u8d2d\u6570\u91cf");
                    }
                } else if (XbjOrderConstants.SALE_ORDER_TYPE.SINGLE.equals(orderPurchaseXbjBO.getOrderType())) {
                    BigDecimal newPurchaseTotalCount = purchaseTotalCount.multiply(new BigDecimal(1.2)).setScale(2, 4);
                    if (isDebugEnabled) {
                        log.debug("\u603b\u4ef7\u6027\u6216\u8005 \u5355\u4ef7\u578b" + orderPurchaseXbjBO.getOrderType());
                        log.debug("\u7edf\u8ba1\u6240\u6709\u91c7\u8d2d\u8ba2\u5355\u7684\u53d1\u8d27\u6570\u91cf" + shipTotalCount);
                        log.debug("\u7edf\u8ba1\u6240\u6709\u91c7\u8d2d\u8ba2\u5355\u7684\u91c7\u8d2d\u6570\u91cf" + purchaseTotalCount);
                    }
                    if (shipTotalCount.compareTo(newPurchaseTotalCount) > 0) {
                        if (isDebugEnabled) {
                            log.debug("\u6570\u636e\u4fe1\u606f\u5f02\u5e38\uff0c\u5f53\u524d\u53d1\u8d27\u603b\u91cf\u5927\u4e8e\u6b64\u8ba2\u5355\u91c7\u8d2d\u6570\u91cf");
                        }
                        throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", orderPurchaseItem.getMaterialName() + "\u7684\u5f53\u524d\u53d1\u8d27\u603b\u91cf\u5927\u4e8e\u6b64\u8ba2\u5355\u91c7\u8d2d\u6570\u91cf\u7684120%");
                    }
                }
                orderPurchaseItem.setSendCount(shipMaterielInfoBO.getShipCount());
                orderPurchaseItemList.add(orderPurchaseItem);
            }
            if (isDebugEnabled) {
                log.debug("\u6821\u9a8c\u901a\u8fc7");
            }
        }
        catch (BusinessException e) {
            log.error("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u670d\u52a1\u9a8c\u6536\u7ec4\u5408\u670d\u52a1\u63d0\u4ea4\u5f02\u5e38\uff01" + e.getMessage(), (Throwable)e);
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", e.getMessage());
        }
        catch (Exception e) {
            log.error("\u8be2\u6bd4\u4ef7\u7269\u8d44\u53d1\u8d27\u5355\u751f\u6210\u4e1a\u52a1\u6821\u9a8c\u5f02\u5e38:", (Throwable)e);
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", e.getMessage());
        }
        return orderPurchaseItemList;
    }

    private XbjShipAndItemBusiReqBO initParams(OrderPurchaseAtomServiceXbjRspBO orderPurchaseXbjBO, List<OrderPurchaseItemXbjPO> orderPurchaseItemList, XbjOrderDeliveryCreateReqBO xbjOrderDeliveryCreateReqBO) {
        XbjShipAndItemBusiReqBO shipAndItemBusiReq = new XbjShipAndItemBusiReqBO();
        OrderSaleInfoXbjRspBO orderSaleInfoRsp = this.orderSaleXbjAtomService.selectOrderSaleById(orderPurchaseXbjBO.getSaleOrderId(), orderPurchaseXbjBO.getPurchaserId());
        try {
            GenerateOrderIdAndCodeXbjReqBO generateOrderIdAndCodeXbjReqBO = new GenerateOrderIdAndCodeXbjReqBO();
            generateOrderIdAndCodeXbjReqBO.setGenerateOrderType(XbjOrderConstants.GENERATE_ORDER_TYPE.SHIP);
            generateOrderIdAndCodeXbjReqBO.setPurchaseOrderId(orderPurchaseXbjBO.getPurchaseOrderId());
            generateOrderIdAndCodeXbjReqBO.setPurchaseId(orderPurchaseXbjBO.getPurchaserId());
            GenerateOrderIdAndCodeXbjRspBO generateOrderIdAndCodeXbjRspBO = this.generateOrderIdAndCodeXbjAtomService.generateOrderIdAndCode(generateOrderIdAndCodeXbjReqBO);
            shipAndItemBusiReq.setShipOrderId(generateOrderIdAndCodeXbjRspBO.getOrderId());
            shipAndItemBusiReq.setShipOrderCode(generateOrderIdAndCodeXbjRspBO.getOrderCode());
            shipAndItemBusiReq.setPurchaseOrderId(orderPurchaseXbjBO.getPurchaseOrderId());
            shipAndItemBusiReq.setPurchaseOrderCode(orderPurchaseXbjBO.getPurchaseOrderCode());
            shipAndItemBusiReq.setSaleOrderCode(orderSaleInfoRsp.getSaleOrderCode());
            shipAndItemBusiReq.setSaleOrderId(orderPurchaseXbjBO.getSaleOrderId());
            shipAndItemBusiReq.setPurchaserId(orderPurchaseXbjBO.getPurchaserId());
            shipAndItemBusiReq.setPurchaserAccountId(orderPurchaseXbjBO.getPurchaserAccountId());
            shipAndItemBusiReq.setPurchaserAccountName(orderPurchaseXbjBO.getPurchaseOrderName());
            shipAndItemBusiReq.setProfessionalOrganizationId(orderPurchaseXbjBO.getProfessionalOrganizationId());
            shipAndItemBusiReq.setGoodsSupplierId(orderPurchaseXbjBO.getGoodsSupplierId());
            shipAndItemBusiReq.setShipStatus("4");
            shipAndItemBusiReq.setShipDate(new Date());
            shipAndItemBusiReq.setShipId(xbjOrderDeliveryCreateReqBO.getShipId());
            shipAndItemBusiReq.setShipName(xbjOrderDeliveryCreateReqBO.getShipName());
            shipAndItemBusiReq.setShipPhone(xbjOrderDeliveryCreateReqBO.getShipPhone());
            if (null != xbjOrderDeliveryCreateReqBO.getPurchaseAccessoryReqList() && xbjOrderDeliveryCreateReqBO.getPurchaseAccessoryReqList().size() > 0) {
                shipAndItemBusiReq.setIsEnclosure(OrderCenterConstant.IS_ENCLOSURE.YES);
            } else {
                shipAndItemBusiReq.setIsEnclosure(OrderCenterConstant.IS_ENCLOSURE.NO);
            }
            shipAndItemBusiReq.setOperId(xbjOrderDeliveryCreateReqBO.getUserId());
            shipAndItemBusiReq.setCreateTime(new Date());
            ArrayList<XbjShipItemReqBO> ShipItemReqList = new ArrayList<XbjShipItemReqBO>();
            for (OrderPurchaseItemXbjPO orderPurchaseItem : orderPurchaseItemList) {
                XbjShipItemReqBO shipItemReq = new XbjShipItemReqBO();
                BeanUtils.copyProperties((Object)orderPurchaseItem, (Object)shipItemReq);
                shipItemReq.setPurchaseOrderItemId(orderPurchaseItem.getPurchaseOrderItemId());
                shipItemReq.setPurchaseCount(orderPurchaseItem.getSendCount());
                shipItemReq.setPurchaseOrderId(orderPurchaseXbjBO.getPurchaseOrderId());
                shipItemReq.setSaleOrderId(orderPurchaseXbjBO.getSaleOrderId());
                shipItemReq.setSaleOrderItemId(orderPurchaseItem.getSaleOrderItemId());
                shipItemReq.setPurchaserId(orderPurchaseXbjBO.getPurchaserId());
                shipItemReq.setPurchaserAccountId(orderPurchaseXbjBO.getPurchaserAccountId());
                shipItemReq.setPurchaserAccountName(orderPurchaseXbjBO.getPurchaserAccountName());
                shipItemReq.setProfessionalOrganizationId(orderPurchaseXbjBO.getProfessionalOrganizationId());
                shipItemReq.setGoodsSupplierId(orderPurchaseXbjBO.getGoodsSupplierId());
                shipItemReq.setSkuId(orderPurchaseItem.getSkuId());
                shipItemReq.setSkuName(orderPurchaseItem.getSkuName());
                ShipItemReqList.add(shipItemReq);
            }
            shipAndItemBusiReq.setShipItemList(ShipItemReqList);
        }
        catch (Exception e) {
            if (isDebugEnabled) {
                log.debug("\u8be2\u6bd4\u4ef7\u7269\u8d44\u53d1\u8d27\u5355\u751f\u6210\u4e1a\u52a1,\u5b9e\u4f8b\u5316\u53c2\u6570\u5f02\u5e38:" + e.getMessage());
            }
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", e.getMessage());
        }
        return shipAndItemBusiReq;
    }

    private List<AccessoryXbjPO> assembleAccessoryData(Long shipOrderId, OrderPurchaseAtomServiceXbjRspBO orderPurchaseXbjBO, Integer paramObjectType, List<XbjPurchaseAccessoryReqBO> purchaseAccessoryReqList) {
        ArrayList<AccessoryXbjPO> accessoryList = new ArrayList<AccessoryXbjPO>();
        for (XbjPurchaseAccessoryReqBO purchaseAccessoryReqBO : purchaseAccessoryReqList) {
            AccessoryXbjPO accessory = new AccessoryXbjPO();
            accessory.setAccessoryId(purchaseAccessoryReqBO.getAccessoryId());
            accessory.setAccessoryName(purchaseAccessoryReqBO.getAccessoryName());
            accessory.setAccessoryUrl(purchaseAccessoryReqBO.getAccessoryUrl());
            accessory.setCreateDate(new Date());
            accessory.setGoodsSupplierId(String.valueOf(orderPurchaseXbjBO.getGoodsSupplierId()));
            accessory.setObjectId(shipOrderId);
            accessory.setObjectType(paramObjectType);
            accessory.setProfessionalOrganizationId(String.valueOf(orderPurchaseXbjBO.getProfessionalOrganizationId()));
            accessory.setPurchaserAccountId(orderPurchaseXbjBO.getPurchaserAccountId());
            accessory.setPurchaserAccountName(orderPurchaseXbjBO.getPurchaserAccountName());
            accessory.setPurchaserId(orderPurchaseXbjBO.getPurchaserId());
            accessory.setRemark("\u8be2\u6bd4\u4ef7\u7269\u8d44\u53d1\u8d27\u5355\u521b\u5efa");
            accessoryList.add(accessory);
        }
        return accessoryList;
    }

    private void sendMessage(OrderSaleInfoXbjRspBO orderSale, XbjOrderDeliveryCreateReqBO reqBO, String shipOrderCode, Integer isDispatch) {
        try {
            OrderSendMsgAtomXbjReqBO orderSendMsgBusiReq = new OrderSendMsgAtomXbjReqBO();
            if (XbjOrderConstants.SALE_ORDER_TYPE_XBJ.equals(orderSale.getSaleOrderType())) {
                OrderSaleItemXbjPO orderSaleItemPO = new OrderSaleItemXbjPO();
                orderSaleItemPO.setSaleOrderId(orderSale.getSaleOrderId());
                List<OrderSaleItemXbjPO> itemList = this.orderSaleItemXbjMapper.getList(orderSaleItemPO);
                if (itemList != null && itemList.size() > 0) {
                    ArrayList<Long> planUserAllList = new ArrayList<Long>();
                    for (OrderSaleItemXbjPO po : itemList) {
                        if (po.getPlanUserId() == null) continue;
                        planUserAllList.add(po.getPlanUserId());
                    }
                    ArrayList<Long> newUserList = new ArrayList<Long>();
                    if (planUserAllList.size() > 0) {
                        for (Long userId : planUserAllList) {
                            if (newUserList.contains(userId)) continue;
                            newUserList.add(userId);
                        }
                    }
                    orderSendMsgBusiReq.setReceiveList(newUserList);
                }
            } else if (XbjOrderConstants.SALE_ORDER_TYPE_KJXY.equals(orderSale.getSaleOrderType())) {
                orderSendMsgBusiReq.setMessageAccount(orderSale.getPurchaserAccountId() + "");
            }
            orderSendMsgBusiReq.setSmsTemplateId(XbjOrderConstants.SEND_ORDER_DELIVERY_JHCGY);
            ArrayList<String> sendTypes = new ArrayList<String>();
            sendTypes.add("3");
            orderSendMsgBusiReq.setSendTypes(sendTypes);
            HashMap<String, Object> smsParam = new HashMap<String, Object>();
            smsParam.put("orderId", orderSale.getSaleOrderCode());
            smsParam.put("orderName", orderSale.getSaleOrderName());
            smsParam.put("shipId", shipOrderCode);
            orderSendMsgBusiReq.setSmsParam(smsParam);
            orderSendMsgBusiReq.setUserId(reqBO.getUserId());
            if (orderSendMsgBusiReq.getReceiveList() == null || orderSendMsgBusiReq.getReceiveList().size() == 0) {
                orderSendMsgBusiReq.setMessageAccount(orderSale.getPurchaserAccountId() + "");
            }
            orderSendMsgBusiReq.setRemindConfigureId(orderSendMsgBusiReq.getSmsTemplateId());
            orderSendMsgBusiReq.setOrderCode(orderSale.getSaleOrderCode());
            orderSendMsgBusiReq.setRemark1(orderSale.getSaleOrderId().toString());
            orderSendMsgBusiReq.setRemark2(orderSale.getPurchaseOrderId().toString());
            orderSendMsgBusiReq.setRemark3(orderSale.getPurchaserId().toString());
            RspInfoBO rspInfoBO = this.xbjOrderSendMsgAtomService.dealSendMsg(orderSendMsgBusiReq);
            log.error("\u4f9b\u5e94\u5546\u53d1\u8d27\u53d1\u9001\u7ad9\u5185\u4fe1\u8fd4\u56de\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)rspInfoBO));
            if (!"0000".equals(rspInfoBO.getRespCode())) {
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u4f9b\u5e94\u5546\u53d1\u8d27\u5f02\u5e38\uff0c\u53d1\u9001\u7ad9\u5185\u4fe1\u5931\u8d25\uff01");
            }
            if (XbjOrderConstants.IS_DISPATCH_YES.equals(isDispatch)) {
                orderSendMsgBusiReq.setSmsTemplateId(XbjOrderConstants.SEND_ORDER_DELIVERY_PSZZ);
                ArrayList<Long> newUserList1 = new ArrayList<Long>();
                orderSendMsgBusiReq.setReceiveList(newUserList1);
                orderSendMsgBusiReq.setMessageAccount(orderSale.getDeliveryId() + "");
                smsParam = new HashMap();
                smsParam.put("purchaseId", orderSale.getPurchaseOrderCode());
                smsParam.put("purchaseName", orderSale.getSaleOrderName());
                smsParam.put("shipId", shipOrderCode);
                orderSendMsgBusiReq.setSmsParam(smsParam);
                RspInfoBO rspInfoBO1 = this.xbjOrderSendMsgAtomService.dealSendMsg(orderSendMsgBusiReq);
                log.error("\u4f9b\u5e94\u5546\u53d1\u8d27\u53d1\u9001\u7ad9\u5185\u4fe1\u8fd4\u56de\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)rspInfoBO1));
                if (!"0000".equals(rspInfoBO1.getRespCode())) {
                    throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u4f9b\u5e94\u5546\u53d1\u8d27\u5f02\u5e38\uff0c\u53d1\u9001\u7ad9\u5185\u4fe1\u5931\u8d25\uff01");
                }
            }
        }
        catch (Exception e) {
            log.error("\u4f9b\u5e94\u5546\u53d1\u8d27\u53d1\u9001\u7ad9\u5185\u4fe1\u5931\u8d25=====", (Throwable)e);
        }
    }
}

