/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.alibaba.fastjson.JSON;
import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.ArrivalRegistrationXbjAtomService;
import com.cgd.order.atom.bo.ArrivalRegistrationAtomXbjReqBO;
import com.cgd.order.busi.bo.XbjArrivalRegistrationShipBusiReqBO;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.OrderShipItemXbjMapper;
import com.cgd.order.dao.OrderShipXbjMapper;
import com.cgd.order.po.OrderShipItemXbjPO;
import com.cgd.order.po.OrderShipXbjPO;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ArrivalRegistrationXbjAtomServiceImpl
implements ArrivalRegistrationXbjAtomService {
    private static final Logger log = LoggerFactory.getLogger(ArrivalRegistrationXbjAtomServiceImpl.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private OrderShipXbjMapper orderShipXbjMapper;
    @Autowired
    private OrderShipItemXbjMapper orderShipItemXbjMapper;

    @Override
    public void saveArrivalRegistration(ArrivalRegistrationAtomXbjReqBO arrivalRegistrationAtomReq) {
        if (isDebugEnabled) {
            log.debug("\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u5165\u53c2" + JSON.toJSONString((Object)arrivalRegistrationAtomReq));
        }
        this.validateBOData(arrivalRegistrationAtomReq);
        try {
            List<XbjArrivalRegistrationShipBusiReqBO> orderShipList = arrivalRegistrationAtomReq.getOrderShipList();
            for (XbjArrivalRegistrationShipBusiReqBO orderShip : orderShipList) {
                if (orderShip == null) {
                    throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1  \u53d1\u8d27\u5355\u4e0d\u80fd\u4e3a\u7a7a");
                }
                OrderShipXbjPO record = new OrderShipXbjPO();
                record.setPurchaseOrderId(arrivalRegistrationAtomReq.getPurchaseOrderId());
                record.setPurchaserId(arrivalRegistrationAtomReq.getPurchaserId());
                record.setShipOrderId(orderShip.getShipOrderId());
                OrderShipXbjPO orderShipInfo = this.orderShipXbjMapper.getModelBy(record);
                if (orderShipInfo == null) {
                    throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1  \u53d1\u8d27\u5355\u3010" + orderShip.getShipOrderId() + "\u3011\u4e0d\u5b58\u5728");
                }
                if (!XbjOrderConstants.XBJ_SALE_PURCHASE_ORDER_STATUS.SENDING.equals(Integer.valueOf(orderShipInfo.getShipStatus()))) {
                    throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1  \u53d1\u8d27\u5355\u3010" + orderShip.getShipOrderId() + "\u3011\u72b6\u6001\u4e0d\u4e3a4\uff08\u53d1\u8d27\u4e2d\uff09");
                }
                orderShipInfo.setArriveTime(new Date());
                orderShipInfo.setArriveRemark(arrivalRegistrationAtomReq.getArriveRemark());
                orderShipInfo.setShipStatus(String.valueOf(XbjOrderConstants.XBJ_SALE_PURCHASE_ORDER_STATUS.SHIP_STATUS_TO_ARRIVED));
                int returnCount = this.orderShipXbjMapper.updateById(orderShipInfo);
                if (returnCount == 0) {
                    throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1  \u66f4\u65b0\u53d1\u8d27\u5355\u5931\u8d25");
                }
                this.updateShipItemRegistrationInfo(arrivalRegistrationAtomReq.getPurchaserId(), orderShip);
            }
        }
        catch (BusinessException e) {
            log.error("\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38:", (Throwable)e);
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", e.getMessage());
        }
        catch (Exception e) {
            log.error("\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38:", (Throwable)e);
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38");
        }
    }

    private void updateShipItemRegistrationInfo(Long purchaserId, XbjArrivalRegistrationShipBusiReqBO orderShip) {
        try {
            if (orderShip == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1  \u53d1\u8d27\u5355\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            OrderShipItemXbjPO recordItem = new OrderShipItemXbjPO();
            recordItem.setPurchaserId(purchaserId);
            recordItem.setShipItemId(orderShip.getShipItemId());
            OrderShipItemXbjPO orderShipItemInfo = this.orderShipItemXbjMapper.getModelBy(recordItem);
            if (orderShipItemInfo == null) {
                throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1 \u4e0d\u5b58\u5728\u53d1\u8d27\u5355\u660e\u7ec6\u3010" + orderShip.getShipItemId() + "\u3011\u6570\u636e");
            }
            orderShipItemInfo.setArriveCount(orderShip.getArriveCount());
            int returnCount = this.orderShipItemXbjMapper.updateById(orderShipItemInfo);
            if (returnCount == 0) {
                throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1  \u66f4\u65b0\u53d1\u8d27\u5355\u660e\u7ec6\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38:", (Throwable)e);
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1  \u67e5\u8be2\u6216\u66f4\u65b0\u8ba2\u5355\u660e\u7ec6\u65f6\u6570\u636e\u5e93\u5f02\u5e38");
        }
    }

    private void validateBOData(ArrivalRegistrationAtomXbjReqBO arrivalRegistrationAtomReq) {
        if (arrivalRegistrationAtomReq == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1  \u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (arrivalRegistrationAtomReq.getPurchaseOrderId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1  \u91c7\u8d2d\u5355ID\u3010purchaseOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (arrivalRegistrationAtomReq.getPurchaserId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1  \u91c7\u8d2d\u5355\u4f4dID\u3010purchaserId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (arrivalRegistrationAtomReq.getOrderShipList() == null || arrivalRegistrationAtomReq.getOrderShipList().size() <= 0) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1  \u53d1\u8d27\u5355List\u3010orderShipItemList\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (arrivalRegistrationAtomReq.getOrderShipList().get(0).getShipItemId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1  \u53d1\u8d27\u5355List\u3010shipItemId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (arrivalRegistrationAtomReq.getOrderShipList().get(0).getShipOrderId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1  \u53d1\u8d27\u5355List\u3010shipOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

