/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.CreateSalesOrderDetailsXbjAtomService;
import com.cgd.order.atom.bo.SalesOrderDetailsXbjReqBo;
import com.cgd.order.dao.OrderSaleItemXbjMapper;
import com.cgd.order.po.OrderSaleItemXbjPO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CreateSalesOrderDetailsXbjAtomServiceImpl
implements CreateSalesOrderDetailsXbjAtomService {
    private static final Logger log = LoggerFactory.getLogger(CreateSalesOrderDetailsXbjAtomServiceImpl.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private OrderSaleItemXbjMapper orderSaleItemXbjMapper;

    public void setOrderSaleItemXbjMapper(OrderSaleItemXbjMapper orderSaleItemXbjMapper) {
        this.orderSaleItemXbjMapper = orderSaleItemXbjMapper;
    }

    @Override
    public boolean createOrderDetails(List<SalesOrderDetailsXbjReqBo> saleOrderBo) {
        if (isDebugEnabled) {
            log.debug("\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u5165\u53c2\uff1a" + saleOrderBo);
        }
        try {
            for (int i = 0; i < saleOrderBo.size(); ++i) {
                this.validateDetailParams(saleOrderBo.get(i));
                OrderSaleItemXbjPO record = new OrderSaleItemXbjPO();
                SalesOrderDetailsXbjReqBo salesOrderDetailsReqBo = saleOrderBo.get(i);
                record = saleOrderBo.get(i).SalesOrderDetailsReqBoToOrderSaleItem(salesOrderDetailsReqBo);
                this.orderSaleItemXbjMapper.insertSelective(record);
            }
        }
        catch (Exception e) {
            if (isDebugEnabled) {
                log.debug("\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u539f\u5b50\u670d\u52a1\u5f02\u5e38" + e);
            }
            throw new BusinessException("RSP_CODE_DAO_ERROR", "\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u539f\u5b50\u670d\u52a1\u5f02\u5e38\uff01");
        }
        return true;
    }

    public void validateDetailParams(SalesOrderDetailsXbjReqBo saleOrderBo) {
        if (null == saleOrderBo) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355\u751f\u6210\u539f\u5b50\u670d\u52a1\u5165\u53c2\u4e3a\u7a7a");
        }
        if (null == saleOrderBo.getSaleOrderId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355\u751f\u6210\u539f\u5b50\u670d\u52a1\u9500\u552e\u8ba2\u5355\u7f16\u7801\u53f7\u53c2\u4e3a\u7a7a");
        }
        if (null == saleOrderBo.getSaleOrderItemId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355\u751f\u6210\u539f\u5b50\u670d\u52a1\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u7f16\u53f7\u5165\u53c2\u4e3a\u7a7a");
        }
        if (null == saleOrderBo.getPurchaserId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355\u751f\u6210\u539f\u5b50\u670d\u52a1\u91c7\u8d2d\u5355\u4f4d\u7f16\u53f7\u5165\u53c2\u4e3a\u7a7a");
        }
        if (null == saleOrderBo.getPurchaserAccountId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355\u751f\u6210\u539f\u5b50\u670d\u52a1\u91c7\u8d2d\u5355\u4f4d\u4e0b\u5355\u4eba\u7f16\u53f7\u5165\u53c2\u4e3a\u7a7a");
        }
        if (null == saleOrderBo.getProfessionalOrganizationId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355\u751f\u6210\u539f\u5b50\u670d\u52a1\u4e13\u4e1a\u673a\u6784\u5165\u53c2\u4e3a\u7a7a");
        }
        if (null == saleOrderBo.getGoodsSupplierId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355\u751f\u6210\u539f\u5b50\u670d\u52a1\u4f9b\u5e94\u5546\u5165\u53c2\u4e3a\u7a7a");
        }
    }
}

