/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.GenerateOrderIdAndCodeXbjAtomService;
import com.cgd.order.atom.OrderConstrConfirmXbjAtomService;
import com.cgd.order.atom.bo.GenerateOrderIdAndCodeXbjReqBO;
import com.cgd.order.atom.bo.GenerateOrderIdAndCodeXbjRspBO;
import com.cgd.order.atom.bo.OrderConstrConfirmAccessoryXbjBO;
import com.cgd.order.atom.bo.OrderConstrConfirmItemXbjBO;
import com.cgd.order.atom.bo.OrderConstrConfirmXbjReqBO;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.AccessoryXbjMapper;
import com.cgd.order.dao.InspectionShipRelationXbjMapper;
import com.cgd.order.dao.OrderConstrCompleteItemXbjMapper;
import com.cgd.order.dao.OrderConstrCompleteXbjMapper;
import com.cgd.order.dao.OrderConstrInspectionItemXbjMapper;
import com.cgd.order.dao.OrderConstrInspectionXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.po.AccessoryXbjPO;
import com.cgd.order.po.InspectionShipRelationXbjPO;
import com.cgd.order.po.OrderConstrCompleteItemXbjPO;
import com.cgd.order.po.OrderConstrInspectionItemXbjPO;
import com.cgd.order.po.OrderConstrInspectionXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderConstrConfirmXbjAtomServiceImpl
implements OrderConstrConfirmXbjAtomService {
    private static final Logger logger = LoggerFactory.getLogger(OrderConstrConfirmXbjAtomServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private OrderSaleXbjMapper orderSaleXbjMapper;
    @Autowired
    private OrderConstrInspectionXbjMapper orderConstrInspectionXbjMapper;
    @Autowired
    private OrderConstrInspectionItemXbjMapper orderConstrInspectionItemXbjMapper;
    @Autowired
    private OrderConstrCompleteXbjMapper orderConstrCompleteXbjMapper;
    @Autowired
    private OrderConstrCompleteItemXbjMapper orderConstrCompleteItemXbjMapper;
    @Autowired
    private AccessoryXbjMapper accessoryXbjMapper;
    @Autowired
    private InspectionShipRelationXbjMapper inspectionShipRelationXbjMapper;
    @Autowired
    private GenerateOrderIdAndCodeXbjAtomService generateOrderIdAndCodeXbjAtomService;

    @Override
    public GenerateOrderIdAndCodeXbjRspBO insertConstrConfirmDetail(OrderConstrConfirmXbjReqBO reqBO) {
        OrderSaleXbjPO orderSalePO = this.dealWithOrderSaleExist(reqBO);
        GenerateOrderIdAndCodeXbjReqBO generateOrderIdAndCodeXbjReqBO = new GenerateOrderIdAndCodeXbjReqBO();
        generateOrderIdAndCodeXbjReqBO.setGenerateOrderType(XbjOrderConstants.GENERATE_ORDER_TYPE.CONSTR_INSPECTION);
        generateOrderIdAndCodeXbjReqBO.setPurchaseId(reqBO.getPurchaserId());
        generateOrderIdAndCodeXbjReqBO.setSaleOrderId(reqBO.getSaleOrderId());
        GenerateOrderIdAndCodeXbjRspBO orderIdAndCode = this.generateOrderIdAndCodeXbjAtomService.generateOrderIdAndCode(generateOrderIdAndCodeXbjReqBO);
        try {
            this.insertConstrInfo(orderIdAndCode, orderSalePO, reqBO);
            this.insertConstrItem(orderIdAndCode, reqBO.getConfirmItemList(), reqBO.getPurchaserId());
            this.insertConstrAccessory(orderIdAndCode, orderSalePO, reqBO.getAccessoryList());
            this.insertConstrRelation(orderIdAndCode, orderSalePO, reqBO.getConfirmItemList());
        }
        catch (Exception e) {
            if (this.isDebugEnabled) {
                logger.debug("\u65bd\u5de5\u9a8c\u6536\u5355\u751f\u6210\u539f\u5b50\u670d\u52a1\u5f02\u5e38:{}", (Object)e.getMessage());
                e.printStackTrace();
            }
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u65bd\u5de5\u9a8c\u6536\u5355\u751f\u6210\u539f\u5b50\u670d\u52a1\u5f02\u5e38:" + e.getMessage());
        }
        return orderIdAndCode;
    }

    private void insertConstrRelation(GenerateOrderIdAndCodeXbjRspBO orderIdAndCode, OrderSaleXbjPO orderSalePO, List<OrderConstrConfirmItemXbjBO> confirmItemList) throws Exception {
        HashSet<Long> constrOrderIds = new HashSet<Long>();
        for (OrderConstrConfirmItemXbjBO orderConstrConfirmItemTemp : confirmItemList) {
            constrOrderIds.add(orderConstrConfirmItemTemp.getConstrOrderId());
        }
        for (Long constrOrderId : constrOrderIds) {
            InspectionShipRelationXbjPO inspectionShipRelationXbjPO = new InspectionShipRelationXbjPO();
            inspectionShipRelationXbjPO.setPurchaserId(orderSalePO.getPurchaserId());
            inspectionShipRelationXbjPO.setPurchaserAccountId(orderSalePO.getPurchaserAccountId());
            inspectionShipRelationXbjPO.setPurchaserAccountName(orderSalePO.getPurchaserAccountName());
            inspectionShipRelationXbjPO.setProfessionalOrganizationId(orderSalePO.getProfessionalOrganizationId());
            inspectionShipRelationXbjPO.setGoodsSupplierId(orderSalePO.getGoodsSupplierId());
            inspectionShipRelationXbjPO.setInspectionOrderId(orderIdAndCode.getOrderId());
            inspectionShipRelationXbjPO.setCompleteId(constrOrderId);
            inspectionShipRelationXbjPO.setSaleOrderId(orderSalePO.getSaleOrderId());
            inspectionShipRelationXbjPO.setCreateTime(new Date());
            this.inspectionShipRelationXbjMapper.insert(inspectionShipRelationXbjPO);
        }
    }

    private void insertConstrAccessory(GenerateOrderIdAndCodeXbjRspBO orderIdAndCode, OrderSaleXbjPO orderSalePO, List<OrderConstrConfirmAccessoryXbjBO> accessoryList) throws Exception {
        if (accessoryList != null) {
            for (OrderConstrConfirmAccessoryXbjBO accessoryTemp : accessoryList) {
                AccessoryXbjPO accessory = new AccessoryXbjPO();
                accessory.setObjectId(orderIdAndCode.getOrderId());
                accessory.setObjectType(XbjOrderConstants.ACCESSORY_TYPE.CONSTR_INSPECTION);
                accessory.setOrderCode(orderIdAndCode.getOrderCode());
                accessory.setPurchaserId(orderSalePO.getPurchaserId());
                accessory.setPurchaserAccountId(orderSalePO.getPurchaserAccountId());
                accessory.setPurchaserAccountName(orderSalePO.getPurchaserAccountName());
                accessory.setProfessionalOrganizationId(String.valueOf(orderSalePO.getProfessionalOrganizationId()));
                accessory.setGoodsSupplierId(String.valueOf(orderSalePO.getGoodsSupplierId()));
                accessory.setAccessoryId(accessoryTemp.getAccessoryId());
                accessory.setAccessoryUrl(accessoryTemp.getAccessoryUrl());
                accessory.setAccessoryName(accessoryTemp.getAccessoryName());
                accessory.setRemark("\u8be2\u6bd4\u4ef7\u65bd\u5de5\u5b8c\u5de5\u9a8c\u6536\u5355\u9644\u4ef6");
                accessory.setCreateDate(new Date());
                this.accessoryXbjMapper.insert(accessory);
            }
        }
    }

    private void insertConstrItem(GenerateOrderIdAndCodeXbjRspBO orderIdAndCode, List<OrderConstrConfirmItemXbjBO> confirmItemList, Long purchaseId) throws Exception {
        for (OrderConstrConfirmItemXbjBO orderConstrConfirmItemTemp : confirmItemList) {
            OrderConstrInspectionItemXbjPO orderConstrInspectionItemXbjPO = new OrderConstrInspectionItemXbjPO();
            OrderConstrCompleteItemXbjPO orderConstrCompleteItemReqPO = new OrderConstrCompleteItemXbjPO();
            orderConstrCompleteItemReqPO.setConstrCompleteOrderId(orderConstrConfirmItemTemp.getConstrOrderId());
            orderConstrCompleteItemReqPO.setPurchaseOrderItemId(orderConstrConfirmItemTemp.getPurchaseOrderItemId());
            orderConstrCompleteItemReqPO.setPurchaserId(purchaseId);
            OrderConstrCompleteItemXbjPO orderConstrCompleteItemRspPO = this.orderConstrCompleteItemXbjMapper.getModelBy(orderConstrCompleteItemReqPO);
            orderConstrInspectionItemXbjPO.setConstrOrderId(orderConstrCompleteItemRspPO.getConstrCompleteOrderId());
            orderConstrInspectionItemXbjPO.setConstrItemId(orderConstrCompleteItemRspPO.getItemId());
            orderConstrInspectionItemXbjPO.setConstrInspectionId(orderIdAndCode.getOrderId());
            orderConstrInspectionItemXbjPO.setSaleOrderItemId(orderConstrCompleteItemRspPO.getSaleOrderItemId());
            orderConstrInspectionItemXbjPO.setPurchaseOrderItemId(orderConstrCompleteItemRspPO.getPurchaseOrderItemId());
            orderConstrInspectionItemXbjPO.setPurchaserId(orderConstrCompleteItemRspPO.getPurchaserId());
            orderConstrInspectionItemXbjPO.setPurchaserAccountId(orderConstrCompleteItemRspPO.getPurchaserAccountId());
            orderConstrInspectionItemXbjPO.setPurchaserAccountName(orderConstrCompleteItemRspPO.getPurchaserAccountName());
            orderConstrInspectionItemXbjPO.setProfessionalOrganizationId(orderConstrCompleteItemRspPO.getProfessionalOrganizationId());
            orderConstrInspectionItemXbjPO.setGoodsSupplierId(orderConstrCompleteItemRspPO.getGoodsSupplierId());
            orderConstrInspectionItemXbjPO.setProjectId(orderConstrCompleteItemRspPO.getProjectId());
            orderConstrInspectionItemXbjPO.setProjectName(orderConstrCompleteItemRspPO.getProjectName());
            orderConstrInspectionItemXbjPO.setProjectCode(orderConstrCompleteItemRspPO.getProjectCode());
            orderConstrInspectionItemXbjPO.setProjectContent(orderConstrCompleteItemRspPO.getProjectContent());
            orderConstrInspectionItemXbjPO.setSellingPrice(orderConstrCompleteItemRspPO.getSellingPrice());
            orderConstrInspectionItemXbjPO.setPurchaseCount(orderConstrCompleteItemRspPO.getPurchaseCount());
            orderConstrInspectionItemXbjPO.setUnitName(orderConstrCompleteItemRspPO.getUnitName());
            orderConstrInspectionItemXbjPO.setOnceAcceptanceCount(orderConstrConfirmItemTemp.getConstrCount());
            this.orderConstrInspectionItemXbjMapper.insert(orderConstrInspectionItemXbjPO);
        }
    }

    private void insertConstrInfo(GenerateOrderIdAndCodeXbjRspBO orderIdAndCode, OrderSaleXbjPO orderSalePO, OrderConstrConfirmXbjReqBO reqBO) throws Exception {
        OrderConstrInspectionXbjPO orderConstrInspection = new OrderConstrInspectionXbjPO();
        orderConstrInspection.setConstrInspectionOrderId(orderIdAndCode.getOrderId());
        orderConstrInspection.setConstrInspectionOrderCode(orderIdAndCode.getOrderCode());
        orderConstrInspection.setPurchaseOrderId(orderSalePO.getPurchaseOrderId());
        orderConstrInspection.setPurchaseOrderCode(orderSalePO.getPurchaseOrderCode());
        orderConstrInspection.setSaleOrderId(orderSalePO.getSaleOrderId());
        orderConstrInspection.setSaleOrderCode(orderSalePO.getSaleOrderCode());
        orderConstrInspection.setGoodsSupplierId(orderSalePO.getGoodsSupplierId());
        orderConstrInspection.setPurchaserId(orderSalePO.getPurchaserId());
        orderConstrInspection.setPurchaserAccountId(orderSalePO.getPurchaserAccountId());
        orderConstrInspection.setPurchaserAccountName(orderSalePO.getPurchaserAccountName());
        orderConstrInspection.setProfessionalOrganizationId(orderSalePO.getProfessionalOrganizationId());
        orderConstrInspection.setOrderType(orderSalePO.getOrderType());
        orderConstrInspection.setOperId(reqBO.getOperId());
        orderConstrInspection.setCreateTime(new Date());
        orderConstrInspection.setRemark(reqBO.getRemark());
        if (null != reqBO.getAccessoryList() && reqBO.getAccessoryList().size() > 0) {
            orderConstrInspection.setIsEnclosure(XbjOrderConstants.SALE_ORDER_PURCHASE_WHOLE_ACCEPTANCE_YES);
        } else {
            orderConstrInspection.setIsEnclosure(XbjOrderConstants.SALE_ORDER_PURCHASE_WHOLE_ACCEPTANCE_NO);
        }
        this.orderConstrInspectionXbjMapper.insert(orderConstrInspection);
    }

    private OrderSaleXbjPO dealWithOrderSaleExist(OrderConstrConfirmXbjReqBO reqBO) {
        OrderSaleXbjPO orderSaleXbjPO = this.orderSaleXbjMapper.selectOrderSaleByCondition(reqBO.getSaleOrderId(), reqBO.getPurchaserId());
        if (null == orderSaleXbjPO) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u65e0\u6cd5\u5b9a\u4f4d\u5230\u6307\u5b9a\u9500\u552e\u8ba2\u5355\uff01");
        }
        return orderSaleXbjPO;
    }
}

