/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.OrderDispatcherXbjAtomService;
import com.cgd.order.atom.bo.OrderDispatcherAtomXbjReqBO;
import com.cgd.order.atom.bo.OrderDispatcherAtomXbjRspBO;
import com.cgd.order.constant.Constant;
import com.cgd.order.constant.OrderCenterConstant;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.OrderProtocolItemXbjMapper;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.OrderSaleStatusChngLogXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.dao.PurchaseOrderStatusChngXbjMapper;
import com.cgd.order.po.OrderProtocolItemXbjPO;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.po.OrderSaleStatusChngLogXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import com.cgd.order.po.PurchaseOrderStatusChngXbjPO;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OrderDispatcherXbjAtomServiceImpl
implements OrderDispatcherXbjAtomService {
    private static final Log log = LogFactory.getLog(OrderDispatcherXbjAtomServiceImpl.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private OrderSaleXbjMapper orderSaleXbjMapper;
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;
    private OrderProtocolItemXbjMapper orderProtocolItemXbjMapper;
    private OrderSaleStatusChngLogXbjMapper orderSaleStatusChngLogXbjMapper;
    private PurchaseOrderStatusChngXbjMapper purchaseOrderStatusChngXbjMapper;

    public void setOrderSaleXbjMapper(OrderSaleXbjMapper orderSaleXbjMapper) {
        this.orderSaleXbjMapper = orderSaleXbjMapper;
    }

    public void setOrderPurchaseXbjMapper(OrderPurchaseXbjMapper orderPurchaseXbjMapper) {
        this.orderPurchaseXbjMapper = orderPurchaseXbjMapper;
    }

    public void setOrderProtocolItemXbjMapper(OrderProtocolItemXbjMapper orderProtocolItemXbjMapper) {
        this.orderProtocolItemXbjMapper = orderProtocolItemXbjMapper;
    }

    public void setOrderSaleStatusChngLogXbjMapper(OrderSaleStatusChngLogXbjMapper orderSaleStatusChngLogXbjMapper) {
        this.orderSaleStatusChngLogXbjMapper = orderSaleStatusChngLogXbjMapper;
    }

    public void setPurchaseOrderStatusChngXbjMapper(PurchaseOrderStatusChngXbjMapper purchaseOrderStatusChngXbjMapper) {
        this.purchaseOrderStatusChngXbjMapper = purchaseOrderStatusChngXbjMapper;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OrderDispatcherAtomXbjRspBO dealWithDispatcher(OrderDispatcherAtomXbjReqBO orderDispatcherAtomReq) {
        OrderDispatcherAtomXbjRspBO orderDispatcherAtomRspBO = new OrderDispatcherAtomXbjRspBO();
        try {
            OrderSaleXbjPO record = this.orderSaleXbjMapper.selectByIdAndPurchaserId(orderDispatcherAtomReq.getSaleOrderId(), orderDispatcherAtomReq.getPurchaserId());
            if (null == record) {
                orderDispatcherAtomRspBO.setRespCode("RSP_CODE_ATOM_SERVICE_ERROR");
                orderDispatcherAtomRspBO.setRespDesc("\u6b64\u8ba2\u5355[" + orderDispatcherAtomReq.getSaleOrderId() + "]\u67e5\u8be2\u5bf9\u5e94\u9500\u552e\u7ed3\u679c\u4e3a\u7a7a\uff01");
                return orderDispatcherAtomRspBO;
            }
            if (XbjOrderConstants.SALE_ORDER_TYPE_KJXY.equals(record.getSaleOrderType())) {
                OrderProtocolItemXbjPO orderProtocolItem = this.orderProtocolItemXbjMapper.queryBySaleOrderId(record.getSaleOrderId());
                if (null == orderProtocolItem) {
                    orderDispatcherAtomRspBO.setRespCode("RSP_CODE_ATOM_SERVICE_ERROR");
                    orderDispatcherAtomRspBO.setRespDesc("\u6b64\u8ba2\u5355[" + record.getSaleOrderId() + "]\u67e5\u8be2\u5bf9\u5e94\u534f\u8bae\u7ed3\u679c\u4e3a\u7a7a\uff01");
                    return orderDispatcherAtomRspBO;
                }
                if (null == String.valueOf(orderProtocolItem.getAdjustMechanism())) {
                    orderDispatcherAtomRspBO.setRespCode("RSP_CODE_ATOM_SERVICE_ERROR");
                    orderDispatcherAtomRspBO.setRespDesc("\u6b64\u534f\u8baeProtocolItemId[" + orderProtocolItem.getProtocolItemId() + "]\u5bf9\u5e94\u8c03\u4ef7\u673a\u5236\u4e3a\u7a7a!");
                    return orderDispatcherAtomRspBO;
                }
                if (orderProtocolItem.getAdjustMechanism() == OrderCenterConstant.ADJUST_PRICE.DURING) {
                    record.setSaleOrderStatus(XbjOrderConstants.XBJ_SALE_ORDER_STATUS.ORDER_CHECK);
                } else {
                    OrderPurchaseXbjPO orderPurchase = this.orderPurchaseXbjMapper.selectByPurchaseOrderIdAndSupplierId(record.getPurchaseOrderId(), record.getGoodsSupplierId());
                    if (null == orderPurchase) {
                        orderDispatcherAtomRspBO.setRespCode("RSP_CODE_ATOM_SERVICE_ERROR");
                        orderDispatcherAtomRspBO.setRespDesc("\u6b64\u8ba2\u5355[" + record.getPurchaseOrderId() + "]\u67e5\u8be2\u5bf9\u5e94\u91c7\u8d2d\u7ed3\u679c\u4e3a\u7a7a\uff01");
                        return orderDispatcherAtomRspBO;
                    }
                    record.setSaleOrderStatus(XbjOrderConstants.XBJ_SALE_ORDER_STATUS.ORDER_CONFIRM);
                    orderPurchase.setPurchaseOrderStatus(Constant.SALSE_ORDER_STATE_SUPPLY_CONFIRMING);
                    orderPurchase.setDeliveryId(orderDispatcherAtomReq.getDeliveryId());
                    orderPurchase.setDeliveryName(orderDispatcherAtomReq.getDeliveryName());
                    orderPurchase.setModifyOperId(orderDispatcherAtomReq.getOperId());
                    orderPurchase.setDispatcherRemark(orderDispatcherAtomReq.getComment());
                    int resultPurchase = this.orderPurchaseXbjMapper.updateDeliveryInfo(orderPurchase);
                    if (resultPurchase <= 0) {
                        orderDispatcherAtomRspBO.setRespCode("RSP_CODE_ATOM_SERVICE_ERROR");
                        orderDispatcherAtomRspBO.setRespDesc("\u6b64\u8ba2\u5355[" + orderPurchase.getPurchaseOrderId() + "]\u66f4\u65b0\u5bf9\u5e94\u91c7\u8d2d\u8ba2\u5355\u914d\u9001\u5458\u4fe1\u606f\u5931\u8d25\uff01");
                        return orderDispatcherAtomRspBO;
                    }
                    PurchaseOrderStatusChngXbjPO hisPo = new PurchaseOrderStatusChngXbjPO();
                    hisPo.setCreateDate(new Date());
                    hisPo.setGoodsSupplierId(orderPurchase.getGoodsSupplierId());
                    hisPo.setNewSaleOrderStatus(orderPurchase.getPurchaseOrderStatus());
                    hisPo.setOldSaleOrderStatus(orderPurchase.getPurchaseOrderStatus());
                    hisPo.setOperId(orderDispatcherAtomReq.getOperId() + "");
                    hisPo.setProfessionalOrganizationId(orderPurchase.getProfessionalOrganizationId());
                    hisPo.setPurchaseOrderId(orderPurchase.getPurchaseOrderId());
                    hisPo.setPurchaserAccountId(orderPurchase.getPurchaserAccountId());
                    hisPo.setPurchaserAccountName(orderPurchase.getPurchaserAccountName());
                    hisPo.setPurchaserId(orderPurchase.getPurchaserId());
                    hisPo.setSaleOrderId(orderPurchase.getSaleOrderId());
                    this.purchaseOrderStatusChngXbjMapper.insertSelective(hisPo);
                }
                record.setDeliveryId(orderDispatcherAtomReq.getDeliveryId());
                record.setDeliveryName(orderDispatcherAtomReq.getDeliveryName());
                record.setModifyOperId(orderDispatcherAtomReq.getOperId());
                record.setDispatcherRemark(orderDispatcherAtomReq.getComment());
                int resultSale = this.orderSaleXbjMapper.updateDeliveryInfo(record);
                if (resultSale <= 0) {
                    orderDispatcherAtomRspBO.setRespCode("RSP_CODE_ATOM_SERVICE_ERROR");
                    orderDispatcherAtomRspBO.setRespDesc("\u6b64\u8ba2\u5355[" + record.getSaleOrderId() + "]\u66f4\u65b0\u5bf9\u5e94\u9500\u552e\u8ba2\u5355\u914d\u9001\u5458\u4fe1\u606f\u5931\u8d25\uff01");
                    return orderDispatcherAtomRspBO;
                }
                OrderSaleStatusChngLogXbjPO hisPo = new OrderSaleStatusChngLogXbjPO();
                hisPo.setPurchaserId(record.getPurchaserId());
                hisPo.setPurchaserAccountId(record.getPurchaserAccountId());
                hisPo.setPurchaserAccountName(record.getPurchaserAccountName());
                hisPo.setGoodsSupplierId(record.getGoodsSupplierId());
                hisPo.setSaleOrderId(record.getSaleOrderId());
                hisPo.setOldSaleOrderStatus(record.getSaleOrderStatus());
                hisPo.setNewSaleOrderStatus(record.getSaleOrderStatus());
                hisPo.setProfessionalOrganizationId(record.getProfessionalOrganizationId());
                hisPo.setCreateDate(new Date());
                hisPo.setOperId(orderDispatcherAtomReq.getOperId() + "");
                this.orderSaleStatusChngLogXbjMapper.insertSelective(hisPo);
                orderDispatcherAtomRspBO.setRespCode("0000");
                orderDispatcherAtomRspBO.setRespDesc("\u8ba2\u5355\u5206\u914d\u539f\u5b50\u670d\u52a1\u6267\u884c\u6210\u529f\uff01");
            } else {
                if (!XbjOrderConstants.SALE_ORDER_TYPE_XBJ.equals(record.getSaleOrderType())) throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8c03\u7528\u8ba2\u5355\u5206\u914d\u539f\u5b50\u670d\u52a1\u5f02\u5e38:\u9500\u552e\u8ba2\u5355\u7c7b\u578b\u5f02\u5e38");
                record.setDeliveryId(orderDispatcherAtomReq.getDeliveryId());
                record.setDeliveryName(orderDispatcherAtomReq.getDeliveryName());
                record.setModifyOperId(orderDispatcherAtomReq.getOperId());
                record.setDispatcherRemark(orderDispatcherAtomReq.getComment());
                int resultSale = this.orderSaleXbjMapper.updateDeliveryInfo(record);
                if (resultSale <= 0) {
                    orderDispatcherAtomRspBO.setRespCode("RSP_CODE_ATOM_SERVICE_ERROR");
                    orderDispatcherAtomRspBO.setRespDesc("\u9500\u552e\u8ba2\u5355[" + record.getSaleOrderId() + "]\u66f4\u65b0\u5bf9\u5e94\u9500\u552e\u8ba2\u5355\u914d\u9001\u5458\u4fe1\u606f\u5931\u8d25\uff01");
                    return orderDispatcherAtomRspBO;
                }
                OrderPurchaseXbjPO orderPurchase = this.orderPurchaseXbjMapper.selectByPurchaseOrderIdAndSupplierId(record.getPurchaseOrderId(), record.getGoodsSupplierId());
                if (null == orderPurchase) {
                    orderDispatcherAtomRspBO.setRespCode("RSP_CODE_ATOM_SERVICE_ERROR");
                    orderDispatcherAtomRspBO.setRespDesc("\u6b64\u8ba2\u5355[" + record.getPurchaseOrderId() + "]\u67e5\u8be2\u5bf9\u5e94\u91c7\u8d2d\u8ba2\u5355\u7ed3\u679c\u4e3a\u7a7a\uff01");
                    return orderDispatcherAtomRspBO;
                }
                orderPurchase.setPurchaseOrderStatus(XbjOrderConstants.PURCHASE_ORDER_BE_MAINTAINING);
                orderPurchase.setDeliveryId(orderDispatcherAtomReq.getDeliveryId());
                orderPurchase.setDeliveryName(orderDispatcherAtomReq.getDeliveryName());
                orderPurchase.setModifyOperId(orderDispatcherAtomReq.getOperId());
                orderPurchase.setDispatcherRemark(orderDispatcherAtomReq.getComment());
                int resultPurchase = this.orderPurchaseXbjMapper.updateDeliveryInfo(orderPurchase);
                if (resultPurchase <= 0) {
                    orderDispatcherAtomRspBO.setRespCode("RSP_CODE_ATOM_SERVICE_ERROR");
                    orderDispatcherAtomRspBO.setRespDesc("\u6b64\u8ba2\u5355[" + orderPurchase.getPurchaseOrderId() + "]\u66f4\u65b0\u5bf9\u5e94\u91c7\u8d2d\u8ba2\u5355\u914d\u9001\u5458\u4fe1\u606f\u5931\u8d25\uff01");
                    return orderDispatcherAtomRspBO;
                }
                PurchaseOrderStatusChngXbjPO hisPo = new PurchaseOrderStatusChngXbjPO();
                hisPo.setCreateDate(new Date());
                hisPo.setGoodsSupplierId(orderPurchase.getGoodsSupplierId());
                hisPo.setNewSaleOrderStatus(orderPurchase.getPurchaseOrderStatus());
                hisPo.setOldSaleOrderStatus(orderPurchase.getPurchaseOrderStatus());
                hisPo.setOperId(orderDispatcherAtomReq.getOperId() + "");
                hisPo.setProfessionalOrganizationId(orderPurchase.getProfessionalOrganizationId());
                hisPo.setPurchaseOrderId(orderPurchase.getPurchaseOrderId());
                hisPo.setPurchaserAccountId(orderPurchase.getPurchaserAccountId());
                hisPo.setPurchaserAccountName(orderPurchase.getPurchaserAccountName());
                hisPo.setPurchaserId(orderPurchase.getPurchaserId());
                hisPo.setSaleOrderId(orderPurchase.getSaleOrderId());
                this.purchaseOrderStatusChngXbjMapper.insertSelective(hisPo);
                orderDispatcherAtomRspBO.setRespCode("0000");
                orderDispatcherAtomRspBO.setRespDesc("\u8ba2\u5355\u5206\u914d\u539f\u5b50\u670d\u52a1\u6267\u884c\u6210\u529f\uff01");
            }
            orderDispatcherAtomRspBO.setOrderSale(record);
            return orderDispatcherAtomRspBO;
        }
        catch (Exception e) {
            orderDispatcherAtomRspBO.setRespCode("RSP_CODE_ATOM_SERVICE_ERROR");
            orderDispatcherAtomRspBO.setRespDesc("\u8ba2\u5355\u5206\u914d\u539f\u5b50\u670d\u52a1\u5f02\u5e38:" + e.getMessage());
        }
        return orderDispatcherAtomRspBO;
    }
}

