/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.PurchaseOrderPriceAdjustmentXbjAtomService;
import com.cgd.order.atom.bo.PurchaseOrderPriceAdjustmentAtomXbjReqBO;
import com.cgd.order.atom.bo.PurchaseOrderPriceAdjustmentAtomXbjRspBO;
import com.cgd.order.dao.OrderPurchaseItemXbjMapper;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.po.OrderSaleItemXbjPO;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseOrderPriceAdjustmentXbjAtomServiceImpl
implements PurchaseOrderPriceAdjustmentXbjAtomService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseOrderPriceAdjustmentXbjAtomService.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private OrderPurchaseXbjMapper orderPurchaseMapper;
    @Autowired
    private OrderPurchaseItemXbjMapper orderPurchaseItemMapper;

    @Override
    public PurchaseOrderPriceAdjustmentAtomXbjRspBO purchaseOrderPriceAdjustment(PurchaseOrderPriceAdjustmentAtomXbjReqBO purchaseOrderPriceAdjustmentAtomReqBO) {
        if (isDebugEnabled) {
            log.debug("\u91c7\u8d2d\u8ba2\u5355\u8c03\u4ef7\u539f\u5b50\u670d\u52a1\u5165\u53c2\uff1a" + purchaseOrderPriceAdjustmentAtomReqBO.toString());
        }
        PurchaseOrderPriceAdjustmentAtomXbjRspBO purchaseOrderPriceAdjustmentAtomRspBO = new PurchaseOrderPriceAdjustmentAtomXbjRspBO();
        try {
            if (null == purchaseOrderPriceAdjustmentAtomReqBO.getPurchaseOrderId()) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u8ba2\u5355\u8c03\u4ef7\u670d\u52a1\uff1a\u91c7\u8d2d\u8ba2\u5355Id[purchaseOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == purchaseOrderPriceAdjustmentAtomReqBO.getPurchaserId()) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u8ba2\u5355\u8c03\u4ef7\u670d\u52a1\uff1aPurchaserId[purchaserId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == purchaseOrderPriceAdjustmentAtomReqBO.getPurchaseOrderMoney()) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u8ba2\u5355\u8c03\u4ef7\u670d\u52a1\uff1a\u91c7\u8d2d\u8ba2\u5355\u91d1\u989d[purchaseOrderMoney]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == purchaseOrderPriceAdjustmentAtomReqBO.getOrderSaleItemList() || purchaseOrderPriceAdjustmentAtomReqBO.getOrderSaleItemList().size() == 0) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u8ba2\u5355\u8c03\u4ef7\u670d\u52a1\uff1a\u9500\u552e\u8ba2\u5355\u660e\u7ec6[orderSaleItemList]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            OrderPurchaseXbjPO orderPurchase = this.orderPurchaseMapper.selectByPurchaseOrderIdAndPurchaserId(purchaseOrderPriceAdjustmentAtomReqBO.getPurchaseOrderId(), purchaseOrderPriceAdjustmentAtomReqBO.getPurchaserId());
            if (orderPurchase == null) {
                purchaseOrderPriceAdjustmentAtomRspBO.setIsSuccess(false);
                purchaseOrderPriceAdjustmentAtomRspBO.setRespCode("RSP_CODE_ATOM_SERVICE_ERROR");
                purchaseOrderPriceAdjustmentAtomRspBO.setRespDesc("\u6839\u636epurchaseOrderId, purchaserId \u67e5\u8be2\u83b7\u53d6\u91c7\u8d2d\u8ba2\u5355\u8868\u6570\u636e\u4e0d\u5b58\u5728");
                return purchaseOrderPriceAdjustmentAtomRspBO;
            }
            orderPurchase.setPurchaseOrderMoney(purchaseOrderPriceAdjustmentAtomReqBO.getPurchaseOrderMoney());
            int count = this.orderPurchaseMapper.updateById(orderPurchase);
            if (count == 0) {
                purchaseOrderPriceAdjustmentAtomRspBO.setIsSuccess(false);
                purchaseOrderPriceAdjustmentAtomRspBO.setRespCode("RSP_CODE_ATOM_SERVICE_ERROR");
                purchaseOrderPriceAdjustmentAtomRspBO.setRespDesc("\u6839\u636epurchaseOrderId, purchaserId \u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u8868\u6570\u636e\u5931\u8d25");
                return purchaseOrderPriceAdjustmentAtomRspBO;
            }
            List<OrderSaleItemXbjPO> orderSaleItemList = purchaseOrderPriceAdjustmentAtomReqBO.getOrderSaleItemList();
            for (OrderSaleItemXbjPO orderSaleItem : orderSaleItemList) {
                BigDecimal purchaseCount = orderSaleItem.getPurchaseCount();
                BigDecimal purchasingPric = new BigDecimal(orderSaleItem.getNewPurchasingPrice());
                BigDecimal purchaseTotal = purchaseCount.multiply(purchasingPric);
                long total = purchaseTotal.longValue();
                int size = this.orderPurchaseItemMapper.updatePurchaseOrderItemBySaleOrderId(orderSaleItem.getSaleOrderItemId(), orderSaleItem.getPurchaserId(), orderSaleItem.getNewPurchasingPrice(), orderSaleItem.getNewSellingPrice(), orderSaleItem.getMarkUpRateNew(), total);
                if (size != 0) continue;
                purchaseOrderPriceAdjustmentAtomRspBO.setIsSuccess(false);
                purchaseOrderPriceAdjustmentAtomRspBO.setRespCode("RSP_CODE_ATOM_SERVICE_ERROR");
                purchaseOrderPriceAdjustmentAtomRspBO.setRespDesc("\u6839\u636esaleOrderItemId, purchaserId\u672a\u67e5\u8be2\u5230\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u6570\u636e");
                return purchaseOrderPriceAdjustmentAtomRspBO;
            }
            purchaseOrderPriceAdjustmentAtomRspBO.setIsSuccess(true);
            purchaseOrderPriceAdjustmentAtomRspBO.setRespCode("\u6210\u529f");
            purchaseOrderPriceAdjustmentAtomRspBO.setRespDesc("\u6210\u529f");
            return purchaseOrderPriceAdjustmentAtomRspBO;
        }
        catch (Exception e) {
            log.error("\u91c7\u8d2d\u8ba2\u5355\u8c03\u4ef7\u539f\u5b50\u670d\u52a1\u5931\u8d25", (Throwable)e);
            purchaseOrderPriceAdjustmentAtomRspBO.setIsSuccess(false);
            purchaseOrderPriceAdjustmentAtomRspBO.setRespCode("8888");
            purchaseOrderPriceAdjustmentAtomRspBO.setRespDesc("\u5931\u8d25");
            return purchaseOrderPriceAdjustmentAtomRspBO;
        }
    }
}

