/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.cgd.common.bo.RspPageBO;
import com.cgd.feature.orm.mybatis.Page;
import com.cgd.order.atom.QryOrderListXbjAtomService;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.XbjOrderTypeQryMapper;
import com.cgd.order.intfce.bo.XbjOrderConstrInfoBO;
import com.cgd.order.intfce.bo.XbjOrderServInfoBO;
import com.cgd.order.intfce.bo.XbjOrderShipInfoBO;
import com.cgd.order.intfce.bo.XbjOrderTypeBO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QryOrderListXbjAtomServiceImpl
implements QryOrderListXbjAtomService {
    private static final Log log = LogFactory.getLog(QryOrderListXbjAtomService.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    private XbjOrderTypeQryMapper xbjOrderTypeQryMapper;

    public void setXbjOrderTypeQryMapper(XbjOrderTypeQryMapper xbjOrderTypeQryMapper) {
        this.xbjOrderTypeQryMapper = xbjOrderTypeQryMapper;
    }

    @Override
    public RspPageBO<XbjOrderShipInfoBO> qryOrderShipBySale(String saleOrderId, int pageNo, int pageSize) {
        RspPageBO resultPage = new RspPageBO();
        XbjOrderTypeBO xbjOrderTypeBO = this.xbjOrderTypeQryMapper.qrySaleOrderType(saleOrderId);
        if (xbjOrderTypeBO != null && XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_WUZI.intValue() == xbjOrderTypeBO.getSaleOrderPurchaseType()) {
            Page page = new Page(pageNo, pageSize);
            HashMap<String, Object> condition = new HashMap<String, Object>();
            condition.put("saleOrderId", saleOrderId);
            List<XbjOrderShipInfoBO> saleOrderShipList = this.xbjOrderTypeQryMapper.qryOrderShipList(condition, (Page<XbjOrderShipInfoBO>)page);
            if (saleOrderShipList == null) {
                saleOrderShipList = new ArrayList<XbjOrderShipInfoBO>();
            }
            resultPage.setRecordsTotal(page.getTotalCount());
            resultPage.setTotal(page.getTotalPages());
            resultPage.setRespCode("0000");
            resultPage.setRespDesc("\u5386\u53f2\u53d1\u8d27\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5b8c\u6210\uff01");
            resultPage.setRows(saleOrderShipList);
            if (this.isDebugEnabled) {
                log.debug((Object)("\u5386\u53f2\u53d1\u8d27\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u51fa\u53c2" + resultPage));
            }
        } else {
            resultPage.setRespCode("7777");
            resultPage.setRespDesc("\u8ba2\u5355\u7c7b\u578b[SALE_ORDER_PURCHASE_TYPE]\u4e0d\u662f\u53d1\u8d27\u5355");
        }
        return resultPage;
    }

    @Override
    public RspPageBO<XbjOrderShipInfoBO> qryOrderShipByPurchase(String purchaseOrderId, int pageNo, int pageSize) {
        RspPageBO resultPage = new RspPageBO();
        XbjOrderTypeBO xbjOrderTypeBO = this.xbjOrderTypeQryMapper.qryPurchaseOrderType(purchaseOrderId);
        if (xbjOrderTypeBO != null && XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_WUZI.intValue() == xbjOrderTypeBO.getSaleOrderPurchaseType()) {
            Page page = new Page(pageNo, pageSize);
            HashMap<String, Object> condition = new HashMap<String, Object>();
            condition.put("purchaseOrderId", purchaseOrderId);
            List<XbjOrderShipInfoBO> purchaseOrderShipList = this.xbjOrderTypeQryMapper.qryOrderShipList(condition, (Page<XbjOrderShipInfoBO>)page);
            if (purchaseOrderShipList == null) {
                purchaseOrderShipList = new ArrayList<XbjOrderShipInfoBO>();
            }
            resultPage.setRecordsTotal(page.getTotalCount());
            resultPage.setTotal(page.getTotalPages());
            resultPage.setRespCode("0000");
            resultPage.setRespDesc("\u5386\u53f2\u53d1\u8d27\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5b8c\u6210\uff01");
            resultPage.setRows(purchaseOrderShipList);
            if (this.isDebugEnabled) {
                log.debug((Object)("\u5386\u53f2\u53d1\u8d27\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u51fa\u53c2" + resultPage));
            }
        } else {
            resultPage.setRespCode("7777");
            resultPage.setRespDesc("\u8ba2\u5355\u7c7b\u578b[SALE_ORDER_PURCHASE_TYPE]\u4e0d\u662f\u53d1\u8d27\u5355");
        }
        return resultPage;
    }

    @Override
    public RspPageBO<XbjOrderConstrInfoBO> qryOrderConstrBySale(String saleOrderId, int pageNo, int pageSize) {
        RspPageBO resultPage = new RspPageBO();
        XbjOrderTypeBO xbjOrderTypeBO = this.xbjOrderTypeQryMapper.qrySaleOrderType(saleOrderId);
        if (xbjOrderTypeBO != null && XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_SHIGONG.intValue() == xbjOrderTypeBO.getSaleOrderPurchaseType()) {
            Page page = new Page(pageNo, pageSize);
            HashMap<String, Object> condition = new HashMap<String, Object>();
            condition.put("saleOrderId", saleOrderId);
            List<XbjOrderConstrInfoBO> saleOrderConstrList = this.xbjOrderTypeQryMapper.qryOrderConstrList(condition, (Page<XbjOrderConstrInfoBO>)page);
            if (saleOrderConstrList == null) {
                saleOrderConstrList = new ArrayList<XbjOrderConstrInfoBO>();
            }
            resultPage.setRecordsTotal(page.getTotalCount());
            resultPage.setTotal(page.getTotalPages());
            resultPage.setRespCode("0000");
            resultPage.setRespDesc("\u5386\u53f2\u65bd\u5de5\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5b8c\u6210\uff01");
            resultPage.setRows(saleOrderConstrList);
            if (this.isDebugEnabled) {
                log.debug((Object)("\u5386\u53f2\u65bd\u5de5\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u51fa\u53c2" + resultPage));
            }
        } else {
            resultPage.setRespCode("7777");
            resultPage.setRespDesc("\u8ba2\u5355\u7c7b\u578b[SALE_ORDER_PURCHASE_TYPE]\u4e0d\u662f\u65bd\u5de5\u5355");
        }
        return resultPage;
    }

    @Override
    public RspPageBO<XbjOrderConstrInfoBO> qryOrderConstrByPurchase(String purchaseOrderId, int pageNo, int pageSize) {
        RspPageBO resultPage = new RspPageBO();
        XbjOrderTypeBO xbjOrderTypeBO = this.xbjOrderTypeQryMapper.qryPurchaseOrderType(purchaseOrderId);
        if (xbjOrderTypeBO != null && XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_SHIGONG.intValue() == xbjOrderTypeBO.getSaleOrderPurchaseType()) {
            Page page = new Page(pageNo, pageSize);
            HashMap<String, Object> condition = new HashMap<String, Object>();
            condition.put("purchaseOrderId", purchaseOrderId);
            List<XbjOrderConstrInfoBO> purchaseOrderConstrList = this.xbjOrderTypeQryMapper.qryOrderConstrList(condition, (Page<XbjOrderConstrInfoBO>)page);
            if (purchaseOrderConstrList == null) {
                purchaseOrderConstrList = new ArrayList<XbjOrderConstrInfoBO>();
            }
            resultPage.setRecordsTotal(page.getTotalCount());
            resultPage.setTotal(page.getTotalPages());
            resultPage.setRespCode("0000");
            resultPage.setRespDesc("\u5386\u53f2\u65bd\u5de5\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5b8c\u6210\uff01");
            resultPage.setRows(purchaseOrderConstrList);
            if (this.isDebugEnabled) {
                log.debug((Object)("\u5386\u53f2\u65bd\u5de5\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u51fa\u53c2" + resultPage));
            }
        } else {
            resultPage.setRespCode("7777");
            resultPage.setRespDesc("\u8ba2\u5355\u7c7b\u578b[SALE_ORDER_PURCHASE_TYPE]\u4e0d\u662f\u65bd\u5de5\u5355");
        }
        return resultPage;
    }

    @Override
    public RspPageBO<XbjOrderServInfoBO> qryOrderServBySale(String saleOrderId, int pageNo, int pageSize) {
        RspPageBO resultPage = new RspPageBO();
        XbjOrderTypeBO xbjOrderTypeBO = this.xbjOrderTypeQryMapper.qrySaleOrderType(saleOrderId);
        if (xbjOrderTypeBO != null && XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_FUWU.intValue() == xbjOrderTypeBO.getSaleOrderPurchaseType()) {
            Page page = new Page(pageNo, pageSize);
            HashMap<String, Object> condition = new HashMap<String, Object>();
            condition.put("saleOrderId", saleOrderId);
            List<XbjOrderServInfoBO> saleOrderServList = this.xbjOrderTypeQryMapper.qryOrderServList(condition, (Page<XbjOrderServInfoBO>)page);
            if (saleOrderServList == null) {
                saleOrderServList = new ArrayList<XbjOrderServInfoBO>();
            }
            resultPage.setRecordsTotal(page.getTotalCount());
            resultPage.setTotal(page.getTotalPages());
            resultPage.setRespCode("0000");
            resultPage.setRespDesc("\u5386\u53f2\u670d\u52a1\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5b8c\u6210\uff01");
            resultPage.setRows(saleOrderServList);
            if (this.isDebugEnabled) {
                log.debug((Object)("\u5386\u53f2\u670d\u52a1\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u51fa\u53c2" + resultPage));
            }
        } else {
            resultPage.setRespCode("7777");
            resultPage.setRespDesc("\u8ba2\u5355\u7c7b\u578b[SALE_ORDER_PURCHASE_TYPE]\u4e0d\u662f\u670d\u52a1\u5355");
        }
        return resultPage;
    }

    @Override
    public RspPageBO<XbjOrderServInfoBO> qryOrderServByPurchase(String purchaseOrderId, int pageNo, int pageSize) {
        RspPageBO resultPage = new RspPageBO();
        XbjOrderTypeBO xbjOrderTypeBO = this.xbjOrderTypeQryMapper.qryPurchaseOrderType(purchaseOrderId);
        if (xbjOrderTypeBO != null && XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_FUWU.intValue() == xbjOrderTypeBO.getSaleOrderPurchaseType()) {
            Page page = new Page(pageNo, pageSize);
            HashMap<String, Object> condition = new HashMap<String, Object>();
            condition.put("purchaseOrderId", purchaseOrderId);
            List<XbjOrderServInfoBO> purchaseOrderServList = this.xbjOrderTypeQryMapper.qryOrderServList(condition, (Page<XbjOrderServInfoBO>)page);
            if (purchaseOrderServList == null) {
                purchaseOrderServList = new ArrayList<XbjOrderServInfoBO>();
            }
            resultPage.setRecordsTotal(page.getTotalCount());
            resultPage.setTotal(page.getTotalPages());
            resultPage.setRespCode("0000");
            resultPage.setRespDesc("\u5386\u53f2\u670d\u52a1\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5b8c\u6210\uff01");
            resultPage.setRows(purchaseOrderServList);
            if (this.isDebugEnabled) {
                log.debug((Object)("\u5386\u53f2\u670d\u52a1\u5355\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u51fa\u53c2" + resultPage));
            }
        } else {
            resultPage.setRespCode("7777");
            resultPage.setRespDesc("\u8ba2\u5355\u7c7b\u578b[SALE_ORDER_PURCHASE_TYPE]\u4e0d\u662f\u670d\u52a1\u5355");
        }
        return resultPage;
    }
}

