/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.cgd.order.atom.PurchaseOrderPriceAdjustmentXbjAtomService;
import com.cgd.order.atom.SaleOrderPriceAdjustmentXbjAtomService;
import com.cgd.order.atom.bo.PurchaseOrderPriceAdjustmentAtomXbjReqBO;
import com.cgd.order.atom.bo.PurchaseOrderPriceAdjustmentAtomXbjRspBO;
import com.cgd.order.atom.bo.SaleOrderPriceAdjustmentAtomXbjReqBO;
import com.cgd.order.atom.bo.SaleOrderPriceAdjustmentAtomXbjRspBO;
import com.cgd.order.dao.OrderSaleItemXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.po.OrderSaleItemXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleOrderPriceAdjustmentXbjAtomServiceImpl
implements SaleOrderPriceAdjustmentXbjAtomService {
    private static final Log log = LogFactory.getLog(SaleOrderPriceAdjustmentXbjAtomServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private OrderSaleXbjMapper orderSaleMapper;
    @Autowired
    private OrderSaleItemXbjMapper orderSaleItemMapper;
    @Autowired
    private PurchaseOrderPriceAdjustmentXbjAtomService purchaseOrderPriceAdjustmentAtomService;

    public OrderSaleXbjMapper getOrderSaleMapper() {
        return this.orderSaleMapper;
    }

    public void setOrderSaleMapper(OrderSaleXbjMapper orderSaleMapper) {
        this.orderSaleMapper = orderSaleMapper;
    }

    public OrderSaleItemXbjMapper getOrderSaleItemMapper() {
        return this.orderSaleItemMapper;
    }

    public void setOrderSaleItemMapper(OrderSaleItemXbjMapper orderSaleItemMapper) {
        this.orderSaleItemMapper = orderSaleItemMapper;
    }

    public void setPurchaseOrderPriceAdjustmentAtomService(PurchaseOrderPriceAdjustmentXbjAtomService purchaseOrderPriceAdjustmentAtomService) {
        this.purchaseOrderPriceAdjustmentAtomService = purchaseOrderPriceAdjustmentAtomService;
    }

    @Override
    public SaleOrderPriceAdjustmentAtomXbjRspBO updateSaleOrderPrice(SaleOrderPriceAdjustmentAtomXbjReqBO saleOrderPriceAdjustmentAtomReq) {
        if (this.isDebugEnabled) {
            log.debug((Object)("\u9500\u552e\u8ba2\u5355\u8c03\u4ef7\u539f\u5b50\u670d\u52a1\u5165\u53c2 SaleOrderPriceAdjustmentAtomReqBO=" + saleOrderPriceAdjustmentAtomReq));
        }
        SaleOrderPriceAdjustmentAtomXbjRspBO saleOrderPriceAdjustmentAtomRsp = new SaleOrderPriceAdjustmentAtomXbjRspBO();
        try {
            OrderSaleXbjPO orderSale = this.orderSaleMapper.selectByIdAndPurchaserId(saleOrderPriceAdjustmentAtomReq.getSaleOrderId(), saleOrderPriceAdjustmentAtomReq.getPurchaserId());
            if (orderSale == null) {
                saleOrderPriceAdjustmentAtomRsp.setRespCode("RSP_CODE_ATOM_SERVICE_ERROR");
                saleOrderPriceAdjustmentAtomRsp.setRespDesc("\u9500\u552e\u8ba2\u5355\u8c03\u4ef7\u539f\u5b50\u670d\u52a1\uff1a\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u9500\u552e\u8ba2\u5355ID\uff1a" + saleOrderPriceAdjustmentAtomReq.getSaleOrderId());
                return saleOrderPriceAdjustmentAtomRsp;
            }
            List<OrderSaleItemXbjPO> orderSaleItemList = this.orderSaleItemMapper.selectBySaleOrderAndPurchaserId(saleOrderPriceAdjustmentAtomReq.getSaleOrderId(), saleOrderPriceAdjustmentAtomReq.getPurchaserId());
            if (null == orderSaleItemList || orderSaleItemList.size() <= 0) {
                saleOrderPriceAdjustmentAtomRsp.setRespCode("RSP_CODE_ATOM_SERVICE_ERROR");
                saleOrderPriceAdjustmentAtomRsp.setRespDesc("\u9500\u552e\u8ba2\u5355\u8c03\u4ef7\u539f\u5b50\u670d\u52a1\uff1a\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u4e0d\u5b58\u5728\uff0c\u9500\u552e\u8ba2\u5355ID\uff1a" + saleOrderPriceAdjustmentAtomReq.getSaleOrderId());
                return saleOrderPriceAdjustmentAtomRsp;
            }
            Map<String, String> mapMoney = this.getOrderSumPrice(orderSaleItemList);
            String respStr = mapMoney.get("respStr");
            if (!StringUtils.isBlank((CharSequence)respStr)) {
                saleOrderPriceAdjustmentAtomRsp.setRespCode("RSP_CODE_ATOM_SERVICE_ERROR");
                saleOrderPriceAdjustmentAtomRsp.setRespDesc("\u9500\u552e\u8ba2\u5355\u8c03\u4ef7\u539f\u5b50\u670d\u52a1\uff1a\u83b7\u53d6\u9500\u552e\u8ba2\u5355\u91c7\u8d2d\u603b\u91d1\u989d\u3001\u9500\u552e\u603b\u91d1\u989d\u5f02\u5e38");
                return saleOrderPriceAdjustmentAtomRsp;
            }
            String respDesc = this.updateSaleOrderItemPrice(orderSaleItemList);
            if (!StringUtils.isBlank((CharSequence)respDesc)) {
                saleOrderPriceAdjustmentAtomRsp.setRespCode("RSP_CODE_ATOM_SERVICE_ERROR");
                saleOrderPriceAdjustmentAtomRsp.setRespDesc(respDesc);
                return saleOrderPriceAdjustmentAtomRsp;
            }
            orderSale.setSaleOrderMoney(Long.valueOf(mapMoney.get("sunSellingPrice")));
            int updateCount = this.orderSaleMapper.updateById(orderSale);
            if (updateCount <= 0) {
                saleOrderPriceAdjustmentAtomRsp.setRespCode("RSP_CODE_ATOM_SERVICE_ERROR");
                saleOrderPriceAdjustmentAtomRsp.setRespDesc("\u9500\u552e\u8ba2\u5355\u8c03\u4ef7\u539f\u5b50\u670d\u52a1\uff1a\u66f4\u65b0\u9500\u552e\u8ba2\u5355\u9500\u552e\u8ba2\u5355\u91d1\u989d\u5931\u8d25\uff0c\u9500\u552e\u8ba2\u5355ID\uff1a" + saleOrderPriceAdjustmentAtomReq.getSaleOrderId());
                return saleOrderPriceAdjustmentAtomRsp;
            }
            PurchaseOrderPriceAdjustmentAtomXbjReqBO purchaseOrderPriceAdjustmentAtomReq = new PurchaseOrderPriceAdjustmentAtomXbjReqBO();
            purchaseOrderPriceAdjustmentAtomReq.setPurchaseOrderId(orderSale.getPurchaseOrderId());
            purchaseOrderPriceAdjustmentAtomReq.setPurchaserId(orderSale.getPurchaserId());
            purchaseOrderPriceAdjustmentAtomReq.setPurchaseOrderMoney(Long.valueOf(mapMoney.get("sunPurchasingPrice")));
            purchaseOrderPriceAdjustmentAtomReq.setOrderSaleItemList(orderSaleItemList);
            PurchaseOrderPriceAdjustmentAtomXbjRspBO purchaseOrderPriceAdjustmentAtomRsp = this.purchaseOrderPriceAdjustmentAtomService.purchaseOrderPriceAdjustment(purchaseOrderPriceAdjustmentAtomReq);
            if (purchaseOrderPriceAdjustmentAtomRsp != null && !purchaseOrderPriceAdjustmentAtomRsp.getIsSuccess().booleanValue()) {
                saleOrderPriceAdjustmentAtomRsp.setRespCode("RSP_CODE_ATOM_SERVICE_ERROR");
                saleOrderPriceAdjustmentAtomRsp.setRespDesc(purchaseOrderPriceAdjustmentAtomRsp.getRespDesc());
                return saleOrderPriceAdjustmentAtomRsp;
            }
            saleOrderPriceAdjustmentAtomRsp.setRespCode("0000");
            saleOrderPriceAdjustmentAtomRsp.setRespDesc("\u9500\u552e\u8ba2\u5355\u8c03\u4ef7\u539f\u5b50\u670d\u52a1\u6267\u884c\u6210\u529f\uff01");
        }
        catch (Exception e) {
            saleOrderPriceAdjustmentAtomRsp.setRespCode("RSP_CODE_ATOM_SERVICE_ERROR");
            saleOrderPriceAdjustmentAtomRsp.setRespDesc("\u9500\u552e\u8ba2\u5355\u8c03\u4ef7\u539f\u5b50\u670d\u52a1\u5f02\u5e38");
            return saleOrderPriceAdjustmentAtomRsp;
        }
        return saleOrderPriceAdjustmentAtomRsp;
    }

    private String updateSaleOrderItemPrice(List<OrderSaleItemXbjPO> orderSaleItemList) {
        String respDesc = null;
        try {
            for (OrderSaleItemXbjPO orderSaleItem : orderSaleItemList) {
                BigDecimal sellingPrice = new BigDecimal(orderSaleItem.getNewSellingPrice());
                BigDecimal total = sellingPrice.multiply(orderSaleItem.getPurchaseCount());
                orderSaleItem.setTotal(total.longValue());
                orderSaleItem.setSellingPrice(orderSaleItem.getNewSellingPrice());
                orderSaleItem.setPurchasingPrice(orderSaleItem.getNewPurchasingPrice());
                orderSaleItem.setMarkUpRate(orderSaleItem.getMarkUpRateNew());
                orderSaleItem.setMarkUpRateNew(orderSaleItem.getMarkUpRateNew());
                int resultSale = this.orderSaleItemMapper.updateById(orderSaleItem);
                if (resultSale > 0) continue;
                respDesc = "\u9500\u552e\u8ba2\u5355\u8c03\u4ef7\u539f\u5b50\u670d\u52a1\uff1a\u66f4\u65b0\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u5931\u8d25\uff0c\u9500\u552e\u8ba2\u5355ID\uff1a" + orderSaleItem.getSaleOrderId();
                return respDesc;
            }
        }
        catch (Exception e) {
            log.error((Object)"\u9500\u552e\u8ba2\u5355\u8c03\u4ef7\u539f\u5b50\u670d\u52a1\uff1a\u66f4\u65b0\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u4ef7\u683c\u5f02\u5e38", (Throwable)e);
            respDesc = "\u9500\u552e\u8ba2\u5355\u8c03\u4ef7\u539f\u5b50\u670d\u52a1\uff1a\u66f4\u65b0\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u5931\u8d25\uff0c\u9500\u552e\u8ba2\u5355ID\uff1a" + orderSaleItemList.get(0).getSaleOrderId();
        }
        return respDesc;
    }

    private Map<String, String> getOrderSumPrice(List<OrderSaleItemXbjPO> orderSaleItemList) {
        HashMap<String, String> map = new HashMap<String, String>();
        BigDecimal sunPurchasingPrice = new BigDecimal("0");
        BigDecimal sunSellingPrice = new BigDecimal("0");
        try {
            for (OrderSaleItemXbjPO orderSaleItem : orderSaleItemList) {
                if (orderSaleItem.getNewPurchasingPrice() == null || orderSaleItem.getNewSellingPrice() == null || orderSaleItem.getMarkUpRateNew() == null) {
                    log.error((Object)"\u9500\u552e\u8ba2\u5355\u8c03\u4ef7\u539f\u5b50\u670d\u52a1\uff1a\u65b0\u91c7\u8d2d\u4ef7\u683c\u3001\u65b0\u9500\u552e\u4ef7\u683c\u3001\u65b0\u8c03\u4ef7\u6bd4\u7387\u5305\u542b\u7a7a\u503c");
                    map.put("respStr", "\u9500\u552e\u8ba2\u5355\u8c03\u4ef7\u539f\u5b50\u670d\u52a1\uff1a\u65b0\u91c7\u8d2d\u4ef7\u683c\u3001\u65b0\u9500\u552e\u4ef7\u683c\u3001\u65b0\u8c03\u4ef7\u6bd4\u7387\u5305\u542b\u7a7a\u503c");
                }
                BigDecimal purchasingPrice = new BigDecimal(orderSaleItem.getNewPurchasingPrice());
                BigDecimal sellingPrice = new BigDecimal(orderSaleItem.getNewSellingPrice());
                sunPurchasingPrice = sunPurchasingPrice.add(purchasingPrice.multiply(orderSaleItem.getPurchaseCount()));
                sunSellingPrice = sunSellingPrice.add(sellingPrice.multiply(orderSaleItem.getPurchaseCount()));
            }
            map.put("sunPurchasingPrice", String.valueOf(sunPurchasingPrice.longValue()));
            map.put("sunSellingPrice", String.valueOf(sunSellingPrice.longValue()));
        }
        catch (Exception e) {
            log.error((Object)"\u9500\u552e\u8ba2\u5355\u8c03\u4ef7\u539f\u5b50\u670d\u52a1\uff1a\u83b7\u53d6\u9500\u552e\u8ba2\u5355\u91c7\u8d2d\u603b\u91d1\u989d\u3001\u9500\u552e\u603b\u91d1\u989d\u5f02\u5e38", (Throwable)e);
            map.put("respStr", "\u9500\u552e\u8ba2\u5355\u8c03\u4ef7\u539f\u5b50\u670d\u52a1\uff1a\u83b7\u53d6\u9500\u552e\u8ba2\u5355\u91c7\u8d2d\u603b\u91d1\u989d\u3001\u9500\u552e\u603b\u91d1\u989d\u5f02\u5e38");
        }
        return map;
    }
}

