/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.atom.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.order.atom.CreateAgreementAttachXbjAtomService;
import com.cgd.order.atom.CreateSalesOrderDetailsXbjAtomService;
import com.cgd.order.atom.GenerateOrderIdAndCodeXbjAtomService;
import com.cgd.order.atom.GetSalesOrderSeqXbjAtomService;
import com.cgd.order.atom.XbjProtocolCreateSaleOrderAtomService;
import com.cgd.order.atom.bo.GenerateOrderIdAndCodeXbjReqBO;
import com.cgd.order.atom.bo.GenerateOrderIdAndCodeXbjRspBO;
import com.cgd.order.atom.bo.OrderProtocolItemAtomXbjReqBO;
import com.cgd.order.atom.bo.SalesOrderDetailsXbjReqBo;
import com.cgd.order.busi.bo.XbjAccessoryBusiReqBO;
import com.cgd.order.busi.bo.XbjProtocolOrderSaleBusiReqBO;
import com.cgd.order.busi.bo.XbjProtocolOrderSaleBusiRspBO;
import com.cgd.order.busi.bo.XbjProtocolOrderSaleItemReqBO;
import com.cgd.order.busi.bo.XbjProtocolSubmitOrderSaleItemIntfceRspBO;
import com.cgd.order.constant.Constant;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.AccessoryXbjMapper;
import com.cgd.order.dao.InfoAddressXbjMapper;
import com.cgd.order.dao.OrderProfessionalOrganizationXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.po.AccessoryXbjPO;
import com.cgd.order.po.InfoAddressXbjPO;
import com.cgd.order.po.OrderProfessionalOrganizationXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import com.cgd.order.util.FormatCodeUtilXbj;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class XbjProtocolCreateSaleOrderAtomServiceImpl
implements XbjProtocolCreateSaleOrderAtomService {
    private static final Logger log = LoggerFactory.getLogger(XbjProtocolCreateSaleOrderAtomServiceImpl.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private InfoAddressXbjMapper infoAddressXbjMapper;
    private OrderSaleXbjMapper orderSaleXbjMapper;
    private CreateSalesOrderDetailsXbjAtomService createSalesOrderDetailsXbjAtomService;
    private GetSalesOrderSeqXbjAtomService getSalesOrderSeqXbjAtomService;
    private CreateAgreementAttachXbjAtomService createAgreementAttachXbjAtomService;
    private AccessoryXbjMapper accessoryXbjMapper;
    private GenerateOrderIdAndCodeXbjAtomService generateOrderIdAndCodeXbjAtomService;
    private OrderProfessionalOrganizationXbjMapper orderProfessionalOrganizationXbjMapper;

    public void setInfoAddressXbjMapper(InfoAddressXbjMapper infoAddressXbjMapper) {
        this.infoAddressXbjMapper = infoAddressXbjMapper;
    }

    public void setOrderSaleXbjMapper(OrderSaleXbjMapper orderSaleXbjMapper) {
        this.orderSaleXbjMapper = orderSaleXbjMapper;
    }

    public void setCreateSalesOrderDetailsXbjAtomService(CreateSalesOrderDetailsXbjAtomService createSalesOrderDetailsXbjAtomService) {
        this.createSalesOrderDetailsXbjAtomService = createSalesOrderDetailsXbjAtomService;
    }

    public void setGetSalesOrderSeqXbjAtomService(GetSalesOrderSeqXbjAtomService getSalesOrderSeqXbjAtomService) {
        this.getSalesOrderSeqXbjAtomService = getSalesOrderSeqXbjAtomService;
    }

    public void setCreateAgreementAttachXbjAtomService(CreateAgreementAttachXbjAtomService createAgreementAttachXbjAtomService) {
        this.createAgreementAttachXbjAtomService = createAgreementAttachXbjAtomService;
    }

    public void setAccessoryXbjMapper(AccessoryXbjMapper accessoryXbjMapper) {
        this.accessoryXbjMapper = accessoryXbjMapper;
    }

    public void setGenerateOrderIdAndCodeXbjAtomService(GenerateOrderIdAndCodeXbjAtomService generateOrderIdAndCodeXbjAtomService) {
        this.generateOrderIdAndCodeXbjAtomService = generateOrderIdAndCodeXbjAtomService;
    }

    public void setOrderProfessionalOrganizationXbjMapper(OrderProfessionalOrganizationXbjMapper orderProfessionalOrganizationXbjMapper) {
        this.orderProfessionalOrganizationXbjMapper = orderProfessionalOrganizationXbjMapper;
    }

    @Override
    public XbjProtocolOrderSaleBusiRspBO createXbjProtocolSaleOrder(XbjProtocolOrderSaleBusiReqBO xbjProtocolOrderSaleBusiReqBO) {
        if (isDebugEnabled) {
            log.debug("\u8be2\u6bd4\u4ef7\uff08\u6846\u67b6\u534f\u8bae\uff09\u9500\u552e\u8ba2\u5355\u521b\u5efa\u5165\u53c2" + xbjProtocolOrderSaleBusiReqBO);
        }
        XbjProtocolOrderSaleBusiRspBO xbjProtocolOrderSaleBusiRspBO = new XbjProtocolOrderSaleBusiRspBO();
        try {
            this.validateNotNullBO(xbjProtocolOrderSaleBusiReqBO);
            OrderProfessionalOrganizationXbjPO orderProfessionalOrganization = this.orderProfessionalOrganizationXbjMapper.qryOrderProfessional(xbjProtocolOrderSaleBusiReqBO.getProfessionalOrganizationId());
            if (null == orderProfessionalOrganization || orderProfessionalOrganization.getPrefix() == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\uff08\u6846\u67b6\u534f\u8bae\uff09\u7ec4\u7ec7\u673a\u6784\u67e5\u8be2\u5f02\u5e38");
            }
            GenerateOrderIdAndCodeXbjReqBO generateSaleOrderIDAndCodeRepBO = new GenerateOrderIdAndCodeXbjReqBO();
            generateSaleOrderIDAndCodeRepBO.setGenerateOrderType(XbjOrderConstants.GENERATE_ORDER_TYPE.SALE);
            generateSaleOrderIDAndCodeRepBO.setPrefix(orderProfessionalOrganization.getPrefix());
            GenerateOrderIdAndCodeXbjRspBO generateSaleOrderIDAndCodeRspBO = this.generateOrderIdAndCodeXbjAtomService.generateOrderIdAndCode(generateSaleOrderIDAndCodeRepBO);
            if (generateSaleOrderIDAndCodeRspBO == null || generateSaleOrderIDAndCodeRspBO.getOrderId() == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\uff08\u6846\u67b6\u534f\u8bae\uff09\u9500\u552e\u8ba2\u5355ID\u548c\u7f16\u53f7\u751f\u6210\u5f02\u5e38");
            }
            if (isDebugEnabled) {
                log.debug("\u9500\u552e\u8ba2\u5355ID\uff1a" + generateSaleOrderIDAndCodeRspBO.getOrderId() + "\u9500\u552e\u8ba2\u5355CODE\uff1a" + generateSaleOrderIDAndCodeRspBO.getOrderCode());
            }
            GenerateOrderIdAndCodeXbjReqBO generatePurchaseIdAndCodeXbjReqBO = new GenerateOrderIdAndCodeXbjReqBO();
            generatePurchaseIdAndCodeXbjReqBO.setGenerateOrderType(XbjOrderConstants.GENERATE_ORDER_TYPE.PURCHASE);
            generatePurchaseIdAndCodeXbjReqBO.setSaleOrderCode(generateSaleOrderIDAndCodeRspBO.getOrderCode());
            GenerateOrderIdAndCodeXbjRspBO generatePurchaseIDAndCodeRspBO = this.generateOrderIdAndCodeXbjAtomService.generateOrderIdAndCode(generatePurchaseIdAndCodeXbjReqBO);
            if (generatePurchaseIDAndCodeRspBO == null || generatePurchaseIDAndCodeRspBO.getOrderId() == null) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\uff08\u6846\u67b6\u534f\u8bae\uff09\u91c7\u8d2d\u8ba2\u5355ID\u548c\u7f16\u53f7\u751f\u6210\u5f02\u5e38");
            }
            if (isDebugEnabled) {
                log.debug("\u91c7\u8d2d\u8ba2\u5355ID\uff1a" + generateSaleOrderIDAndCodeRspBO.getOrderId() + "\u91c7\u8d2d\u8ba2\u5355CODE\uff1a" + generateSaleOrderIDAndCodeRspBO.getOrderCode());
            }
            if (Constant.IS_DISPATCH_NO.equals(xbjProtocolOrderSaleBusiReqBO.getIsDisPatch())) {
                xbjProtocolOrderSaleBusiReqBO.setProfessionalOrganizationId(xbjProtocolOrderSaleBusiReqBO.getGoodsSupplierId());
            }
            InfoAddressXbjPO infoAddressPO = this.initInfoAddress(xbjProtocolOrderSaleBusiReqBO, generateSaleOrderIDAndCodeRspBO);
            try {
                this.infoAddressXbjMapper.insertSelective(infoAddressPO);
            }
            catch (Exception e) {
                if (isDebugEnabled) {
                    log.debug("\u8be2\u6bd4\u4ef7\uff08\u6846\u67b6\u534f\u8bae\uff09\u9500\u552e\u8ba2\u5355\u5730\u5740\u751f\u6210\u4fe1\u606f\u63d2\u5165\u6570\u636e\u5e93\u5f02\u5e38!" + e.getMessage());
                }
                throw new BusinessException("RSP_CODE_DAO_ERROR", "\u8be2\u6bd4\u4ef7\uff08\u6846\u67b6\u534f\u8bae\uff09\u9500\u552e\u8ba2\u5355\u5730\u5740\u4fe1\u606f\u751f\u6210\u63d2\u5165\u6570\u636e\u5e93\u5f02\u5e38");
            }
            OrderSaleXbjPO transformationOrderSale = this.initOrderSale(xbjProtocolOrderSaleBusiReqBO, generateSaleOrderIDAndCodeRspBO, generatePurchaseIDAndCodeRspBO);
            try {
                this.orderSaleXbjMapper.insertSelective(transformationOrderSale);
            }
            catch (Exception e) {
                if (isDebugEnabled) {
                    log.debug("\u8be2\u6bd4\u4ef7\uff08\u6846\u67b6\u534f\u8bae\uff09\u9500\u552e\u8ba2\u5355\u751f\u6210\u63d2\u5165\u6570\u636e\u5e93\u5f02\u5e38!" + e.getMessage());
                }
                throw new BusinessException("RSP_CODE_DAO_ERROR", "\u8be2\u6bd4\u4ef7\uff08\u6846\u67b6\u534f\u8bae\uff09\u9500\u552e\u8ba2\u5355\u751f\u6210\u63d2\u5165\u6570\u636e\u5e93\u5f02\u5e38");
            }
            List<SalesOrderDetailsXbjReqBo> salesOrderDetailsReq = this.initSalesOrderDetailsReq(xbjProtocolOrderSaleBusiReqBO, generateSaleOrderIDAndCodeRspBO);
            try {
                this.createSalesOrderDetailsXbjAtomService.createOrderDetails(salesOrderDetailsReq);
            }
            catch (Exception e) {
                if (isDebugEnabled) {
                    log.debug("\u751f\u6210\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u7f16\u539f\u5b50\u670d\u52a1\u5f02\u5e38!" + e.getMessage());
                }
                throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u751f\u6210\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u7f16\u539f\u5b50\u670d\u52a1\u5f02\u5e38!");
            }
            try {
                OrderProtocolItemAtomXbjReqBO eaOrderProtocolItemAtom = this.initOrderProtocolItem(xbjProtocolOrderSaleBusiReqBO, generatePurchaseIDAndCodeRspBO, generateSaleOrderIDAndCodeRspBO);
                this.createAgreementAttachXbjAtomService.createAgreementAttachAtomService(eaOrderProtocolItemAtom);
            }
            catch (Exception e) {
                if (isDebugEnabled) {
                    log.debug("\u8be2\u6bd4\u4ef7\uff08\u6846\u67b6\u534f\u8bae\uff09\u751f\u6210\u534f\u8bae\u660e\u7ec6\u5f02\u5e38!" + e.getMessage());
                }
                throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\uff08\u6846\u67b6\u534f\u8bae\uff09\u751f\u6210\u534f\u8bae\u660e\u7ec6\u5f02\u5e38!");
            }
            try {
                List accessoryList = xbjProtocolOrderSaleBusiReqBO.getAccessoryList();
                if (null != accessoryList && !accessoryList.isEmpty()) {
                    ArrayList<AccessoryXbjPO> orderAccessorys = new ArrayList<AccessoryXbjPO>();
                    for (XbjAccessoryBusiReqBO accessoryBusiReqBO : accessoryList) {
                        AccessoryXbjPO accessory = new AccessoryXbjPO();
                        accessory.setObjectId(transformationOrderSale.getSaleOrderId());
                        accessory.setObjectType(Constant.ORDER_SALE_CREATE_OBJECT_TYPE);
                        accessory.setPurchaserId(transformationOrderSale.getPurchaserId());
                        accessory.setPurchaserAccountId(transformationOrderSale.getPurchaserAccountId());
                        accessory.setPurchaserAccountName(transformationOrderSale.getPurchaserAccountName());
                        accessory.setProfessionalOrganizationId(transformationOrderSale.getProfessionalOrganizationId() + "");
                        accessory.setGoodsSupplierId(transformationOrderSale.getGoodsSupplierId() + "");
                        accessory.setAccessoryName(accessoryBusiReqBO.getAccessoryName());
                        accessory.setAccessoryUrl(accessoryBusiReqBO.getAccessoryUrl());
                        accessory.setAccessoryId(accessoryBusiReqBO.getAccessoryId() + "");
                        accessory.setCreateDate(new Date());
                        orderAccessorys.add(accessory);
                    }
                    this.accessoryXbjMapper.insertSelectiveBatch(orderAccessorys);
                }
            }
            catch (Exception e) {
                if (isDebugEnabled) {
                    log.debug("\u8be2\u6bd4\u4ef7\uff08\u6846\u67b6\u534f\u8bae\uff09\u4e0b\u5355\u9644\u4ef6\u751f\u6210\u5f02\u5e38\uff1a" + e.getMessage());
                }
                throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\uff08\u6846\u67b6\u534f\u8bae\uff09\u4e0b\u5355\u9644\u4ef6\u751f\u6210\u5f02\u5e38!");
            }
            ArrayList<XbjProtocolSubmitOrderSaleItemIntfceRspBO> xbjProtocolSubmitOrderSaleItemIntfceRspList = new ArrayList<XbjProtocolSubmitOrderSaleItemIntfceRspBO>();
            XbjProtocolSubmitOrderSaleItemIntfceRspBO xbjProtocolSubmitOrderSaleItemIntfceRspBO = new XbjProtocolSubmitOrderSaleItemIntfceRspBO();
            xbjProtocolSubmitOrderSaleItemIntfceRspBO.setSaleOrderCode(transformationOrderSale.getSaleOrderCode());
            xbjProtocolSubmitOrderSaleItemIntfceRspBO.setSaleOrderId(String.valueOf(transformationOrderSale.getSaleOrderId()));
            xbjProtocolSubmitOrderSaleItemIntfceRspBO.setGoodsSupplierId(String.valueOf(transformationOrderSale.getGoodsSupplierId()));
            xbjProtocolSubmitOrderSaleItemIntfceRspBO.setGoodSupplierName(transformationOrderSale.getGoodsSupplierName());
            xbjProtocolSubmitOrderSaleItemIntfceRspBO.setStatusId(transformationOrderSale.getSaleOrderStatus());
            xbjProtocolSubmitOrderSaleItemIntfceRspBO.setStatusName("");
            xbjProtocolSubmitOrderSaleItemIntfceRspBO.setFee(new BigDecimal(transformationOrderSale.getSaleOrderMoney()));
            xbjProtocolSubmitOrderSaleItemIntfceRspBO.setPurchaseOrderId(String.valueOf(transformationOrderSale.getPurchaserId()));
            xbjProtocolSubmitOrderSaleItemIntfceRspList.add(xbjProtocolSubmitOrderSaleItemIntfceRspBO);
            xbjProtocolOrderSaleBusiRspBO.setXbjProtocolSubmitOrderSaleItemIntfceRspBO(xbjProtocolSubmitOrderSaleItemIntfceRspList);
            xbjProtocolOrderSaleBusiRspBO.setRespCode("0000");
            xbjProtocolOrderSaleBusiRspBO.setRespDesc("\u9500\u552e\u8ba2\u5355\u53ca\u660e\u7ec6\u751f\u6210\u6210\u529f!");
            return xbjProtocolOrderSaleBusiRspBO;
        }
        catch (Exception e) {
            if (isDebugEnabled) {
                log.debug("\u8be2\u6bd4\u4ef7\uff08\u6846\u67b6\u534f\u8bae\uff09\u9500\u552e\u8ba2\u5355\u751f\u6210\u5f02\u5e38\uff1a", (Throwable)e);
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\uff08\u6846\u67b6\u534f\u8bae\uff09\u751f\u6210\u9500\u552e\u8ba2\u5355\u51fa\u9519\uff01");
        }
    }

    public void validateNotNullBO(XbjProtocolOrderSaleBusiReqBO xbjProtocolOrderSaleBusiReqBO) {
        if (null == xbjProtocolOrderSaleBusiReqBO) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\u4e3a\u7a7a");
        }
        if (null == xbjProtocolOrderSaleBusiReqBO.getInfoAddress().getReceiverProvinceId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u6536\u8d27\u4eba\u7701\u4efd\u7f16\u7801\u4e3a\u7a7a");
        }
        if (null == xbjProtocolOrderSaleBusiReqBO.getInfoAddress().getReceiverCityId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u6536\u8d27\u4eba\u5730\u5e02\u7f16\u7801\u4e3a\u7a7a");
        }
        if (null == xbjProtocolOrderSaleBusiReqBO.getInfoAddress().getReceiverCountyId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u6536\u8d27\u4eba\u533a\u53bf\u7f16\u7801\u4e3a\u7a7a");
        }
        if (null == xbjProtocolOrderSaleBusiReqBO.getInfoAddress().getReceiverName()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u6536\u8d27\u4eba\u540d\u79f0\u4e3a\u7a7a");
        }
        if (null == xbjProtocolOrderSaleBusiReqBO.getInfoAddress().getReceiverAddress()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u6536\u8d27\u4eba\u5730\u5740\u4e3a\u7a7a");
        }
        if (null == xbjProtocolOrderSaleBusiReqBO.getPurchaserAccount()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u91c7\u8d2d\u8d26\u5957\u7f16\u7801\u4e3a\u7a7a");
        }
        if (null == xbjProtocolOrderSaleBusiReqBO.getPurchaserId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u91c7\u8d2d\u5546\u7f16\u53f7\u4e3a\u7a7a");
        }
        if (null == xbjProtocolOrderSaleBusiReqBO.getPurchaserAccountId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u91c7\u8d2d\u5546\u4e0b\u5355\u4eba\u7f16\u53f7\u4e3a\u7a7a");
        }
        if (null == xbjProtocolOrderSaleBusiReqBO.getProfessionalOrganizationId()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u4e13\u4e1a\u673a\u6784\u7f16\u53f7\u4e3a\u7a7a");
        }
        if (null == xbjProtocolOrderSaleBusiReqBO.getSaleOrderType()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u9500\u552e\u8ba2\u5355\u6765\u6e90\u4e3a\u7a7a");
        }
        if (null == xbjProtocolOrderSaleBusiReqBO.getSaleOrderPurchaseType()) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u91c7\u8d2d\u7c7b\u522b\u4e3a\u7a7a");
        }
    }

    public InfoAddressXbjPO initInfoAddress(XbjProtocolOrderSaleBusiReqBO xbjProtocolOrderSaleBusiReqBO, GenerateOrderIdAndCodeXbjRspBO generateOrderSale) {
        InfoAddressXbjPO infoAddress = new InfoAddressXbjPO();
        infoAddress.setSaleOrderId(generateOrderSale.getOrderId());
        infoAddress.setPurchaserId(xbjProtocolOrderSaleBusiReqBO.getPurchaserId());
        infoAddress.setPurchaserAccountId(xbjProtocolOrderSaleBusiReqBO.getPurchaserAccountId());
        infoAddress.setPurchaserAccountName(xbjProtocolOrderSaleBusiReqBO.getPurchaserAccountName());
        infoAddress.setProfessionalOrganizationId(xbjProtocolOrderSaleBusiReqBO.getProfessionalOrganizationId());
        infoAddress.setGoodsSupplierId(xbjProtocolOrderSaleBusiReqBO.getGoodsSupplierId());
        infoAddress.setReceiverCountryId(xbjProtocolOrderSaleBusiReqBO.getInfoAddress().getReceiverCountryId());
        infoAddress.setReceiverCountryName(xbjProtocolOrderSaleBusiReqBO.getInfoAddress().getReceiverCountryName());
        infoAddress.setReceiverProvinceId(xbjProtocolOrderSaleBusiReqBO.getInfoAddress().getReceiverProvinceId());
        infoAddress.setReceiverProvinceName(xbjProtocolOrderSaleBusiReqBO.getInfoAddress().getReceiverProvinceName());
        infoAddress.setReceiverCityId(xbjProtocolOrderSaleBusiReqBO.getInfoAddress().getReceiverCityId());
        infoAddress.setReceiverCityName(xbjProtocolOrderSaleBusiReqBO.getInfoAddress().getReceiverCityName());
        infoAddress.setReceiverCountyId(xbjProtocolOrderSaleBusiReqBO.getInfoAddress().getReceiverCountyId());
        infoAddress.setReceiverCountyName(xbjProtocolOrderSaleBusiReqBO.getInfoAddress().getReceiverCountyName());
        infoAddress.setReceiverTown(xbjProtocolOrderSaleBusiReqBO.getInfoAddress().getReceiverTown());
        infoAddress.setReceiverTownId(xbjProtocolOrderSaleBusiReqBO.getInfoAddress().getReceiverTownId());
        infoAddress.setReceiverAddress(xbjProtocolOrderSaleBusiReqBO.getInfoAddress().getReceiverAddress());
        infoAddress.setReceiverCompany(xbjProtocolOrderSaleBusiReqBO.getInfoAddress().getReceiverCompany());
        infoAddress.setReceiverName(xbjProtocolOrderSaleBusiReqBO.getInfoAddress().getReceiverName());
        infoAddress.setReceiverFixPhone(xbjProtocolOrderSaleBusiReqBO.getInfoAddress().getReceiverFixPhone());
        infoAddress.setReceiverMobileNumber(xbjProtocolOrderSaleBusiReqBO.getInfoAddress().getReceiverMobileNumber());
        infoAddress.setReceiverEmail(xbjProtocolOrderSaleBusiReqBO.getInfoAddress().getReceiverEmail());
        return infoAddress;
    }

    public OrderSaleXbjPO initOrderSale(XbjProtocolOrderSaleBusiReqBO xbjProtocolOrderSaleBusiReqBO, GenerateOrderIdAndCodeXbjRspBO generateOrderIdAndCodeXbjRspBO, GenerateOrderIdAndCodeXbjRspBO generatePurchaseIdAndCodeXbjRspBO) {
        OrderSaleXbjPO orderSale = new OrderSaleXbjPO();
        BeanUtils.copyProperties((Object)xbjProtocolOrderSaleBusiReqBO, (Object)orderSale);
        orderSale.setSaleOrderCode(generateOrderIdAndCodeXbjRspBO.getOrderCode());
        orderSale.setSaleOrderId(generateOrderIdAndCodeXbjRspBO.getOrderId());
        orderSale.setPurchaseOrderCode(generatePurchaseIdAndCodeXbjRspBO.getOrderCode());
        orderSale.setPurchaseOrderId(generatePurchaseIdAndCodeXbjRspBO.getOrderId());
        orderSale.setPlaAgreementCode(xbjProtocolOrderSaleBusiReqBO.getPlaAgreementCode());
        orderSale.setIsDispatch(xbjProtocolOrderSaleBusiReqBO.getIsDispatch());
        orderSale.setCreateTime(new Date());
        orderSale.setGiveTime(xbjProtocolOrderSaleBusiReqBO.getGiveTime());
        orderSale.setArriveTime(xbjProtocolOrderSaleBusiReqBO.getArriveTime());
        return orderSale;
    }

    public List<SalesOrderDetailsXbjReqBo> initSalesOrderDetailsReq(XbjProtocolOrderSaleBusiReqBO xbjProtocolOrderSaleBusiReqBO, GenerateOrderIdAndCodeXbjRspBO generateOrderSale) {
        ArrayList<SalesOrderDetailsXbjReqBo> orderSaleItem = new ArrayList<SalesOrderDetailsXbjReqBo>();
        List orderSaleItemList = xbjProtocolOrderSaleBusiReqBO.getXbjProtocolOrderSaleItemList();
        for (int i = 0; i < orderSaleItemList.size(); ++i) {
            Long salesOrderSeq = this.getSalesOrderSeqXbjAtomService.getSalesOrderSeq();
            if (null == salesOrderSeq) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u7f16\u53f7\u751f\u6210\u5f02\u5e38");
            }
            SalesOrderDetailsXbjReqBo salesOrderDetails = new SalesOrderDetailsXbjReqBo();
            salesOrderDetails.setSaleOrderItemId(salesOrderSeq);
            salesOrderDetails.setSaleOrderId(generateOrderSale.getOrderId());
            salesOrderDetails.setPurchaserId(xbjProtocolOrderSaleBusiReqBO.getPurchaserId());
            salesOrderDetails.setPurchaserAccountId(xbjProtocolOrderSaleBusiReqBO.getPurchaserAccountId());
            salesOrderDetails.setPurchaserAccountName(xbjProtocolOrderSaleBusiReqBO.getPurchaserAccountName());
            salesOrderDetails.setProfessionalOrganizationId(xbjProtocolOrderSaleBusiReqBO.getProfessionalOrganizationId());
            salesOrderDetails.setGoodsSupplierId(xbjProtocolOrderSaleBusiReqBO.getGoodsSupplierId());
            salesOrderDetails.setDeptId(xbjProtocolOrderSaleBusiReqBO.getDeptId());
            salesOrderDetails.setPurchaserAccountOrgId(xbjProtocolOrderSaleBusiReqBO.getPurchaserAccountOrgId());
            salesOrderDetails.setMaterialName(((XbjProtocolOrderSaleItemReqBO)orderSaleItemList.get(i)).getMaterialName());
            salesOrderDetails.setSpecifications(((XbjProtocolOrderSaleItemReqBO)orderSaleItemList.get(i)).getSpecifications());
            salesOrderDetails.setModel(((XbjProtocolOrderSaleItemReqBO)orderSaleItemList.get(i)).getModel());
            salesOrderDetails.setFigureNo(((XbjProtocolOrderSaleItemReqBO)orderSaleItemList.get(i)).getFigureNo());
            salesOrderDetails.setMaterialQuality(((XbjProtocolOrderSaleItemReqBO)orderSaleItemList.get(i)).getMaterialQuality());
            if (((XbjProtocolOrderSaleItemReqBO)orderSaleItemList.get(i)).getMaterialId() != null) {
                salesOrderDetails.setMaterialId(((XbjProtocolOrderSaleItemReqBO)orderSaleItemList.get(i)).getMaterialId() + "");
            }
            if (((XbjProtocolOrderSaleItemReqBO)orderSaleItemList.get(i)).getMaterialClassId() != null) {
                salesOrderDetails.setSkuId(FormatCodeUtilXbj.skuIdRightFormat(((XbjProtocolOrderSaleItemReqBO)orderSaleItemList.get(i)).getMaterialClassId()));
            }
            Integer saleOrderType = xbjProtocolOrderSaleBusiReqBO.getSaleOrderPurchaseType();
            if (salesOrderDetails.getSkuId() == null && (XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_SHIGONG.equals(saleOrderType) || XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_FUWU.equals(saleOrderType))) {
                salesOrderDetails.setSkuId(0L);
            }
            try {
                salesOrderDetails.setSellingPrice(MoneyUtil.BigDecimal2Long((BigDecimal)((XbjProtocolOrderSaleItemReqBO)orderSaleItemList.get(i)).getSalePrice()));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            salesOrderDetails.setPurchaseCount(((XbjProtocolOrderSaleItemReqBO)orderSaleItemList.get(i)).getPurchaseCount());
            salesOrderDetails.setUnitName(((XbjProtocolOrderSaleItemReqBO)orderSaleItemList.get(i)).getMeasureName());
            salesOrderDetails.setPurchasingPrice(((XbjProtocolOrderSaleItemReqBO)orderSaleItemList.get(i)).getPurchasingPrice());
            salesOrderDetails.setSkuCurrencyType(((XbjProtocolOrderSaleItemReqBO)orderSaleItemList.get(i)).getCurrencyType());
            salesOrderDetails.setTotal(((XbjProtocolOrderSaleItemReqBO)orderSaleItemList.get(i)).getTotal());
            salesOrderDetails.setCompleteCount(new BigDecimal(0));
            salesOrderDetails.setAcceptanceCount(new BigDecimal(0));
            salesOrderDetails.setSaleOrderItemStatus(xbjProtocolOrderSaleBusiReqBO.getSaleOrderStatus());
            salesOrderDetails.setProjectId(((XbjProtocolOrderSaleItemReqBO)orderSaleItemList.get(i)).getProjectId());
            salesOrderDetails.setProjectCode(((XbjProtocolOrderSaleItemReqBO)orderSaleItemList.get(i)).getProjectCode());
            salesOrderDetails.setProjectName(((XbjProtocolOrderSaleItemReqBO)orderSaleItemList.get(i)).getProjectName());
            salesOrderDetails.setProjectContent(((XbjProtocolOrderSaleItemReqBO)orderSaleItemList.get(i)).getContentDescription());
            salesOrderDetails.setMaterialCode(((XbjProtocolOrderSaleItemReqBO)orderSaleItemList.get(i)).getMaterialCode());
            salesOrderDetails.setBrandId(((XbjProtocolOrderSaleItemReqBO)orderSaleItemList.get(i)).getBrandId());
            salesOrderDetails.setBrand(((XbjProtocolOrderSaleItemReqBO)orderSaleItemList.get(i)).getBrand());
            salesOrderDetails.setManufacturer(((XbjProtocolOrderSaleItemReqBO)orderSaleItemList.get(i)).getManufacturer());
            salesOrderDetails.setMaterialClassId(((XbjProtocolOrderSaleItemReqBO)orderSaleItemList.get(i)).getMaterialClassId());
            salesOrderDetails.setUsedCompany(((XbjProtocolOrderSaleItemReqBO)orderSaleItemList.get(i)).getUsedCompany());
            salesOrderDetails.setRecvAddr(((XbjProtocolOrderSaleItemReqBO)orderSaleItemList.get(i)).getRecvAddr());
            salesOrderDetails.setSupplyCycle(((XbjProtocolOrderSaleItemReqBO)orderSaleItemList.get(i)).getSupplyCycle());
            orderSaleItem.add(salesOrderDetails);
        }
        return orderSaleItem;
    }

    public OrderProtocolItemAtomXbjReqBO initOrderProtocolItem(XbjProtocolOrderSaleBusiReqBO xbjProtocolOrderSaleBusiReqBO, GenerateOrderIdAndCodeXbjRspBO generateOrderPurchase, GenerateOrderIdAndCodeXbjRspBO generateOrderSale) {
        OrderProtocolItemAtomXbjReqBO orderProtocolItem = new OrderProtocolItemAtomXbjReqBO();
        BeanUtils.copyProperties((Object)xbjProtocolOrderSaleBusiReqBO.getXbjOrderProtocolItem(), (Object)orderProtocolItem);
        if (null != xbjProtocolOrderSaleBusiReqBO.getXbjOrderProtocolItem().getScopeType()) {
            orderProtocolItem.setScopeType(xbjProtocolOrderSaleBusiReqBO.getXbjOrderProtocolItem().getScopeType());
        }
        if (null != xbjProtocolOrderSaleBusiReqBO.getXbjOrderProtocolItem().getTaxRate()) {
            orderProtocolItem.setTaxRate(xbjProtocolOrderSaleBusiReqBO.getXbjOrderProtocolItem().getTaxRate().longValue());
        }
        orderProtocolItem.setCurrencyType(xbjProtocolOrderSaleBusiReqBO.getXbjOrderProtocolItem().getCurrencyType());
        orderProtocolItem.setSaleOrderId(generateOrderSale.getOrderId());
        orderProtocolItem.setPurchaseOrderId(generateOrderPurchase.getOrderId());
        orderProtocolItem.setPurchaserId(xbjProtocolOrderSaleBusiReqBO.getPurchaserId());
        orderProtocolItem.setPurchaserAccountId(xbjProtocolOrderSaleBusiReqBO.getPurchaserAccountId());
        orderProtocolItem.setIsDispatch(xbjProtocolOrderSaleBusiReqBO.getIsDisPatch());
        orderProtocolItem.setProfessionalOrganizationId(xbjProtocolOrderSaleBusiReqBO.getProfessionalOrganizationId());
        orderProtocolItem.setProtocolCode(xbjProtocolOrderSaleBusiReqBO.getXbjOrderProtocolItem().getPlaAgreementCode());
        orderProtocolItem.setGoodsSupplierId(xbjProtocolOrderSaleBusiReqBO.getGoodsSupplierId());
        List eaAgreementAttachList = xbjProtocolOrderSaleBusiReqBO.getXbjOrderProtocolItem().getXbjAgreementAttachList();
        if (null != eaAgreementAttachList && !eaAgreementAttachList.isEmpty()) {
            orderProtocolItem.setXbjAgreementAttachList(eaAgreementAttachList);
        }
        return orderProtocolItem;
    }
}

