/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.alibaba.fastjson.JSON;
import com.cgd.common.busi.bo.RspBusiBaseBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.OrderDispatcherXbjAtomService;
import com.cgd.order.atom.OrderPurchaseStatusChngXbjService;
import com.cgd.order.atom.OrderSaleXbjAtomService;
import com.cgd.order.atom.bo.OrderDispatcherAtomXbjReqBO;
import com.cgd.order.atom.bo.OrderDispatcherAtomXbjRspBO;
import com.cgd.order.atom.bo.OrderPurchaseStatusChngReqBo;
import com.cgd.order.atom.bo.OrderSaleXbjReqBO;
import com.cgd.order.busi.XbjApprovalConfirmBusiService;
import com.cgd.order.busi.XbjCreateOrderFlowSheetBusiService;
import com.cgd.order.busi.bo.XbjOrderConfirmRejectReqBO;
import com.cgd.order.busi.bo.XbjOrderConfirmRejectRspBO;
import com.cgd.order.busi.bo.XbjOrderFlowSheetReqBO;
import com.cgd.order.busi.bo.XbjOrderFlowSheetRspBO;
import com.cgd.order.constant.Constant;
import com.cgd.order.constant.OrderCenterConstant;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.OrderDealNoticeItemXbjMapper;
import com.cgd.order.dao.OrderProcessCodeXbjMapper;
import com.cgd.order.dao.OrderProtocolItemXbjMapper;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.po.OrderDealNoticeItemXbjPO;
import com.cgd.order.po.OrderProcessCodeXbjPO;
import com.cgd.order.po.OrderProtocolItemXbjPO;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import com.cgd.workflow.bo.DoTaskCompleteReqBO;
import com.cgd.workflow.bo.TodoMyTaskRspBO;
import com.cgd.workflow.bo.TodoTaskReqBO;
import com.cgd.workflow.busin.service.DoTaskCompleteBusinService;
import com.cgd.workflow.busin.service.QueryMyTodoTaskBusinService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class XbjApprovalConfirmBusiServiceImpl
implements XbjApprovalConfirmBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjApprovalConfirmBusiService.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    private OrderSaleXbjMapper orderSaleXbjMapper;
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;
    private OrderDealNoticeItemXbjMapper orderDealNoticeItemXbjMapper;
    private OrderPurchaseStatusChngXbjService orderPurchaseStatusChngXbjService;
    private OrderSaleXbjAtomService orderSaleXbjAtomService;
    private OrderProtocolItemXbjMapper orderProtocolItemXbjMapper;
    private OrderDispatcherXbjAtomService orderDispatcherXbjAtomService;
    private XbjCreateOrderFlowSheetBusiService createOrderFlowSheetBusiService;
    @Autowired
    OrderProcessCodeXbjMapper orderProcessCodeXbjMapper;
    @Autowired
    QueryMyTodoTaskBusinService queryMyTodoTaskBusinService;
    @Autowired
    DoTaskCompleteBusinService doTaskCompleteBusinService;

    public void setOrderSaleXbjMapper(OrderSaleXbjMapper orderSaleXbjMapper) {
        this.orderSaleXbjMapper = orderSaleXbjMapper;
    }

    public void setOrderPurchaseXbjMapper(OrderPurchaseXbjMapper orderPurchaseXbjMapper) {
        this.orderPurchaseXbjMapper = orderPurchaseXbjMapper;
    }

    public void setOrderDealNoticeItemXbjMapper(OrderDealNoticeItemXbjMapper orderDealNoticeItemXbjMapper) {
        this.orderDealNoticeItemXbjMapper = orderDealNoticeItemXbjMapper;
    }

    public void setOrderPurchaseStatusChngXbjService(OrderPurchaseStatusChngXbjService orderPurchaseStatusChngXbjService) {
        this.orderPurchaseStatusChngXbjService = orderPurchaseStatusChngXbjService;
    }

    public void setOrderSaleXbjAtomService(OrderSaleXbjAtomService orderSaleXbjAtomService) {
        this.orderSaleXbjAtomService = orderSaleXbjAtomService;
    }

    public void setOrderProtocolItemXbjMapper(OrderProtocolItemXbjMapper orderProtocolItemXbjMapper) {
        this.orderProtocolItemXbjMapper = orderProtocolItemXbjMapper;
    }

    public void setOrderDispatcherXbjAtomService(OrderDispatcherXbjAtomService orderDispatcherXbjAtomService) {
        this.orderDispatcherXbjAtomService = orderDispatcherXbjAtomService;
    }

    public void setCreateOrderFlowSheetBusiService(XbjCreateOrderFlowSheetBusiService createOrderFlowSheetBusiService) {
        this.createOrderFlowSheetBusiService = createOrderFlowSheetBusiService;
    }

    public XbjOrderConfirmRejectRspBO confirmApprovalOrder(XbjOrderConfirmRejectReqBO reqBO) {
        XbjOrderConfirmRejectRspBO rspBO;
        block36: {
            this.validateBOData(reqBO);
            if (this.isDebugEnabled) {
                log.debug("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5ba1\u6279\u901a\u8fc7\u4e1a\u52a1\u670d\u52a1  -> \u5165\u53c2:" + reqBO.toString());
            }
            rspBO = new XbjOrderConfirmRejectRspBO();
            try {
                OrderSaleXbjPO orderSaleXbjPO = new OrderSaleXbjPO();
                orderSaleXbjPO.setSaleOrderId(Long.valueOf(reqBO.getSaleOrderId()));
                orderSaleXbjPO = this.orderSaleXbjMapper.getModelBy(orderSaleXbjPO);
                if (orderSaleXbjPO == null) {
                    rspBO.setRespCode("RSP_CODE_BUSI_SERVICE_ERROR");
                    rspBO.setRespDesc("\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
                    return rspBO;
                }
                Integer isDispatch = orderSaleXbjPO.getIsDispatch();
                OrderPurchaseXbjPO orderPurchase = this.orderPurchaseXbjMapper.getModelById(orderSaleXbjPO.getPurchaseOrderId());
                if (orderPurchase == null) {
                    rspBO.setRespCode("RSP_CODE_BUSI_SERVICE_ERROR");
                    rspBO.setRespDesc("\u6839\u636e\u91c7\u8d2d\u8ba2\u5355id[purchaseOrderId]\u67e5\u8be2\u4e0d\u5230\u91c7\u8d2d\u8ba2\u5355\u8bb0\u5f55");
                    return rspBO;
                }
                boolean isArgDispatch = false;
                if (Constant.IS_DISPATCH_YES.equals(isDispatch)) {
                    Long defaultProducerId = null;
                    String defaultProducerNm = "";
                    if (XbjOrderConstants.SALE_ORDER_TYPE_KJXY.equals(orderSaleXbjPO.getSaleOrderType())) {
                        OrderProtocolItemXbjPO protocolItemXbjPO = new OrderProtocolItemXbjPO();
                        protocolItemXbjPO.setSaleOrderId(orderSaleXbjPO.getSaleOrderId());
                        protocolItemXbjPO = this.orderProtocolItemXbjMapper.getModelBy(protocolItemXbjPO);
                        if (protocolItemXbjPO != null) {
                            defaultProducerId = protocolItemXbjPO.getProducerId();
                            defaultProducerNm = protocolItemXbjPO.getProducerName();
                        }
                    } else if (XbjOrderConstants.SALE_ORDER_TYPE_XBJ.equals(orderSaleXbjPO.getSaleOrderType())) {
                        OrderDealNoticeItemXbjPO dealNoticeItemXbjPO = new OrderDealNoticeItemXbjPO();
                        dealNoticeItemXbjPO.setSaleOrderId(orderSaleXbjPO.getSaleOrderId());
                        dealNoticeItemXbjPO = this.orderDealNoticeItemXbjMapper.getModelBy(dealNoticeItemXbjPO);
                        if (dealNoticeItemXbjPO != null) {
                            defaultProducerId = dealNoticeItemXbjPO.getProducerId();
                            defaultProducerNm = dealNoticeItemXbjPO.getProducerName();
                        }
                    } else {
                        throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8ba2\u5355\u7c7b\u578b\u6709\u8bef\uff0c\u4e0d\u4e3a\u8be2\u6bd4\u4ef7\u8ba2\u5355");
                    }
                    try {
                        if (defaultProducerId != null && StringUtils.isNotBlank((CharSequence)defaultProducerNm)) {
                            OrderDispatcherAtomXbjReqBO dispatcherAtomXbjReqBO = new OrderDispatcherAtomXbjReqBO();
                            dispatcherAtomXbjReqBO.setDeliveryId(defaultProducerId);
                            dispatcherAtomXbjReqBO.setDeliveryName(defaultProducerNm);
                            dispatcherAtomXbjReqBO.setOperId(Long.valueOf(reqBO.getUserId()));
                            dispatcherAtomXbjReqBO.setPurchaserId(orderSaleXbjPO.getPurchaserId());
                            dispatcherAtomXbjReqBO.setSaleOrderId(orderSaleXbjPO.getSaleOrderId());
                            OrderDispatcherAtomXbjRspBO dispatcherAtomXbjRspBO = this.orderDispatcherXbjAtomService.dealWithDispatcher(dispatcherAtomXbjReqBO);
                            if (null != dispatcherAtomXbjRspBO) {
                                if (dispatcherAtomXbjRspBO.getRespCode().equals("0000")) {
                                    XbjOrderFlowSheetReqBO orderFlowSheetReqBO = new XbjOrderFlowSheetReqBO();
                                    BeanUtils.copyProperties((Object)reqBO, (Object)orderFlowSheetReqBO);
                                    orderFlowSheetReqBO.setOrderId(orderSaleXbjPO.getSaleOrderId());
                                    orderFlowSheetReqBO.setPurchaserId(orderSaleXbjPO.getPurchaserId());
                                    orderFlowSheetReqBO.setOrderType(OrderCenterConstant.ORDER_TYPE.SALE);
                                    orderFlowSheetReqBO.setOrderBusiType("B_1");
                                    XbjOrderFlowSheetRspBO orderFlowSheetRspBO = this.createOrderFlowSheetBusiService.createOrderFlowSheet(orderFlowSheetReqBO);
                                    if (null != orderFlowSheetRspBO && orderFlowSheetRspBO.getRespCode().equals("0000")) {
                                        if (this.isDebugEnabled) {
                                            log.debug("\u6839\u636e\u534f\u8bae\u9ed8\u8ba4\u914d\u9001\u5458\u5206\u914d\u670d\u52a1\u6210\u529f");
                                        }
                                        isArgDispatch = true;
                                    } else {
                                        log.error("\u8ba2\u5355\u5206\u914d\u6210\u529f\uff0c\u6267\u884c\u6d41\u7a0b\u751f\u6210\u4e1a\u52a1\u5931\u8d25\uff1a" + orderFlowSheetRspBO.getRespDesc());
                                    }
                                } else {
                                    log.error("\u8c03\u7528\u8ba2\u5355\u5206\u914d\u539f\u5b50\u670d\u52a1\u5931\u8d25:" + dispatcherAtomXbjRspBO.getRespDesc());
                                }
                            } else {
                                log.error("\u8c03\u7528\u8ba2\u5355\u5206\u914d\u539f\u5b50\u670d\u52a1\u5f02\u5e38,\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff01");
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error("-------\u6839\u636e\u534f\u8bae\u9ed8\u8ba4\u914d\u9001\u5458\u5206\u914d\u670d\u52a1\u5f02\u5e38-------", (Throwable)e);
                    }
                }
                if (!isArgDispatch) {
                    if (XbjOrderConstants.SALE_ORDER_PURCHASE_TYPE_WUZI == orderSaleXbjPO.getSaleOrderPurchaseType() && Constant.IS_DISPATCH_YES.equals(isDispatch)) {
                        Integer newStatus = Constant.SALSE_ORDER_STATE_TO_ALLOCATION;
                        if (Constant.SALSE_ORDER_STATE_CANCEL.equals(orderPurchase.getPurchaseOrderStatus())) {
                            rspBO.setRespCode("RSP_CODE_BUSI_SERVICE_ERROR");
                            rspBO.setRespDesc("\u91c7\u8d2d\u8ba2\u5355\u72b6\u6001[purchaseOrderStatus]\u4e3a\u5df2\u53d6\u6d88\uff0c\u4e0d\u53ef\u8fdb\u884c\u72b6\u6001\u66f4\u65b0");
                            return rspBO;
                        }
                        if (this.isDebugEnabled) {
                            log.debug("\u91c7\u8d2d\u8ba2\u5355\u72b6\u6001\u66f4\u65b0 -------------------------------------------------------------");
                            log.debug("\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f:------------------------------>" + JSON.toJSONString((Object)orderPurchase));
                        }
                        OrderPurchaseStatusChngReqBo orderPurchaseStatusChngReqBo = this.transferOrderPurchaseStatusChngReqBO(reqBO.getUserId(), orderPurchase, newStatus);
                        this.orderPurchaseStatusChngXbjService.dealOrderPurchaseStatus(orderPurchaseStatusChngReqBo);
                        OrderSaleXbjReqBO orderSaleReqBO = this.transferOrderSaleReqBO(orderSaleXbjPO, orderSaleXbjPO.getSaleOrderStatus(), newStatus, Long.valueOf(reqBO.getUserId()));
                        this.orderSaleXbjAtomService.salerOrderStatusChange(orderSaleReqBO);
                    } else {
                        Integer saleOrderNewStatus = Constant.SALSE_ORDER_STATE_TO_CONF;
                        OrderSaleXbjReqBO orderSaleReqBO = this.transferOrderSaleReqBO(orderSaleXbjPO, orderSaleXbjPO.getSaleOrderStatus(), saleOrderNewStatus, Long.valueOf(reqBO.getUserId()));
                        this.orderSaleXbjAtomService.salerOrderStatusChange(orderSaleReqBO);
                        Integer purchaseOrderNewStatus = Constant.SALSE_ORDER_STATE_SUPPLY_CONFIRMING;
                        OrderPurchaseStatusChngReqBo orderPurchaseStatusChngReqBo = this.transferOrderPurchaseStatusChngReqBO(reqBO.getUserId(), orderPurchase, purchaseOrderNewStatus);
                        this.orderPurchaseStatusChngXbjService.dealOrderPurchaseStatus(orderPurchaseStatusChngReqBo);
                    }
                }
                OrderProcessCodeXbjPO process = new OrderProcessCodeXbjPO();
                process.setOrderId(orderSaleXbjPO.getSaleOrderId());
                process.setBusiType("50");
                process.setProcessStatus("0");
                process = this.orderProcessCodeXbjMapper.getModelBy(process);
                Integer workFlag = XbjOrderConstants.WORK_FLAG.PASS;
                if (process != null) {
                    String processCode = process.getProcessCode();
                    TodoTaskReqBO todoTaskReqBO = new TodoTaskReqBO();
                    todoTaskReqBO.setUserId(Long.valueOf(reqBO.getUserId()));
                    todoTaskReqBO.setBusinessType("50");
                    todoTaskReqBO.setProcInstId(processCode);
                    TodoMyTaskRspBO queryMyTodoTask = this.queryMyTodoTaskBusinService.queryMyTodoTask(todoTaskReqBO);
                    if (queryMyTodoTask.getTaskId() != null && !"".equals(queryMyTodoTask.getTaskId())) {
                        DoTaskCompleteReqBO doTaskCompleteReqBo = new DoTaskCompleteReqBO();
                        doTaskCompleteReqBo.setTaskId(queryMyTodoTask.getTaskId());
                        doTaskCompleteReqBo.setBusinessType("50");
                        doTaskCompleteReqBo.setUserId(Long.valueOf(reqBO.getUserId()));
                        doTaskCompleteReqBo.setSeqFlowId(workFlag + "");
                        if (this.isDebugEnabled) {
                            log.debug("=========================================\u5de5\u4f5c\u6d41\u6267\u884c\u5b8c\u6210\u4efb\u52a1\u6d41\u7a0b=============================start");
                        }
                        RspBusiBaseBO doTaskComplete = this.doTaskCompleteBusinService.doTaskComplete(doTaskCompleteReqBo);
                        log.debug("=========================================\u5de5\u4f5c\u6d41\u6267\u884c\u5b8c\u6210\u4efb\u52a1\u6d41\u7a0b\u8fd4\u56de=============================RSP\uff1a" + doTaskComplete.toString());
                        if (!doTaskComplete.getRespCode().equals("0000")) {
                            rspBO.setRespCode("8888");
                            rspBO.setRespDesc("\u5de5\u4f5c\u6d41\u6267\u884c\u5b8c\u6210\u4efb\u52a1\u6d41\u7a0b\u5931\u8d25");
                            if (this.isDebugEnabled) {
                                log.debug("=========================================\u5de5\u4f5c\u6d41\u6267\u884c\u5b8c\u6210\u4efb\u52a1\u6d41\u7a0b\u5931\u8d25=============================start");
                            }
                            return rspBO;
                        }
                        if (workFlag == XbjOrderConstants.WORK_FLAG.PASS) {
                            process.setProcessStatus("1");
                            this.orderProcessCodeXbjMapper.updateById(process);
                        }
                    } else {
                        rspBO.setRespCode("8888");
                        rspBO.setRespDesc("\u5f53\u524d\u65e0\u4ee3\u529e\u4efb\u52a1");
                        if (this.isDebugEnabled) {
                            log.debug("=========================================\u5f53\u524d\u65e0\u5f85\u529e\u4efb\u52a1=============================start");
                        }
                    }
                    break block36;
                }
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u9500\u552e\u8ba2\u5355\u8c03\u4ef7\u63d0\u4ea4\u5ba1\u6838\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff1a\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u6d41\u7a0b\u5b9e\u4f8b");
            }
            catch (BusinessException e) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", e.getMessage());
            }
            catch (Exception e) {
                log.error("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5ba1\u6279\u901a\u8fc7\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38", (Throwable)e);
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5ba1\u6279\u901a\u8fc7\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38");
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validateBOData(XbjOrderConfirmRejectReqBO XbjOrderConfirmRejectReqBO2) {
        if (XbjOrderConfirmRejectReqBO2 == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5ba1\u6279\u901a\u8fc7\u4e1a\u52a1\u670d\u52a1  \u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)XbjOrderConfirmRejectReqBO2.getSaleOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5ba1\u6279\u901a\u8fc7\u4e1a\u52a1\u670d\u52a1  \u9500\u552e\u5355ID\u3010saleOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)XbjOrderConfirmRejectReqBO2.getUserId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u5ba1\u6279\u901a\u8fc7\u4e1a\u52a1\u670d\u52a1  \u7528\u6237ID\u3010userId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private OrderPurchaseStatusChngReqBo transferOrderPurchaseStatusChngReqBO(String userId, OrderPurchaseXbjPO orderPurchase, Integer purchaseOrderStatus) {
        OrderPurchaseStatusChngReqBo req = new OrderPurchaseStatusChngReqBo();
        req.setPurchaseOrderId(orderPurchase.getPurchaseOrderId());
        req.setPurchaseOrderOldStatus(orderPurchase.getPurchaseOrderStatus());
        req.setPurchaseOrderStatus(purchaseOrderStatus);
        req.setPurchaserId(orderPurchase.getPurchaserId());
        req.setPurchaserAccountId(orderPurchase.getPurchaserAccountId());
        req.setOperId(userId);
        req.setProfessionalOrganizationId(orderPurchase.getProfessionalOrganizationId());
        req.setGoodsSupplierId(orderPurchase.getGoodsSupplierId());
        req.setPurchaserAccountName(orderPurchase.getPurchaserAccountName());
        req.setSaleOrderId(orderPurchase.getSaleOrderId());
        return req;
    }

    private OrderSaleXbjReqBO transferOrderSaleReqBO(OrderSaleXbjPO orderSale, Integer oldStatus, Integer newStatus, Long userId) {
        OrderSaleXbjReqBO req = new OrderSaleXbjReqBO();
        req.setSaleOrderId(orderSale.getSaleOrderId());
        req.setSaleOrderStatus(newStatus);
        req.setSaleOrderOldStatus(oldStatus);
        req.setPurchaserId(orderSale.getPurchaserId());
        req.setPurchaserAccountId(orderSale.getPurchaserAccountId());
        req.setOperId(userId + "");
        req.setProfessionalOrganizationId(orderSale.getProfessionalOrganizationId());
        req.setGoodsSupplierId(orderSale.getGoodsSupplierId());
        req.setModifyOprId(userId);
        req.setPurchaserAccountName(orderSale.getPurchaserAccountName());
        req.setSaleOrderType(orderSale.getSaleOrderType());
        return req;
    }
}

