/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.alibaba.fastjson.JSON;
import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.AccessoryXbjAtomService;
import com.cgd.order.atom.ArrivalRegistrationXbjAtomService;
import com.cgd.order.atom.bo.ArrivalRegistrationAtomXbjReqBO;
import com.cgd.order.busi.XbjArrivalRegistrationBusiService;
import com.cgd.order.busi.bo.XbjArrivalRegistrationBusiReqBO;
import com.cgd.order.busi.bo.XbjArrivalRegistrationBusiRspBO;
import com.cgd.order.busi.bo.XbjPurchaseAccessoryReqBO;
import com.cgd.order.constant.Constant;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.po.AccessoryXbjPO;
import com.cgd.order.po.OrderPurchaseXbjPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class XbjArrivalRegistrationBusiServiceImpl
implements XbjArrivalRegistrationBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjArrivalRegistrationBusiServiceImpl.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private ArrivalRegistrationXbjAtomService arrivalRegistrationXbjAtomService;
    @Autowired
    private AccessoryXbjAtomService accessoryXbjAtomService;
    @Autowired
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;

    public XbjArrivalRegistrationBusiRspBO saveArrivalRegistration(XbjArrivalRegistrationBusiReqBO xbjArrivalRegistrationBusiReqBO) {
        if (isDebugEnabled) {
            log.debug("\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u5165\u53c2" + JSON.toJSONString((Object)xbjArrivalRegistrationBusiReqBO));
        }
        this.validateBOData(xbjArrivalRegistrationBusiReqBO);
        OrderPurchaseXbjPO orderPurchaseXbjPO = this.orderPurchaseXbjMapper.selectByPurchaseOrderIdAndPurchaserId(xbjArrivalRegistrationBusiReqBO.getPurchaseOrderId(), xbjArrivalRegistrationBusiReqBO.getPurchaserId());
        if (orderPurchaseXbjPO == null) {
            if (isDebugEnabled) {
                log.debug("\u6839\u636e\u8ba2\u5355ID\u3010" + xbjArrivalRegistrationBusiReqBO.getPurchaseOrderId() + "\u3011" + "\uff0c\u91c7\u8d2d\u5355\u4f4dID\u3010" + xbjArrivalRegistrationBusiReqBO.getPurchaserId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u8ba2\u5355\u6570\u636e");
            }
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6839\u636e\u8ba2\u5355ID\u3010" + xbjArrivalRegistrationBusiReqBO.getPurchaseOrderId() + "\u3011" + "\uff0c\u91c7\u8d2d\u5355\u4f4dID\u3010" + xbjArrivalRegistrationBusiReqBO.getPurchaserId() + "\u3011\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u8ba2\u5355\u6570\u636e");
        }
        if (null == orderPurchaseXbjPO.getWholeAcceptance() || XbjOrderConstants.SALE_ORDER_PURCHASE_WHOLE_ACCEPTANCE_YES == orderPurchaseXbjPO.getWholeAcceptance()) {
            if (isDebugEnabled) {
                log.debug("\u6b64\u8ba2\u5355[" + xbjArrivalRegistrationBusiReqBO.getPurchaseOrderId() + "]\u5df2\u7ecf\u6574\u5355\u9a8c\u6536,\u65e0\u6cd5\u8fdb\u884c\u5230\u8d27\u767b\u8bb0\u64cd\u4f5c");
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6b64\u8ba2\u5355\u5df2\u7ecf\u6574\u5355\u9a8c\u6536,\u65e0\u6cd5\u8fdb\u884c\u5230\u8d27\u767b\u8bb0\u64cd\u4f5c");
        }
        try {
            ArrivalRegistrationAtomXbjReqBO arrivalRegistrationAtomXbjReq = new ArrivalRegistrationAtomXbjReqBO();
            BeanUtils.copyProperties((Object)xbjArrivalRegistrationBusiReqBO, (Object)arrivalRegistrationAtomXbjReq);
            this.arrivalRegistrationXbjAtomService.saveArrivalRegistration(arrivalRegistrationAtomXbjReq);
            this.assembleAccessoryData(orderPurchaseXbjPO, xbjArrivalRegistrationBusiReqBO.getPurchaseAccessoryList());
            XbjArrivalRegistrationBusiRspBO eaArrivalRegistrationBusiRsp = new XbjArrivalRegistrationBusiRspBO();
            eaArrivalRegistrationBusiRsp.setRespCode("0000");
            eaArrivalRegistrationBusiRsp.setRespDesc("\u5230\u8d27\u7b7e\u6536\u6210\u529f");
            return eaArrivalRegistrationBusiRsp;
        }
        catch (BusinessException e) {
            log.error("\u7535\u529b\u4e13\u533a\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", e.getMessage());
        }
        catch (Exception e) {
            log.error("\u7535\u529b\u4e13\u533a\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u7535\u529b\u4e13\u533a\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff01");
        }
    }

    private void validateBOData(XbjArrivalRegistrationBusiReqBO xbjArrivalRegistrationBusiReqBO) {
        if (xbjArrivalRegistrationBusiReqBO == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1  \u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjArrivalRegistrationBusiReqBO.getPurchaseOrderId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1  \u91c7\u8d2d\u5355ID\u3010purchaseOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjArrivalRegistrationBusiReqBO.getPurchaserId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1  \u91c7\u8d2d\u5355\u4f4dID\u3010purchaserId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjArrivalRegistrationBusiReqBO.getOrderShipList() == null || xbjArrivalRegistrationBusiReqBO.getOrderShipList().size() <= 0) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1  \u53d1\u8d27\u5355List\u3010orderShipItemList\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.isBlank((CharSequence)xbjArrivalRegistrationBusiReqBO.getArriveRemark()) && xbjArrivalRegistrationBusiReqBO.getArriveRemark().length() > 200) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u5230\u8d27\u767b\u8bb0\u4e1a\u52a1\u670d\u52a1  \u53d1\u8d27\u5907\u6ce8\u8f93\u5165\u5b57\u7b26\u4e0d\u80fd\u8d85\u51fa200\u4e2a");
        }
    }

    private void assembleAccessoryData(OrderPurchaseXbjPO orderPurchaseXbjPO, List<XbjPurchaseAccessoryReqBO> purchaseAccessoryList) {
        if (purchaseAccessoryList != null && purchaseAccessoryList.size() > 0) {
            ArrayList<AccessoryXbjPO> accessoryList = new ArrayList<AccessoryXbjPO>();
            for (XbjPurchaseAccessoryReqBO xbjPurchaseAccessoryReqBO : purchaseAccessoryList) {
                AccessoryXbjPO accessory = new AccessoryXbjPO();
                accessory.setAccessoryId(xbjPurchaseAccessoryReqBO.getAccessoryId());
                accessory.setAccessoryName(xbjPurchaseAccessoryReqBO.getAccessoryName());
                accessory.setAccessoryUrl(xbjPurchaseAccessoryReqBO.getAccessoryUrl());
                accessory.setCreateDate(new Date());
                accessory.setGoodsSupplierId(String.valueOf(orderPurchaseXbjPO.getGoodsSupplierId()));
                accessory.setObjectId(orderPurchaseXbjPO.getPurchaseOrderId());
                accessory.setObjectType(Constant.REGISTRATION_OBJECT_TYPE);
                accessory.setProfessionalOrganizationId(String.valueOf(orderPurchaseXbjPO.getProfessionalOrganizationId()));
                accessory.setPurchaserAccountId(orderPurchaseXbjPO.getPurchaserAccountId());
                accessory.setPurchaserAccountName(orderPurchaseXbjPO.getPurchaserAccountName());
                accessory.setPurchaserId(orderPurchaseXbjPO.getPurchaserId());
                accessory.setRemark("\u5230\u8d27\u767b\u8bb0");
                accessoryList.add(accessory);
            }
            int count = this.accessoryXbjAtomService.batchSave(accessoryList);
            if (count == 0) {
                if (isDebugEnabled) {
                    log.debug("\u6b64\u8ba2\u5355[" + orderPurchaseXbjPO.getPurchaseOrderId() + "]\u9644\u4ef6\u4fdd\u5b58\u5931\u8d25");
                }
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u6b64\u8ba2\u5355[" + orderPurchaseXbjPO.getPurchaseOrderId() + "]\u9644\u4ef6\u4fdd\u5b58\u5931\u8d25");
            }
        }
    }
}

