/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.cgd.common.bo.RspPageBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.feature.orm.mybatis.Page;
import com.cgd.manage.dic.dict.service.DicDictionaryService;
import com.cgd.order.busi.XbjListBackInspectionBusiService;
import com.cgd.order.constant.Constant;
import com.cgd.order.dao.InspectionShipProXbjMapper;
import com.cgd.order.dao.InspectionXbjMapper;
import com.cgd.order.dao.OrderReceiveItemXbjMapper;
import com.cgd.order.dao.OrderSaleItemXbjMapper;
import com.cgd.order.dao.OrderShipItemXbjMapper;
import com.cgd.order.dao.SkuInfoXbjMapper;
import com.cgd.order.intfce.bo.XbjBackInspectionReqBO;
import com.cgd.order.intfce.bo.XbjBackInspectionRspBO;
import com.cgd.order.intfce.bo.XbjSkuInfoBO;
import com.cgd.order.po.InspectionAndSaleOrderXbjPO;
import com.cgd.order.po.InspectionXbjPO;
import com.cgd.order.po.OrderReceiveItemXbjPO;
import com.cgd.order.po.OrderSaleItemXbjPO;
import com.cgd.order.po.SkuInfoXbjPO;
import com.cgd.user.org.busi.QryOrgInfoByIdBusiService;
import com.cgd.user.org.busi.bo.QryOrgInfoByIdReqBO;
import com.cgd.user.org.busi.bo.QryOrgInfoByIdRspBO;
import com.cgd.user.org.busi.bo.UserOrganisationBO;
import com.cgd.user.supplier.busi.SelectSupplierInfoByIdBusiService;
import com.cgd.user.supplier.busi.bo.SelectSupplierInfoByIdReqBO;
import com.cgd.user.supplier.busi.bo.SelectSupplierInfoByIdRspBO;
import com.cgd.user.userInfo.busi.SelectUserInfoByUserIdBusiService;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdReqBO;
import com.cgd.user.userInfo.busi.bo.SelectUserInfoByUserIdRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class XbjListBackInspectionBusiServiceImpl
implements XbjListBackInspectionBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjListBackInspectionBusiServiceImpl.class);
    private final Boolean isDebugEnabled = log.isDebugEnabled();
    private InspectionXbjMapper inspectionXbjMapper;
    private DicDictionaryService dicDictionaryService;
    private SelectUserInfoByUserIdBusiService selectUserInfoByUserIdBusiService;
    private QryOrgInfoByIdBusiService qryOrgInfoByIdBusiService;
    private SelectSupplierInfoByIdBusiService selectSupplierInfoByIdBusiService;
    private OrderReceiveItemXbjMapper orderReceiveItemXbjMapper;
    private SkuInfoXbjMapper skuInfoXbjMapper;
    private OrderSaleItemXbjMapper orderSaleItemXbjMapper;
    private InspectionShipProXbjMapper inspectionShipProXbjMapper;
    private OrderShipItemXbjMapper orderShipItemXbjMapper;

    public void setInspectionXbjMapper(InspectionXbjMapper inspectionXbjMapper) {
        this.inspectionXbjMapper = inspectionXbjMapper;
    }

    public void setDicDictionaryService(DicDictionaryService dicDictionaryService) {
        this.dicDictionaryService = dicDictionaryService;
    }

    public void setSelectUserInfoByUserIdBusiService(SelectUserInfoByUserIdBusiService selectUserInfoByUserIdBusiService) {
        this.selectUserInfoByUserIdBusiService = selectUserInfoByUserIdBusiService;
    }

    public void setQryOrgInfoByIdBusiService(QryOrgInfoByIdBusiService qryOrgInfoByIdBusiService) {
        this.qryOrgInfoByIdBusiService = qryOrgInfoByIdBusiService;
    }

    public void setSelectSupplierInfoByIdBusiService(SelectSupplierInfoByIdBusiService selectSupplierInfoByIdBusiService) {
        this.selectSupplierInfoByIdBusiService = selectSupplierInfoByIdBusiService;
    }

    public void setOrderReceiveItemXbjMapper(OrderReceiveItemXbjMapper orderReceiveItemXbjMapper) {
        this.orderReceiveItemXbjMapper = orderReceiveItemXbjMapper;
    }

    public void setSkuInfoXbjMapper(SkuInfoXbjMapper skuInfoXbjMapper) {
        this.skuInfoXbjMapper = skuInfoXbjMapper;
    }

    public void setOrderSaleItemXbjMapper(OrderSaleItemXbjMapper orderSaleItemXbjMapper) {
        this.orderSaleItemXbjMapper = orderSaleItemXbjMapper;
    }

    public void setInspectionShipProXbjMapper(InspectionShipProXbjMapper inspectionShipProXbjMapper) {
        this.inspectionShipProXbjMapper = inspectionShipProXbjMapper;
    }

    public void setOrderShipItemXbjMapper(OrderShipItemXbjMapper orderShipItemXbjMapper) {
        this.orderShipItemXbjMapper = orderShipItemXbjMapper;
    }

    public RspPageBO<XbjBackInspectionRspBO> dealListBackInspection(XbjBackInspectionReqBO xbjBackInspectionReqBO) {
        RspPageBO rspPage = new RspPageBO();
        try {
            this.validateParams(xbjBackInspectionReqBO);
            Integer pageNo = xbjBackInspectionReqBO.getPageNo();
            Integer pageSize = xbjBackInspectionReqBO.getPageSize();
            Page page = new Page(pageNo.intValue(), pageSize.intValue());
            Map<String, Object> condition = this.getCondition(xbjBackInspectionReqBO);
            List<InspectionAndSaleOrderXbjPO> inspectionAndSaleOrderXbjPOS = this.inspectionXbjMapper.selectBackInspectionXbj(condition, (Page<InspectionXbjPO>)page);
            if (CollectionUtils.isEmpty(inspectionAndSaleOrderXbjPOS)) {
                throw new BusinessException("0000", "\u53ef\u9000\u8d27\u9a8c\u6536\u5355\u4e3a\u7a7a");
            }
            Map returnStatusMap = this.dicDictionaryService.getValueByCode("ORDER_STATUS");
            Map orderSourceMap = this.dicDictionaryService.getValueByCode("ORDER_SOURCE");
            ArrayList<XbjBackInspectionRspBO> backList = new ArrayList<XbjBackInspectionRspBO>();
            for (int i = 0; i < inspectionAndSaleOrderXbjPOS.size(); ++i) {
                InspectionAndSaleOrderXbjPO tmpInspectionAndSaleOrderXbjPO = inspectionAndSaleOrderXbjPOS.get(i);
                XbjBackInspectionRspBO back = null;
                try {
                    back = this.transferBackInspectionRsp(tmpInspectionAndSaleOrderXbjPO, returnStatusMap, orderSourceMap);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", e.getMessage());
                }
                backList.add(back);
            }
            rspPage.setRows(backList);
            rspPage.setPageNo(page.getPageNo());
            rspPage.setRecordsTotal(page.getTotalCount());
            rspPage.setTotal(page.getTotalPages());
            rspPage.setRespCode("0000");
            rspPage.setRespDesc("\u67e5\u8be2\u6210\u529f");
            return rspPage;
        }
        catch (BusinessException e) {
            if (this.isDebugEnabled.booleanValue()) {
                log.debug("\u8be2\u6bd4\u4ef7\u67e5\u8be2\u53ef\u9000\u8d27\u9a8c\u6536\u5355\u4e1a\u52a1\u670d\u52a1usinessException");
            }
            log.error("\u8be2\u6bd4\u4ef7\u67e5\u8be2\u53ef\u9000\u8d27\u9a8c\u6536\u5355\u4e1a\u52a1\u670d\u52a1\u63d0\u4ea4\u5f02\u5e38\uff01" + e.getMessage(), (Throwable)e);
            rspPage.setRespCode("8888");
            rspPage.setRespDesc("\u8be2\u6bd4\u4ef7\u67e5\u8be2\u53ef\u9000\u8d27\u9a8c\u6536\u5355\u4e1a\u52a1\u670d\u52a1\u63d0\u4ea4\u5931\u8d25" + e.getMessage());
            return rspPage;
        }
        catch (Exception e) {
            log.error("\u8be2\u6bd4\u4ef7\u67e5\u8be2\u53ef\u9000\u8d27\u9a8c\u6536\u5355\u4e1a\u52a1\u670d\u52a1 \u5f02\u5e38", (Throwable)e);
            if (this.isDebugEnabled.booleanValue()) {
                log.debug("\u8be2\u6bd4\u4ef7\u67e5\u8be2\u53ef\u9000\u8d27\u9a8c\u6536\u5355\u4e1a\u52a1\u670d\u52a1BusinessException");
            }
            rspPage.setRespCode("8888");
            rspPage.setRespDesc("\u8be2\u6bd4\u4ef7\u67e5\u8be2\u53ef\u9000\u8d27\u9a8c\u6536\u5355\u4e1a\u52a1\u670d\u52a1\u63d0\u4ea4\u5931\u8d25" + e.getMessage());
            return rspPage;
        }
    }

    private Map<String, Object> getCondition(XbjBackInspectionReqBO xbjBackInspectionReqBO) {
        HashMap<String, Object> condition = new HashMap<String, Object>();
        condition.put("saleOrderCode", StringUtils.trimToNull((String)xbjBackInspectionReqBO.getSaleOrderCode()));
        condition.put("saleOrderName", StringUtils.trimToNull((String)xbjBackInspectionReqBO.getSaleOrderName()));
        condition.put("inspectionCode", StringUtils.trimToNull((String)xbjBackInspectionReqBO.getInspectionCode()));
        condition.put("inspectionName", StringUtils.trimToNull((String)xbjBackInspectionReqBO.getInspectionName()));
        condition.put("beginTime", xbjBackInspectionReqBO.getBeginTime());
        condition.put("endTime", xbjBackInspectionReqBO.getEndTime());
        condition.put("supplierId", xbjBackInspectionReqBO.getSupplierId());
        condition.put("saleOrderType", xbjBackInspectionReqBO.getSaleOrderType());
        condition.put("companyId", xbjBackInspectionReqBO.getCompanyId());
        ArrayList<Integer> listStatus = new ArrayList<Integer>();
        listStatus.add(Constant.SALSE_ORDER_STATE_COMPLETED);
        listStatus.add(Constant.SALSE_ORDER_STATE_TO_SENDING);
        condition.put("saleOrderStatus", listStatus);
        if (this.isDebugEnabled.booleanValue()) {
            log.debug("\u8be2\u6bd4\u4ef7\u67e5\u8be2\u53ef\u9000\u8d27\u9a8c\u6536\u5355\u5217\u8868\u6761\u4ef6\u5165\u53c2:{}", (Object)((Object)condition).toString());
        }
        return condition;
    }

    private XbjBackInspectionRspBO transferBackInspectionRsp(InspectionAndSaleOrderXbjPO inspectionAndSaleOrderXbjPO, Map<String, String> statusMap, Map<String, String> sourceMap) throws Exception {
        UserOrganisationBO userOrganisation;
        XbjBackInspectionRspBO rsp = new XbjBackInspectionRspBO();
        BeanUtils.copyProperties((Object)inspectionAndSaleOrderXbjPO, (Object)rsp);
        rsp.setInspectionId(inspectionAndSaleOrderXbjPO.getInspectionId() + "");
        rsp.setSaleOrderId(inspectionAndSaleOrderXbjPO.getSaleOrderId() + "");
        rsp.setPurchaseId(inspectionAndSaleOrderXbjPO.getPurchaserId() + "");
        Long purchaseAccountId = inspectionAndSaleOrderXbjPO.getPurchaseAccountId();
        SelectUserInfoByUserIdReqBO selectUserInfoReqBO = new SelectUserInfoByUserIdReqBO();
        selectUserInfoReqBO.setUserId(purchaseAccountId);
        SelectUserInfoByUserIdRspBO userInfo = this.selectUserInfoByUserIdBusiService.selectUserInfoByUserId(selectUserInfoReqBO);
        if (userInfo != null) {
            rsp.setPurchaseAcountName(userInfo.getName());
            rsp.setPurchaseAccountMobile(userInfo.getTelephone());
        }
        Long operId = inspectionAndSaleOrderXbjPO.getOperId();
        selectUserInfoReqBO.setUserId(operId);
        userInfo = this.selectUserInfoByUserIdBusiService.selectUserInfoByUserId(selectUserInfoReqBO);
        if (userInfo != null) {
            rsp.setInspectionName(userInfo.getName());
            rsp.setInspectionNameMobile(userInfo.getTelephone());
        }
        QryOrgInfoByIdReqBO qryOrgInfoByIdReqBO = new QryOrgInfoByIdReqBO();
        qryOrgInfoByIdReqBO.setOrganizationId(inspectionAndSaleOrderXbjPO.getProfessionOrganizationId());
        QryOrgInfoByIdRspBO org = this.qryOrgInfoByIdBusiService.qryOrgInfoById(qryOrgInfoByIdReqBO);
        if (org != null && (userOrganisation = org.getUserOrganisationBO()) != null) {
            rsp.setProfessionalOrganizationName(userOrganisation.getTitle());
        }
        SelectSupplierInfoByIdReqBO selectSupplierInfoByIdReqBO = new SelectSupplierInfoByIdReqBO();
        selectSupplierInfoByIdReqBO.setSupplierId(inspectionAndSaleOrderXbjPO.getGoodsSupplierId());
        SelectSupplierInfoByIdRspBO supplier = this.selectSupplierInfoByIdBusiService.selectSupplierInfoById(selectSupplierInfoByIdReqBO);
        if (supplier != null) {
            rsp.setSupplierName(supplier.getSupplierName());
        }
        rsp.setSaleOrderStatus(statusMap.get(inspectionAndSaleOrderXbjPO.getSaleOrderStatusCode() + ""));
        rsp.setOrderSource(sourceMap.get(inspectionAndSaleOrderXbjPO.getSaleOrderType() + ""));
        Long inspectionId = inspectionAndSaleOrderXbjPO.getInspectionId();
        Long purchaserId = inspectionAndSaleOrderXbjPO.getPurchaserId();
        List<OrderReceiveItemXbjPO> itemList = this.orderReceiveItemXbjMapper.queryItemList(inspectionId, purchaserId);
        if (CollectionUtils.isNotEmpty(itemList)) {
            ArrayList<XbjSkuInfoBO> skuList = new ArrayList<XbjSkuInfoBO>();
            for (OrderReceiveItemXbjPO orderReceiveXbjItem : itemList) {
                XbjSkuInfoBO skuInfo = this.transferSkuInfo(orderReceiveXbjItem);
                skuList.add(skuInfo);
            }
            rsp.setSkuInfoList(skuList);
        }
        return rsp;
    }

    private XbjSkuInfoBO transferSkuInfo(OrderReceiveItemXbjPO orderReceiveItem) throws Exception {
        List<Long> shipOrderIds;
        XbjSkuInfoBO skuInfoBO = new XbjSkuInfoBO();
        skuInfoBO.setInspectionItemId(orderReceiveItem.getInspectionId());
        skuInfoBO.setSkuName(orderReceiveItem.getSkuName());
        skuInfoBO.setUnitName(orderReceiveItem.getUnitName());
        skuInfoBO.setInspectionCount(orderReceiveItem.getPurchaseCount());
        skuInfoBO.setInReturnCount(orderReceiveItem.getReturnCount());
        skuInfoBO.setCompleteReturnCount(orderReceiveItem.getAlreadyReturnCount());
        Long sellingPrice = orderReceiveItem.getSellingPrice();
        if (sellingPrice != null) {
            try {
                BigDecimal skuSalePrice = MoneyUtil.Long2BigDecimal((Long)sellingPrice);
                skuInfoBO.setSkuSalePrice(skuSalePrice);
            }
            catch (Exception e) {
                if (this.isDebugEnabled.booleanValue()) {
                    log.debug("\u9a8c\u6536\u5355\u660e\u7ec6\u91d1\u989d\u8f6c\u5316\u9519\u8bef:" + e.getMessage());
                }
                e.printStackTrace();
            }
        }
        SkuInfoXbjPO skuInfoXbjPO = new SkuInfoXbjPO();
        skuInfoXbjPO.setSaleOrderItemId(orderReceiveItem.getSaleOrderItemId());
        skuInfoXbjPO.setPurchaserId(orderReceiveItem.getPurchaserId());
        SkuInfoXbjPO skuInfo = this.skuInfoXbjMapper.getListBysaleOrderItemIdAndPurchaserId(skuInfoXbjPO);
        if (skuInfo != null) {
            skuInfoBO.setSkuUrl(skuInfo.getSkuMainPicUrl());
        }
        OrderSaleItemXbjPO orderSaleItemXbjPO = new OrderSaleItemXbjPO();
        orderSaleItemXbjPO.setSaleOrderItemId(orderReceiveItem.getSaleOrderItemId());
        orderSaleItemXbjPO.setPurchaserId(orderReceiveItem.getPurchaserId());
        OrderSaleItemXbjPO orderSaleItem = this.orderSaleItemXbjMapper.selectBySaleOrderItemIdAndPurchaserId(orderSaleItemXbjPO);
        if (orderSaleItem != null) {
            skuInfoBO.setPurchaseCount(orderSaleItem.getPurchaseCount());
            skuInfoBO.setSkuId(orderSaleItem.getSkuId());
        }
        if ((shipOrderIds = this.inspectionShipProXbjMapper.selectByInspectionIdAndSkuIdAndPurchaserIdXbj(orderReceiveItem.getInspectionId(), orderReceiveItem.getSkuId(), orderReceiveItem.getPurchaserId())) != null && !shipOrderIds.isEmpty()) {
            BigDecimal sendTotalCount = BigDecimal.ZERO;
            for (Long shipOrderId : shipOrderIds) {
                BigDecimal sendCount = this.orderShipItemXbjMapper.selectByShipOrderIdAndItemIdAndPurchaserIdXbj(shipOrderId, orderReceiveItem.getShipItemId(), orderReceiveItem.getPurchaserId());
                if (sendCount == null) continue;
                sendTotalCount = sendTotalCount.add(sendCount);
            }
            skuInfoBO.setShipCount(sendTotalCount);
        }
        return skuInfoBO;
    }

    private void validateParams(XbjBackInspectionReqBO xbjBackInspectionReqBO) {
        if (xbjBackInspectionReqBO == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjBackInspectionReqBO.getSaleOrderType() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2[saleOrderType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

