/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.cgd.common.bo.RspInfoBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.order.busi.XbjNoDispatchRemindSupplierConfirmBusiService;
import com.cgd.order.busi.XbjOrderSendMsgBusiService;
import com.cgd.order.busi.bo.OrderSendMsgBusiReqBO;
import com.cgd.order.busi.bo.XbjSendMsgInfoReqBO;
import com.cgd.order.busi.bo.XbjSendMsgInfoRspBO;
import com.cgd.order.constant.Constant;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import java.util.ArrayList;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="xbjNoDispatchRemindSupplierConfirmBusiService")
public class XbjNoDispatchRemindSupplierConfirmBusiServiceImpl
implements XbjNoDispatchRemindSupplierConfirmBusiService {
    @Autowired
    private XbjOrderSendMsgBusiService orderSendMsgBusiService;
    @Autowired
    private OrderSaleXbjMapper orderSaleMapper;
    @Autowired
    private OrderPurchaseXbjMapper orderPurchaseMapper;

    public XbjSendMsgInfoRspBO dealRemindSupplierConfirm(XbjSendMsgInfoReqBO xbjSendMsgInfoReqBO) {
        this.validateParams(xbjSendMsgInfoReqBO);
        Integer orderType = xbjSendMsgInfoReqBO.getOrderType();
        String orderCode = null;
        String orderName = null;
        String purchaserName = null;
        if (Constant.ORDER_TYPE_SALE.equals(orderType)) {
            OrderSaleXbjPO orderSale = this.orderSaleMapper.queryByCondition(xbjSendMsgInfoReqBO.getOrderId(), xbjSendMsgInfoReqBO.getPurchaserId());
            if (orderSale == null) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u8ba2\u5355");
            }
            orderCode = orderSale.getSaleOrderCode();
            orderName = orderSale.getSaleOrderName();
            purchaserName = orderSale.getPurchaserName();
        } else if (Constant.ORDER_TYPE_PURCHASE.equals(orderType)) {
            OrderPurchaseXbjPO orderPurchase = this.orderPurchaseMapper.selectByPurchaseOrderIdAndPurchaserId(xbjSendMsgInfoReqBO.getOrderId(), xbjSendMsgInfoReqBO.getPurchaserId());
            if (orderPurchase == null) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u8ba2\u5355");
            }
            orderCode = orderPurchase.getPurchaseOrderCode();
            orderName = orderPurchase.getPurchaseOrderName();
            purchaserName = orderPurchase.getPurchaserName();
        }
        OrderSendMsgBusiReqBO orderSendMsgBusiReq = this.transferSendMsgReqBO(xbjSendMsgInfoReqBO, orderCode, orderName, purchaserName);
        RspInfoBO rspBusiBaseBO = this.orderSendMsgBusiService.dealSendMsg(orderSendMsgBusiReq);
        XbjSendMsgInfoRspBO rsp = new XbjSendMsgInfoRspBO();
        rsp.setRespCode(rspBusiBaseBO.getRespCode());
        rsp.setRespDesc(rspBusiBaseBO.getRespDesc());
        return rsp;
    }

    private OrderSendMsgBusiReqBO transferSendMsgReqBO(XbjSendMsgInfoReqBO xbjSendMsgInfoReqBO, String orderCode, String orderName, String purchaserName) {
        OrderSendMsgBusiReqBO orderSendMsgBusiReq = new OrderSendMsgBusiReqBO();
        ArrayList<String> sendTypes = new ArrayList<String>();
        sendTypes.add(xbjSendMsgInfoReqBO.getSendType());
        orderSendMsgBusiReq.setSendTypes(sendTypes);
        orderSendMsgBusiReq.setMobile(xbjSendMsgInfoReqBO.getContactPhone());
        orderSendMsgBusiReq.setEmail(xbjSendMsgInfoReqBO.getContactEmail());
        orderSendMsgBusiReq.setSmsTemplateId(xbjSendMsgInfoReqBO.getTemplateId());
        orderSendMsgBusiReq.setEmailTemplateId(xbjSendMsgInfoReqBO.getTemplateId());
        orderSendMsgBusiReq.setSubject("\u63d0\u9192\u786e\u8ba4");
        orderSendMsgBusiReq.setOrderCode(orderCode);
        HashMap<String, String> smsParam = new HashMap<String, String>();
        smsParam.put("orderCode", orderCode);
        smsParam.put("orderName", orderName);
        smsParam.put("purchaserName", purchaserName);
        HashMap<String, String> emailParam = new HashMap<String, String>();
        emailParam.put("orderCode", orderCode);
        emailParam.put("orderName", orderName);
        emailParam.put("purchaserName", purchaserName);
        orderSendMsgBusiReq.setRemindConfigureId(xbjSendMsgInfoReqBO.getId());
        orderSendMsgBusiReq.setEmailParam(emailParam);
        orderSendMsgBusiReq.setSmsParam(smsParam);
        return orderSendMsgBusiReq;
    }

    private void validateParams(XbjSendMsgInfoReqBO xbjSendMsgInfoReqBO) {
        if (xbjSendMsgInfoReqBO == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjSendMsgInfoReqBO.getOrderId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355id[orderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjSendMsgInfoReqBO.getOrderType() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8ba2\u5355\u7c7b\u578b[orderType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjSendMsgInfoReqBO.getPurchaserId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u5546id[purchaserId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjSendMsgInfoReqBO.getSendType() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u53d1\u9001\u65b9\u5f0f[sendType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjSendMsgInfoReqBO.getTemplateId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u6a21\u677fid[templateId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjSendMsgInfoReqBO.getId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u914d\u7f6eid[Id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

