/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.cgd.order.atom.OrderConstrDetailCrtXbjAtomService;
import com.cgd.order.atom.OrderCountModifyXbjService;
import com.cgd.order.atom.bo.OrderConstrAccessoryXbjBO;
import com.cgd.order.atom.bo.OrderConstrDetailCrtXbjReqBO;
import com.cgd.order.atom.bo.OrderConstrItemXbjBO;
import com.cgd.order.busi.XbjOrderConstrCreateBusiService;
import com.cgd.order.busi.bo.XbjConstrAccessoryReqBO;
import com.cgd.order.busi.bo.XbjConstrItemReqBO;
import com.cgd.order.busi.bo.XbjOrderConstrCreateReqBO;
import com.cgd.order.busi.bo.XbjOrderConstrCreateRspBO;
import com.cgd.order.dao.OrderPurchaseItemXbjMapper;
import com.cgd.order.po.OrderPurchaseItemXbjPO;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class XbjOrderConstrCreateBusiServiceImpl
implements XbjOrderConstrCreateBusiService {
    private static final Logger logger = LoggerFactory.getLogger(XbjOrderConstrCreateBusiServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    @Autowired
    private OrderConstrDetailCrtXbjAtomService orderConstrDetailCrtXbjAtomService;
    @Autowired
    private OrderCountModifyXbjService orderCountModifyXbjService;
    @Autowired
    private OrderPurchaseItemXbjMapper orderPurchaseItemXbjMapper;

    public XbjOrderConstrCreateRspBO createOrderConstr(XbjOrderConstrCreateReqBO reqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u8be2\u6bd4\u4ef7\u65bd\u5de5\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a{}", (Object)reqBO.toString());
        }
        OrderConstrDetailCrtXbjReqBO orderConstrDetailCrtXbjReqBO = new OrderConstrDetailCrtXbjReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)orderConstrDetailCrtXbjReqBO);
        ArrayList<OrderConstrItemXbjBO> constrItemList = new ArrayList<OrderConstrItemXbjBO>();
        for (XbjConstrItemReqBO tempBO : reqBO.getConstrItemList()) {
            OrderConstrItemXbjBO orderConstrItem = new OrderConstrItemXbjBO();
            BeanUtils.copyProperties((Object)tempBO, (Object)orderConstrItem);
            orderConstrItem.setSellingPrice(tempBO.getSellingPrice().longValue());
            orderConstrItem.setPurchaseCount(tempBO.getPurchaseCount().intValue());
            constrItemList.add(orderConstrItem);
            OrderPurchaseItemXbjPO orderPurchaseItemXbjPO = new OrderPurchaseItemXbjPO();
            orderPurchaseItemXbjPO.setSendCount(orderConstrItem.getOnceCompleteCount());
            orderPurchaseItemXbjPO.setWaitSendCount(orderConstrItem.getOnceCompleteCount());
            orderPurchaseItemXbjPO.setPurchaserId(orderConstrItem.getPurchaserId());
            orderPurchaseItemXbjPO.setPurchaseOrderItemId(orderConstrItem.getPurchaseOrderItemId());
            this.orderPurchaseItemXbjMapper.updateSendAndWaitingCount(orderPurchaseItemXbjPO);
        }
        orderConstrDetailCrtXbjReqBO.setConstrItemList(constrItemList);
        ArrayList<OrderConstrAccessoryXbjBO> constrAccessoryList = new ArrayList<OrderConstrAccessoryXbjBO>();
        for (XbjConstrAccessoryReqBO tempBO : reqBO.getConstrAccessoryList()) {
            OrderConstrAccessoryXbjBO orderConstrAccessory = new OrderConstrAccessoryXbjBO();
            BeanUtils.copyProperties((Object)tempBO, (Object)orderConstrAccessory);
            constrAccessoryList.add(orderConstrAccessory);
        }
        orderConstrDetailCrtXbjReqBO.setConstrAccessoryList(constrAccessoryList);
        this.orderConstrDetailCrtXbjAtomService.insertOrderConstrDetail(orderConstrDetailCrtXbjReqBO);
        XbjOrderConstrCreateRspBO rspBO = new XbjOrderConstrCreateRspBO();
        rspBO.setConstrOrderId(orderConstrDetailCrtXbjReqBO.getConstrCompleteOrderId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u65bd\u5de5\u5355\u751f\u6210\u6210\u529f!");
        return rspBO;
    }
}

