/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.alibaba.fastjson.JSON;
import com.cgd.common.bo.RspInfoBO;
import com.cgd.common.busi.bo.RspBusiBaseBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.order.atom.GenerateOrderIdAndCodeXbjAtomService;
import com.cgd.order.atom.PurchaseOrderInfoXbjAtomService;
import com.cgd.order.atom.bo.GenerateOrderIdAndCodeXbjReqBO;
import com.cgd.order.atom.bo.GenerateOrderIdAndCodeXbjRspBO;
import com.cgd.order.atom.bo.PurchaseOrderInfoReqBO;
import com.cgd.order.busi.XbjOrderMaintenanceBusiService;
import com.cgd.order.busi.bo.OrderPurchaseItemXbjBO;
import com.cgd.order.busi.bo.XbjOrderMaintenanceReqBO;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.OrderProcessCodeXbjMapper;
import com.cgd.order.dao.OrderPurchaseItemEditXbjMapper;
import com.cgd.order.dao.OrderPurchaseItemXbjMapper;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.OrderSaleItemXbjMapper;
import com.cgd.order.po.OrderProcessCodeXbjPO;
import com.cgd.order.po.OrderPurchaseItemEditXbjPO;
import com.cgd.order.po.OrderPurchaseItemXbjPO;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.po.OrderSaleItemXbjPO;
import com.cgd.workflow.bo.BpmStartReqBO;
import com.cgd.workflow.bo.BpmStartRspBO;
import com.cgd.workflow.bo.DoTaskCompleteReqBO;
import com.cgd.workflow.bo.TodoMyTaskRspBO;
import com.cgd.workflow.bo.TodoTaskReqBO;
import com.cgd.workflow.busin.service.BpmStartBusinService;
import com.cgd.workflow.busin.service.DoTaskCompleteBusinService;
import com.cgd.workflow.busin.service.QueryMyTodoTaskBusinService;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class XbjOrderMaintenanceBusiServiceImpl
implements XbjOrderMaintenanceBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjOrderMaintenanceBusiService.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private PurchaseOrderInfoXbjAtomService purchaseOrderInfoXbjAtomService;
    @Autowired
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;
    @Autowired
    private OrderSaleItemXbjMapper orderSaleItemXbjMapper;
    @Autowired
    private OrderPurchaseItemXbjMapper orderPurchaseItemXbjMapper;
    @Autowired
    private OrderPurchaseItemEditXbjMapper orderPurchaseItemEditXbjMapper;
    @Autowired
    private GenerateOrderIdAndCodeXbjAtomService generateOrderIdAndCodeXbjAtomService;
    @Autowired
    private BpmStartBusinService bpmStartBusinService;
    @Autowired
    private QueryMyTodoTaskBusinService queryMyTodoTaskBusinService;
    @Autowired
    private DoTaskCompleteBusinService doTaskCompleteBusinService;
    @Autowired
    private OrderProcessCodeXbjMapper orderProcessCodeXbjMapper;

    public RspInfoBO calcXbjSaleOrderItemAdjust(XbjOrderMaintenanceReqBO reqBO) {
        block21: {
            if (StringUtils.isBlank((CharSequence)reqBO.getSaleOrderId()) || StringUtils.isBlank((CharSequence)reqBO.getPurchaserId())) {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u7ef4\u62a4\u4e1a\u52a1\u670d\u52a1  \u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (this.isDebugEnabled) {
                log.debug("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u7ef4\u62a4\u4e1a\u52a1\u670d\u52a1\u5165\u53c2" + JSON.toJSONString((Object)reqBO));
            }
            try {
                RspInfoBO rspBO;
                OrderPurchaseXbjPO orderPurchaseXbjPO = new OrderPurchaseXbjPO();
                orderPurchaseXbjPO.setSaleOrderId(Long.valueOf(reqBO.getSaleOrderId()));
                orderPurchaseXbjPO.setPurchaserId(Long.valueOf(reqBO.getPurchaserId()));
                orderPurchaseXbjPO = this.orderPurchaseXbjMapper.getModelBy(orderPurchaseXbjPO);
                if (orderPurchaseXbjPO == null) {
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u672a\u67e5\u8be2\u5230\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f");
                }
                orderPurchaseXbjPO.setPurchaseOrderStatus(XbjOrderConstants.PURCHASE_ORDER_MAINTAIN_APPROVING);
                this.orderPurchaseXbjMapper.updateById(orderPurchaseXbjPO);
                PurchaseOrderInfoReqBO updateReqBO = new PurchaseOrderInfoReqBO();
                BeanUtils.copyProperties((Object)updateReqBO, (Object)reqBO);
                updateReqBO.setSaleOrderId(Long.valueOf(reqBO.getSaleOrderId()));
                if (StringUtils.isNotBlank((CharSequence)reqBO.getTaxRate())) {
                    updateReqBO.setTaxRate(Long.valueOf(reqBO.getTaxRate()));
                }
                this.purchaseOrderInfoXbjAtomService.updatePurchaseOrderInfo(updateReqBO);
                List orderPurchaseItemXbjBOs = reqBO.getOrderPurchaseItemXbjBOs();
                if (orderPurchaseItemXbjBOs != null) {
                    for (OrderPurchaseItemXbjBO itemXbjBO : orderPurchaseItemXbjBOs) {
                        OrderPurchaseItemXbjPO orderPurchaseItemXbjPO = new OrderPurchaseItemXbjPO();
                        orderPurchaseItemXbjPO.setPurchaseOrderItemId(Long.valueOf(itemXbjBO.getPurchaseOrderItemId()));
                        orderPurchaseItemXbjPO.setPurchaseOrderId(orderPurchaseXbjPO.getPurchaseOrderId());
                        orderPurchaseItemXbjPO = this.orderPurchaseItemXbjMapper.getModelBy(orderPurchaseItemXbjPO);
                        if (orderPurchaseItemXbjPO == null) {
                            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6839\u636e[purchaseOrderItemId]\u548c[saleOrderId]\u6ca1\u6709\u67e5\u8be2\u5230\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6");
                        }
                        OrderSaleItemXbjPO orderSaleItemXbjPO = this.orderSaleItemXbjMapper.getModelById(orderPurchaseItemXbjPO.getSaleOrderItemId());
                        if (orderSaleItemXbjPO == null) {
                            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6839\u636e[purchaseOrderItemId]\u6ca1\u6709\u67e5\u8be2\u5230\u9500\u552e\u8ba2\u5355\u660e\u7ec6");
                        }
                        GenerateOrderIdAndCodeXbjReqBO idAndCodeXbjReqBO = new GenerateOrderIdAndCodeXbjReqBO();
                        idAndCodeXbjReqBO.setGenerateOrderType(XbjOrderConstants.GENERATE_ORDER_TYPE.BATCH_SEQ);
                        GenerateOrderIdAndCodeXbjRspBO rspBO2 = this.generateOrderIdAndCodeXbjAtomService.generateOrderIdAndCode(idAndCodeXbjReqBO);
                        Long editId = rspBO2.getOrderId();
                        OrderPurchaseItemEditXbjPO oldItemEdit = new OrderPurchaseItemEditXbjPO();
                        OrderPurchaseItemEditXbjPO newItemEdit = new OrderPurchaseItemEditXbjPO();
                        BeanUtils.copyProperties((Object)oldItemEdit, (Object)orderPurchaseItemXbjPO);
                        oldItemEdit.setIsNew(XbjOrderConstants.PURCHASE_ORDER_OLD);
                        oldItemEdit.setEditId(editId);
                        orderPurchaseItemXbjPO.setNewSellingPrice(MoneyUtil.BigDecimal2Long((BigDecimal)itemXbjBO.getSalePriceNew()));
                        orderPurchaseItemXbjPO.setNewPurchasingPrice(MoneyUtil.BigDecimal2Long((BigDecimal)itemXbjBO.getPurchasingPriceNew()));
                        orderPurchaseItemXbjPO.setMarkUpRateNew(itemXbjBO.getMarkUpRateNew());
                        orderSaleItemXbjPO.setNewSellingPrice(MoneyUtil.BigDecimal2Long((BigDecimal)itemXbjBO.getSalePriceNew()));
                        orderSaleItemXbjPO.setNewPurchasingPrice(MoneyUtil.BigDecimal2Long((BigDecimal)itemXbjBO.getPurchasingPriceNew()));
                        BeanUtils.copyProperties((Object)newItemEdit, (Object)orderPurchaseItemXbjPO);
                        newItemEdit.setIsNew(XbjOrderConstants.PURCHASE_ORDER_NEW);
                        newItemEdit.setEditId(editId);
                        this.orderPurchaseItemEditXbjMapper.insert(oldItemEdit);
                        this.orderPurchaseItemEditXbjMapper.insert(newItemEdit);
                        this.orderPurchaseItemXbjMapper.updateById(orderPurchaseItemXbjPO);
                        this.orderSaleItemXbjMapper.updateById(orderSaleItemXbjPO);
                    }
                }
                OrderProcessCodeXbjPO process = new OrderProcessCodeXbjPO();
                process.setOrderId(Long.valueOf(reqBO.getSaleOrderId()));
                process.setBusiType("51");
                process.setProcessStatus("0");
                if (this.isDebugEnabled) {
                    log.debug(" \u67e5\u8be2\u5de5\u4f5c\u6d41\u5165\u53c2===================" + JSON.toJSONString((Object)process));
                }
                if ((process = this.orderProcessCodeXbjMapper.getModelBy(process)) == null) {
                    if (this.isDebugEnabled) {
                        log.debug("=========================================\u521d\u6b21\u8c03\u4ef7=============================start");
                    }
                    BpmStartReqBO bpmStartReqBO = new BpmStartReqBO();
                    bpmStartReqBO.setApplyerId(Long.valueOf(reqBO.getUserId()));
                    bpmStartReqBO.setUserId(Long.valueOf(reqBO.getUserId()));
                    bpmStartReqBO.setBusinessId(reqBO.getSaleOrderId());
                    bpmStartReqBO.setBusinessTitle("\u8ba2\u5355\u8c03\u4ef7\u5ba1\u6279");
                    bpmStartReqBO.setBusinessType("51");
                    bpmStartReqBO.setDetailUrl("http://www.baidu.com");
                    bpmStartReqBO.setStartFlag("1");
                    HashMap<String, Object> variables = new HashMap<String, Object>();
                    variables.put("purchaserId", reqBO.getPurchaserId());
                    variables.put("userId", reqBO.getUserId());
                    bpmStartReqBO.setVariables(variables);
                    BpmStartRspBO bpmStart = this.bpmStartBusinService.bpmStart(bpmStartReqBO);
                    if (bpmStart.getProcInstId() != null && !"".equals(bpmStart.getProcInstId())) {
                        String procInstId = bpmStart.getProcInstId();
                        OrderProcessCodeXbjPO addRecord = new OrderProcessCodeXbjPO();
                        addRecord.setOrderId(orderPurchaseXbjPO.getSaleOrderId());
                        addRecord.setBusiType("51");
                        addRecord.setProcessCode(procInstId);
                        addRecord.setCreatTime(new Date());
                        addRecord.setProcessStatus("0");
                        this.orderProcessCodeXbjMapper.insert(addRecord);
                        break block21;
                    }
                    rspBO = new RspInfoBO();
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u5de5\u4f5c\u6d41\u542f\u52a8\u5931\u8d25");
                    if (this.isDebugEnabled) {
                        log.debug("=========================================\u5de5\u4f5c\u6d41\u542f\u52a8\u5931\u8d25=============================start");
                    }
                    return rspBO;
                }
                if (this.isDebugEnabled) {
                    log.debug("=========================================\u4e8c\u6b21\u8c03\u4ef7=============================start");
                }
                String processCode = process.getProcessCode();
                TodoTaskReqBO todoTaskReqBO = new TodoTaskReqBO();
                todoTaskReqBO.setUserId(Long.valueOf(reqBO.getUserId()));
                todoTaskReqBO.setBusinessType("51");
                todoTaskReqBO.setProcInstId(processCode);
                TodoMyTaskRspBO queryMyTodoTask = this.queryMyTodoTaskBusinService.queryMyTodoTask(todoTaskReqBO);
                if (queryMyTodoTask.getTaskId() != null && !"".equals(queryMyTodoTask.getTaskId())) {
                    DoTaskCompleteReqBO doTaskCompleteReqBo = new DoTaskCompleteReqBO();
                    doTaskCompleteReqBo.setTaskId(queryMyTodoTask.getTaskId());
                    doTaskCompleteReqBo.setBusinessType("51");
                    doTaskCompleteReqBo.setUserId(Long.valueOf(reqBO.getUserId()));
                    RspBusiBaseBO doTaskComplete = this.doTaskCompleteBusinService.doTaskComplete(doTaskCompleteReqBo);
                    if (!doTaskComplete.getRespCode().equals("0000")) {
                        RspInfoBO rspBO3 = new RspInfoBO();
                        rspBO3.setRespCode("8888");
                        rspBO3.setRespDesc("\u5de5\u4f5c\u6d41\u6267\u884c\u5b8c\u6210\u4efb\u52a1\u6d41\u7a0b\u5931\u8d25");
                        if (this.isDebugEnabled) {
                            log.debug("=========================================\u5de5\u4f5c\u6d41\u6267\u884c\u5b8c\u6210\u4efb\u52a1\u6d41\u7a0b\u5931\u8d25=============================start");
                        }
                        return rspBO3;
                    }
                    break block21;
                }
                rspBO = new RspInfoBO();
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5f53\u524d\u65e0\u4ee3\u529e\u4efb\u52a1");
                if (this.isDebugEnabled) {
                    log.debug("=========================================\u5f53\u524d\u65e0\u5f85\u529e\u4efb\u52a1=============================start");
                }
                return rspBO;
            }
            catch (BusinessException e) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", e.getMessage());
            }
            catch (Exception e) {
                log.error("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u7ef4\u62a4\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38", (Throwable)e);
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u7ef4\u62a4\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38");
            }
        }
        RspInfoBO rspBO = new RspInfoBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8ba2\u5355\u7ef4\u62a4\u6210\u529f");
        return rspBO;
    }
}

