/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.alibaba.fastjson.JSON;
import com.cgd.common.busi.bo.RspBusiBaseBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.OrderPurchaseStatusChngXbjService;
import com.cgd.order.atom.bo.OrderPurchaseStatusChngReqBo;
import com.cgd.order.busi.XbjCreateOrderFlowSheetBusiService;
import com.cgd.order.busi.XbjOrderMtRejectBusiService;
import com.cgd.order.busi.bo.XbjOrderConfirmRejectRspBO;
import com.cgd.order.busi.bo.XbjOrderFlowSheetReqBO;
import com.cgd.order.busi.bo.XbjOrderFlowSheetRspBO;
import com.cgd.order.busi.bo.XbjOrderMtConfirmRejectReqBO;
import com.cgd.order.constant.Constant;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.OrderProcessCodeXbjMapper;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.po.OrderProcessCodeXbjPO;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import com.cgd.workflow.bo.DoTaskCompleteReqBO;
import com.cgd.workflow.bo.TodoMyTaskRspBO;
import com.cgd.workflow.bo.TodoTaskReqBO;
import com.cgd.workflow.busin.service.BpmStartBusinService;
import com.cgd.workflow.busin.service.DoTaskCompleteBusinService;
import com.cgd.workflow.busin.service.QueryMyTodoTaskBusinService;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class XbjOrderMtRejectBusiServiceImpl
implements XbjOrderMtRejectBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjOrderMtRejectBusiService.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    private OrderSaleXbjMapper orderSaleXbjMapper;
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;
    private OrderPurchaseStatusChngXbjService orderPurchaseStatusChngXbjService;
    @Autowired
    private XbjCreateOrderFlowSheetBusiService xbjCreateOrderFlowSheetBusiService;
    @Autowired
    private BpmStartBusinService bpmStartBusinService;
    @Autowired
    private QueryMyTodoTaskBusinService queryMyTodoTaskBusinService;
    @Autowired
    private DoTaskCompleteBusinService doTaskCompleteBusinService;
    @Autowired
    OrderProcessCodeXbjMapper orderProcessCodeXbjMapper;

    public void setOrderSaleXbjMapper(OrderSaleXbjMapper orderSaleXbjMapper) {
        this.orderSaleXbjMapper = orderSaleXbjMapper;
    }

    public void setOrderPurchaseXbjMapper(OrderPurchaseXbjMapper orderPurchaseXbjMapper) {
        this.orderPurchaseXbjMapper = orderPurchaseXbjMapper;
    }

    public void setOrderPurchaseStatusChngXbjService(OrderPurchaseStatusChngXbjService orderPurchaseStatusChngXbjService) {
        this.orderPurchaseStatusChngXbjService = orderPurchaseStatusChngXbjService;
    }

    public XbjOrderConfirmRejectRspBO dealXbjOrderMtReject(XbjOrderMtConfirmRejectReqBO reqBO) {
        XbjOrderConfirmRejectRspBO rspBO;
        block17: {
            this.validateBOData(reqBO);
            if (this.isDebugEnabled) {
                log.debug("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u7ef4\u62a4\u5ba1\u6279\u9a73\u56de\u4e1a\u52a1\u670d\u52a1\u5165\u53c2" + JSON.toJSONString((Object)reqBO));
            }
            rspBO = new XbjOrderConfirmRejectRspBO();
            try {
                OrderSaleXbjPO orderSaleXbjPO = new OrderSaleXbjPO();
                orderSaleXbjPO.setSaleOrderId(Long.valueOf(reqBO.getSaleOrderId()));
                orderSaleXbjPO.setPurchaseOrderId(Long.valueOf(reqBO.getPurchaseOrderId()));
                orderSaleXbjPO = this.orderSaleXbjMapper.getModelBy(orderSaleXbjPO);
                if (orderSaleXbjPO == null) {
                    rspBO.setRespCode("RSP_CODE_BUSI_SERVICE_ERROR");
                    rspBO.setRespDesc("\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
                    return rspBO;
                }
                OrderPurchaseXbjPO orderPurchase = this.orderPurchaseXbjMapper.getModelById(Long.valueOf(reqBO.getPurchaseOrderId()));
                if (orderPurchase == null) {
                    rspBO.setRespCode("RSP_CODE_BUSI_SERVICE_ERROR");
                    rspBO.setRespDesc("\u6839\u636e\u91c7\u8d2d\u8ba2\u5355id[purchaseOrderId]\u67e5\u8be2\u4e0d\u5230\u91c7\u8d2d\u8ba2\u5355\u8bb0\u5f55");
                    return rspBO;
                }
                if (XbjOrderConstants.PURCHASE_ORDER_MAINTAIN_APPROVING != orderPurchase.getPurchaseOrderStatus()) {
                    if (this.isDebugEnabled) {
                        log.debug("\u91c7\u8d2d\u8ba2\u5355ID\u3010" + reqBO.getPurchaseOrderId() + "\u3011\u5bf9\u5e94\u91c7\u8d2d\u8ba2\u5355\u72b6\u6001\u4e0d\u4e3a\u7ef4\u62a4\u5ba1\u6279\u4e2d\uff0c\u4e0d\u80fd\u7ee7\u7eed\u64cd\u4f5c\uff01");
                    }
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5bf9\u5e94\u91c7\u8d2d\u8ba2\u5355\u72b6\u6001\u4e0d\u4e3a\u7ef4\u62a4\u5ba1\u6279\u4e2d\uff0c\u4e0d\u80fd\u7ee7\u7eed\u64cd\u4f5c\uff01");
                }
                OrderPurchaseStatusChngReqBo orderPurchaseStatusChngReqBo = new OrderPurchaseStatusChngReqBo();
                orderPurchaseStatusChngReqBo.setPurchaseOrderId(orderPurchase.getPurchaseOrderId());
                orderPurchaseStatusChngReqBo.setPurchaserId(orderPurchase.getPurchaserId());
                orderPurchaseStatusChngReqBo.setGoodsSupplierId(orderPurchase.getGoodsSupplierId());
                orderPurchaseStatusChngReqBo.setPurchaseOrderStatus(XbjOrderConstants.PURCHASE_ORDER_BE_MAINTAINING);
                orderPurchaseStatusChngReqBo.setPurchaseOrderOldStatus(orderPurchase.getPurchaseOrderStatus());
                orderPurchaseStatusChngReqBo.setPurchaserAccountId(orderPurchase.getPurchaserAccountId());
                orderPurchaseStatusChngReqBo.setPurchaserAccountName(orderPurchase.getPurchaserAccountName());
                orderPurchaseStatusChngReqBo.setOperId(reqBO.getUserId());
                orderPurchaseStatusChngReqBo.setProfessionalOrganizationId(orderPurchase.getProfessionalOrganizationId());
                orderPurchaseStatusChngReqBo.setSaleOrderId(orderPurchase.getSaleOrderId());
                this.orderPurchaseStatusChngXbjService.dealOrderPurchaseStatus(orderPurchaseStatusChngReqBo);
                this.orderPurchaseXbjMapper.updateCancelInfo(orderPurchase.getPurchaseOrderId(), "MAINTAIN_REJECT_CANCEL", reqBO.getCancelRemark(), new Date(), Long.valueOf(reqBO.getUserId()));
                XbjOrderFlowSheetReqBO orderFlowSheetReqBO = new XbjOrderFlowSheetReqBO();
                orderFlowSheetReqBO.setOrderId(orderPurchase.getPurchaseOrderId());
                orderFlowSheetReqBO.setPurchaserId(orderPurchase.getPurchaserId());
                orderFlowSheetReqBO.setOperRemark(reqBO.getCancelRemark());
                orderFlowSheetReqBO.setUserId(Long.valueOf(reqBO.getUserId()));
                orderFlowSheetReqBO.setOrderType(Constant.ORDER_TYPE_PURCHASE);
                orderFlowSheetReqBO.setOrderBusiType("B_30");
                XbjOrderFlowSheetRspBO orderFlowSheetRsp = this.xbjCreateOrderFlowSheetBusiService.createOrderFlowSheet(orderFlowSheetReqBO);
                if (orderFlowSheetRsp != null && "8888".equals(orderFlowSheetRsp.getRespCode())) {
                    throw new BusinessException(orderFlowSheetRsp.getRespCode(), "\u8ba2\u5355\u6d41\u7a0b\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
                }
                Integer workFlag = XbjOrderConstants.WORK_FLAG.NOPASS;
                OrderProcessCodeXbjPO process = new OrderProcessCodeXbjPO();
                process.setOrderId(orderSaleXbjPO.getSaleOrderId());
                process.setBusiType("51");
                process.setProcessStatus("0");
                process = this.orderProcessCodeXbjMapper.getModelBy(process);
                if (process != null) {
                    String processCode = process.getProcessCode();
                    TodoTaskReqBO todoTaskReqBO = new TodoTaskReqBO();
                    todoTaskReqBO.setUserId(Long.valueOf(reqBO.getUserId()));
                    todoTaskReqBO.setBusinessType("51");
                    todoTaskReqBO.setProcInstId(processCode);
                    TodoMyTaskRspBO queryMyTodoTask = this.queryMyTodoTaskBusinService.queryMyTodoTask(todoTaskReqBO);
                    if (queryMyTodoTask.getTaskId() != null && !"".equals(queryMyTodoTask.getTaskId())) {
                        DoTaskCompleteReqBO doTaskCompleteReqBo = new DoTaskCompleteReqBO();
                        doTaskCompleteReqBo.setTaskId(queryMyTodoTask.getTaskId());
                        doTaskCompleteReqBo.setBusinessType("51");
                        doTaskCompleteReqBo.setUserId(Long.valueOf(reqBO.getUserId()));
                        doTaskCompleteReqBo.setSeqFlowId(workFlag + "");
                        if (this.isDebugEnabled) {
                            log.debug("=========================================\u5de5\u4f5c\u6d41\u6267\u884c\u5b8c\u6210\u4efb\u52a1\u6d41\u7a0b=============================start");
                        }
                        RspBusiBaseBO doTaskComplete = this.doTaskCompleteBusinService.doTaskComplete(doTaskCompleteReqBo);
                        log.debug("=========================================\u5de5\u4f5c\u6d41\u6267\u884c\u5b8c\u6210\u4efb\u52a1\u6d41\u7a0b\u8fd4\u56de=============================RSP\uff1a" + doTaskComplete.toString());
                        if (!doTaskComplete.getRespCode().equals("0000")) {
                            rspBO.setRespCode("8888");
                            rspBO.setRespDesc("\u5de5\u4f5c\u6d41\u6267\u884c\u5b8c\u6210\u4efb\u52a1\u6d41\u7a0b\u5931\u8d25");
                            if (this.isDebugEnabled) {
                                log.debug("=========================================\u5de5\u4f5c\u6d41\u6267\u884c\u5b8c\u6210\u4efb\u52a1\u6d41\u7a0b\u5931\u8d25=============================start");
                            }
                            return rspBO;
                        }
                        if (workFlag == XbjOrderConstants.WORK_FLAG.PASS) {
                            process.setProcessStatus("1");
                            this.orderProcessCodeXbjMapper.updateById(process);
                        }
                    } else {
                        rspBO.setRespCode("8888");
                        rspBO.setRespDesc("\u5f53\u524d\u65e0\u4ee3\u529e\u4efb\u52a1");
                        if (this.isDebugEnabled) {
                            log.debug("=========================================\u5f53\u524d\u65e0\u5f85\u529e\u4efb\u52a1=============================start");
                        }
                    }
                    break block17;
                }
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u9500\u552e\u8ba2\u5355\u8c03\u4ef7\u63d0\u4ea4\u5ba1\u6838\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff1a\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u6d41\u7a0b\u5b9e\u4f8b");
            }
            catch (BusinessException e) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", e.getMessage());
            }
            catch (Exception e) {
                log.error("\u8be2\u6bd4\u4ef7\u8ba2\u5355\u7ef4\u62a4\u5ba1\u6279\u9a73\u56de\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38", (Throwable)e);
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u7ef4\u62a4\u5ba1\u6279\u9a73\u56de\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38");
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validateBOData(XbjOrderMtConfirmRejectReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u7ef4\u62a4\u5ba1\u6279\u9a73\u56de\u4e1a\u52a1\u670d\u52a1  \u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getSaleOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u7ef4\u62a4\u5ba1\u6279\u9a73\u56de\u4e1a\u52a1\u670d\u52a1  \u9500\u552e\u5355ID\u3010saleOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getPurchaseOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u7ef4\u62a4\u5ba1\u6279\u9a73\u56de\u4e1a\u52a1\u670d\u52a1  \u91c7\u8d2d\u8ba2\u5355ID\u3010purchaserOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getUserId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u7ef4\u62a4\u5ba1\u6279\u9a73\u56de\u4e1a\u52a1\u670d\u52a1  \u7528\u6237ID\u3010userId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

