/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.alibaba.fastjson.JSON;
import com.cgd.common.bo.RspInfoBO;
import com.cgd.common.busi.bo.RspBusiBaseBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.AccessoryXbjAtomService;
import com.cgd.order.atom.OrderSaleXbjAtomService;
import com.cgd.order.atom.SaleOrderPriceAdjustmentXbjAtomService;
import com.cgd.order.atom.SaleOrderStatusCheckXbjService;
import com.cgd.order.atom.bo.OrderSaleXbjReqBO;
import com.cgd.order.atom.bo.SaleOrderPriceAdjustmentAtomXbjReqBO;
import com.cgd.order.atom.bo.SaleOrderPriceAdjustmentAtomXbjRspBO;
import com.cgd.order.atom.bo.SaleOrderStatusCheckXbjReqBO;
import com.cgd.order.atom.bo.SaleOrderStatusCheckXbjRspBO;
import com.cgd.order.busi.XbjCreateOrderFlowSheetBusiService;
import com.cgd.order.busi.XbjOrderSalePriceAdjustCommentService;
import com.cgd.order.busi.bo.XbjOrderFlowSheetReqBO;
import com.cgd.order.busi.bo.XbjOrderFlowSheetRspBO;
import com.cgd.order.busi.bo.XbjOrderSalePriceAdjustCommentReqBO;
import com.cgd.order.constant.OrderCenterConstant;
import com.cgd.order.constant.XConstant;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.OrderProcessCodeXbjMapper;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.po.OrderProcessCodeXbjPO;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import com.cgd.workflow.bo.DoTaskCompleteReqBO;
import com.cgd.workflow.bo.TodoMyTaskRspBO;
import com.cgd.workflow.bo.TodoTaskReqBO;
import com.cgd.workflow.busin.service.DoTaskCompleteBusinService;
import com.cgd.workflow.busin.service.QueryMyTodoTaskBusinService;
import java.lang.reflect.UndeclaredThrowableException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class XbjOrderSalePriceAdjustCommentServiceImpl
implements XbjOrderSalePriceAdjustCommentService {
    private static final Logger log = LoggerFactory.getLogger(XbjOrderSalePriceAdjustCommentService.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private AccessoryXbjAtomService accessoryXbjAtomService;
    @Autowired
    private SaleOrderStatusCheckXbjService saleOrderStatusCheckXbjService;
    @Autowired
    private OrderSaleXbjAtomService orderSaleXbjAtomService;
    @Autowired
    private OrderSaleXbjMapper orderSaleXbjMapper;
    @Autowired
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;
    @Autowired
    private SaleOrderPriceAdjustmentXbjAtomService saleOrderPriceAdjustmentXbjAtomService;
    @Autowired
    private XbjCreateOrderFlowSheetBusiService xbjCreateOrderFlowSheetBusiService;
    @Autowired
    private OrderProcessCodeXbjMapper orderProcessCodeXbjMapper;
    @Autowired
    private QueryMyTodoTaskBusinService queryMyTodoTaskBusinService;
    @Autowired
    private DoTaskCompleteBusinService doTaskCompleteBusinService;

    public RspInfoBO dealWithAdjustComment(XbjOrderSalePriceAdjustCommentReqBO reqBO) {
        this.validReqBO(reqBO);
        if (isDebugEnabled) {
            log.debug("\u8be2\u6bd4\u4ef7\u8c03\u4ef7\u901a\u8fc7/\u9a73\u56de\u4e1a\u52a1\u670d\u52a1\u5165\u53c2" + JSON.toJSONString((Object)reqBO));
        }
        try {
            OrderSaleXbjPO orderSale;
            Boolean passFlag;
            Long saleOrderId;
            block27: {
                SaleOrderStatusCheckXbjRspBO saleOrderStatusCheckRsp;
                Integer workFlag = Integer.valueOf(reqBO.getWorkFlag());
                saleOrderId = Long.valueOf(reqBO.getSaleOrderId());
                int saleOrderStatus = 0;
                passFlag = false;
                if (workFlag == XbjOrderConstants.WORK_FLAG.PASS) {
                    saleOrderStatus = XbjOrderConstants.XBJ_SALE_ORDER_STATUS.ORDER_CONFIRM;
                    passFlag = true;
                } else if (workFlag == XbjOrderConstants.WORK_FLAG.NOPASS) {
                    this.accessoryXbjAtomService.deleteAccessoryInfo(saleOrderId, XbjOrderConstants.ACCESSORY_ADJUST_SALE_ORDER);
                    saleOrderStatus = XbjOrderConstants.XBJ_SALE_ORDER_STATUS.ORDER_CHECK;
                } else {
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5165\u53c2\u64cd\u4f5c\u6807\u8bc6[" + workFlag + "]\u4e0d\u7b26\u5408\u8981\u6c42\uff01");
                }
                orderSale = this.orderSaleXbjMapper.selectOrderSaleByCondition(saleOrderId, Long.valueOf(reqBO.getPurchaseId()));
                if (null == orderSale) {
                    throw new BusinessException("RSP_CODE_SALSE_ORDER_NOT_EXIST", "\u9500\u552e\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
                }
                SaleOrderStatusCheckXbjReqBO saleOrderStatusCheckReq = new SaleOrderStatusCheckXbjReqBO();
                saleOrderStatusCheckReq.setSaleOrderType(orderSale.getSaleOrderType());
                saleOrderStatusCheckReq.setNewSaleOrderStatus(saleOrderStatus);
                saleOrderStatusCheckReq.setOldSaleOrderStatus(orderSale.getSaleOrderStatus());
                if (isDebugEnabled) {
                    log.debug("\u72b6\u6001\u53d8\u5316\u6821\u9a8c\u5165\u53c2:" + saleOrderStatusCheckReq.toString());
                }
                if (!"0000".equals((saleOrderStatusCheckRsp = this.saleOrderStatusCheckXbjService.notifySaleOrderStatus(saleOrderStatusCheckReq)).getCheckRspCode())) {
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", saleOrderStatusCheckRsp.getCheckRspDesc());
                }
                OrderSaleXbjReqBO orderSaleReqBO = new OrderSaleXbjReqBO();
                orderSaleReqBO.setSaleOrderId(orderSale.getSaleOrderId());
                orderSaleReqBO.setSaleOrderStatus(saleOrderStatus);
                orderSaleReqBO.setSaleOrderOldStatus(orderSale.getSaleOrderStatus());
                orderSaleReqBO.setPurchaserId(orderSale.getPurchaserId());
                orderSaleReqBO.setPurchaserAccountId(orderSale.getPurchaserAccountId());
                orderSaleReqBO.setProfessionalOrganizationId(orderSale.getProfessionalOrganizationId());
                orderSaleReqBO.setOperId(String.valueOf(reqBO.getUserId()));
                this.orderSaleXbjAtomService.salerOrderStatusChange(orderSaleReqBO);
                OrderProcessCodeXbjPO process = new OrderProcessCodeXbjPO();
                process.setOrderId(orderSale.getSaleOrderId());
                process.setBusiType("51");
                process.setProcessStatus("0");
                try {
                    process = this.orderProcessCodeXbjMapper.getModelBy(process);
                    if (process != null) {
                        String processCode = process.getProcessCode();
                        TodoTaskReqBO todoTaskReqBO = new TodoTaskReqBO();
                        todoTaskReqBO.setUserId(Long.valueOf(reqBO.getUserId()));
                        todoTaskReqBO.setBusinessType("51");
                        todoTaskReqBO.setProcInstId(processCode);
                        TodoMyTaskRspBO queryMyTodoTask = this.queryMyTodoTaskBusinService.queryMyTodoTask(todoTaskReqBO);
                        if (queryMyTodoTask.getTaskId() != null && !"".equals(queryMyTodoTask.getTaskId())) {
                            DoTaskCompleteReqBO doTaskCompleteReqBo = new DoTaskCompleteReqBO();
                            doTaskCompleteReqBo.setTaskId(queryMyTodoTask.getTaskId());
                            doTaskCompleteReqBo.setBusinessType("51");
                            doTaskCompleteReqBo.setUserId(Long.valueOf(reqBO.getUserId()));
                            doTaskCompleteReqBo.setSeqFlowId(workFlag + "");
                            if (isDebugEnabled) {
                                log.debug("=========================================\u5de5\u4f5c\u6d41\u6267\u884c\u5b8c\u6210\u4efb\u52a1\u6d41\u7a0b=============================start");
                            }
                            RspBusiBaseBO doTaskComplete = this.doTaskCompleteBusinService.doTaskComplete(doTaskCompleteReqBo);
                            log.debug("=========================================\u5de5\u4f5c\u6d41\u6267\u884c\u5b8c\u6210\u4efb\u52a1\u6d41\u7a0b\u8fd4\u56de=============================RSP\uff1a" + doTaskComplete.toString());
                            if (!doTaskComplete.getRespCode().equals("0000")) {
                                RspInfoBO rspBO = new RspInfoBO();
                                rspBO.setRespCode("8888");
                                rspBO.setRespDesc("\u5de5\u4f5c\u6d41\u6267\u884c\u5b8c\u6210\u4efb\u52a1\u6d41\u7a0b\u5931\u8d25");
                                if (isDebugEnabled) {
                                    log.debug("=========================================\u5de5\u4f5c\u6d41\u6267\u884c\u5b8c\u6210\u4efb\u52a1\u6d41\u7a0b\u5931\u8d25=============================start");
                                }
                                return rspBO;
                            }
                            if (workFlag == XbjOrderConstants.WORK_FLAG.PASS) {
                                process.setProcessStatus("1");
                                this.orderProcessCodeXbjMapper.updateById(process);
                            }
                        } else {
                            RspInfoBO rspBO = new RspInfoBO();
                            rspBO.setRespCode("8888");
                            rspBO.setRespDesc("\u5f53\u524d\u65e0\u4ee3\u529e\u4efb\u52a1");
                            if (isDebugEnabled) {
                                log.debug("=========================================\u5f53\u524d\u65e0\u5f85\u529e\u4efb\u52a1=============================start");
                            }
                        }
                        break block27;
                    }
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u9500\u552e\u8ba2\u5355\u8c03\u4ef7\u63d0\u4ea4\u5ba1\u6838\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff1a\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u6d41\u7a0b\u5b9e\u4f8b");
                }
                catch (UndeclaredThrowableException e) {
                    log.error("\u5de5\u4f5c\u6d41\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u5de5\u4f5c\u6d41\u63a5\u53e3\u5f02\u5e38");
                }
                catch (Exception e) {
                    log.error("\u8be2\u6bd4\u4ef7\u9500\u552e\u8ba2\u5355\u8c03\u4ef7\u63d0\u4ea4\u5ba1\u6838\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38", (Throwable)e);
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u9500\u552e\u8ba2\u5355\u8c03\u4ef7\u63d0\u4ea4\u5ba1\u6838\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38");
                }
            }
            if (passFlag.booleanValue()) {
                OrderPurchaseXbjPO record = this.orderPurchaseXbjMapper.getModelById(orderSale.getPurchaseOrderId());
                record.setDeliveryId(orderSale.getDeliveryId());
                record.setDeliveryName(orderSale.getDeliveryName());
                record.setGoodsSupplierId(orderSale.getGoodsSupplierId());
                record.setModifyOperId(reqBO.getUserId());
                record.setPurchaseOrderId(orderSale.getPurchaseOrderId());
                record.setPurchaseOrderStatus(XConstant.SALE_ORDER_STATE_SUPPLY_CONFIRMING);
                int result = this.orderPurchaseXbjMapper.updateById(record);
                if (result > 0) {
                    SaleOrderPriceAdjustmentAtomXbjReqBO orderPriceAdjustmentAtomReq = new SaleOrderPriceAdjustmentAtomXbjReqBO();
                    orderPriceAdjustmentAtomReq.setPurchaserId(Long.valueOf(reqBO.getPurchaseId()));
                    orderPriceAdjustmentAtomReq.setSaleOrderId(saleOrderId);
                    SaleOrderPriceAdjustmentAtomXbjRspBO adjustmentAtomXbjRspBO = this.saleOrderPriceAdjustmentXbjAtomService.updateSaleOrderPrice(orderPriceAdjustmentAtomReq);
                    if (!"0000".equals(adjustmentAtomXbjRspBO.getRespCode())) {
                        throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", adjustmentAtomXbjRspBO.getRespDesc());
                    }
                } else {
                    throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u4fee\u6539\u91c7\u8d2d\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38");
                }
            }
            XbjOrderFlowSheetReqBO orderFlowSheetReqBO = new XbjOrderFlowSheetReqBO();
            orderFlowSheetReqBO.setOrderId(orderSale.getSaleOrderId());
            orderFlowSheetReqBO.setPurchaserId(orderSale.getPurchaserId());
            orderFlowSheetReqBO.setUserId(reqBO.getUserId());
            orderFlowSheetReqBO.setUserName(orderSale.getPurchaserAccountName());
            orderFlowSheetReqBO.setOrderType(OrderCenterConstant.ORDER_TYPE.SALE);
            orderFlowSheetReqBO.setOrderBusiType("B_3");
            XbjOrderFlowSheetRspBO orderFlowSheetRsp = this.xbjCreateOrderFlowSheetBusiService.createOrderFlowSheet(orderFlowSheetReqBO);
            if (orderFlowSheetRsp != null && "8888".equals(orderFlowSheetRsp.getRespCode())) {
                throw new BusinessException(orderFlowSheetRsp.getRespCode(), "\u8ba2\u5355\u6d41\u7a0b\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
            }
        }
        catch (BusinessException e) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", e.getMessage());
        }
        catch (Exception e) {
            log.error("\u8be2\u6bd4\u4ef7\u8c03\u4ef7\u901a\u8fc7/\u9a73\u56de\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u8be2\u6bd4\u4ef7\u8c03\u4ef7\u901a\u8fc7/\u9a73\u56de\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38");
        }
        RspInfoBO rspBO = new RspInfoBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validReqBO(XbjOrderSalePriceAdjustCommentReqBO reqBO) {
        if (null == reqBO) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u901a\u8fc7\u9a73\u56de\u72b6\u6001\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1:\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getPurchaseId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u901a\u8fc7\u9a73\u56de\u72b6\u6001\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1:\u5165\u53c2-\u91c7\u8d2d\u5546\u7f16\u53f7:[purchaseId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getSaleOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u901a\u8fc7\u9a73\u56de\u72b6\u6001\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1:\u5165\u53c2-\u9500\u552e\u8ba2\u5355\u53f7:[saleOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getWorkFlag())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u901a\u8fc7\u9a73\u56de\u72b6\u6001\u53d8\u66f4\u4e1a\u52a1\u670d\u52a1:\u5165\u53c2-\u5224\u65ad\u6807\u8bc6:[workFlag]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

