/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.order.atom.CheckMsgSendCountXbjAtomService;
import com.cgd.order.atom.QrySmsTemplateXbjAtomService;
import com.cgd.order.atom.bo.QrySmsTemplateAtomXbjReqBO;
import com.cgd.order.busi.XbjCheckSaleOrderConfirmService;
import com.cgd.order.busi.XbjCheckWhetherShipAllService;
import com.cgd.order.busi.XbjProfessNoticeIntfceService;
import com.cgd.order.busi.bo.XbjCheckSaleOrderConfirmReqBO;
import com.cgd.order.busi.bo.XbjCheckSaleOrderConfirmRspBO;
import com.cgd.order.busi.bo.XbjCheckWhetherShipAllReqBO;
import com.cgd.order.busi.bo.XbjCheckWhetherShipAllRspBO;
import com.cgd.order.busi.bo.XbjProfessNoticeReqBO;
import com.cgd.order.busi.bo.XbjProfessNoticeRspBO;
import com.cgd.order.constant.Constant;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.intfce.XbjQryReceiveRecipientInfoIntfceService;
import com.cgd.order.intfce.XbjTemplateMatchIntfceService;
import com.cgd.order.intfce.bo.XbjContactInfoBO;
import com.cgd.order.intfce.bo.XbjQryReceiveRecipientReqBO;
import com.cgd.order.intfce.bo.XbjQryReceiveRecipientRspBO;
import com.cgd.order.intfce.bo.XbjTemplateMatchReqBO;
import com.cgd.order.intfce.bo.XbjTemplateMatchRspBO;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.po.RemindConfigureXbjPO;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class XbjProfessNoticeIntfceServiceImpl
implements XbjProfessNoticeIntfceService {
    private static final Logger log = LoggerFactory.getLogger(XbjProfessNoticeIntfceServiceImpl.class);
    private final Boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;
    @Autowired
    private XbjCheckSaleOrderConfirmService xbjCheckSaleOrderConfirmService;
    @Autowired
    private XbjCheckWhetherShipAllService checkWhetherShipAllService;
    @Autowired
    private QrySmsTemplateXbjAtomService qrySmsTemplateXbjAtomService;
    @Autowired
    private CheckMsgSendCountXbjAtomService checkMsgSendCountXbjAtomService;
    @Autowired
    private XbjQryReceiveRecipientInfoIntfceService xbjQryReceiveRecipientInfoIntfceService;
    @Autowired
    private XbjTemplateMatchIntfceService templateMatchIntfceService;

    public XbjProfessNoticeRspBO professNotice(XbjProfessNoticeReqBO xbjProfessNoticeReqBO) {
        XbjProfessNoticeRspBO xbjProfessNoticeRspBO;
        block9: {
            if (this.isDebugEnabled.booleanValue()) {
                log.debug("\u4e13\u4e1a\u673a\u6784\u63d0\u9192\u4fe1\u606f\u7ec4\u5408\u670d\u52a1\u5165\u53c2" + xbjProfessNoticeReqBO);
            }
            this.validateBOData(xbjProfessNoticeReqBO);
            xbjProfessNoticeRspBO = new XbjProfessNoticeRspBO();
            try {
                OrderPurchaseXbjPO condition = new OrderPurchaseXbjPO();
                condition.setPurchaseOrderId(Long.parseLong(xbjProfessNoticeReqBO.getPurchaseOrderId()));
                condition.setPurchaserId(xbjProfessNoticeReqBO.getPurchaserId());
                OrderPurchaseXbjPO orderPurchaseXbjPO = this.orderPurchaseXbjMapper.getModelBy(condition);
                if (orderPurchaseXbjPO == null) {
                    throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u5931\u8d25\uff01");
                }
                if (xbjProfessNoticeReqBO.getNoticeType().equals("remindConfirm")) {
                    this.checkSaleOrderConfirm(orderPurchaseXbjPO.getSaleOrderId(), orderPurchaseXbjPO.getPurchaserId());
                    xbjProfessNoticeReqBO.setOrderType(Constant.ORDER_TYPE_PURCHASE);
                    xbjProfessNoticeReqBO.setBusiCode("B_16");
                    String respDesc = this.sendRemindMsg(xbjProfessNoticeReqBO, orderPurchaseXbjPO.getPurchaseOrderCode());
                    xbjProfessNoticeRspBO.setRespCode("0000");
                    xbjProfessNoticeRspBO.setRespDesc(respDesc);
                    break block9;
                }
                if (xbjProfessNoticeReqBO.getNoticeType().equals("ugreDelivery")) {
                    this.checkWhetherShipAll(orderPurchaseXbjPO.getSaleOrderId(), orderPurchaseXbjPO.getPurchaserId());
                    xbjProfessNoticeReqBO.setOrderType(Constant.ORDER_TYPE_PURCHASE);
                    xbjProfessNoticeReqBO.setBusiCode("B_14");
                    String respDesc = this.sendRemindMsg(xbjProfessNoticeReqBO, orderPurchaseXbjPO.getPurchaseOrderCode());
                    xbjProfessNoticeRspBO.setRespCode("0000");
                    xbjProfessNoticeRspBO.setRespDesc(respDesc);
                    break block9;
                }
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u4e13\u4e1a\u673a\u6784\u63d0\u9192\u4fe1\u606f\u7ec4\u5408\u670d\u52a1  \u91c7\u8d2d\u5355\u4f4dID\u3010noticeType\u3011\u4e0d\u80fd\u4e3a\u65e0\u6548\u53c2\u6570\uff01");
            }
            catch (BusinessException e) {
                if (this.isDebugEnabled.booleanValue()) {
                    log.debug("\u4e13\u4e1a\u673a\u6784\u63d0\u9192\u4fe1\u606f\u7ec4\u5408\u670d\u52a1\u4e1a\u52a1\u5f02\u5e38\uff1a" + e.getMessage());
                }
                xbjProfessNoticeRspBO.setRespCode("8888");
                xbjProfessNoticeRspBO.setRespDesc(e.getMessage());
                return xbjProfessNoticeRspBO;
            }
            catch (Exception e) {
                if (this.isDebugEnabled.booleanValue()) {
                    log.debug("\u4e13\u4e1a\u673a\u6784\u63d0\u9192\u4fe1\u606f\u7ec4\u5408\u670d\u52a1\u5f02\u5e38\uff1a" + e.getMessage());
                }
                xbjProfessNoticeRspBO.setRespCode("8888");
                xbjProfessNoticeRspBO.setRespDesc(e.getMessage());
                return xbjProfessNoticeRspBO;
            }
        }
        return xbjProfessNoticeRspBO;
    }

    private void checkWhetherShipAll(Long saleOrderId, Long purchaserId) {
        XbjCheckWhetherShipAllReqBO checkWhetherShipAllReqBO = new XbjCheckWhetherShipAllReqBO();
        checkWhetherShipAllReqBO.setSaleOrderId(String.valueOf(saleOrderId));
        checkWhetherShipAllReqBO.setPurchaserId(purchaserId);
        XbjCheckWhetherShipAllRspBO checkWhetherShipAllRspBO = this.checkWhetherShipAllService.checkWhetherShipAll(checkWhetherShipAllReqBO);
        if (checkWhetherShipAllRspBO != null && !"0000".equals(checkWhetherShipAllRspBO.getRespCode())) {
            log.debug("\u4e13\u4e1a\u673a\u6784\u50ac\u4ea4\u4fe1\u606f\u7ec4\u5408\u670d\u52a1-\u53d1\u8d27\u5355\u9a8c\u8bc1\u5f02\u5e38\uff1a" + checkWhetherShipAllRspBO.getRespDesc());
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", checkWhetherShipAllRspBO.getRespDesc());
        }
        if (checkWhetherShipAllRspBO == null || checkWhetherShipAllRspBO.getAllShip().booleanValue()) {
            log.debug("\u4e13\u4e1a\u673a\u6784\u50ac\u4ea4\u4fe1\u606f\u7ec4\u5408\u670d\u52a1-\u53d1\u8d27\u5355\u5df2\u5168\u90e8\u53d1\u8d27\u5b8c\u6210\uff0c\u4e0d\u80fd\u8fdb\u884c\u50ac\u4ea4\uff01");
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u53d1\u8d27\u5355\u5df2\u5168\u90e8\u53d1\u8d27\u5b8c\u6210\uff0c\u4e0d\u80fd\u8fdb\u884c\u50ac\u4ea4\uff01");
        }
    }

    private void validateBOData(XbjProfessNoticeReqBO xbjProfessNoticeReqBO) {
        if (xbjProfessNoticeReqBO == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u4e13\u4e1a\u673a\u6784\u63d0\u9192\u4fe1\u606f\u7ec4\u5408\u670d\u52a1  \u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)xbjProfessNoticeReqBO.getPurchaseOrderId())) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u4e13\u4e1a\u673a\u6784\u63d0\u9192\u4fe1\u606f\u7ec4\u5408\u670d\u52a1  \u91c7\u8d2d\u8ba2\u5355ID\u3010purchaseOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (xbjProfessNoticeReqBO.getPurchaserId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u4e13\u4e1a\u673a\u6784\u63d0\u9192\u4fe1\u606f\u7ec4\u5408\u670d\u52a1  \u91c7\u8d2d\u5355\u4f4dID\u3010purchaserId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (xbjProfessNoticeReqBO.getNoticeType() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u4e13\u4e1a\u673a\u6784\u63d0\u9192\u4fe1\u606f\u7ec4\u5408\u670d\u52a1  \u91c7\u8d2d\u5355\u4f4dID\u3010noticeType\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void checkSaleOrderConfirm(Long saleOrderId, Long purchaerId) {
        XbjCheckSaleOrderConfirmReqBO checkSaleOrderConfirmReqBO = new XbjCheckSaleOrderConfirmReqBO();
        checkSaleOrderConfirmReqBO.setSaleOrderId(String.valueOf(saleOrderId));
        checkSaleOrderConfirmReqBO.setPurchaserId(purchaerId);
        XbjCheckSaleOrderConfirmRspBO checkSaleOrderConfirmRspBO = this.xbjCheckSaleOrderConfirmService.checkSaleOrderConfirm(checkSaleOrderConfirmReqBO);
        if (checkSaleOrderConfirmRspBO != null && !"0000".equals(checkSaleOrderConfirmRspBO.getRespCode())) {
            if (this.isDebugEnabled.booleanValue()) {
                log.debug("\u4e13\u4e1a\u673a\u6784\u63d0\u9192\u4fe1\u606f\u7ec4\u5408\u670d\u52a1-\u9500\u552e\u8ba2\u5355\u9a8c\u8bc1\u5f02\u5e38\uff1a" + checkSaleOrderConfirmRspBO.getRespDesc());
            }
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", checkSaleOrderConfirmRspBO.getRespDesc());
        }
        if (checkSaleOrderConfirmRspBO == null || !checkSaleOrderConfirmRspBO.getConfirmFlag().booleanValue()) {
            if (this.isDebugEnabled.booleanValue()) {
                log.debug("\u4e13\u4e1a\u673a\u6784\u50ac\u4ea4\u4fe1\u606f\u7ec4\u5408\u670d\u52a1-\u9500\u552e\u8ba2\u5355\u4e0d\u80fd\u8fdb\u884c\u63d0\u9192\u64cd\u4f5c\uff01");
            }
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u9500\u552e\u8ba2\u5355\u4e0d\u80fd\u8fdb\u884c\u63d0\u9192\u64cd\u4f5c\uff01");
        }
    }

    private String sendRemindMsg(XbjProfessNoticeReqBO xbjProfessNoticeReqBO, String orderCode) {
        QrySmsTemplateAtomXbjReqBO qrySmsTemplateAtomReqBO = new QrySmsTemplateAtomXbjReqBO();
        qrySmsTemplateAtomReqBO.setOrderId(Long.parseLong(xbjProfessNoticeReqBO.getPurchaseOrderId()));
        qrySmsTemplateAtomReqBO.setOrderType(xbjProfessNoticeReqBO.getOrderType());
        qrySmsTemplateAtomReqBO.setBusiCode(xbjProfessNoticeReqBO.getBusiCode());
        qrySmsTemplateAtomReqBO.setPurchaserId(xbjProfessNoticeReqBO.getPurchaserId());
        List<RemindConfigureXbjPO> remindConfigureList = this.qrySmsTemplateXbjAtomService.querySmsTemplate(qrySmsTemplateAtomReqBO);
        if (remindConfigureList == null || remindConfigureList.size() == 0) {
            if (this.isDebugEnabled.booleanValue()) {
                log.debug("\u4e13\u4e1a\u673a\u6784\u63d0\u9192\u4fe1\u606f\u7ec4\u5408\u670d\u52a1-\u6ca1\u6709\u5bf9\u5e94\u6a21\u677f\u914d\u7f6e");
            }
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u6ca1\u6709\u5bf9\u5e94\u6a21\u677f\u914d\u7f6e");
        }
        int successCount = 0;
        int failurCount = 0;
        for (RemindConfigureXbjPO remindConfigure : remindConfigureList) {
            List contactInfoList;
            Boolean flg = this.checkMsgSendCountXbjAtomService.checkMsgSendCount(orderCode, remindConfigure.getId(), new Date(), remindConfigure.getSendCount(), "day");
            if (!flg.booleanValue()) {
                if (this.isDebugEnabled.booleanValue()) {
                    log.debug("\u4e13\u4e1a\u673a\u6784\u63d0\u9192\u4fe1\u606f\u7ec4\u5408\u670d\u52a1-\u3010" + remindConfigure.getId() + "\u3011\u8d85\u51fa\u53d1\u9001\u6b21\u6570\uff0c\u4e0d\u80fd\u518d\u53d1\u9001\u4fe1\u606f");
                }
                ++failurCount;
                continue;
            }
            XbjQryReceiveRecipientRspBO qryContactInfo = this.qryContactInfo(remindConfigure.getRoleId(), Long.parseLong(xbjProfessNoticeReqBO.getPurchaseOrderId()), Constant.ORDER_TYPE_PURCHASE, xbjProfessNoticeReqBO.getPurchaserId());
            if (qryContactInfo == null) continue;
            if (this.isDebugEnabled.booleanValue()) {
                log.debug("\u8054\u7cfb\u4eba\u4fe1\u606f\uff1a" + qryContactInfo);
            }
            if (null == (contactInfoList = qryContactInfo.getContactInfoList()) || contactInfoList.isEmpty()) continue;
            for (XbjContactInfoBO contactInfo : contactInfoList) {
                XbjTemplateMatchRspBO templateMatchRspBO = this.dealTemplateMatch(xbjProfessNoticeReqBO, remindConfigure, contactInfo);
                if (templateMatchRspBO != null && "0000".equals(templateMatchRspBO.getRespCode())) {
                    ++successCount;
                    continue;
                }
                ++failurCount;
            }
        }
        String respDesc = "\u53d1\u9001\u6210\u529f\u3010" + successCount + "\u3011\u6761\u4fe1\u606f\uff0c\u53d1\u9001\u5931\u8d25\u3010" + failurCount + "\u3011\u6761\u4fe1\u606f";
        return respDesc;
    }

    private XbjTemplateMatchRspBO dealTemplateMatch(XbjProfessNoticeReqBO xbjProfessNoticeReqBO, RemindConfigureXbjPO remindConfigureXbjPO, XbjContactInfoBO contactInfo) {
        XbjTemplateMatchReqBO templateMatchReqBO = new XbjTemplateMatchReqBO();
        templateMatchReqBO.setOrderId(Long.valueOf(Long.parseLong(xbjProfessNoticeReqBO.getPurchaseOrderId())));
        templateMatchReqBO.setOrderType(Constant.ORDER_TYPE_PURCHASE);
        templateMatchReqBO.setTemplateId(Long.valueOf(Long.parseLong(remindConfigureXbjPO.getTemplateId())));
        templateMatchReqBO.setCongifId(remindConfigureXbjPO.getId());
        templateMatchReqBO.setPurchaserId(xbjProfessNoticeReqBO.getPurchaserId());
        templateMatchReqBO.setSendType(remindConfigureXbjPO.getSendType());
        templateMatchReqBO.setRoleId(remindConfigureXbjPO.getRoleId());
        templateMatchReqBO.setCellphone(contactInfo.getCellphone());
        templateMatchReqBO.setEmail(contactInfo.getEmail());
        return this.templateMatchIntfceService.templateMatch(templateMatchReqBO);
    }

    private XbjQryReceiveRecipientRspBO qryContactInfo(String roleId, Long orderId, Integer orderType, Long purchaserId) {
        XbjQryReceiveRecipientReqBO qryReceiveRecipient = new XbjQryReceiveRecipientReqBO();
        qryReceiveRecipient.setRoleId(roleId);
        qryReceiveRecipient.setOrderId(orderId);
        qryReceiveRecipient.setOrderType(orderType);
        qryReceiveRecipient.setPurchaserId(purchaserId);
        return this.xbjQryReceiveRecipientInfoIntfceService.qryReceiveRecipient(qryReceiveRecipient);
    }
}

