/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.feature.orm.mybatis.Page;
import com.cgd.order.busi.XbjQryOrderConstrDetailBusiService;
import com.cgd.order.busi.bo.CompleteItemRspBO;
import com.cgd.order.busi.bo.XbjQryOrderConstrDetailReqBO;
import com.cgd.order.busi.bo.XbjQryOrderConstrDetailRspBO;
import com.cgd.order.dao.AccessoryXbjMapper;
import com.cgd.order.dao.OrderConstrCompleteItemXbjMapper;
import com.cgd.order.dao.OrderConstrCompleteXbjMapper;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.intfce.bo.XbjAccessoryBO;
import com.cgd.order.po.AccessoryXbjPO;
import com.cgd.order.po.OrderConstrCompleteItemXbjPO;
import com.cgd.order.po.OrderConstrCompleteXbjPO;
import com.cgd.order.util.DateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class XbjQryOrderConstrDetailBusiServiceImpl
implements XbjQryOrderConstrDetailBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjQryOrderConstrDetailBusiService.class);
    private final Boolean isDebugEnabled = log.isDebugEnabled();
    private OrderConstrCompleteXbjMapper orderConstrXbjMapper;
    private OrderConstrCompleteItemXbjMapper orderConstrItemXbjMapper;
    private AccessoryXbjMapper accessoryXbjMapper;
    @Autowired
    private OrderSaleXbjMapper orderSaleXbjMapper;
    @Autowired
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;

    public void setOrderConstrXbjMapper(OrderConstrCompleteXbjMapper orderConstrXbjMapper) {
        this.orderConstrXbjMapper = orderConstrXbjMapper;
    }

    public void setOrderConstrItemXbjMapper(OrderConstrCompleteItemXbjMapper orderConstrItemXbjMapper) {
        this.orderConstrItemXbjMapper = orderConstrItemXbjMapper;
    }

    public void setAccessoryXbjMapper(AccessoryXbjMapper accessoryXbjMapper) {
        this.accessoryXbjMapper = accessoryXbjMapper;
    }

    public XbjQryOrderConstrDetailRspBO selectConstrInspectionDetail(XbjQryOrderConstrDetailReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65bd\u5de5\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\uff0c\u5165\u53c2constrCompleteOrderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.isDebugEnabled.booleanValue()) {
            log.debug("\u5386\u53f2\u65bd\u5de5\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1  -> \u5165\u53c2BO:" + reqBO.toString());
        }
        XbjQryOrderConstrDetailRspBO rspBo = new XbjQryOrderConstrDetailRspBO();
        OrderConstrCompleteItemXbjPO orderConstrItemPO = new OrderConstrCompleteItemXbjPO();
        try {
            Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
            if (!StringUtils.isEmpty((CharSequence)reqBO.getConstrCompleteOrderId())) {
                ArrayList<XbjAccessoryBO> accessoryBOList = new ArrayList<XbjAccessoryBO>();
                OrderConstrCompleteXbjPO orderConstr = this.orderConstrXbjMapper.getModelById(Long.valueOf(reqBO.getConstrCompleteOrderId()));
                if (orderConstr != null) {
                    orderConstrItemPO.setConstrCompleteOrderId(orderConstr.getConstrCompleteOrderId());
                    BeanUtils.copyProperties((Object)rspBo, (Object)orderConstr);
                    rspBo.setOpenDateStr(DateUtil.dateToStrLong(orderConstr.getOpenDate()));
                    rspBo.setConstrCompleteOrderId(String.valueOf(orderConstr.getConstrCompleteOrderId()));
                    AccessoryXbjPO accessoryPO = new AccessoryXbjPO();
                    accessoryPO.setObjectId((long)orderConstr.getSaleOrderId());
                    List<AccessoryXbjPO> accessoryPOList = this.accessoryXbjMapper.getList(accessoryPO);
                    if (accessoryPOList != null) {
                        for (AccessoryXbjPO accessory : accessoryPOList) {
                            XbjAccessoryBO accessoryBO = new XbjAccessoryBO();
                            BeanUtils.copyProperties((Object)accessoryBO, (Object)accessory);
                            accessoryBOList.add(accessoryBO);
                        }
                        rspBo.setDownLoadFiles(accessoryBOList);
                    }
                }
            } else if (reqBO.getPurchaseOrderId() != null || reqBO.getSaleOrderId() != null) {
                Serializable po;
                if (reqBO.getSaleOrderId() != null) {
                    po = this.orderSaleXbjMapper.getModelById(reqBO.getSaleOrderId());
                    if (po == null) {
                        throw new BusinessException("RSP_CODE_SALSE_ORDER_NOT_EXIST", "\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728");
                    }
                    orderConstrItemPO.setSaleOrderId(reqBO.getSaleOrderId());
                }
                if (reqBO.getPurchaseOrderId() != null) {
                    po = this.orderPurchaseXbjMapper.getModelById(reqBO.getPurchaseOrderId());
                    if (po == null) {
                        throw new BusinessException("RSP_CODE_SALSE_ORDER_NOT_EXIST", "\u91c7\u8d2d\u8ba2\u5355\u4e0d\u5b58\u5728");
                    }
                    orderConstrItemPO.setPurchaseOrderId(reqBO.getPurchaseOrderId());
                }
            } else {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u65bd\u5de5\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\uff0c\u5165\u53c2constrCompleteOrderId saleOrderId purchaseId \u5fc5\u4f20\u5176\u4e00");
            }
            ArrayList<CompleteItemRspBO> completeItemRspBOList = new ArrayList<CompleteItemRspBO>();
            List<OrderConstrCompleteItemXbjPO> constrItemList = this.orderConstrItemXbjMapper.getListPage(orderConstrItemPO, (Page<OrderConstrCompleteItemXbjPO>)page, "");
            if (constrItemList != null) {
                for (OrderConstrCompleteItemXbjPO constrItemXbjPO : constrItemList) {
                    CompleteItemRspBO completeItemRspBO = new CompleteItemRspBO();
                    BeanUtils.copyProperties((Object)completeItemRspBO, (Object)constrItemXbjPO);
                    completeItemRspBO.setOnceCompleteCount(constrItemXbjPO.getOnceCompleteCount());
                    completeItemRspBO.setOpenDate(DateUtil.dateToStrLong(constrItemXbjPO.getOpenDate()));
                    completeItemRspBO.setFinishDate(DateUtil.dateToStrLong(constrItemXbjPO.getFinishDate()));
                    completeItemRspBO.setSellingPrice(MoneyUtil.Long2BigDecimal((Long)constrItemXbjPO.getSellingPrice()));
                    completeItemRspBO.setConstrCompleteOrderId(constrItemXbjPO.getConstrCompleteOrderId() + "");
                    completeItemRspBO.setOpenOrderNo(constrItemXbjPO.getOpenOrderNo());
                    completeItemRspBOList.add(completeItemRspBO);
                }
            }
            rspBo.setRows(completeItemRspBOList);
            rspBo.setRecordsTotal(page.getTotalCount());
            rspBo.setTotal(page.getTotalPages());
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u5386\u53f2\u65bd\u5de5\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5b8c\u6210\uff01");
        }
        catch (Exception e) {
            log.error("\u65bd\u5de5\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u65bd\u5de5\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38");
        }
        if (this.isDebugEnabled.booleanValue()) {
            log.debug("\u5386\u53f2\u65bd\u5de5\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1  -> \u51fa\u53c2BO:" + rspBo.toString());
        }
        return rspBo;
    }
}

