/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.cgd.common.bo.RspPageBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.feature.orm.mybatis.Page;
import com.cgd.order.busi.XbjQryOrderServDetailBusiService;
import com.cgd.order.busi.bo.CompleteItemRspBO;
import com.cgd.order.busi.bo.XbjQryOrderServDetailReqBO;
import com.cgd.order.busi.bo.XbjQryOrderServDetailRspBO;
import com.cgd.order.dao.AccessoryXbjMapper;
import com.cgd.order.dao.OrderServCompleteItemXbjMapper;
import com.cgd.order.dao.OrderServCompleteXbjMapper;
import com.cgd.order.intfce.bo.XbjAccessoryBO;
import com.cgd.order.po.AccessoryXbjPO;
import com.cgd.order.po.OrderServCompleteItemXbjPO;
import com.cgd.order.po.OrderServCompleteXbjPO;
import com.cgd.order.util.DateUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XbjQryOrderServDetailBusiServiceImpl
implements XbjQryOrderServDetailBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjQryOrderServDetailBusiService.class);
    private final Boolean isDebugEnabled = log.isDebugEnabled();
    private OrderServCompleteXbjMapper orderServXbjMapper;
    private OrderServCompleteItemXbjMapper orderServItemXbjMapper;
    private AccessoryXbjMapper accessoryXbjMapper;

    public void setOrderServXbjMapper(OrderServCompleteXbjMapper orderServXbjMapper) {
        this.orderServXbjMapper = orderServXbjMapper;
    }

    public void setOrderServItemXbjMapper(OrderServCompleteItemXbjMapper orderServItemXbjMapper) {
        this.orderServItemXbjMapper = orderServItemXbjMapper;
    }

    public void setAccessoryXbjMapper(AccessoryXbjMapper accessoryXbjMapper) {
        this.accessoryXbjMapper = accessoryXbjMapper;
    }

    public XbjQryOrderServDetailRspBO selectServInspectionDetail(XbjQryOrderServDetailReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u670d\u52a1\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\uff0c\u5165\u53c2servCompleteOrderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.isDebugEnabled.booleanValue()) {
            log.debug("\u5386\u53f2\u670d\u52a1\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1  -> \u5165\u53c2BO:" + reqBO.toString());
        }
        XbjQryOrderServDetailRspBO rspBo = new XbjQryOrderServDetailRspBO();
        try {
            Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
            RspPageBO servItemPage = new RspPageBO();
            ArrayList<CompleteItemRspBO> completeItemRspBOList = new ArrayList<CompleteItemRspBO>();
            OrderServCompleteItemXbjPO orderServItemPO = new OrderServCompleteItemXbjPO();
            if (!StringUtils.isEmpty((CharSequence)reqBO.getServCompleteOrderId())) {
                ArrayList<XbjAccessoryBO> accessoryBOList = new ArrayList<XbjAccessoryBO>();
                OrderServCompleteXbjPO orderServ = this.orderServXbjMapper.getModelById(Long.valueOf(reqBO.getServCompleteOrderId()));
                if (orderServ != null) {
                    orderServItemPO.setServCompleteOrderId(orderServ.getServCompleteOrderId());
                    rspBo.setOpenDateStr(DateUtil.dateToStrLong(orderServ.getOpenDate()));
                    rspBo.setServCompleteOrderId(String.valueOf(orderServ.getServCompleteOrderId()));
                    rspBo.setOpenOrderNo(orderServ.getOpenOrderNo());
                    rspBo.setServRelaName(orderServ.getConstrRelaName());
                    rspBo.setServRelaPhone(orderServ.getConstrRelaPhone());
                    AccessoryXbjPO accessoryPO = new AccessoryXbjPO();
                    accessoryPO.setObjectId((long)orderServ.getSaleOrderId());
                    List<AccessoryXbjPO> accessoryPOList = this.accessoryXbjMapper.getList(accessoryPO);
                    if (accessoryPOList != null) {
                        for (AccessoryXbjPO accessory : accessoryPOList) {
                            XbjAccessoryBO accessoryBO = new XbjAccessoryBO();
                            BeanUtils.copyProperties((Object)accessoryBO, (Object)accessory);
                            accessoryBOList.add(accessoryBO);
                        }
                        rspBo.setDownLoadFiles(accessoryBOList);
                    }
                }
            } else if (reqBO.getPurchaseOrderId() != null || reqBO.getSaleOrderId() != null) {
                if (reqBO.getSaleOrderId() != null) {
                    orderServItemPO.setSaleOrderId(reqBO.getSaleOrderId());
                }
                if (reqBO.getPurchaseOrderId() != null) {
                    orderServItemPO.setPurchaseOrderId(reqBO.getPurchaseOrderId());
                }
            } else {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u670d\u52a1\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\uff0c\u5165\u53c2servCompleteOrderId saleOrderId purchaseId \u5fc5\u4f20\u5176\u4e00");
            }
            List<OrderServCompleteItemXbjPO> servItemList = this.orderServItemXbjMapper.getListPage(orderServItemPO, (Page<OrderServCompleteItemXbjPO>)page, "");
            if (servItemList != null) {
                for (OrderServCompleteItemXbjPO servItemXbjPO : servItemList) {
                    CompleteItemRspBO completeItemRspBO = new CompleteItemRspBO();
                    BeanUtils.copyProperties((Object)completeItemRspBO, (Object)servItemXbjPO);
                    completeItemRspBO.setOpenDate(DateUtil.dateToStrLong(servItemXbjPO.getOpenDate()));
                    completeItemRspBO.setFinishDate(DateUtil.dateToStrLong(servItemXbjPO.getFinishDate()));
                    completeItemRspBO.setOnceCompleteCount(servItemXbjPO.getOnceCompleteCount());
                    completeItemRspBO.setSellingPrice(MoneyUtil.Long2BigDecimal((Long)servItemXbjPO.getSellingPrice()));
                    completeItemRspBO.setOpenOrderNo(servItemXbjPO.getOpenOrderNo());
                    completeItemRspBOList.add(completeItemRspBO);
                }
            }
            rspBo.setRecordsTotal(page.getTotalCount());
            rspBo.setTotal(page.getTotalPages());
            rspBo.setRows(completeItemRspBOList);
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u5386\u53f2\u670d\u52a1\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5b8c\u6210\uff01");
        }
        catch (Exception e) {
            log.error("\u670d\u52a1\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u670d\u52a1\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38");
        }
        if (this.isDebugEnabled.booleanValue()) {
            log.debug("\u5386\u53f2\u670d\u52a1\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1  -> \u51fa\u53c2BO:" + rspBo.toString());
        }
        return rspBo;
    }
}

