/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.DateUtil;
import com.cgd.common.util.MoneyUtil;
import com.cgd.feature.orm.mybatis.Page;
import com.cgd.order.busi.XbjQryOrderShipDetailBusiService;
import com.cgd.order.busi.bo.OrderShipDetailItemBO;
import com.cgd.order.busi.bo.XbjQryOrderShipDetailReqBO;
import com.cgd.order.busi.bo.XbjQryOrderShipDetailRspBO;
import com.cgd.order.busi.bo.XbjQuerySaleOrderItemRspBO;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.AccessoryXbjMapper;
import com.cgd.order.dao.OrderPurchaseItemXbjMapper;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.OrderReceiveItemXbjMapper;
import com.cgd.order.dao.OrderSaleItemXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.dao.OrderShipItemXbjMapper;
import com.cgd.order.dao.OrderShipXbjMapper;
import com.cgd.order.intfce.bo.XbjAccessoryBO;
import com.cgd.order.po.AccessoryXbjPO;
import com.cgd.order.po.OrderPurchaseItemXbjPO;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.po.OrderReceiveItemXbjPO;
import com.cgd.order.po.OrderSaleItemXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import com.cgd.order.po.OrderShipXbjPO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class XbjQryOrderShipDetailBusiServiceImpl
implements XbjQryOrderShipDetailBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjQryOrderShipDetailBusiService.class);
    private final Boolean isDebugEnabled = log.isDebugEnabled();
    private OrderShipXbjMapper orderShipXbjMapper;
    private OrderShipItemXbjMapper orderShipItemXbjMapper;
    private AccessoryXbjMapper accessoryXbjMapper;
    @Autowired
    private OrderSaleXbjMapper orderSaleXbjMapper;
    @Autowired
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;
    @Autowired
    private OrderPurchaseItemXbjMapper orderPurchaseItemXbjMapper;
    @Autowired
    private OrderSaleItemXbjMapper orderSaleItemXbjMapper;
    @Autowired
    private OrderReceiveItemXbjMapper orderReceiveItemXbjMapper;

    public void setOrderShipXbjMapper(OrderShipXbjMapper orderShipXbjMapper) {
        this.orderShipXbjMapper = orderShipXbjMapper;
    }

    public void setOrderShipItemXbjMapper(OrderShipItemXbjMapper orderShipItemXbjMapper) {
        this.orderShipItemXbjMapper = orderShipItemXbjMapper;
    }

    public void setAccessoryXbjMapper(AccessoryXbjMapper accessoryXbjMapper) {
        this.accessoryXbjMapper = accessoryXbjMapper;
    }

    public XbjQryOrderShipDetailRspBO selectInspection(XbjQryOrderShipDetailReqBO reqBO) {
        if (reqBO == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u53d1\u8d27\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\uff0c\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.isDebugEnabled.booleanValue()) {
            log.debug("\u5386\u53f2\u53d1\u8d27\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1  -> \u5165\u53c2BO:" + reqBO.toString());
        }
        XbjQryOrderShipDetailRspBO rspBo = new XbjQryOrderShipDetailRspBO();
        try {
            OrderShipXbjPO orderShipXbjPO = new OrderShipXbjPO();
            if (StringUtils.isNotBlank((CharSequence)reqBO.getShipOrderId())) {
                OrderShipXbjPO orderShip = this.orderShipXbjMapper.getModelById(Long.valueOf(reqBO.getShipOrderId()));
                if (orderShip != null) {
                    BeanUtils.copyProperties((Object)rspBo, (Object)orderShip);
                    rspBo.setShipOrderId(String.valueOf(orderShip.getShipOrderId()));
                    rspBo.setShipDate(DateUtil.dateToStrLong((Date)orderShip.getShipDate()));
                    rspBo.setArriveDate(DateUtil.dateToStrLong((Date)orderShip.getArriveTime()));
                    ArrayList<XbjAccessoryBO> accessoryBOList = new ArrayList<XbjAccessoryBO>();
                    AccessoryXbjPO accessoryPO = new AccessoryXbjPO();
                    accessoryPO.setObjectId(orderShip.getShipOrderId());
                    List<AccessoryXbjPO> accessoryPOList = this.accessoryXbjMapper.getList(accessoryPO);
                    if (accessoryPOList != null) {
                        for (AccessoryXbjPO accessoryXbjPO : accessoryPOList) {
                            XbjAccessoryBO accessoryBO = new XbjAccessoryBO();
                            BeanUtils.copyProperties((Object)accessoryBO, (Object)accessoryXbjPO);
                            accessoryBOList.add(accessoryBO);
                        }
                        rspBo.setDownLoadFiles(accessoryBOList);
                    }
                }
                orderShipXbjPO.setShipOrderId(Long.valueOf(reqBO.getShipOrderId()));
            } else if (StringUtils.isNotBlank((CharSequence)reqBO.getPurchaseOrderId()) || StringUtils.isNotBlank((CharSequence)reqBO.getSaleOrderId())) {
                BigDecimal maxAcceptanceCount;
                XbjQuerySaleOrderItemRspBO rspBO;
                BigDecimal acceptanceCount;
                List<OrderReceiveItemXbjPO> OrderReceiveItemList;
                OrderReceiveItemXbjPO orderReciveItemCondition;
                ArrayList<XbjQuerySaleOrderItemRspBO> rspList;
                Serializable condition;
                if (StringUtils.isNotBlank((CharSequence)reqBO.getPurchaseOrderId())) {
                    orderShipXbjPO.setPurchaseOrderId(Long.valueOf(reqBO.getPurchaseOrderId()));
                    OrderPurchaseXbjPO orderPurchaseXbjPO = this.orderPurchaseXbjMapper.getModelById(Long.valueOf(reqBO.getPurchaseOrderId()));
                    if (orderPurchaseXbjPO == null) {
                        rspBo.setRespCode("8888");
                        rspBo.setRespDesc("\u65e0\u5bf9\u5e94\u9500\u552e\u8ba2\u5355\uff01");
                    }
                    condition = new OrderPurchaseItemXbjPO();
                    ((OrderPurchaseItemXbjPO)condition).setPurchaseOrderId(Long.valueOf(reqBO.getPurchaseOrderId()));
                    List<OrderPurchaseItemXbjPO> orderPurchaseItemList = this.orderPurchaseItemXbjMapper.getList((OrderPurchaseItemXbjPO)condition);
                    rspList = new ArrayList<XbjQuerySaleOrderItemRspBO>();
                    for (OrderPurchaseItemXbjPO orderPurchaseItemXbjPO : orderPurchaseItemList) {
                        orderReciveItemCondition = new OrderReceiveItemXbjPO();
                        orderReciveItemCondition.setPurchaseOrderItemId(orderPurchaseItemXbjPO.getPurchaseOrderItemId());
                        OrderReceiveItemList = this.orderReceiveItemXbjMapper.getList(orderReciveItemCondition);
                        acceptanceCount = BigDecimal.valueOf(0L);
                        for (OrderReceiveItemXbjPO itemPO : OrderReceiveItemList) {
                            acceptanceCount = acceptanceCount.add(itemPO.getPurchaseCount());
                        }
                        rspBO = new XbjQuerySaleOrderItemRspBO();
                        BeanUtils.copyProperties((Object)rspBo, (Object)orderPurchaseItemXbjPO);
                        rspBO.setAcceptanceCount(acceptanceCount);
                        if (orderPurchaseXbjPO.getOrderType() == XbjOrderConstants.SALE_ORDER_TYPE.SINGLE) {
                            maxAcceptanceCount = orderPurchaseItemXbjPO.getPurchaseCount().multiply(BigDecimal.valueOf(1.2));
                            rspBO.setResidualAcceptanceCount(maxAcceptanceCount.subtract(acceptanceCount));
                        } else {
                            rspBO.setResidualAcceptanceCount(orderPurchaseItemXbjPO.getPurchaseCount().subtract(acceptanceCount));
                        }
                        rspList.add(rspBO);
                    }
                    rspBo.setSaleOrderItemRspBOS(rspList);
                }
                if (StringUtils.isNotBlank((CharSequence)reqBO.getSaleOrderId())) {
                    orderShipXbjPO.setSaleOrderId(Long.valueOf(reqBO.getSaleOrderId()));
                    OrderSaleXbjPO orderSaleXbjPO = this.orderSaleXbjMapper.getModelById(Long.valueOf(reqBO.getSaleOrderId()));
                    if (orderSaleXbjPO == null) {
                        rspBo.setRespCode("8888");
                        rspBo.setRespDesc("\u65e0\u5bf9\u5e94\u9500\u552e\u8ba2\u5355\uff01");
                    }
                    condition = new OrderSaleItemXbjPO();
                    ((OrderSaleItemXbjPO)condition).setSaleOrderId(Long.valueOf(reqBO.getSaleOrderId()));
                    List<OrderSaleItemXbjPO> orderSaleItemList = this.orderSaleItemXbjMapper.getList((OrderSaleItemXbjPO)condition);
                    rspList = new ArrayList();
                    for (OrderSaleItemXbjPO orderSaleItemXbjPO : orderSaleItemList) {
                        orderReciveItemCondition = new OrderReceiveItemXbjPO();
                        orderReciveItemCondition.setSaleOrderItemId(orderSaleItemXbjPO.getSaleOrderItemId());
                        OrderReceiveItemList = this.orderReceiveItemXbjMapper.getList(orderReciveItemCondition);
                        acceptanceCount = BigDecimal.valueOf(0L);
                        for (OrderReceiveItemXbjPO itemPO : OrderReceiveItemList) {
                            acceptanceCount = acceptanceCount.add(itemPO.getPurchaseCount());
                        }
                        rspBO = new XbjQuerySaleOrderItemRspBO();
                        BeanUtils.copyProperties((Object)rspBo, (Object)orderSaleItemXbjPO);
                        rspBO.setAcceptanceCount(acceptanceCount);
                        if (orderSaleXbjPO.getOrderType() == XbjOrderConstants.SALE_ORDER_TYPE.SINGLE) {
                            maxAcceptanceCount = orderSaleItemXbjPO.getPurchaseCount().multiply(BigDecimal.valueOf(1.2));
                            rspBO.setResidualAcceptanceCount(maxAcceptanceCount.subtract(acceptanceCount));
                        } else {
                            rspBO.setResidualAcceptanceCount(orderSaleItemXbjPO.getPurchaseCount().subtract(acceptanceCount));
                        }
                        rspList.add(rspBO);
                    }
                    rspBo.setSaleOrderItemRspBOS(rspList);
                }
            } else {
                throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u53d1\u8d27\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\uff0c\u5165\u53c2shipOrderId saleOrderId purchaseId \u5fc5\u4f20\u5176\u4e00");
            }
            Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
            rspBo.setRows(new ArrayList());
            List<OrderShipDetailItemBO> rspList = this.orderShipXbjMapper.selectOrderShipDetailPage(orderShipXbjPO, (Page<OrderShipXbjPO>)page);
            if (rspList != null) {
                for (OrderShipDetailItemBO shipItemRspBO : rspList) {
                    if (shipItemRspBO.getSellingPrice() != null) {
                        shipItemRspBO.setSellingPrice(MoneyUtil.Long2BigDecimal((Long)shipItemRspBO.getSellingPrice().longValue()));
                    }
                    if (shipItemRspBO.getPurchasingPrice() != null) {
                        shipItemRspBO.setPurchasingPrice(MoneyUtil.Long2BigDecimal((Long)shipItemRspBO.getPurchasingPrice().longValue()));
                    }
                    if (shipItemRspBO.getArriveTime() != null) {
                        shipItemRspBO.setArriveDate(DateUtil.dateToStrLong((Date)shipItemRspBO.getArriveTime()));
                    }
                    if (shipItemRspBO.getShipTime() == null) continue;
                    shipItemRspBO.setShipDate(DateUtil.dateToStrLong((Date)shipItemRspBO.getShipTime()));
                }
                rspBo.setRows(rspList);
            }
            rspBo.setRecordsTotal(page.getTotalCount());
            rspBo.setTotal(page.getTotalPages());
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u5386\u53f2\u53d1\u8d27\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5b8c\u6210\uff01");
        }
        catch (Exception e) {
            log.error("\u53d1\u8d27\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u53d1\u8d27\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38");
        }
        if (this.isDebugEnabled.booleanValue()) {
            log.debug("\u5386\u53f2\u53d1\u8d27\u5355\u660e\u7ec6\u67e5\u8be2\u4e1a\u52a1\u670d\u52a1  -> \u51fa\u53c2BO:" + rspBo.toString());
        }
        return rspBo;
    }
}

