/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.manage.dic.dict.service.DicDictionaryService;
import com.cgd.order.busi.XbjQuerySaleOrderInfoBusiService;
import com.cgd.order.busi.bo.InfoAddressRspBO;
import com.cgd.order.busi.bo.XbjOrderDealNoticeItemReqBO;
import com.cgd.order.busi.bo.XbjOrderProtocolItemReqBO;
import com.cgd.order.busi.bo.XbjQuerySaleOrderInfoReqBO;
import com.cgd.order.busi.bo.XbjQuerySaleOrderInfoRspBO;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.InfoAddressXbjMapper;
import com.cgd.order.dao.OrderDealNoticeItemMapper;
import com.cgd.order.dao.OrderProtocolItemXbjMapper;
import com.cgd.order.dao.OrderPurchaseXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.po.InfoAddressXbjPO;
import com.cgd.order.po.OrderDealNoticeItemXbjPO;
import com.cgd.order.po.OrderProtocolItemXbjPO;
import com.cgd.order.po.OrderPurchaseXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class XbjQuerySaleOrderInfoBusiServiceImpl
implements XbjQuerySaleOrderInfoBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjQuerySaleOrderInfoBusiServiceImpl.class);
    private final Boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private OrderSaleXbjMapper orderSaleXbjMapper;
    @Autowired
    private OrderPurchaseXbjMapper orderPurchaseXbjMapper;
    @Autowired
    private OrderProtocolItemXbjMapper orderProtocolItemXbjMapper;
    @Autowired
    private OrderDealNoticeItemMapper orderDealNoticeItemMapper;
    @Autowired
    private DicDictionaryService dicDictionaryService;
    @Autowired
    private InfoAddressXbjMapper infoAddressXbjMapper;

    public XbjQuerySaleOrderInfoRspBO querySaleOrderInfo(XbjQuerySaleOrderInfoReqBO xbjQuerySaleOrderInfoReqBO) {
        this.validateArg(xbjQuerySaleOrderInfoReqBO);
        XbjQuerySaleOrderInfoRspBO xbjQuerySaleOrderInfoRspBO = new XbjQuerySaleOrderInfoRspBO();
        try {
            Long purchaserId = 0L;
            if (xbjQuerySaleOrderInfoReqBO.getPurchaserId() != null) {
                purchaserId = Long.valueOf(xbjQuerySaleOrderInfoReqBO.getPurchaserId());
            }
            if (xbjQuerySaleOrderInfoReqBO.getSaleOrderId() != null && !xbjQuerySaleOrderInfoReqBO.getSaleOrderId().equals("")) {
                Long saleOrderId = Long.valueOf(xbjQuerySaleOrderInfoReqBO.getSaleOrderId());
                this.getSaleOrderInfo(saleOrderId, xbjQuerySaleOrderInfoRspBO, purchaserId);
                xbjQuerySaleOrderInfoRspBO.setRespCode("0000");
                xbjQuerySaleOrderInfoRspBO.setRespDesc("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u8be6\u60c5\u6210\u529f");
            } else if (xbjQuerySaleOrderInfoReqBO.getPurchaseOrderId() != null && !xbjQuerySaleOrderInfoReqBO.getPurchaseOrderId().equals("")) {
                Long purchaseOrderId = Long.valueOf(xbjQuerySaleOrderInfoReqBO.getPurchaseOrderId());
                this.getPurchaseOrderInfo(purchaseOrderId, xbjQuerySaleOrderInfoRspBO, purchaserId);
                xbjQuerySaleOrderInfoRspBO.setRespCode("0000");
                xbjQuerySaleOrderInfoRspBO.setRespDesc("\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355\u8be6\u60c5\u6210\u529f");
            } else {
                xbjQuerySaleOrderInfoRspBO.setRespCode("8888");
                xbjQuerySaleOrderInfoRspBO.setRespDesc("\u65e0\u6548\u5165\u53c2");
                return xbjQuerySaleOrderInfoRspBO;
            }
            this.setOrderDispatchName(xbjQuerySaleOrderInfoRspBO);
            this.setOrderResorces(xbjQuerySaleOrderInfoRspBO);
            if (this.isDebugEnabled.booleanValue()) {
                log.debug("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u8be6\u60c5========================================");
            }
        }
        catch (Exception e) {
            xbjQuerySaleOrderInfoRspBO.setRespCode("8888");
            xbjQuerySaleOrderInfoRspBO.setRespDesc("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u8be6\u60c5\u5f02\u5e38");
            log.error("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u8be6\u60c5\u5f02\u5e38:" + e);
        }
        return xbjQuerySaleOrderInfoRspBO;
    }

    private XbjQuerySaleOrderInfoRspBO getSaleOrderInfo(Long saleOrderId, XbjQuerySaleOrderInfoRspBO xbjQuerySaleOrderInfoRspBO, Long purchaserId) throws Exception {
        InfoAddressRspBO qryInfoAddress;
        Map valueByCode;
        String giveTime;
        Map valueByCode2;
        String payType;
        Map valueByCode3;
        OrderPurchaseXbjPO orderPurchasePo;
        OrderSaleXbjPO xbjOrderSale = this.orderSaleXbjMapper.getModelById(saleOrderId);
        if (xbjOrderSale == null) {
            xbjQuerySaleOrderInfoRspBO.setRespCode("8888");
            xbjQuerySaleOrderInfoRspBO.setRespDesc("\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728");
            return xbjQuerySaleOrderInfoRspBO;
        }
        BeanUtils.copyProperties((Object)xbjOrderSale, (Object)xbjQuerySaleOrderInfoRspBO);
        xbjQuerySaleOrderInfoRspBO.setSaleOrderId(xbjOrderSale.getSaleOrderId().toString());
        xbjQuerySaleOrderInfoRspBO.setPurchaserPersonName(xbjOrderSale.getPurchaserAccountName());
        xbjQuerySaleOrderInfoRspBO.setPurchaserPersonCellphone(xbjOrderSale.getPurchaserMobile());
        xbjQuerySaleOrderInfoRspBO.setSupplierName(xbjOrderSale.getGoodsSupplierName());
        xbjQuerySaleOrderInfoRspBO.setSupplierManName(xbjOrderSale.getGoodsSupplierRelaman());
        xbjQuerySaleOrderInfoRspBO.setSupplierManPhone(xbjOrderSale.getGoodsSupplierMobile());
        xbjQuerySaleOrderInfoRspBO.setProfessionalOrganizationId(String.valueOf(xbjOrderSale.getProfessionalOrganizationId()));
        xbjQuerySaleOrderInfoRspBO.setProfessionalAccount(String.valueOf(xbjOrderSale.getProfessionalAccount()));
        xbjQuerySaleOrderInfoRspBO.setSaleOrderStatus(xbjOrderSale.getSaleOrderStatus() + "");
        if (xbjOrderSale.getSaleOrderMoney() != null) {
            xbjQuerySaleOrderInfoRspBO.setSaleOrderMoney(MoneyUtil.Long2BigDecimal((Long)xbjOrderSale.getSaleOrderMoney()));
        }
        if ((orderPurchasePo = this.orderPurchaseXbjMapper.getModelById(xbjOrderSale.getPurchaseOrderId())).getPurchaseOrderMoney() != null) {
            xbjQuerySaleOrderInfoRspBO.setPurchaserOrderMoney(MoneyUtil.Long2BigDecimal((Long)orderPurchasePo.getPurchaseOrderMoney()));
        }
        this.getEnterpriseAndSupplierPayType(xbjQuerySaleOrderInfoRspBO);
        String saleOrderStatus = "" + xbjQuerySaleOrderInfoRspBO.getSaleOrderStatus();
        if (saleOrderStatus != null && !"".equals(saleOrderStatus) && (valueByCode3 = this.dicDictionaryService.getValueByCode("ORDER_STATUS")) != null) {
            String saleOrderStatusStr = (String)valueByCode3.get(saleOrderStatus);
            xbjQuerySaleOrderInfoRspBO.setSaleOrderStatus(saleOrderStatusStr);
        }
        if ((payType = xbjQuerySaleOrderInfoRspBO.getPayType()) != null && !"".equals(payType) && (valueByCode2 = this.dicDictionaryService.getValueByCode("PAY_TYPE")) != null) {
            String payTypeString = (String)valueByCode2.get(payType);
            xbjQuerySaleOrderInfoRspBO.setPayType(payTypeString);
        }
        if ((giveTime = xbjQuerySaleOrderInfoRspBO.getGiveTime()) != null && !"".equals(giveTime) && (valueByCode = this.dicDictionaryService.getValueByCode("GIVE_TIME")) != null) {
            String giveTimeString = (String)valueByCode.get(giveTime);
            xbjQuerySaleOrderInfoRspBO.setGiveTime(giveTimeString);
        }
        if ((qryInfoAddress = this.qryInfoAddress(saleOrderId, xbjOrderSale.getPurchaserId())) != null) {
            xbjQuerySaleOrderInfoRspBO.setReceiverName(qryInfoAddress.getReceiverName());
            xbjQuerySaleOrderInfoRspBO.setReceiverMobileNumber(qryInfoAddress.getReceiverMobileNumber());
            String fullAddress = qryInfoAddress.getAddress();
            xbjQuerySaleOrderInfoRspBO.setFullReceiveAddress(fullAddress);
        }
        Integer saleOrderType = xbjOrderSale.getSaleOrderType();
        this.getProtocolInfo(xbjQuerySaleOrderInfoRspBO, saleOrderType, xbjOrderSale.getSaleOrderId());
        if (!xbjQuerySaleOrderInfoRspBO.getRespCode().equals("0000")) {
            return xbjQuerySaleOrderInfoRspBO;
        }
        return xbjQuerySaleOrderInfoRspBO;
    }

    private XbjQuerySaleOrderInfoRspBO getPurchaseOrderInfo(Long purchaseOrderId, XbjQuerySaleOrderInfoRspBO xbjQuerySaleOrderInfoRspBO, Long purchaserId) throws Exception {
        InfoAddressRspBO qryInfoAddress;
        Map valueByCode;
        String giveTime;
        Map valueByCode2;
        String payType;
        OrderSaleXbjPO xbjOrderSale;
        OrderPurchaseXbjPO orderPurchasePo = this.orderPurchaseXbjMapper.getModelById(purchaseOrderId);
        if (orderPurchasePo == null) {
            xbjQuerySaleOrderInfoRspBO.setRespCode("8888");
            xbjQuerySaleOrderInfoRspBO.setRespDesc("\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728");
            return xbjQuerySaleOrderInfoRspBO;
        }
        BeanUtils.copyProperties((Object)orderPurchasePo, (Object)xbjQuerySaleOrderInfoRspBO);
        xbjQuerySaleOrderInfoRspBO.setSaleOrderId(orderPurchasePo.getSaleOrderId().toString());
        xbjQuerySaleOrderInfoRspBO.setPurchaserPersonName(orderPurchasePo.getPurchaserAccountName());
        xbjQuerySaleOrderInfoRspBO.setPurchaserPersonCellphone(orderPurchasePo.getPurchaserMobile());
        xbjQuerySaleOrderInfoRspBO.setSupplierName(orderPurchasePo.getGoodsSupplierName());
        xbjQuerySaleOrderInfoRspBO.setSupplierManName(orderPurchasePo.getGoodsSupplierRelaman());
        xbjQuerySaleOrderInfoRspBO.setSupplierManPhone(orderPurchasePo.getGoodsSupplierMobile());
        xbjQuerySaleOrderInfoRspBO.setProfessionalOrganizationId(String.valueOf(orderPurchasePo.getProfessionalOrganizationId()));
        xbjQuerySaleOrderInfoRspBO.setProfessionalAccount(String.valueOf(orderPurchasePo.getProfessionalAccount()));
        xbjQuerySaleOrderInfoRspBO.setPurchaseOrderStatus(orderPurchasePo.getPurchaseOrderStatus() + "");
        if (orderPurchasePo.getPurchaseOrderMoney() != null) {
            xbjQuerySaleOrderInfoRspBO.setPurchaserOrderMoney(MoneyUtil.Long2BigDecimal((Long)orderPurchasePo.getPurchaseOrderMoney()));
        }
        if ((xbjOrderSale = this.orderSaleXbjMapper.getModelById(orderPurchasePo.getSaleOrderId())).getSaleOrderMoney() != null) {
            xbjQuerySaleOrderInfoRspBO.setSaleOrderMoney(MoneyUtil.Long2BigDecimal((Long)xbjOrderSale.getSaleOrderId()));
        }
        this.getEnterpriseAndSupplierPayType(xbjQuerySaleOrderInfoRspBO);
        Map orderStatusCode = this.dicDictionaryService.getValueByCode("ORDER_STATUS");
        if (orderStatusCode != null) {
            String orderStatusString = (String)orderStatusCode.get(xbjQuerySaleOrderInfoRspBO.getPurchaseOrderStatus());
            xbjQuerySaleOrderInfoRspBO.setPurchaseOrderStatus(orderStatusString);
        }
        if ((payType = orderPurchasePo.getPayType()) != null && !"".equals(payType) && (valueByCode2 = this.dicDictionaryService.getValueByCode("PAY_TYPE")) != null) {
            String payTypeString = (String)valueByCode2.get(payType);
            xbjQuerySaleOrderInfoRspBO.setPayType(payTypeString);
        }
        if ((giveTime = xbjQuerySaleOrderInfoRspBO.getGiveTime()) != null && !"".equals(giveTime) && (valueByCode = this.dicDictionaryService.getValueByCode("GIVE_TIME")) != null) {
            String giveTimeString = (String)valueByCode.get(giveTime);
            xbjQuerySaleOrderInfoRspBO.setGiveTime(giveTimeString);
        }
        if ((qryInfoAddress = this.qryInfoAddress(orderPurchasePo.getSaleOrderId(), orderPurchasePo.getPurchaserId())) != null) {
            xbjQuerySaleOrderInfoRspBO.setReceiverName(qryInfoAddress.getReceiverName());
            xbjQuerySaleOrderInfoRspBO.setReceiverMobileNumber(qryInfoAddress.getReceiverMobileNumber());
            String fullAddress = qryInfoAddress.getAddress();
            xbjQuerySaleOrderInfoRspBO.setFullReceiveAddress(fullAddress);
        }
        Integer saleOrderType = orderPurchasePo.getSaleOrderType();
        this.getProtocolInfo(xbjQuerySaleOrderInfoRspBO, saleOrderType, orderPurchasePo.getSaleOrderId());
        if (!xbjQuerySaleOrderInfoRspBO.getRespCode().equals("0000")) {
            return xbjQuerySaleOrderInfoRspBO;
        }
        return xbjQuerySaleOrderInfoRspBO;
    }

    private void setOrderDispatchName(XbjQuerySaleOrderInfoRspBO xbjQuerySaleOrderInfoRspBO) {
        if (xbjQuerySaleOrderInfoRspBO.getIsDispatch() != null) {
            if (xbjQuerySaleOrderInfoRspBO.getIsDispatch() == XbjOrderConstants.IS_DISPATCH_YES) {
                xbjQuerySaleOrderInfoRspBO.setIsDispatchName("\u662f");
            } else if (xbjQuerySaleOrderInfoRspBO.getIsDispatch() == XbjOrderConstants.IS_DISPATCH_NO) {
                xbjQuerySaleOrderInfoRspBO.setIsDispatchName("\u5426");
            }
        }
    }

    private void setOrderResorces(XbjQuerySaleOrderInfoRspBO xbjQuerySaleOrderInfoRspBO) {
        if (xbjQuerySaleOrderInfoRspBO.getSaleOrderType().equals(XbjOrderConstants.SALE_ORDER_TYPE_DLZQ)) {
            xbjQuerySaleOrderInfoRspBO.setSaleOrderTypeName("\u7535\u529b\u4e13\u533a");
        } else if (xbjQuerySaleOrderInfoRspBO.getSaleOrderType().equals(XbjOrderConstants.SALE_ORDER_TYPE_DZCS)) {
            xbjQuerySaleOrderInfoRspBO.setSaleOrderTypeName("\u7535\u529b\u8d85\u5e02");
        } else if (xbjQuerySaleOrderInfoRspBO.getSaleOrderType().equals(XbjOrderConstants.SALE_ORDER_TYPE_KJXY)) {
            xbjQuerySaleOrderInfoRspBO.setSaleOrderTypeName("\u8be2\u6bd4\u4ef7(\u6846\u67b6\u534f\u8bae)");
        } else if (xbjQuerySaleOrderInfoRspBO.getSaleOrderType().equals(XbjOrderConstants.SALE_ORDER_TYPE_XBJ)) {
            xbjQuerySaleOrderInfoRspBO.setSaleOrderTypeName("\u8be2\u6bd4\u4ef7(\u4e00\u5355\u4e00\u91c7)");
        }
    }

    private void validateArg(XbjQuerySaleOrderInfoReqBO xbjSaleOrderInfoReqBO) {
        if (xbjSaleOrderInfoReqBO == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\u8ba2\u5355\u8be6\u60c5\u67e5\u8be2\u5165\u53c2\uff1axbjSaleOrderInfoReqBO\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private XbjQuerySaleOrderInfoRspBO getProtocolInfo(XbjQuerySaleOrderInfoRspBO xbjQuerySaleOrderInfoRspBO, Integer saleOrderType, Long saleOrderId) throws Exception {
        if (saleOrderType != null) {
            Map valueByCode = this.dicDictionaryService.getValueByCode("PAY_WAY_SUP");
            if (XbjOrderConstants.SALE_ORDER_TYPE_XBJ.equals(saleOrderType)) {
                OrderDealNoticeItemXbjPO orderDealNoticeItemXbjPO = new OrderDealNoticeItemXbjPO();
                orderDealNoticeItemXbjPO.setSaleOrderId(saleOrderId);
                List<OrderDealNoticeItemXbjPO> list = this.orderDealNoticeItemMapper.getListBySaleOrderId(orderDealNoticeItemXbjPO);
                if (list == null || list.isEmpty()) {
                    xbjQuerySaleOrderInfoRspBO.setRespCode("8888");
                    xbjQuerySaleOrderInfoRspBO.setRespDesc("\u8ba2\u5355\u8be6\u60c5\u67e5\u8be2\u65f6\uff1a\u67e5\u8be2\u6210\u4ea4\u901a\u77e5\u4e66\u8868\u65e0\u8bb0\u5f55\uff01");
                    return xbjQuerySaleOrderInfoRspBO;
                }
                OrderDealNoticeItemXbjPO po1 = list.get(0);
                XbjOrderDealNoticeItemReqBO xbjOrderDealNoticeItemReqBO = new XbjOrderDealNoticeItemReqBO();
                BeanUtils.copyProperties((Object)po1, (Object)xbjOrderDealNoticeItemReqBO);
                xbjQuerySaleOrderInfoRspBO.setXbjOrderDealNoticeItemReqBO(xbjOrderDealNoticeItemReqBO);
                xbjQuerySaleOrderInfoRspBO.setAdjustFoemula(xbjOrderDealNoticeItemReqBO.getAdjustFoemula());
                xbjQuerySaleOrderInfoRspBO.setAdjustMechanism(String.valueOf(xbjOrderDealNoticeItemReqBO.getAdjustMechanism()));
                xbjQuerySaleOrderInfoRspBO.setProtocolName(xbjOrderDealNoticeItemReqBO.getDealNoticeName());
                if (valueByCode != null && po1.getPay() != null) {
                    String payWayString = (String)valueByCode.get(po1.getPay());
                    xbjQuerySaleOrderInfoRspBO.setToSupplierPayMode(payWayString);
                }
                xbjQuerySaleOrderInfoRspBO.setRespCode("0000");
                return xbjQuerySaleOrderInfoRspBO;
            }
            if (XbjOrderConstants.SALE_ORDER_TYPE_KJXY.equals(saleOrderType)) {
                OrderProtocolItemXbjPO queryBySaleOrderId = this.orderProtocolItemXbjMapper.queryBySaleOrderId(saleOrderId);
                XbjOrderProtocolItemReqBO xbjOrderProtocolItemReqBO = new XbjOrderProtocolItemReqBO();
                BeanUtils.copyProperties((Object)queryBySaleOrderId, (Object)xbjOrderProtocolItemReqBO);
                xbjQuerySaleOrderInfoRspBO.setXbjOrderProtocolItemReqBO(xbjOrderProtocolItemReqBO);
                xbjQuerySaleOrderInfoRspBO.setAdjustFoemula(xbjOrderProtocolItemReqBO.getAdjustFoemula());
                xbjQuerySaleOrderInfoRspBO.setAdjustMechanism(String.valueOf(xbjOrderProtocolItemReqBO.getAdjustMechanism()));
                xbjQuerySaleOrderInfoRspBO.setProtocolName(xbjOrderProtocolItemReqBO.getProtocolName());
                if (valueByCode != null && queryBySaleOrderId.getPayWaySup() != null) {
                    String payWayString = (String)valueByCode.get(queryBySaleOrderId.getPayWaySup());
                    xbjQuerySaleOrderInfoRspBO.setToSupplierPayMode(payWayString);
                }
                xbjQuerySaleOrderInfoRspBO.setRespCode("0000");
                return xbjQuerySaleOrderInfoRspBO;
            }
            xbjQuerySaleOrderInfoRspBO.setRespCode("8888");
            xbjQuerySaleOrderInfoRspBO.setRespDesc("\u8ba2\u5355\u6765\u6e90\uff08saleOrderType\uff09\u975e\u8be2\u6bd4\u4ef7\u7c7b\u578b\uff0c\u4e0d\u80fd\u67e5\u8be2");
            return xbjQuerySaleOrderInfoRspBO;
        }
        xbjQuerySaleOrderInfoRspBO.setRespCode("8888");
        xbjQuerySaleOrderInfoRspBO.setRespDesc("\u8ba2\u5355\u6765\u6e90\uff08saleOrderType\uff09\u4e3a\u7a7a");
        return xbjQuerySaleOrderInfoRspBO;
    }

    private InfoAddressRspBO qryInfoAddress(Long saleOrderId, Long purchaserId) {
        InfoAddressXbjPO infoAddress = this.infoAddressXbjMapper.selectBySaleOrderIdAndPurchaserId(saleOrderId, purchaserId);
        InfoAddressRspBO infoAddressRspBO = new InfoAddressRspBO();
        if (infoAddress != null) {
            BeanUtils.copyProperties((Object)infoAddress, (Object)infoAddressRspBO);
            StringBuilder builder = new StringBuilder();
            if (StringUtils.isNotBlank((CharSequence)infoAddress.getReceiverProvinceName()) && !"0".equals(infoAddress.getReceiverProvinceName())) {
                builder.append(infoAddress.getReceiverProvinceName());
                infoAddressRspBO.setReceiverProvinceName(infoAddress.getReceiverProvinceName());
            }
            if (StringUtils.isNotBlank((CharSequence)infoAddress.getReceiverCityName()) && !"0".equals(infoAddress.getReceiverCityName())) {
                builder.append(infoAddress.getReceiverCityName());
                infoAddressRspBO.setReceiverCityName(infoAddress.getReceiverCityName());
            }
            if (StringUtils.isNotBlank((CharSequence)infoAddress.getReceiverCountyName()) && !"0".equals(infoAddress.getReceiverCountyName())) {
                builder.append(infoAddress.getReceiverCountyName());
                infoAddressRspBO.setReceiverCountyName(infoAddress.getReceiverCountyName());
            }
            if (StringUtils.isNotBlank((CharSequence)infoAddress.getReceiverTown()) && !"0".equals(infoAddress.getReceiverTown())) {
                builder.append(infoAddress.getReceiverTown());
                infoAddressRspBO.setReceiverTown(infoAddress.getReceiverTown());
            }
            if (StringUtils.isNotBlank((CharSequence)infoAddress.getReceiverAddress()) && !"0".equals(infoAddress.getReceiverAddress())) {
                builder.append(infoAddress.getReceiverAddress());
            }
            infoAddressRspBO.setAddress(builder.toString());
        }
        return infoAddressRspBO;
    }

    private void getEnterpriseAndSupplierPayType(XbjQuerySaleOrderInfoRspBO xbjQuerySaleOrderInfoRspBO) {
        String payWaySup;
        String payWayEnt;
        StringBuilder builder1 = new StringBuilder();
        BigDecimal prePayEnt = xbjQuerySaleOrderInfoRspBO.getPrePayEnt();
        BigDecimal matPayEnt = xbjQuerySaleOrderInfoRspBO.getMatPayEnt();
        BigDecimal proPayEnt = xbjQuerySaleOrderInfoRspBO.getProPayEnt();
        BigDecimal verPayEnt = xbjQuerySaleOrderInfoRspBO.getVerPayEnt();
        BigDecimal pilPayEnt = xbjQuerySaleOrderInfoRspBO.getPilPayEnt();
        BigDecimal quaPayEnt = xbjQuerySaleOrderInfoRspBO.getQuaPayEnt();
        if (prePayEnt != null && BigDecimal.ZERO.compareTo(prePayEnt) != 0) {
            builder1.append("\u9884\u4ed8\u6b3e" + prePayEnt.intValue() + "%,");
        }
        if (matPayEnt != null && BigDecimal.ZERO.compareTo(matPayEnt) != 0) {
            builder1.append("\u6295\u6599\u6b3e" + matPayEnt.intValue() + "%,");
        }
        if (proPayEnt != null && BigDecimal.ZERO.compareTo(proPayEnt) != 0) {
            builder1.append("\u8fdb\u5ea6\u6b3e" + proPayEnt.intValue() + "%,");
        }
        if (verPayEnt != null && BigDecimal.ZERO.compareTo(verPayEnt) != 0) {
            builder1.append("\u5230\u8d27\u9a8c\u6536\u5408\u683c\u540e\u4ed8\u6b3e" + verPayEnt.intValue() + "%,");
        }
        if (pilPayEnt != null && BigDecimal.ZERO.compareTo(pilPayEnt) != 0) {
            builder1.append("\u8bd5\u8fd0\u884c\u9a8c\u6536\u6b3e" + pilPayEnt.intValue() + "%,");
        }
        if (quaPayEnt != null && BigDecimal.ZERO.compareTo(quaPayEnt) != 0) {
            builder1.append("\u8d28\u4fdd\u91d1" + quaPayEnt.intValue() + "%,");
        }
        if (StringUtils.isNotBlank((CharSequence)(payWayEnt = builder1.toString()))) {
            payWayEnt = payWayEnt.substring(0, payWayEnt.length() - 1);
            xbjQuerySaleOrderInfoRspBO.setPurchaserPayMode(payWayEnt);
        }
        StringBuilder builder2 = new StringBuilder();
        BigDecimal prePaySup = xbjQuerySaleOrderInfoRspBO.getPrePaySup();
        BigDecimal matPaySup = xbjQuerySaleOrderInfoRspBO.getMatPaySup();
        BigDecimal proPaySup = xbjQuerySaleOrderInfoRspBO.getProPaySup();
        BigDecimal verPaySup = xbjQuerySaleOrderInfoRspBO.getVerPaySup();
        BigDecimal pilPaySup = xbjQuerySaleOrderInfoRspBO.getPilPaySup();
        BigDecimal quaPaySup = xbjQuerySaleOrderInfoRspBO.getQuaPaySup();
        if (prePaySup != null && BigDecimal.ZERO.compareTo(prePaySup) != 0) {
            builder2.append("\u9884\u4ed8\u6b3e" + prePaySup.intValue() + "%,");
        }
        if (matPaySup != null && BigDecimal.ZERO.compareTo(matPaySup) != 0) {
            builder2.append("\u6295\u6599\u6b3e" + matPaySup.intValue() + "%,");
        }
        if (proPaySup != null && BigDecimal.ZERO.compareTo(proPaySup) != 0) {
            builder2.append("\u8fdb\u5ea6\u6b3e" + proPaySup.intValue() + "%,");
        }
        if (verPaySup != null && BigDecimal.ZERO.compareTo(verPaySup) != 0) {
            builder2.append("\u5230\u8d27\u9a8c\u6536\u5408\u683c\u540e\u4ed8\u6b3e" + verPaySup.intValue() + "%,");
        }
        if (pilPaySup != null && BigDecimal.ZERO.compareTo(pilPaySup) != 0) {
            builder2.append("\u8bd5\u8fd0\u884c\u9a8c\u6536\u6b3e" + pilPaySup.intValue() + "%,");
        }
        if (quaPaySup != null && BigDecimal.ZERO.compareTo(quaPaySup) != 0) {
            builder2.append("\u8d28\u4fdd\u91d1" + quaPaySup.intValue() + "%,");
        }
        if (StringUtils.isNotBlank((CharSequence)(payWaySup = builder2.toString()))) {
            payWaySup = payWaySup.substring(0, payWaySup.length() - 1);
            xbjQuerySaleOrderInfoRspBO.setToSupplierPayMode(payWaySup);
        }
    }
}

