/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.cgd.common.bo.RspListInfoBO;
import com.cgd.common.bo.RspPageBO;
import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.feature.orm.mybatis.Page;
import com.cgd.order.busi.XbjQuerySaleOrderItemBusiService;
import com.cgd.order.busi.bo.XbjQuerySaleOrderItemReqBO;
import com.cgd.order.busi.bo.XbjQuerySaleOrderItemRspBO;
import com.cgd.order.dao.OrderPurchaseItemXbjMapper;
import com.cgd.order.dao.OrderSaleItemXbjMapper;
import com.cgd.order.po.OrderPurchaseItemXbjPO;
import com.cgd.order.po.OrderSaleItemXbjPO;
import com.cgd.order.po.XbjQuerySaleOrderItemRspPO;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class XbjQuerySaleOrderItemBusiServiceImpl
implements XbjQuerySaleOrderItemBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjQuerySaleOrderItemBusiServiceImpl.class);
    private final Boolean isDebugEnabled = log.isDebugEnabled();
    @Autowired
    private OrderSaleItemXbjMapper orderSaleItemXbjMapper;
    @Autowired
    private OrderPurchaseItemXbjMapper orderPurchaseItemXbjMapper;

    public RspPageBO<XbjQuerySaleOrderItemRspBO> querySaleOrderItem(XbjQuerySaleOrderItemReqBO xbjQuerySaleOrderItemReqBO) {
        if (this.isDebugEnabled.booleanValue()) {
            log.debug("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u5217\u8868\u5165\u53c2:" + xbjQuerySaleOrderItemReqBO);
        }
        this.validateArg(xbjQuerySaleOrderItemReqBO);
        RspPageBO resultPage = new RspPageBO();
        LinkedList<XbjQuerySaleOrderItemRspBO> XbjQuerySaleOrderItemRspBOs = new LinkedList<XbjQuerySaleOrderItemRspBO>();
        if (xbjQuerySaleOrderItemReqBO.getSaleOrderId() != null && !xbjQuerySaleOrderItemReqBO.getSaleOrderId().equals("")) {
            try {
                Long orderId = Long.valueOf(xbjQuerySaleOrderItemReqBO.getSaleOrderId());
                List<Object> queryOrderSalItemMat = new LinkedList();
                Long purchaserId = Long.valueOf(xbjQuerySaleOrderItemReqBO.getPurchaserId());
                Page page = new Page(xbjQuerySaleOrderItemReqBO.getPageNo(), xbjQuerySaleOrderItemReqBO.getPageSize());
                queryOrderSalItemMat = this.orderSaleItemXbjMapper.queryOrderSalItemMat(orderId, purchaserId, (Page<XbjQuerySaleOrderItemRspPO>)page);
                if (queryOrderSalItemMat != null && !queryOrderSalItemMat.isEmpty()) {
                    for (OrderSaleItemXbjPO orderSaleItemXbjPO : queryOrderSalItemMat) {
                        XbjQuerySaleOrderItemRspBO xbjQuerySaleOrderItemRspBO = new XbjQuerySaleOrderItemRspBO();
                        if (orderSaleItemXbjPO == null) continue;
                        this.propertiesCopy(orderSaleItemXbjPO, xbjQuerySaleOrderItemRspBO);
                        XbjQuerySaleOrderItemRspBOs.add(xbjQuerySaleOrderItemRspBO);
                    }
                } else {
                    resultPage.setRespCode("0000");
                    resultPage.setRespDesc("\u65e0\u8be5\u9500\u552e\u8ba2\u5355\u7684\u660e\u7ec6\u4fe1\u606f");
                    return resultPage;
                }
                resultPage.setPageNo(xbjQuerySaleOrderItemReqBO.getPageNo());
                resultPage.setRecordsTotal(page.getTotalCount());
                resultPage.setTotal(page.getTotalPages());
                resultPage.setRespCode("0000");
                resultPage.setRespDesc("\u67e5\u8be2\u5206\u9875\u9500\u552e\u8ba2\u5355\u5546\u54c1\u8be6\u60c5\u6210\u529f");
                resultPage.setRows(XbjQuerySaleOrderItemRspBOs);
                return resultPage;
            }
            catch (Exception e) {
                log.debug("\u5206\u9875\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                resultPage.setRespCode("8888");
                resultPage.setRespDesc("\u67e5\u8be2\u5206\u9875\u9500\u552e\u8ba2\u5355\u5546\u54c1\u8be6\u60c5\u5931\u8d25");
                return resultPage;
            }
        }
        if (xbjQuerySaleOrderItemReqBO.getPurchaseOrderId() != null && !xbjQuerySaleOrderItemReqBO.getPurchaseOrderId().equals("")) {
            try {
                Long orderId = Long.valueOf(xbjQuerySaleOrderItemReqBO.getPurchaseOrderId());
                Long purchaserId = Long.valueOf(xbjQuerySaleOrderItemReqBO.getPurchaserId());
                List<Object> queryOrderPurchaseItemMat = new LinkedList();
                Page page = new Page(xbjQuerySaleOrderItemReqBO.getPageNo(), xbjQuerySaleOrderItemReqBO.getPageSize());
                OrderPurchaseItemXbjPO condition = new OrderPurchaseItemXbjPO();
                condition.setPurchaseOrderId(purchaserId);
                condition.setPurchaseOrderId(orderId);
                queryOrderPurchaseItemMat = this.orderPurchaseItemXbjMapper.getListPage(condition, (Page<OrderPurchaseItemXbjPO>)page, "");
                if (queryOrderPurchaseItemMat != null && !queryOrderPurchaseItemMat.isEmpty()) {
                    for (OrderPurchaseItemXbjPO orderPurchaseItemXbjPO : queryOrderPurchaseItemMat) {
                        XbjQuerySaleOrderItemRspBO bo = new XbjQuerySaleOrderItemRspBO();
                        if (orderPurchaseItemXbjPO == null) continue;
                        this.propertiesCopy(orderPurchaseItemXbjPO, bo);
                        XbjQuerySaleOrderItemRspBOs.add(bo);
                    }
                } else {
                    resultPage.setRespCode("0000");
                    resultPage.setRespDesc("\u65e0\u8be5\u9500\u552e\u8ba2\u5355\u7684\u660e\u7ec6\u4fe1\u606f");
                    return resultPage;
                }
                resultPage.setPageNo(xbjQuerySaleOrderItemReqBO.getPageNo());
                resultPage.setRecordsTotal(page.getTotalCount());
                resultPage.setTotal(page.getTotalPages());
                resultPage.setRespCode("0000");
                resultPage.setRespDesc("\u67e5\u8be2\u5206\u9875\u9500\u552e\u8ba2\u5355\u5546\u54c1\u8be6\u60c5\u6210\u529f");
                resultPage.setRows(XbjQuerySaleOrderItemRspBOs);
                return resultPage;
            }
            catch (Exception e) {
                log.debug("\u5206\u9875\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                resultPage.setRespCode("8888");
                resultPage.setRespDesc("\u67e5\u8be2\u5206\u9875\u9500\u552e\u8ba2\u5355\u5546\u54c1\u8be6\u60c5\u5931\u8d25");
                return resultPage;
            }
        }
        resultPage.setRespCode("8888");
        resultPage.setRespDesc("\u67e5\u8be2\u5206\u9875\u9500\u552e\u8ba2\u5355\u5546\u54c1\u8be6\u60c5\u5931\u8d25");
        return resultPage;
    }

    private void propertiesCopy(OrderPurchaseItemXbjPO purchasePO, XbjQuerySaleOrderItemRspBO bo) {
        try {
            BeanUtils.copyProperties((Object)purchasePO, (Object)bo);
            bo.setSaleOrderItemId(purchasePO.getSaleOrderItemId() + "");
            bo.setSaleOrderId(purchasePO.getSaleOrderId() + "");
            bo.setPurchaserId(purchasePO.getPurchaserId() + "");
            bo.setPurchaserAccountId(purchasePO.getPurchaserAccountId() + "");
            bo.setProfessionalOrganizationId(purchasePO.getProfessionalOrganizationId() + "");
            bo.setGoodsSupplierId(purchasePO.getGoodsSupplierId() + "");
            bo.setSkuId(purchasePO.getSkuId() + "");
            bo.setBrand(purchasePO.getBrand() + "");
            bo.setTotal(purchasePO.getTotal() + "");
            bo.setPlanDetailNumber(purchasePO.getPlanDetailNumber() + "");
            bo.setDeptId(purchasePO.getDeptId() + "");
            bo.setPurchaserAccountOrgId(purchasePO.getPurchaserAccountOrgId() + "");
            bo.setMarkUpRateNew(purchasePO.getMarkUpRateNew() + "");
            bo.setMarkUpRate(purchasePO.getMarkUpRate());
            bo.setCompleteCount(purchasePO.getSendCount());
            BigDecimal newPurchasingPrice = MoneyUtil.Long2BigDecimal((Long)purchasePO.getNewPurchasingPrice());
            BigDecimal newSellingPrice = MoneyUtil.Long2BigDecimal((Long)purchasePO.getNewSellingPrice());
            bo.setNewPurchasingPrice(newPurchasingPrice);
            bo.setNewSellingPrice(newSellingPrice);
            BigDecimal purchaseCount = purchasePO.getPurchaseCount();
            if (purchasePO.getSellingPrice() != null) {
                BigDecimal sellingPrice = MoneyUtil.Long2BigDecimal((Long)purchasePO.getSellingPrice());
                BigDecimal totalSalePrice = sellingPrice.multiply(purchaseCount);
                bo.setSellingPrice(sellingPrice);
                bo.setTotalSalePrice(totalSalePrice);
                if (newSellingPrice != null) {
                    BigDecimal newTotalSalePrice = newSellingPrice.multiply(purchaseCount);
                    bo.setNewTotalSalePrice(newTotalSalePrice);
                }
            }
            if (purchasePO.getPurchasingPrice() != null) {
                BigDecimal purchasingPrice = MoneyUtil.Long2BigDecimal((Long)purchasePO.getPurchasingPrice());
                BigDecimal totalPurchasePrice = purchasingPrice.multiply(purchaseCount);
                bo.setPurchasingPrice(purchasingPrice);
                bo.setTotalPurchasePrice(totalPurchasePrice);
                if (newPurchasingPrice != null) {
                    BigDecimal newTotalPurchasePrice = newPurchasingPrice.multiply(purchaseCount);
                    bo.setNewTotalPurchasePrice(newTotalPurchasePrice);
                }
            }
        }
        catch (Exception e) {
            log.debug("\u5206\u9875\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u6570\u636e\u8f6c\u6362(\u6570\u636e\u5df2\u67e5\u51fa)\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5206\u9875\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u6570\u636e\u8f6c\u6362(\u6570\u636e\u5df2\u67e5\u51fa)\u51fa\u73b0\u5f02\u5e38\uff1a" + e);
        }
    }

    private void propertiesCopy(OrderSaleItemXbjPO salePO, XbjQuerySaleOrderItemRspBO bo) {
        try {
            BeanUtils.copyProperties((Object)salePO, (Object)bo);
            bo.setSaleOrderItemId(salePO.getSaleOrderItemId() + "");
            bo.setSaleOrderId(salePO.getSaleOrderId() + "");
            bo.setPurchaserId(salePO.getPurchaserId() + "");
            bo.setPurchaserAccountId(salePO.getPurchaserAccountId() + "");
            bo.setProfessionalOrganizationId(salePO.getProfessionalOrganizationId() + "");
            bo.setGoodsSupplierId(salePO.getGoodsSupplierId() + "");
            bo.setSkuId(salePO.getSkuId() + "");
            bo.setBrand(salePO.getBrand() + "");
            bo.setTotal(salePO.getTotal() + "");
            bo.setPlanDetailNumber(salePO.getPlanDetailNumber() + "");
            bo.setDeptId(salePO.getDeptId() + "");
            bo.setPurchaserAccountOrgId(salePO.getPurchaserAccountOrgId() + "");
            bo.setMarkUpRateNew(salePO.getMarkUpRateNew() + "");
            bo.setMarkUpRate(salePO.getMarkUpRate());
            BigDecimal newPurchasingPrice = MoneyUtil.Long2BigDecimal((Long)salePO.getNewPurchasingPrice());
            BigDecimal newSellingPrice = MoneyUtil.Long2BigDecimal((Long)salePO.getNewSellingPrice());
            bo.setNewPurchasingPrice(newPurchasingPrice);
            bo.setNewSellingPrice(newSellingPrice);
            BigDecimal purchaseCount = salePO.getPurchaseCount();
            if (salePO.getSellingPrice() != null) {
                BigDecimal sellingPrice = MoneyUtil.Long2BigDecimal((Long)salePO.getSellingPrice());
                BigDecimal totalSalePrice = sellingPrice.multiply(purchaseCount);
                bo.setSellingPrice(sellingPrice);
                bo.setTotalSalePrice(totalSalePrice);
                if (newSellingPrice != null) {
                    BigDecimal newTotalSalePrice = newSellingPrice.multiply(purchaseCount);
                    bo.setNewTotalSalePrice(newTotalSalePrice);
                }
            }
            if (salePO.getPurchasingPrice() != null) {
                BigDecimal purchasingPrice = MoneyUtil.Long2BigDecimal((Long)salePO.getPurchasingPrice());
                BigDecimal totalPurchasePrice = purchasingPrice.multiply(purchaseCount);
                bo.setPurchasingPrice(purchasingPrice);
                bo.setTotalPurchasePrice(totalPurchasePrice);
                if (newPurchasingPrice != null) {
                    BigDecimal newTotalPurchasePrice = newPurchasingPrice.multiply(purchaseCount);
                    bo.setNewTotalPurchasePrice(newTotalPurchasePrice);
                }
            }
        }
        catch (Exception e) {
            log.error("\u5206\u9875\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u6570\u636e\u8f6c\u6362(\u6570\u636e\u5df2\u67e5\u51fa)\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5206\u9875\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u6570\u636e\u8f6c\u6362(\u6570\u636e\u5df2\u67e5\u51fa)\u51fa\u73b0\u5f02\u5e38\uff1a" + e);
        }
    }

    private void validateArg(XbjQuerySaleOrderItemReqBO xbjQuerySaleOrderItemReqBO) {
        if (xbjQuerySaleOrderItemReqBO == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u5217\u8868\uff1a\u5165\u53c2\u3010XbjQuerySaleOrderItemReqBO\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String saleOrderId = "";
        String purchaserOrderId = "";
        if (xbjQuerySaleOrderItemReqBO.getSaleOrderId() != null && !xbjQuerySaleOrderItemReqBO.getSaleOrderId().equals("")) {
            saleOrderId = xbjQuerySaleOrderItemReqBO.getSaleOrderId();
        } else if (xbjQuerySaleOrderItemReqBO.getPurchaseOrderId() != null && !xbjQuerySaleOrderItemReqBO.getPurchaseOrderId().equals("")) {
            purchaserOrderId = xbjQuerySaleOrderItemReqBO.getPurchaseOrderId();
        } else {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u5217\u8868\uff1a\u5165\u53c2XbjQuerySaleOrderItemReqBO\uff1asaleOrderId\u6216purchaseOrderId\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public RspListInfoBO<XbjQuerySaleOrderItemRspBO> querySaleOrderItemForExp(XbjQuerySaleOrderItemReqBO xbjQuerySaleOrderItemReqBO) {
        if (this.isDebugEnabled.booleanValue()) {
            log.debug("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u5217\u8868\u5165\u53c2:" + xbjQuerySaleOrderItemReqBO);
        }
        this.validateArg(xbjQuerySaleOrderItemReqBO);
        RspListInfoBO resultPage = new RspListInfoBO();
        LinkedList<XbjQuerySaleOrderItemRspBO> XbjQuerySaleOrderItemRspBOs = new LinkedList<XbjQuerySaleOrderItemRspBO>();
        List<Object> queryOrderSalItemList = new LinkedList();
        if (xbjQuerySaleOrderItemReqBO.getSaleOrderId() != null || xbjQuerySaleOrderItemReqBO.getSaleOrderId().equals("")) {
            try {
                Long orderId = Long.valueOf(xbjQuerySaleOrderItemReqBO.getSaleOrderId());
                OrderSaleItemXbjPO conditionPO = new OrderSaleItemXbjPO();
                conditionPO.setSaleOrderId(orderId);
                queryOrderSalItemList = this.orderSaleItemXbjMapper.selectBySaleOrderId(conditionPO);
                if (queryOrderSalItemList != null && !queryOrderSalItemList.isEmpty()) {
                    for (OrderSaleItemXbjPO orderSaleItemXbjPO : queryOrderSalItemList) {
                        XbjQuerySaleOrderItemRspBO bo = new XbjQuerySaleOrderItemRspBO();
                        if (orderSaleItemXbjPO == null) continue;
                        this.propertiesCopy(orderSaleItemXbjPO, bo);
                        XbjQuerySaleOrderItemRspBOs.add(bo);
                    }
                } else {
                    resultPage.setRespCode("0000");
                    resultPage.setRespDesc("\u65e0\u8be5\u9500\u552e\u8ba2\u5355\u7684\u660e\u7ec6\u4fe1\u606f");
                    return resultPage;
                }
                resultPage.setRespCode("0000");
                resultPage.setRespDesc("\u67e5\u8be2\u5206\u9875\u9500\u552e\u8ba2\u5355\u5546\u54c1\u8be6\u60c5\u6210\u529f");
                resultPage.setList(XbjQuerySaleOrderItemRspBOs);
                return resultPage;
            }
            catch (Exception e) {
                log.debug("\u5206\u9875\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                resultPage.setRespCode("8888");
                resultPage.setRespDesc("\u67e5\u8be2\u5206\u9875\u9500\u552e\u8ba2\u5355\u5546\u54c1\u8be6\u60c5\u5931\u8d25");
                return resultPage;
            }
        }
        if (xbjQuerySaleOrderItemReqBO.getPurchaseOrderId() != null || xbjQuerySaleOrderItemReqBO.getPurchaseOrderId().equals("")) {
            try {
                Long orderId = Long.valueOf(xbjQuerySaleOrderItemReqBO.getPurchaseOrderId());
                Long purchaserId = Long.valueOf(xbjQuerySaleOrderItemReqBO.getPurchaserId());
                List<Object> queryOrderPurchaseItemList = new LinkedList();
                LinkedList<XbjQuerySaleOrderItemRspBO> linkedList = new LinkedList<XbjQuerySaleOrderItemRspBO>();
                OrderPurchaseItemXbjPO condition = new OrderPurchaseItemXbjPO();
                condition.setPurchaseOrderId(purchaserId);
                queryOrderPurchaseItemList = this.orderPurchaseItemXbjMapper.getList(condition);
                if (queryOrderPurchaseItemList != null && !queryOrderPurchaseItemList.isEmpty()) {
                    for (OrderPurchaseItemXbjPO orderPurchaseItemXbjPO : queryOrderPurchaseItemList) {
                        XbjQuerySaleOrderItemRspBO bo = new XbjQuerySaleOrderItemRspBO();
                        if (orderPurchaseItemXbjPO == null) continue;
                        this.propertiesCopy(orderPurchaseItemXbjPO, bo);
                        linkedList.add(bo);
                    }
                } else {
                    resultPage.setRespCode("0000");
                    resultPage.setRespDesc("\u65e0\u8be5\u9500\u552e\u8ba2\u5355\u7684\u660e\u7ec6\u4fe1\u606f");
                    return resultPage;
                }
                resultPage.setRespCode("0000");
                resultPage.setRespDesc("\u67e5\u8be2\u5206\u9875\u9500\u552e\u8ba2\u5355\u5546\u54c1\u8be6\u60c5\u6210\u529f");
                resultPage.setList(linkedList);
                return resultPage;
            }
            catch (Exception e) {
                log.debug("\u5206\u9875\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u660e\u7ec6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                resultPage.setRespCode("8888");
                resultPage.setRespDesc("\u67e5\u8be2\u5206\u9875\u9500\u552e\u8ba2\u5355\u5546\u54c1\u8be6\u60c5\u5931\u8d25");
                return resultPage;
            }
        }
        resultPage.setRespCode("8888");
        resultPage.setRespDesc("\u67e5\u8be2\u5206\u9875\u9500\u552e\u8ba2\u5355\u5546\u54c1\u8be6\u60c5\u5931\u8d25");
        return resultPage;
    }
}

