/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.manage.dic.dict.service.DicDictionaryService;
import com.cgd.order.atom.AccessoryXbjAtomService;
import com.cgd.order.atom.EaReturnCountModifyXbjAtomService;
import com.cgd.order.atom.GoodsReturnXbjAtomService;
import com.cgd.order.atom.bo.GoodsReturnAtomXbjReqBO;
import com.cgd.order.atom.bo.GoodsReturnAtomXbjRspBO;
import com.cgd.order.atom.bo.ReturnCountModifyXbjReqBO;
import com.cgd.order.busi.XbjReturnAgreeBusiService;
import com.cgd.order.busi.bo.XbjAccessoryBusiReqBO;
import com.cgd.order.busi.bo.XbjReturnGoodsReqBO;
import com.cgd.order.busi.bo.XbjReturnGoodsRspBO;
import com.cgd.order.constant.Constant;
import com.cgd.order.constant.OrderCenterConstant;
import com.cgd.order.constant.XConstant;
import com.cgd.order.constant.XOrderCenterConstant;
import com.cgd.order.dao.OrderFlowSheetXbjMapper;
import com.cgd.order.dao.ReturnItemXbjMapper;
import com.cgd.order.po.AccessoryXbjPO;
import com.cgd.order.po.OrderFlowSheetXbjPO;
import com.cgd.order.po.ReturnItemXbjPO;
import com.cgd.pay.busi.BusiElecRefundOperateService;
import com.cgd.pay.busi.bo.BusiElecRefundOperateReqBO;
import com.cgd.pay.busi.vo.ElecAllowRefundItemVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class XbjReturnAgreeBusiServiceImpl
implements XbjReturnAgreeBusiService {
    private static final Log log = LogFactory.getLog(XbjReturnAgreeBusiService.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    private DicDictionaryService dicDictionaryService;
    private GoodsReturnXbjAtomService goodsReturnXbjAtomService;
    private OrderFlowSheetXbjMapper orderFlowSheetXbjMapper;
    private AccessoryXbjAtomService accessoryXbjAtomService;
    private EaReturnCountModifyXbjAtomService eaReturnCountModifyXbjAtomService;
    @Autowired
    private BusiElecRefundOperateService busiElecRefundOperateService;
    @Autowired
    private ReturnItemXbjMapper returnItemXbjMapper;

    public void setDicDictionaryService(DicDictionaryService dicDictionaryService) {
        this.dicDictionaryService = dicDictionaryService;
    }

    public void setGoodsReturnXbjAtomService(GoodsReturnXbjAtomService goodsReturnXbjAtomService) {
        this.goodsReturnXbjAtomService = goodsReturnXbjAtomService;
    }

    public void setOrderFlowSheetXbjMapper(OrderFlowSheetXbjMapper orderFlowSheetXbjMapper) {
        this.orderFlowSheetXbjMapper = orderFlowSheetXbjMapper;
    }

    public void setAccessoryXbjAtomService(AccessoryXbjAtomService accessoryXbjAtomService) {
        this.accessoryXbjAtomService = accessoryXbjAtomService;
    }

    public void setEaReturnCountModifyXbjAtomService(EaReturnCountModifyXbjAtomService eaReturnCountModifyXbjAtomService) {
        this.eaReturnCountModifyXbjAtomService = eaReturnCountModifyXbjAtomService;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XbjReturnGoodsRspBO dealReturnAgree(XbjReturnGoodsReqBO xbjReturnGoodsReqBO) {
        if (this.isDebugEnabled) {
            log.debug((Object)("\u8be2\u6bd4\u4ef7\u5f85\u786e\u8ba4\u9000\u8d27\u5355\u67e5\u8be2-\u540c\u610f\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + xbjReturnGoodsReqBO.toString()));
        }
        try {
            this.validateParams(xbjReturnGoodsReqBO);
            XbjReturnGoodsRspBO xbjReturnGoodsRspBO = new XbjReturnGoodsRspBO();
            GoodsReturnAtomXbjReqBO goodsReturnAtomXbjReqBO = new GoodsReturnAtomXbjReqBO();
            goodsReturnAtomXbjReqBO.setGoodsReturnId(xbjReturnGoodsReqBO.getGoodsReturnId());
            goodsReturnAtomXbjReqBO.setPurchaserId(xbjReturnGoodsReqBO.getPurchaserId());
            GoodsReturnAtomXbjRspBO goodsReturnAtomXbjRspBO = this.goodsReturnXbjAtomService.queryFromReturn(goodsReturnAtomXbjReqBO);
            if (goodsReturnAtomXbjRspBO == null || !"0000".equals(goodsReturnAtomXbjRspBO.getRespCode())) throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9000\u8d27\u540c\u610f\u670d\u52a1\u5f02\u5e38:\u67e5\u8be2\u9000\u8d27\u5355\u8bb0\u5f55\u5931\u8d25\uff01");
            Integer oldReturnStatus = goodsReturnAtomXbjRspBO.getReturnStatus();
            if (!OrderCenterConstant.RETURN_STATUS.CONFIRM.equals(oldReturnStatus)) throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9000\u8d27\u540c\u610f\u670d\u52a1\u5f02\u5e38:\u9000\u8d27\u5355\u5df2\u53d6\u6d88,\u540c\u610f\u9000\u8d27\u4e0d\u6210\u529f\uff01");
            GoodsReturnAtomXbjRspBO goodsReturnAtom = this.goodsReturnXbjAtomService.updateGoodsReturnStatus(xbjReturnGoodsReqBO.getGoodsReturnId(), xbjReturnGoodsReqBO.getPurchaserId(), OrderCenterConstant.RETURN_STATUS.AGREE, xbjReturnGoodsReqBO.getReturnReason());
            if (!goodsReturnAtom.getRespCode().equals("0000")) throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9000\u8d27\u540c\u610f\u670d\u52a1\u5f02\u5e38:\u9000\u8d27\u5355\u72b6\u6001\u53d8\u66f4\u5931\u8d25\uff01");
            this.updateReceiveItem(xbjReturnGoodsReqBO.getGoodsReturnId(), xbjReturnGoodsReqBO.getPurchaserId(), goodsReturnAtomXbjRspBO.getInspectionId());
            if (null != xbjReturnGoodsReqBO.getAccessoryList() && !xbjReturnGoodsReqBO.getAccessoryList().isEmpty()) {
                List<AccessoryXbjPO> acessoryList = this.assembleAccessoryData(goodsReturnAtomXbjRspBO, Constant.GOODS_RETURN_AGREE_OBJECT_TYPE, xbjReturnGoodsReqBO.getAccessoryList());
                this.accessoryXbjAtomService.batchSave(acessoryList);
            }
            xbjReturnGoodsReqBO.setOrderBusiType("R_2");
            this.insertOrderFlowSheet(xbjReturnGoodsReqBO, goodsReturnAtomXbjRspBO);
            if (goodsReturnAtomXbjRspBO.getIsDispatch().equals(XConstant.IS_DISPATCH_YES)) {
                BusiElecRefundOperateReqBO refundreqBO = new BusiElecRefundOperateReqBO();
                refundreqBO.setInspectionId(goodsReturnAtomXbjRspBO.getInspectionId().toString());
                refundreqBO.setOperUnitNo(goodsReturnAtomXbjRspBO.getProfessionalOrganizationId().toString());
                refundreqBO.setPurchaseNo(goodsReturnAtomXbjRspBO.getPurchaserId().toString());
                refundreqBO.setOprType(XOrderCenterConstant.REFUND.AGREE);
                ReturnItemXbjPO condition = new ReturnItemXbjPO();
                List<ReturnItemXbjPO> returnItemXbjPOList = this.returnItemXbjMapper.getList(condition);
                ArrayList<ElecAllowRefundItemVO> refundItemList = new ArrayList<ElecAllowRefundItemVO>();
                for (ReturnItemXbjPO po : returnItemXbjPOList) {
                    ElecAllowRefundItemVO vo = new ElecAllowRefundItemVO();
                    vo.setRefundCount(po.getReturnCount());
                    vo.setRefundTotAmt(po.getReturnCount().multiply(MoneyUtil.Long2BigDecimal((Long)po.getPurchasingPrice())));
                    vo.setSkuId(po.getSkuId() + "");
                    vo.setSaleItemNo(po.getSaleOrderItemId() + "");
                    refundItemList.add(vo);
                }
                refundreqBO.setRefundItems(refundItemList);
                this.busiElecRefundOperateService.processRefund(refundreqBO);
            }
            xbjReturnGoodsRspBO.setInspectionId(goodsReturnAtomXbjRspBO.getInspectionId());
            xbjReturnGoodsRspBO.setGoodsReturnCode(goodsReturnAtomXbjRspBO.getGoodsReturnCode());
            xbjReturnGoodsRspBO.setProfessionalOrganizationId(goodsReturnAtomXbjRspBO.getProfessionalOrganizationId());
            xbjReturnGoodsRspBO.setPurchaserId(goodsReturnAtomXbjRspBO.getPurchaserId());
            xbjReturnGoodsRspBO.setPurchaserAccountOrgId(goodsReturnAtomXbjRspBO.getPurchaserAccountOrgId());
            xbjReturnGoodsRspBO.setSaleOrderId(goodsReturnAtomXbjRspBO.getSaleOrderId());
            xbjReturnGoodsRspBO.setIsDispatch(goodsReturnAtomXbjRspBO.getIsDispatch());
            xbjReturnGoodsRspBO.setRespCode("0000");
            xbjReturnGoodsRspBO.setRespDesc("\u9000\u8d27\u5355\u72b6\u6001\u53d8\u66f4\u6210\u529f\uff01");
            if (!this.isDebugEnabled) return xbjReturnGoodsRspBO;
            log.debug((Object)("\u5f85\u786e\u8ba4\u9000\u8d27\u5355\u67e5\u8be2-\u540c\u610f\u4e1a\u52a1\u670d\u52a1 \u5b8c\u6210\u8c03\u7528\u51fa\u53c2\uff1aRespCode=" + xbjReturnGoodsRspBO.getRespCode() + ", RespDesc=" + xbjReturnGoodsRspBO.getRespDesc()));
            return xbjReturnGoodsRspBO;
        }
        catch (Exception e) {
            log.error((Object)"\u9000\u8d27\u540c\u610f\u670d\u52a1\u5f02\u5e38:", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9000\u8d27\u540c\u610f\u670d\u52a1\u5f02\u5e38");
        }
    }

    private void insertOrderFlowSheet(XbjReturnGoodsReqBO xbjReturnGoodsReqBO, GoodsReturnAtomXbjRspBO goodsReturnAtomXbjRspBO) {
        String busiName;
        OrderFlowSheetXbjPO orderFlowSheetXbjPO = new OrderFlowSheetXbjPO();
        Map<String, String> purchaserOrderMode = this.queryValueByCode("RETURN_ORDER_TYPE");
        if (purchaserOrderMode != null) {
            busiName = purchaserOrderMode.get(xbjReturnGoodsReqBO.getOrderBusiType());
            if (busiName == null || "".equals(busiName)) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6839\u636e\u6570\u636e\u5b57\u5178code\u83b7\u53d6title\u6570\u636e\u4e3a\u7a7a");
            }
        } else {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u83b7\u53d6\u6570\u636e\u5b57\u5178\u6570\u636e\u4e3a\u7a7a");
        }
        orderFlowSheetXbjPO.setBusiType(xbjReturnGoodsReqBO.getOrderBusiType());
        orderFlowSheetXbjPO.setBusiName(busiName);
        orderFlowSheetXbjPO.setOperId(xbjReturnGoodsReqBO.getUserId());
        orderFlowSheetXbjPO.setOperName(xbjReturnGoodsReqBO.getUserName());
        orderFlowSheetXbjPO.setOrderId(xbjReturnGoodsReqBO.getGoodsReturnId());
        orderFlowSheetXbjPO.setOperDeptId(xbjReturnGoodsReqBO.getOrgId());
        orderFlowSheetXbjPO.setOperDeptName(xbjReturnGoodsReqBO.getOrgName());
        orderFlowSheetXbjPO.setOperCompId(xbjReturnGoodsReqBO.getCompanyId());
        orderFlowSheetXbjPO.setOperCompName(xbjReturnGoodsReqBO.getCompanyName());
        orderFlowSheetXbjPO.setProfessionalOrganizationId(goodsReturnAtomXbjRspBO.getProfessionalOrganizationId());
        orderFlowSheetXbjPO.setPurchaserAccountId(goodsReturnAtomXbjRspBO.getPurchaserAccountId());
        orderFlowSheetXbjPO.setPurchaserId(goodsReturnAtomXbjRspBO.getPurchaserId());
        orderFlowSheetXbjPO.setGoodsSupplierId(goodsReturnAtomXbjRspBO.getGoodsSupplierId());
        orderFlowSheetXbjPO.setOrderType(OrderCenterConstant.ORDER_TYPE.RETURN);
        orderFlowSheetXbjPO.setOperTime(new Date());
        this.orderFlowSheetXbjMapper.insertSelective(orderFlowSheetXbjPO);
    }

    private Map<String, String> queryValueByCode(String pCode) {
        try {
            Map purchaserOrderMode = this.dicDictionaryService.getValueByCode(pCode);
            return purchaserOrderMode;
        }
        catch (Exception e) {
            log.error((Object)("\u67e5\u8be2\u6570\u636e\u5b57\u5178\u5931\u8d25" + e));
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u67e5\u8be2\u6570\u636e\u5b57\u5178\u5931\u8d25");
        }
    }

    private List<AccessoryXbjPO> assembleAccessoryData(GoodsReturnAtomXbjRspBO goodsReturnAtomXbjRspBO, Integer goodsReturnAgreeObjectType, List<XbjAccessoryBusiReqBO> list) {
        ArrayList<AccessoryXbjPO> accessoryList = new ArrayList<AccessoryXbjPO>();
        for (XbjAccessoryBusiReqBO xbjAccessoryBusiReqBO : list) {
            AccessoryXbjPO accessory = new AccessoryXbjPO();
            accessory.setAccessoryId(String.valueOf(xbjAccessoryBusiReqBO.getAccessoryId()));
            accessory.setAccessoryName(xbjAccessoryBusiReqBO.getAccessoryName());
            accessory.setAccessoryUrl(xbjAccessoryBusiReqBO.getAccessoryUrl());
            accessory.setCreateDate(new Date());
            accessory.setGoodsSupplierId(String.valueOf(goodsReturnAtomXbjRspBO.getGoodsSupplierId()));
            accessory.setObjectId(goodsReturnAtomXbjRspBO.getGoodsReturnId());
            accessory.setObjectType(goodsReturnAgreeObjectType);
            accessory.setProfessionalOrganizationId(String.valueOf(goodsReturnAtomXbjRspBO.getProfessionalOrganizationId()));
            accessory.setPurchaserAccountId(goodsReturnAtomXbjRspBO.getPurchaserAccountId());
            accessory.setPurchaserAccountName(goodsReturnAtomXbjRspBO.getPurchaserAccountName());
            accessory.setPurchaserId(goodsReturnAtomXbjRspBO.getPurchaserId());
            accessory.setRemark("\u7535\u5b50\u4e13\u533a-\u4f9b\u5e94\u5546\u9000\u8d27\u786e\u8ba4-\u540c\u610f\u64cd\u4f5c\u4e0a\u4f20\u9644\u4ef6");
            accessoryList.add(accessory);
        }
        return accessoryList;
    }

    private void updateReceiveItem(Long goodsReturnId, Long purchaserId, Long inspectionId) {
        ReturnCountModifyXbjReqBO returnCountModifyXbjReqBO = new ReturnCountModifyXbjReqBO();
        returnCountModifyXbjReqBO.setGoodsReturnId(goodsReturnId);
        returnCountModifyXbjReqBO.setPurchaserId(purchaserId);
        returnCountModifyXbjReqBO.setInspectionId(inspectionId);
        this.eaReturnCountModifyXbjAtomService.updateReceiveItemReturnCount(returnCountModifyXbjReqBO);
    }

    private void validateParams(XbjReturnGoodsReqBO xbjReturnGoodsReqBO) {
        if (xbjReturnGoodsReqBO == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjReturnGoodsReqBO.getGoodsReturnId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u9000\u8d27\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (xbjReturnGoodsReqBO.getPurchaserId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u91c7\u8d2d\u5546id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

