/*
 * Decompiled with CFR 0.152.
 */
package com.cgd.order.busi.impl;

import com.cgd.common.exception.BusinessException;
import com.cgd.common.util.MoneyUtil;
import com.cgd.manage.dic.dict.service.DicDictionaryService;
import com.cgd.order.atom.CreateReturnXbjAtomService;
import com.cgd.order.atom.GenerateOrderIdAndCodeXbjAtomService;
import com.cgd.order.atom.GoodsReturnXbjAtomService;
import com.cgd.order.atom.bo.GenerateOrderIdAndCodeXbjReqBO;
import com.cgd.order.atom.bo.GenerateOrderIdAndCodeXbjRspBO;
import com.cgd.order.atom.bo.ReturnAtomXbjReqBO;
import com.cgd.order.busi.XbjReturnBusiService;
import com.cgd.order.busi.bo.XbjAccessoryBusiReqBO;
import com.cgd.order.busi.bo.XbjReturnBusiReqBO;
import com.cgd.order.busi.bo.XbjReturnBusiRspBO;
import com.cgd.order.busi.bo.XbjReturnItemReqBO;
import com.cgd.order.busi.bo.XbjReturnItemRspBO;
import com.cgd.order.constant.Constant;
import com.cgd.order.constant.OrderCenterConstant;
import com.cgd.order.constant.XConstant;
import com.cgd.order.constant.XbjOrderConstants;
import com.cgd.order.dao.AccessoryXbjMapper;
import com.cgd.order.dao.InfoAddressXbjMapper;
import com.cgd.order.dao.OrderFlowSheetXbjMapper;
import com.cgd.order.dao.OrderReceiveItemXbjMapper;
import com.cgd.order.dao.OrderSaleItemXbjMapper;
import com.cgd.order.dao.OrderSaleXbjMapper;
import com.cgd.order.dao.ReturnXbjMapper;
import com.cgd.order.intfce.bo.AddressInfoIntfceXbjReqBO;
import com.cgd.order.po.AccessoryXbjPO;
import com.cgd.order.po.InfoAddressXbjPO;
import com.cgd.order.po.OrderFlowSheetXbjPO;
import com.cgd.order.po.OrderReceiveItemXbjPO;
import com.cgd.order.po.OrderSaleItemXbjPO;
import com.cgd.order.po.OrderSaleXbjPO;
import com.cgd.order.po.ReturnXbjPO;
import com.cgd.pay.busi.BusiElecRefundApplyService;
import com.cgd.pay.busi.bo.BusiElecRefundApplyReqBO;
import com.cgd.pay.busi.bo.BusiElecRefundApplyRspBO;
import com.cgd.pay.busi.vo.ElecAllowRefundItemVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class XbjReturnBusiServiceImpl
implements XbjReturnBusiService {
    private static final Logger log = LoggerFactory.getLogger(XbjReturnBusiServiceImpl.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    private OrderSaleXbjMapper orderSaleXbjMapper;
    private GenerateOrderIdAndCodeXbjAtomService generateOrderIdAndCodeXbjAtomService;
    private CreateReturnXbjAtomService createReturnXbjAtomService;
    private OrderSaleItemXbjMapper orderSaleItemXbjMapper;
    private InfoAddressXbjMapper infoAddressXbjMapper;
    private ReturnXbjMapper returnXbjMapper;
    private DicDictionaryService dicDictionaryService;
    private OrderFlowSheetXbjMapper orderFlowSheetXbjMapper;
    private AccessoryXbjMapper accessoryXbjMapper;
    private OrderReceiveItemXbjMapper orderReceiveItemXbjMapper;
    @Autowired
    private BusiElecRefundApplyService busiElecRefundApplyService;
    @Autowired
    private GoodsReturnXbjAtomService goodsReturnXbjAtomService;

    public void setOrderSaleXbjMapper(OrderSaleXbjMapper orderSaleXbjMapper) {
        this.orderSaleXbjMapper = orderSaleXbjMapper;
    }

    public void setGenerateOrderIdAndCodeXbjAtomService(GenerateOrderIdAndCodeXbjAtomService generateOrderIdAndCodeXbjAtomService) {
        this.generateOrderIdAndCodeXbjAtomService = generateOrderIdAndCodeXbjAtomService;
    }

    public void setCreateReturnXbjAtomService(CreateReturnXbjAtomService createReturnXbjAtomService) {
        this.createReturnXbjAtomService = createReturnXbjAtomService;
    }

    public void setOrderSaleItemXbjMapper(OrderSaleItemXbjMapper orderSaleItemXbjMapper) {
        this.orderSaleItemXbjMapper = orderSaleItemXbjMapper;
    }

    public void setInfoAddressXbjMapper(InfoAddressXbjMapper infoAddressXbjMapper) {
        this.infoAddressXbjMapper = infoAddressXbjMapper;
    }

    public void setReturnXbjMapper(ReturnXbjMapper returnXbjMapper) {
        this.returnXbjMapper = returnXbjMapper;
    }

    public void setDicDictionaryService(DicDictionaryService dicDictionaryService) {
        this.dicDictionaryService = dicDictionaryService;
    }

    public void setOrderFlowSheetXbjMapper(OrderFlowSheetXbjMapper orderFlowSheetXbjMapper) {
        this.orderFlowSheetXbjMapper = orderFlowSheetXbjMapper;
    }

    public void setAccessoryXbjMapper(AccessoryXbjMapper accessoryXbjMapper) {
        this.accessoryXbjMapper = accessoryXbjMapper;
    }

    public void setOrderReceiveItemXbjMapper(OrderReceiveItemXbjMapper orderReceiveItemXbjMapper) {
        this.orderReceiveItemXbjMapper = orderReceiveItemXbjMapper;
    }

    public XbjReturnBusiRspBO dealReturn(XbjReturnBusiReqBO returnReq) {
        List<XbjReturnItemReqBO> returnItemList;
        if (this.isDebugEnabled) {
            log.debug("\u8be2\u6bd4\u4ef7\u9000\u8d27\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5165\u53c2" + returnReq);
        }
        XbjReturnBusiRspBO returnBusi = new XbjReturnBusiRspBO();
        OrderSaleXbjPO orderSaleXbj = null;
        try {
            orderSaleXbj = this.orderSaleXbjMapper.selectOrderSaleByCondition(Long.valueOf(returnReq.getSaleOrderId()), returnReq.getPurchaserId());
            if (null == orderSaleXbj) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u4e3a\u7a7a\uff01");
            }
        }
        catch (Exception e) {
            if (this.isDebugEnabled) {
                log.debug("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u51fa\u9519\uff01" + e);
            }
            if (e instanceof BusinessException) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", e.getMessage());
            }
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u5f02\u5e38\uff01");
        }
        GenerateOrderIdAndCodeXbjReqBO generateReturnIdAndCodeXbjReqBO = new GenerateOrderIdAndCodeXbjReqBO();
        generateReturnIdAndCodeXbjReqBO.setGenerateOrderType(XbjOrderConstants.GENERATE_ORDER_TYPE.RETURN);
        generateReturnIdAndCodeXbjReqBO.setSaleOrderId(orderSaleXbj.getSaleOrderId());
        generateReturnIdAndCodeXbjReqBO.setSaleOrderCode(orderSaleXbj.getSaleOrderCode());
        generateReturnIdAndCodeXbjReqBO.setPurchaseId(orderSaleXbj.getPurchaserId());
        GenerateOrderIdAndCodeXbjRspBO generateReturnIDAndCodeRspBO = this.generateOrderIdAndCodeXbjAtomService.generateOrderIdAndCode(generateReturnIdAndCodeXbjReqBO);
        if (generateReturnIDAndCodeRspBO == null || generateReturnIDAndCodeRspBO.getOrderId() == null) {
            throw new BusinessException("RSP_CODE_PARA_NOT_NULL", "\u8be2\u6bd4\u4ef7\uff08\u6846\u67b6\u534f\u8bae\uff09\u9000\u8d27\u8ba2\u5355ID\u548c\u7f16\u53f7\u751f\u6210\u5f02\u5e38");
        }
        if (this.isDebugEnabled) {
            log.debug("\u91c7\u8d2d\u8ba2\u5355ID\uff1a" + generateReturnIDAndCodeRspBO.getOrderId() + "\u91c7\u8d2d\u8ba2\u5355CODE\uff1a" + generateReturnIDAndCodeRspBO.getOrderCode());
        }
        ReturnAtomXbjReqBO returnAtomReqBO = this.initReturnRsp(orderSaleXbj, returnReq, generateReturnIDAndCodeRspBO.getOrderCode());
        Long createReturnId = null;
        try {
            createReturnId = this.createReturnXbjAtomService.createReturn(returnAtomReqBO);
        }
        catch (Exception e) {
            log.error("\u63d2\u5165\u9000\u8d27\u5355\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u63d2\u5165\u9000\u8d27\u5355\u4fe1\u606f\u5f02\u5e38");
        }
        Long pickupAddressId = null;
        try {
            InfoAddressXbjPO pickupInfoAddress = this.initAddressInfo(returnReq.getPickupAddress(), orderSaleXbj, Constant.RETURN_PICK_ORDER, createReturnId);
            this.infoAddressXbjMapper.insertSelectiveReturnId(pickupInfoAddress);
            pickupAddressId = pickupInfoAddress.getId();
        }
        catch (Exception e) {
            log.error("\u5730\u5740\u4fe1\u606f\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u63d2\u5165\u5730\u5740\u4fe1\u606f\u5f02\u5e38\uff01");
        }
        ReturnXbjPO record = new ReturnXbjPO();
        record.setGoodsReturnId(createReturnId);
        record.setPickupAddressId(pickupAddressId);
        int updateByPrimaryKeySelective = this.returnXbjMapper.updateByPrimaryKeySelective(record);
        if (updateByPrimaryKeySelective < 0) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u66f4\u65b0\u9000\u8d27\u5355\u5730\u5740\u4fe1\u606f\u5f02\u5e38");
        }
        this.insertOrderFlowSheet(createReturnId, orderSaleXbj, returnReq);
        this.createAccessory(returnReq.getAccessoryList(), orderSaleXbj, returnReq, createReturnId);
        this.updateOrderReceiveItem(returnReq);
        if (orderSaleXbj.getIsDispatch().equals(XConstant.IS_DISPATCH_YES)) {
            try {
                BusiElecRefundApplyReqBO reqBO = new BusiElecRefundApplyReqBO();
                reqBO.setPurchaseNo(orderSaleXbj.getPurchaserAccountOrgId() + "");
                reqBO.setOperUnitNo(orderSaleXbj.getProfessionalOrganizationId() + "");
                reqBO.setSaleOrderId(orderSaleXbj.getSaleOrderId() + "");
                reqBO.setInspectionId(returnReq.getInspectionId());
                List<XbjReturnItemReqBO> returnItemList2 = returnAtomReqBO.getReturnItemList();
                if (null != returnItemList2 && !returnItemList2.isEmpty()) {
                    ArrayList<ElecAllowRefundItemVO> elecAllowRefundItemList = new ArrayList<ElecAllowRefundItemVO>();
                    for (XbjReturnItemReqBO returnItemAtomReqBO : returnItemList2) {
                        ElecAllowRefundItemVO elecAllowRefundItemVO = new ElecAllowRefundItemVO();
                        elecAllowRefundItemVO.setSaleItemNo(returnItemAtomReqBO.getSaleOrderItemId() + "");
                        elecAllowRefundItemVO.setRefundCount(returnItemAtomReqBO.getReturnCount());
                        elecAllowRefundItemVO.setRefundTotAmt(MoneyUtil.Long2BigDecimal((Long)returnItemAtomReqBO.getSaleFee()));
                        elecAllowRefundItemList.add(elecAllowRefundItemVO);
                    }
                    reqBO.setRefundItems(elecAllowRefundItemList);
                }
                log.debug("\u9000\u8d27\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1:\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u5165\u53c2\u5bf9\u8c61:" + reqBO);
                BusiElecRefundApplyRspBO applyRefund = this.busiElecRefundApplyService.applyRefund(reqBO);
                log.debug("\u9000\u8d27\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1:\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u8fd4\u56de:" + applyRefund);
                this.goodsReturnXbjAtomService.updateAppResult(createReturnId, (long)returnReq.getPurchaserId(), applyRefund.getRespDesc());
                log.debug("\u9000\u8d27\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1:\u8c03\u7528\u66f4\u65b0result\u7ed3\u675f\u3002");
                if (!"0000".equals(applyRefund.getRespCode())) {
                    log.debug("\u9000\u8d27\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1:\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u5931\u8d25\u3002\u3010" + applyRefund.getRespCode() + "\u3011");
                    this.goodsReturnXbjAtomService.updateGoodsReturnStatus(createReturnId, (long)returnReq.getPurchaserId(), OrderCenterConstant.RETURN_STATUS.INVALID, null);
                    throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", applyRefund.getRespDesc());
                }
            }
            catch (Exception e) {
                log.error("\u9000\u8d27\u5355\u751f\u6210\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff01", (Throwable)e);
                if (e instanceof BusinessException) {
                    throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", e.getMessage());
                }
                throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", "\u9000\u8d27\u5355\u751f\u6210\u5f02\u5e38\uff01");
            }
        }
        if (null != (returnItemList = returnAtomReqBO.getReturnItemList()) && !returnItemList.isEmpty()) {
            ArrayList<XbjReturnItemRspBO> returnItemRspList = new ArrayList<XbjReturnItemRspBO>();
            for (XbjReturnItemReqBO returnItemAtomReqBO : returnItemList) {
                XbjReturnItemRspBO returnItemRsp = new XbjReturnItemRspBO();
                returnItemRsp.setMaterialId(returnItemAtomReqBO.getMaterialId());
                returnItemRsp.setRefundCount(returnItemAtomReqBO.getReturnCount());
                returnItemRsp.setRefundTotAmt(returnItemAtomReqBO.getSaleFee());
                returnItemRspList.add(returnItemRsp);
            }
            returnBusi.setReturnItem(returnItemRspList);
        }
        returnBusi.setProfessionalOrganizationId(orderSaleXbj.getProfessionalOrganizationId());
        returnBusi.setGoodsReturnId(createReturnId);
        returnBusi.setPurchaserAccountOrgId(orderSaleXbj.getPurchaserAccountOrgId());
        returnBusi.setIsDispatch(orderSaleXbj.getIsDispatch());
        return returnBusi;
    }

    private ReturnAtomXbjReqBO initReturnRsp(OrderSaleXbjPO orderSale, XbjReturnBusiReqBO returnReq, String returnCode) {
        try {
            ReturnAtomXbjReqBO returnRsp = new ReturnAtomXbjReqBO();
            returnRsp.setGoodsReturnCode(returnCode);
            returnRsp.setPurchaseOrderId(orderSale.getPurchaseOrderId());
            returnRsp.setPurchaseOrderCode(orderSale.getPurchaseOrderCode());
            returnRsp.setPurchaserId(returnReq.getPurchaserId());
            returnRsp.setSaleOrderCode(orderSale.getSaleOrderCode());
            returnRsp.setSaleOrderId(orderSale.getSaleOrderId());
            returnRsp.setProfessionalOrganizationId(orderSale.getProfessionalOrganizationId());
            returnRsp.setPurchaserAccountOrgId(orderSale.getPurchaserAccountOrgId());
            returnRsp.setDeptId(orderSale.getPurchaserId());
            returnRsp.setGoodsSupplierId(orderSale.getGoodsSupplierId());
            returnRsp.setSaleOrderType(orderSale.getSaleOrderType());
            returnRsp.setPurchaserAccountId(returnReq.getUserId());
            returnRsp.setPurchaserAccountName(orderSale.getPurchaserAccountName());
            returnRsp.setCreateTime(new Date());
            returnRsp.setQuestionDesc(returnReq.getQuestionDesc());
            returnRsp.setReturnMode(returnReq.getReturnMode());
            returnRsp.setPickupStartTime(returnReq.getPickupStartTime());
            returnRsp.setPickupEndTime(returnReq.getPickupEndTime());
            returnRsp.setPickupAddressId(Constant.LONG_ZERO);
            returnRsp.setTakeAddressId(Constant.LONG_ZERO);
            returnRsp.setInspectionId(Long.valueOf(returnReq.getInspectionId()));
            returnRsp.setInspectionCode(returnReq.getInspectionCode());
            returnRsp.setOperDeptId(returnReq.getOrgId());
            returnRsp.setOperDeptName(returnReq.getOrgName());
            returnRsp.setReturnStatus(OrderCenterConstant.RETURN_STATUS.CONFIRM);
            returnRsp.setOperId(returnReq.getUserId());
            returnRsp.setOperIdName(returnReq.getUserName());
            returnRsp.setOperCompId(returnReq.getCompanyId());
            returnRsp.setOperCompName(returnReq.getCompanyName());
            returnRsp.setSaleOrderName(orderSale.getSaleOrderName());
            returnRsp.setSaleOrderCreateTime(orderSale.getCreateTime());
            returnRsp.setReturnContactPhone(returnReq.getPickupAddress().getReceiverMobileNumber());
            returnRsp.setReturnContactName(returnReq.getPickupAddress().getReceiverName());
            returnRsp.setIsDispatch(orderSale.getIsDispatch());
            List returnItem = returnReq.getReturnItem();
            Long saleFeeCount = Constant.LONG_ZERO;
            Long purchaseFeeCount = Constant.LONG_ZERO;
            if (null != returnItem && !returnItem.isEmpty()) {
                ArrayList<XbjReturnItemReqBO> returnItemList = new ArrayList<XbjReturnItemReqBO>();
                for (XbjReturnItemReqBO returnItemBo : returnItem) {
                    OrderSaleItemXbjPO orderSaleItem = this.orderSaleItemXbjMapper.selectItemBySaleOrderIdAndItemId(orderSale.getSaleOrderId(), returnItemBo.getSaleOrderItemId(), orderSale.getPurchaserId());
                    XbjReturnItemReqBO returnItemAtom = new XbjReturnItemReqBO();
                    returnItemAtom.setMaterialId(orderSaleItem.getMaterialId());
                    returnItemAtom.setSkuId(orderSaleItem.getSkuId());
                    returnItemAtom.setMaterialName(orderSaleItem.getMaterialName());
                    returnItemAtom.setMaterialClassId(orderSaleItem.getMaterialClassId());
                    returnItemAtom.setMaterialCode(orderSaleItem.getMaterialCode());
                    returnItemAtom.setModel(orderSaleItem.getModel());
                    returnItemAtom.setSpecifications(orderSaleItem.getSpecifications());
                    returnItemAtom.setFigureNo(orderSaleItem.getFigureNo());
                    returnItemAtom.setMaterialQuality(orderSaleItem.getMaterialQuality());
                    returnItemAtom.setBrandId(orderSaleItem.getBrandId());
                    returnItemAtom.setSaleOrderItemId(orderSaleItem.getSaleOrderItemId());
                    returnItemAtom.setBrand(orderSaleItem.getBrand());
                    returnItemAtom.setManufacturer(orderSaleItem.getManufacturer());
                    returnItemAtom.setRecvAddr(orderSaleItem.getRecvAddr());
                    returnItemAtom.setUsedCompany(orderSaleItem.getUsedCompany());
                    returnItemAtom.setPurchasingPrice(orderSaleItem.getPurchasingPrice());
                    returnItemAtom.setUnitName(orderSaleItem.getUnitName());
                    returnItemAtom.setSellingPrice(orderSaleItem.getSellingPrice());
                    returnItemAtom.setReturnCount(returnItemBo.getReturnCount());
                    BigDecimal saleFee = MoneyUtil.Long2BigDecimal((Long)orderSaleItem.getSellingPrice()).multiply(returnItemBo.getReturnCount());
                    BigDecimal purchaseFee = MoneyUtil.Long2BigDecimal((Long)orderSaleItem.getPurchasingPrice()).multiply(returnItemBo.getReturnCount());
                    returnItemAtom.setSaleFee(MoneyUtil.BigDecimal2Long((BigDecimal)saleFee));
                    returnItemAtom.setPurchaseFee(MoneyUtil.BigDecimal2Long((BigDecimal)purchaseFee));
                    returnItemAtom.setShipOrderId(returnItemBo.getShipOrderId());
                    returnItemAtom.setShipItemId(returnItemBo.getShipItemId());
                    returnItemList.add(returnItemAtom);
                    saleFeeCount = saleFeeCount + MoneyUtil.BigDecimal2Long((BigDecimal)saleFee);
                    purchaseFeeCount = purchaseFeeCount + MoneyUtil.BigDecimal2Long((BigDecimal)purchaseFee);
                }
                returnRsp.setReturnItemList(returnItemList);
            }
            returnRsp.setSaleFeeCount(saleFeeCount);
            returnRsp.setPurchaseFeeCount(purchaseFeeCount);
            return returnRsp;
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u8f6c\u6362\u5f02\u5e38:", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9000\u8d27\u5355\u4fe1\u606f\u521d\u59cb\u5316\u5f02\u5e38\uff01");
        }
    }

    private InfoAddressXbjPO initAddressInfo(AddressInfoIntfceXbjReqBO addressInfo, OrderSaleXbjPO orderSale, Integer orderType, Long returnId) {
        InfoAddressXbjPO infoAddress = new InfoAddressXbjPO();
        infoAddress.setSaleOrderId(returnId);
        infoAddress.setPurchaserId(orderSale.getPurchaserId());
        infoAddress.setPurchaserAccountId(orderSale.getPurchaserAccountId());
        infoAddress.setPurchaserAccountName(orderSale.getPurchaserAccountName());
        infoAddress.setProfessionalOrganizationId(orderSale.getProfessionalOrganizationId());
        infoAddress.setGoodsSupplierId(orderSale.getGoodsSupplierId());
        infoAddress.setReceiverCountryId(addressInfo.getReceiverCountryId());
        infoAddress.setReceiverCountryName(addressInfo.getReceiverCountryName());
        infoAddress.setReceiverProvinceId(addressInfo.getReceiverProvinceId());
        infoAddress.setReceiverProvinceName(addressInfo.getReceiverProvinceName());
        infoAddress.setReceiverCityId(addressInfo.getReceiverCityId());
        infoAddress.setReceiverCityName(addressInfo.getReceiverCityName());
        infoAddress.setReceiverCountyId(addressInfo.getReceiverCountyId());
        infoAddress.setReceiverCountyName(addressInfo.getReceiverCountyName());
        infoAddress.setReceiverTown(addressInfo.getReceiverTown());
        infoAddress.setReceiverTownId(addressInfo.getReceiverTownId());
        infoAddress.setReceiverAddress(addressInfo.getReceiverAddress());
        infoAddress.setReceiverCompany(addressInfo.getReceiverCompany());
        infoAddress.setReceiverName(addressInfo.getReceiverName());
        infoAddress.setReceiverFixPhone(addressInfo.getReceiverFixPhone());
        infoAddress.setReceiverMobileNumber(addressInfo.getReceiverMobileNumber());
        infoAddress.setReceiverEmail(addressInfo.getReceiverEmail());
        infoAddress.setOrderType(orderType);
        return infoAddress;
    }

    private void insertOrderFlowSheet(Long goodReturnId, OrderSaleXbjPO orderSale, XbjReturnBusiReqBO returnReq) {
        String busiName;
        OrderFlowSheetXbjPO orderFlowSheet = new OrderFlowSheetXbjPO();
        Map<String, String> purchaserOrderMode = this.queryValueByCode("RETURN_ORDER_TYPE");
        if (purchaserOrderMode != null) {
            busiName = purchaserOrderMode.get("R_1");
            if (busiName == null || "".equals(busiName)) {
                throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6839\u636e\u6570\u636e\u5b57\u5178code\u83b7\u53d6title\u6570\u636e\u4e3a\u7a7a");
            }
        } else {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u83b7\u53d6\u6570\u636e\u5b57\u5178\u6570\u636e\u4e3a\u7a7a");
        }
        orderFlowSheet.setBusiType("R_1");
        orderFlowSheet.setBusiName(busiName);
        orderFlowSheet.setOrderId(goodReturnId);
        orderFlowSheet.setProfessionalOrganizationId(orderSale.getProfessionalOrganizationId());
        orderFlowSheet.setPurchaserAccountId(orderSale.getPurchaserAccountId());
        orderFlowSheet.setPurchaserId(orderSale.getPurchaserId());
        orderFlowSheet.setGoodsSupplierId(orderSale.getGoodsSupplierId());
        orderFlowSheet.setOrderType(XbjOrderConstants.ORDER_TYPE.RETURN);
        orderFlowSheet.setOperTime(new Date());
        orderFlowSheet.setOperName(returnReq.getUserName());
        orderFlowSheet.setOperDeptId(returnReq.getOrgId());
        orderFlowSheet.setOperDeptName(returnReq.getOrgName());
        orderFlowSheet.setOperId(returnReq.getUserId());
        orderFlowSheet.setOperCompId(returnReq.getCompanyId());
        orderFlowSheet.setOperCompName(returnReq.getCompanyName());
        this.orderFlowSheetXbjMapper.insertSelective(orderFlowSheet);
    }

    private void createAccessory(List<XbjAccessoryBusiReqBO> accessoryList, OrderSaleXbjPO selectByIdAndPurchaserId, XbjReturnBusiReqBO returnReq, Long createReturnId) {
        try {
            if (null != accessoryList && !accessoryList.isEmpty()) {
                ArrayList<AccessoryXbjPO> orderShipAccessorys = new ArrayList<AccessoryXbjPO>();
                for (XbjAccessoryBusiReqBO accessoryBusiReqBO : accessoryList) {
                    AccessoryXbjPO accessory = new AccessoryXbjPO();
                    accessory.setObjectId(createReturnId);
                    accessory.setObjectType(Constant.GOODS_RETURN_CREATE_OBJECT_TYPE);
                    accessory.setPurchaserId(returnReq.getCompanyId());
                    accessory.setPurchaserAccountId(returnReq.getUserId());
                    accessory.setPurchaserAccountName(returnReq.getUserName());
                    accessory.setProfessionalOrganizationId(String.valueOf(selectByIdAndPurchaserId.getProfessionalOrganizationId()));
                    accessory.setGoodsSupplierId(String.valueOf(selectByIdAndPurchaserId.getGoodsSupplierId()));
                    accessory.setAccessoryName(accessoryBusiReqBO.getAccessoryName());
                    accessory.setAccessoryUrl(accessoryBusiReqBO.getAccessoryUrl());
                    accessory.setAccessoryId(accessoryBusiReqBO.getAccessoryId() + "");
                    accessory.setCreateDate(new Date());
                    orderShipAccessorys.add(accessory);
                }
                this.accessoryXbjMapper.insertSelectiveBatch(orderShipAccessorys);
            }
        }
        catch (Exception e) {
            log.error("\u9000\u8d27\u5355\u751f\u6210\u9644\u4ef6\u4fe1\u606f\u5f02\u5e38:", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9000\u8d27\u5355\u751f\u6210\u9644\u4ef6\u4fe1\u606f\u5f02\u5e38\uff01");
        }
    }

    private void updateOrderReceiveItem(XbjReturnBusiReqBO returnReq) {
        try {
            List returnItem = returnReq.getReturnItem();
            for (XbjReturnItemReqBO returnItemBO : returnItem) {
                OrderReceiveItemXbjPO receiveItem = new OrderReceiveItemXbjPO();
                receiveItem.setInspectionId(Long.valueOf(returnReq.getInspectionId()));
                receiveItem.setId(returnItemBO.getId());
                receiveItem.setPurchaserId(returnReq.getPurchaserId());
                OrderReceiveItemXbjPO orderReceiveItem = this.orderReceiveItemXbjMapper.queryReturnId(receiveItem);
                if (null != orderReceiveItem) {
                    BigDecimal purchaseCount = orderReceiveItem.getPurchaseCount();
                    BigDecimal waitReturnCount = orderReceiveItem.getReturnCount();
                    BigDecimal alreadyReturnCount = orderReceiveItem.getAlreadyReturnCount();
                    BigDecimal returnCount = returnItemBO.getReturnCount();
                    BigDecimal canReturnCount = purchaseCount.subtract(alreadyReturnCount).subtract(waitReturnCount);
                    if (this.isDebugEnabled) {
                        log.debug("\u5269\u4f59\u53ef\u9000\u6570\u91cf:" + canReturnCount + ",\u91c7\u8d2d\u6570\u91cf\uff1a" + purchaseCount + ",\u5df2\u9000\u6570\u91cf\uff1a" + alreadyReturnCount + "-\u9000\u8d27\u4e2d\u6570\u91cf\uff1a" + alreadyReturnCount);
                        log.debug("\u5f53\u524d\u8981\u9000\u6570\u91cf:" + returnCount);
                    }
                    if (canReturnCount.compareTo(returnCount) == 1 || canReturnCount.compareTo(returnCount) == 0) {
                        BigDecimal waitReturnCountNew = waitReturnCount.add(returnCount);
                        this.orderReceiveItemXbjMapper.updateByInspectionIdAndId(Long.valueOf(returnReq.getInspectionId()), returnReq.getPurchaserId(), returnItemBO.getId(), waitReturnCountNew);
                        continue;
                    }
                    throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u672c\u6b21\u9000\u8d27\u6570\u91cf\u5927\u4e8e\u6700\u5927\u5141\u8bb8\u9000\u8d27\u7684\u6570\u91cf!");
                }
                throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u9a8c\u6536\u5355\u5546\u54c1\u660e\u7ec6,\u9a8c\u6536\u5355ID=" + returnReq.getInspectionId() + ",SKUID=" + returnItemBO.getSkuId());
            }
        }
        catch (Exception e) {
            log.error("\u9000\u8d27\u5355\u66f4\u65b0\u9a8c\u6536\u5355\u660e\u7ec6\u6570\u91cf\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u9000\u8d27\u5355\u66f4\u65b0\u9a8c\u6536\u5355\u660e\u7ec6\u6570\u91cf\u5f02\u5e38\uff01");
        }
    }

    private Map<String, String> queryValueByCode(String pCode) {
        try {
            Map purchaserOrderMode = this.dicDictionaryService.getValueByCode(pCode);
            return purchaserOrderMode;
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u6570\u636e\u5b57\u5178\u5931\u8d25", (Throwable)e);
            throw new BusinessException("RSP_CODE_ATOM_SERVICE_ERROR", "\u67e5\u8be2\u6570\u636e\u5b57\u5178\u5931\u8d25\u8d25");
        }
    }
}

